/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.WeakListeners;

public class J2SELibrarySourceForBinaryQuery
implements SourceForBinaryQueryImplementation {
    private final Map cache = new HashMap();
    private final Map normalizedURLCache = new HashMap();
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$org$netbeans$modules$java$j2seplatform$libraries$J2SELibrarySourceForBinaryQuery;

    public SourceForBinaryQuery.Result findSourceRoots(URL uRL) {
        SourceForBinaryQuery.Result result = (SourceForBinaryQuery.Result)this.cache.get(uRL);
        if (result != null) {
            return result;
        }
        boolean bl = J2SELibrarySourceForBinaryQuery.isNormalizedURL(uRL);
        LibraryManager libraryManager = LibraryManager.getDefault();
        Library[] libraryArray = libraryManager.getLibraries();
        for (int i = 0; i < libraryArray.length; ++i) {
            String string = libraryArray[i].getType();
            if (!"j2se".equalsIgnoreCase(string)) continue;
            List list = libraryArray[i].getContent("classpath");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                URL uRL2 = (URL)iterator.next();
                URL uRL3 = bl ? this.getNormalizedURL(uRL2) : uRL2;
                if (uRL3 == null || !uRL3.equals(uRL)) continue;
                result = new Result(uRL2, libraryArray[i]);
                this.cache.put(uRL, result);
                return result;
            }
        }
        return null;
    }

    private URL getNormalizedURL(URL uRL) {
        FileObject fileObject;
        if (J2SELibrarySourceForBinaryQuery.isNormalizedURL(uRL)) {
            return uRL;
        }
        URL uRL2 = (URL)this.normalizedURLCache.get(uRL);
        if (uRL2 == null && (fileObject = URLMapper.findFileObject((URL)uRL)) != null) {
            try {
                uRL2 = fileObject.getURL();
                this.normalizedURLCache.put(uRL, uRL2);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
        return uRL2;
    }

    private static boolean isNormalizedURL(URL uRL) {
        if ("jar".equals(uRL.getProtocol())) {
            uRL = FileUtil.getArchiveFile((URL)uRL);
        }
        return "file".equals(uRL.getProtocol());
    }

    private static class Result
    implements SourceForBinaryQuery.Result,
    PropertyChangeListener {
        private Library lib;
        private URL entry;
        private ArrayList listeners;
        private FileObject[] cache;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Result(URL uRL, Library library) {
            this.entry = uRL;
            this.lib = library;
            this.lib.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = J2SELibrarySourceForBinaryQuery.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener), (EventListener)this, (Object)this.lib));
        }

        public synchronized FileObject[] getRoots() {
            if (this.cache == null) {
                if (this.lib.getContent("classpath").contains(this.entry)) {
                    List list = this.lib.getContent("src");
                    ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        FileObject fileObject = URLMapper.findFileObject((URL)((URL)iterator.next()));
                        if (fileObject == null) continue;
                        arrayList.add(fileObject);
                    }
                    this.cache = arrayList.toArray(new FileObject[arrayList.size()]);
                } else {
                    this.cache = new FileObject[0];
                }
            }
            return this.cache;
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            if (!$assertionsDisabled && changeListener == null) {
                throw new AssertionError((Object)"Listener cannot be null");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            if (!$assertionsDisabled && changeListener == null) {
                throw new AssertionError((Object)"Listener cannot be null");
            }
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("content".equals(propertyChangeEvent.getPropertyName())) {
                Result result = this;
                synchronized (result) {
                    this.cache = null;
                }
                this.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            Iterator iterator = null;
            Object object = this;
            synchronized (object) {
                if (this.listeners == null) {
                    return;
                }
                iterator = ((ArrayList)this.listeners.clone()).iterator();
            }
            object = new ChangeEvent(this);
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$j2seplatform$libraries$J2SELibrarySourceForBinaryQuery == null ? (class$org$netbeans$modules$java$j2seplatform$libraries$J2SELibrarySourceForBinaryQuery = J2SELibrarySourceForBinaryQuery.class$("org.netbeans.modules.java.j2seplatform.libraries.J2SELibrarySourceForBinaryQuery")) : class$org$netbeans$modules$java$j2seplatform$libraries$J2SELibrarySourceForBinaryQuery).desiredAssertionStatus();
        }
    }
}

