/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.awt.Component;
import java.text.MessageFormat;
import org.netbeans.modules.java.j2seplatform.platformdefinition.BrokenPlatformCustomizer;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformCustomizer;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class J2SEPlatformNode
extends AbstractNode {
    private J2SEPlatformImpl platform;
    private String toolTip;
    private boolean broken;

    public J2SEPlatformNode(J2SEPlatformImpl j2SEPlatformImpl, DataObject dataObject) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{j2SEPlatformImpl, dataObject}));
        this.platform = j2SEPlatformImpl;
        super.setIconBase("org/netbeans/modules/java/j2seplatform/resources/platform");
    }

    public String getDisplayName() {
        return this.platform.getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (this.isBroken()) {
            return "<font color=\"#A40000\">" + this.platform.getDisplayName() + "</font>";
        }
        return null;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public void setName(String string) {
        this.platform.setDisplayName(string);
    }

    public void setDisplayName(String string) {
        this.setName(string);
    }

    public synchronized String getShortDescription() {
        if (this.toolTip == null) {
            this.toolTip = MessageFormat.format(NbBundle.getMessage((Class)J2SEPlatformNode.class, (String)"TXT_J2SEPlatformToolTip"), this.platform.getSpecification().getVersion());
        }
        return this.toolTip;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        if (this.isBroken()) {
            return new BrokenPlatformCustomizer(this.platform);
        }
        return new J2SEPlatformCustomizer(this.platform);
    }

    private boolean isBroken() {
        return this.platform.getInstallFolders().size() == 0;
    }
}

