/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.wizard.J2SEWizardIterator;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class DetectPanel
extends JPanel {
    private NewJ2SEPlatform platform;
    private ArrayList listeners;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField javadoc;
    private JTextField jdkName;
    private JLabel progressLabel;
    private JPanel progressPanel;
    private JTextField sources;

    public DetectPanel(NewJ2SEPlatform newJ2SEPlatform) {
        this.initComponents();
        this.postInitComponents();
        this.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage((Class)DetectPanel.class, (String)"TITLE_PlatformName")});
        this.platform = newJ2SEPlatform;
        this.setName(NbBundle.getMessage((Class)DetectPanel.class, (String)"TITLE_PlatformName"));
    }

    public void addNotify() {
        super.addNotify();
    }

    private void postInitComponents() {
        this.jdkName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                DetectPanel.this.handleNameChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                DetectPanel.this.handleNameChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                DetectPanel.this.handleNameChange();
            }
        });
        this.progressLabel.setVisible(false);
        this.progressPanel.setVisible(false);
    }

    private void handleNameChange() {
        this.fireChange();
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jdkName = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.javadoc = new JTextField();
        this.sources = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.progressLabel = new JLabel();
        this.progressPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)DetectPanel.class).getString("AD_DetectPanel"));
        this.jLabel3.setLabelFor(this.jdkName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getBundle((Class)DetectPanel.class).getString("LBL_DetailsPanel_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jdkName, gridBagConstraints);
        this.jdkName.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)DetectPanel.class).getString("AD_PlatformName"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.sources);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle((Class)DetectPanel.class).getString("TXT_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel4.setLabelFor(this.javadoc);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getBundle((Class)DetectPanel.class).getString("TXT_JavaDoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel1.add((Component)this.javadoc, gridBagConstraints);
        this.javadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)DetectPanel.class).getString("AD_PlatformJavadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.sources, gridBagConstraints);
        this.sources.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)DetectPanel.class).getString("AD_PlatformSources"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getBundle((Class)DetectPanel.class).getString("LBL_BrowseSources"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectPanel.this.selectSources(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)DetectPanel.class).getString("AD_SelectSources"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getBundle((Class)DetectPanel.class).getString("LBL_BrowseJavadoc"));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectPanel.this.selectJavadoc(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        this.jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)DetectPanel.class).getString("AD_SelectJavadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.progressLabel.setLabelFor(this.progressPanel);
        Mnemonics.setLocalizedText((JLabel)this.progressLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/java/j2seplatform/wizard/Bundle").getString("TXT_PlatfromDetectProgress"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.add((Component)this.progressLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.progressPanel, gridBagConstraints);
    }

    private void selectJavadoc(ActionEvent actionEvent) {
        String string = this.browse(this.javadoc.getText(), NbBundle.getMessage((Class)DetectPanel.class, (String)"TXT_SelectJavadoc"));
        if (string != null) {
            this.javadoc.setText(string);
        }
    }

    private void selectSources(ActionEvent actionEvent) {
        String string = this.browse(this.sources.getText(), NbBundle.getMessage((Class)DetectPanel.class, (String)"TXT_SelectSources"));
        if (string != null) {
            this.sources.setText(string);
        }
    }

    public final synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(changeListener);
    }

    public final synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(changeListener);
    }

    public String getPlatformName() {
        return this.jdkName.getText();
    }

    String getSources() {
        String string = this.sources.getText();
        return string.length() == 0 ? null : string;
    }

    void setSources(String string) {
        this.sources.setText(string == null ? "" : string);
    }

    String getJavadoc() {
        String string = this.javadoc.getText();
        return string.length() == 0 ? null : string;
    }

    void setJavadoc(String string) {
        this.javadoc.setText(string == null ? "" : string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChange() {
        Iterator iterator = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners == null) {
                return;
            }
            iterator = ((ArrayList)this.listeners.clone()).iterator();
        }
        serializable = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)serializable);
        }
    }

    void updateData() {
        Map map = this.platform.getSystemProperties();
        if ("".equals(this.jdkName.getText())) {
            this.jdkName.setText(DetectPanel.getInitialName(map));
            this.jdkName.selectAll();
        }
    }

    private static String getInitialName(Map map) {
        String string = (String)map.get("java.vm.name");
        String string2 = (String)map.get("java.vm.version");
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        }
        if (string2 != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String browse(String string, String string2) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.exists() && file.canRead() && (file.isDirectory() || file.getName().endsWith(".zip") || file.getName().endsWith(".jar"));
            }

            public String getDescription() {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel == null ? (class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel = DetectPanel.class$("org.netbeans.modules.java.j2seplatform.wizard.DetectPanel")) : class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel), (String)"TXT_ZipFilter");
            }
        });
        File file = new File(string);
        jFileChooser.setSelectedFile(file);
        jFileChooser.setDialogTitle(string2);
        if (jFileChooser.showOpenDialog(this) == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    static class WizardPanel
    implements WizardDescriptor.Panel,
    TaskListener,
    ChangeListener {
        private DetectPanel component;
        private RequestProcessor.Task task;
        private final J2SEWizardIterator iterator;
        private Collection changeList = new ArrayList();
        private boolean detected;
        private boolean valid;
        private boolean firstPass = true;
        private WizardDescriptor wiz;
        private ProgressHandle progressHandle;

        WizardPanel(J2SEWizardIterator j2SEWizardIterator) {
            this.iterator = j2SEWizardIterator;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeList.add(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                NewJ2SEPlatform newJ2SEPlatform = this.iterator.getPlatform();
                this.component = new DetectPanel(newJ2SEPlatform);
                this.component.addChangeListener(this);
                this.task = RequestProcessor.getDefault().create((Runnable)newJ2SEPlatform);
                this.task.addTaskListener((TaskListener)this);
            }
            return this.component;
        }

        void setValid(boolean bl) {
            if (bl == this.valid) {
                return;
            }
            this.valid = bl;
            this.fireStateChange();
        }

        public HelpCtx getHelp() {
            return new HelpCtx(class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel == null ? (class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel = DetectPanel.class$("org.netbeans.modules.java.j2seplatform.wizard.DetectPanel")) : class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel);
        }

        public boolean isValid() {
            return this.valid;
        }

        public void readSettings(Object object) {
            Serializable serializable;
            Iterator iterator;
            Object object2;
            this.wiz = (WizardDescriptor)object;
            NewJ2SEPlatform newJ2SEPlatform = this.iterator.getPlatform();
            String string = null;
            String string2 = null;
            ClassPath classPath = newJ2SEPlatform.getSourceFolders();
            if (classPath.entries().size() > 0) {
                object2 = ((ClassPath.Entry)classPath.entries().get(0)).getURL();
                if ("jar".equals(((URL)object2).getProtocol())) {
                    object2 = FileUtil.getArchiveFile(object2);
                }
                string = new File(URI.create(((URL)object2).toExternalForm())).getAbsolutePath();
            } else if (this.firstPass && (object2 = newJ2SEPlatform.getInstallFolders().iterator()).hasNext() && (iterator = FileUtil.toFile((FileObject)((FileObject)object2.next()))) != null) {
                serializable = new File((File)((Object)iterator), "src.zip");
                if (serializable.canRead()) {
                    string = serializable.getAbsolutePath();
                } else {
                    serializable = new File((File)((Object)iterator), "src.jar");
                    if (serializable.canRead()) {
                        string = serializable.getAbsolutePath();
                    }
                }
            }
            object2 = newJ2SEPlatform.getJavadocFolders();
            if (object2.size() > 0) {
                iterator = (URL)object2.get(0);
                if ("jar".equals(((URL)((Object)iterator)).getProtocol())) {
                    iterator = FileUtil.getArchiveFile((URL)((Object)iterator));
                }
                string2 = new File(URI.create(((URL)((Object)iterator)).toExternalForm())).getAbsolutePath();
            } else if (this.firstPass) {
                File file;
                iterator = newJ2SEPlatform.getInstallFolders().iterator();
                if (iterator.hasNext() && (serializable = FileUtil.toFile((FileObject)((FileObject)iterator.next()))) != null && (file = new File((File)serializable, "docs")).isDirectory() && file.canRead()) {
                    string2 = file.getAbsolutePath();
                }
                this.firstPass = false;
            }
            this.component.setSources(string);
            this.component.setJavadoc(string2);
            this.component.jdkName.setEditable(false);
            this.component.progressPanel.setVisible(true);
            this.component.progressLabel.setVisible(true);
            this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel == null ? (class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel = DetectPanel.class$("org.netbeans.modules.java.j2seplatform.wizard.DetectPanel")) : class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel), (String)"TXT_PlatfromDetectProgress"));
            this.component.progressPanel.removeAll();
            this.component.progressPanel.setLayout(new GridBagLayout());
            iterator = new GridBagConstraints();
            ((GridBagConstraints)((Object)iterator)).gridy = -1;
            ((GridBagConstraints)((Object)iterator)).gridx = -1;
            ((GridBagConstraints)((Object)iterator)).gridwidth = 0;
            ((GridBagConstraints)((Object)iterator)).gridheight = 0;
            ((GridBagConstraints)((Object)iterator)).fill = 2;
            ((GridBagConstraints)((Object)iterator)).weightx = 1.0;
            serializable = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle);
            ((GridBagLayout)this.component.progressPanel.getLayout()).setConstraints((Component)serializable, (GridBagConstraints)((Object)iterator));
            this.component.progressPanel.add((Component)serializable);
            this.progressHandle.start();
            this.task.schedule(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] changeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.changeList.isEmpty()) {
                    return;
                }
                changeListenerArray = this.changeList.toArray(new ChangeListener[0]);
            }
            object = new ChangeEvent(this);
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged((ChangeEvent)object);
            }
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeList.remove(changeListener);
        }

        public void storeSettings(Object object) {
            if (this.isValid()) {
                URL uRL;
                Serializable serializable;
                Object object2;
                NewJ2SEPlatform newJ2SEPlatform = this.iterator.getPlatform();
                String string = this.component.getPlatformName();
                newJ2SEPlatform.setDisplayName(string);
                String string2 = WizardPanel.createAntName(string);
                newJ2SEPlatform.setAntName(string2);
                ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
                ArrayList<URL> arrayList2 = new ArrayList<URL>();
                String string3 = this.component.getSources();
                if (string3 != null) {
                    object2 = new File(string3);
                    try {
                        serializable = ((File)object2).toURI().toURL();
                        if (FileUtil.isArchiveFile((URL)serializable)) {
                            uRL = URLMapper.findFileObject((URL)(serializable = FileUtil.getArchiveRoot((URL)serializable)));
                            if (uRL != null && (uRL = uRL.getFileObject("src")) != null) {
                                serializable = uRL.getURL();
                            }
                            arrayList.add(ClassPathSupport.createResource((URL)serializable));
                        } else {
                            arrayList.add(ClassPathSupport.createResource((URL)serializable));
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        ErrorManager.getDefault().notify((Throwable)malformedURLException);
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                    }
                }
                if ((object2 = this.component.getJavadoc()) != null) {
                    serializable = new File((String)object2);
                    try {
                        uRL = ((File)serializable).toURI().toURL();
                        if (FileUtil.isArchiveFile((URL)uRL)) {
                            arrayList2.add(FileUtil.getArchiveRoot((URL)uRL));
                        } else {
                            arrayList2.add(uRL);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        ErrorManager.getDefault().notify((Throwable)malformedURLException);
                    }
                }
                newJ2SEPlatform.setSourceFolders(ClassPathSupport.createClassPath(arrayList));
                newJ2SEPlatform.setJavadocFolders(arrayList2);
            }
        }

        public void taskFinished(Task task) {
            SwingUtilities.invokeLater(new Runnable(this){
                static final /* synthetic */ boolean $assertionsDisabled;
                private final /* synthetic */ WizardPanel this$0;
                {
                    this.this$0 = wizardPanel;
                }

                public void run() {
                    WizardPanel.access$600(this.this$0).updateData();
                    DetectPanel.access$300(WizardPanel.access$600(this.this$0)).setEditable(true);
                    if (!$assertionsDisabled && WizardPanel.access$700(this.this$0) == null) {
                        throw new AssertionError();
                    }
                    WizardPanel.access$700(this.this$0).finish();
                    DetectPanel.access$400(WizardPanel.access$600(this.this$0)).setVisible(false);
                    DetectPanel.access$500(WizardPanel.access$600(this.this$0)).setVisible(false);
                    WizardPanel.access$802(this.this$0, WizardPanel.access$900(this.this$0).getPlatform().isValid());
                    WizardPanel.access$1000(this.this$0);
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel == null ? (class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel = DetectPanel.class$("org.netbeans.modules.java.j2seplatform.wizard.DetectPanel")) : class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel).desiredAssertionStatus();
                }
            });
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.checkValid();
        }

        private void checkValid() {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)"");
            String string = this.component.getPlatformName();
            boolean bl = string.length() > 0;
            boolean bl2 = false;
            if (!this.detected) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel == null ? (class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel = DetectPanel.class$("org.netbeans.modules.java.j2seplatform.wizard.DetectPanel")) : class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel), (String)"ERROR_NoSDKRegistry"));
            } else if (!bl) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel == null ? (class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel = DetectPanel.class$("org.netbeans.modules.java.j2seplatform.wizard.DetectPanel")) : class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel), (String)"ERROR_InvalidDisplayName"));
            } else {
                JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
                for (int i = 0; i < javaPlatformArray.length; ++i) {
                    if (!string.equals(javaPlatformArray[i].getDisplayName())) continue;
                    bl2 = true;
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel == null ? (class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel = DetectPanel.class$("org.netbeans.modules.java.j2seplatform.wizard.DetectPanel")) : class$org$netbeans$modules$java$j2seplatform$wizard$DetectPanel), (String)"ERROR_UsedDisplayName"));
                    break;
                }
            }
            boolean bl3 = this.detected && bl && !bl2;
            this.setValid(bl3);
        }

        private static String createAntName(String string) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException();
            }
            String string2 = PropertyUtils.getUsablePropertyName((String)string);
            if (WizardPanel.platformExists(string2)) {
                String string3 = string2;
                int n = 1;
                string2 = string3 + Integer.toString(n);
                while (WizardPanel.platformExists(string2)) {
                    string2 = string3 + Integer.toString(++n);
                }
            }
            return string2;
        }

        private static boolean platformExists(String string) {
            JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
            JavaPlatform[] javaPlatformArray = javaPlatformManager.getInstalledPlatforms();
            for (int i = 0; i < javaPlatformArray.length; ++i) {
                String string2;
                if (!(javaPlatformArray[i] instanceof J2SEPlatformImpl) || !string.equals(string2 = ((J2SEPlatformImpl)javaPlatformArray[i]).getAntName())) continue;
                return true;
            }
            return false;
        }

        static /* synthetic */ DetectPanel access$600(WizardPanel wizardPanel) {
            return wizardPanel.component;
        }

        static /* synthetic */ ProgressHandle access$700(WizardPanel wizardPanel) {
            return wizardPanel.progressHandle;
        }

        static /* synthetic */ boolean access$802(WizardPanel wizardPanel, boolean bl) {
            wizardPanel.detected = bl;
            return wizardPanel.detected;
        }

        static /* synthetic */ J2SEWizardIterator access$900(WizardPanel wizardPanel) {
            return wizardPanel.iterator;
        }

        static /* synthetic */ void access$1000(WizardPanel wizardPanel) {
            wizardPanel.checkValid();
        }
    }
}

