/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.java.j2seplatform.wizard.DetectPanel;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class J2SEWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    DataFolder installFolder;
    DetectPanel.WizardPanel detectPanel;
    Collection listeners;
    NewJ2SEPlatform platform;
    WizardDescriptor wizard;
    int currentIndex;

    public J2SEWizardIterator(FileObject fileObject) throws IOException {
        this.installFolder = DataFolder.findFolder((FileObject)fileObject);
        this.platform = NewJ2SEPlatform.create(fileObject);
    }

    FileObject getInstallFolder() {
        return this.installFolder.getPrimaryFile();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public WizardDescriptor.Panel current() {
        switch (this.currentIndex) {
            case 0: {
                return this.detectPanel;
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        this.detectPanel = new DetectPanel.WizardPanel(this);
        this.currentIndex = 0;
    }

    public Set instantiate() throws IOException {
        this.detectPanel.storeSettings(this.wizard);
        String string = this.getPlatform().getAntName();
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services/Platforms/org-netbeans-api-java-Platform");
        if (fileObject.getFileObject(string, "xml") != null) {
            String string2 = NbBundle.getMessage((Class)J2SEWizardIterator.class, (String)"ERROR_InvalidName");
            throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(string2), 256, null, string2, null, null);
        }
        DataObject dataObject = PlatformConvertor.create(this.getPlatform(), DataFolder.findFolder((FileObject)fileObject), string);
        JavaPlatform javaPlatform = (JavaPlatform)dataObject.getNodeDelegate().getLookup().lookup(JavaPlatform.class);
        return Collections.singleton(javaPlatform);
    }

    public String name() {
        return NbBundle.getMessage((Class)J2SEWizardIterator.class, (String)"TITLE_PlatformName");
    }

    public void nextPanel() {
        ++this.currentIndex;
    }

    public void previousPanel() {
        --this.currentIndex;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wizard = null;
        this.detectPanel = null;
    }

    public NewJ2SEPlatform getPlatform() {
        return this.platform;
    }
}

