/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.java.storagebuilder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.jmi.reflect.RefPackage;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.modules.javacore.CodebasesResolver;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.classpath.MergedClassPathImplementation;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public class Main {
    static String[] names = new String[0];
    private static JavaModelPackage javaPckg;
    public static final int OK = 0;
    public static final int FAILED = 1;

    public static int prebuildJDKStorages(String[] jdks, String destDir) {
        String[][] resNames;
        ArrayList<String> jarsList = new ArrayList<String>(jdks.length * 2);
        ArrayList<Object> resNamesList = new ArrayList<Object>(jdks.length * 2);
        for (int i = 0; i < jdks.length; ++i) {
            int j;
            if (jdks[i].endsWith(".jar") || jdks[i].endsWith(".zip")) {
                jarsList.add(jdks[i]);
                resNamesList.add(new String[0]);
                continue;
            }
            File dir = new File(jdks[i]);
            if (!dir.exists()) {
                System.out.println("JDK home directory not found: " + jdks[i]);
                return 1;
            }
            if (!jdks[i].endsWith(File.separator)) {
                jdks[i] = jdks[i] + File.separator;
            }
            jarsList.add(jdks[i] + "jre" + File.separator + "lib" + File.separator + "rt.jar");
            resNames = new String[names.length];
            for (j = 0; j < names.length; ++j) {
                resNames[j] = names[j].concat(".class");
            }
            resNamesList.add(resNames);
            jarsList.add(jdks[i] + "src.zip");
            resNames = new String[names.length];
            for (j = 0; j < names.length; ++j) {
                resNames[j] = names[j].concat(".java");
            }
            resNamesList.add(resNames);
        }
        String[] jars = jarsList.toArray(new String[jarsList.size()]);
        resNames = (String[][])resNamesList.toArray((T[])new String[jarsList.size()][]);
        return Main.prebuildJars(jars, new boolean[jars.length], resNames, destDir);
    }

    public static int prebuildJars(String[] jars, boolean[] deepParse, String[][] names, String destDir) {
        String dirName;
        File dir = new File(destDir);
        if (!dir.exists()) {
            System.out.println("Target directory does not exist: " + destDir);
            return 1;
        }
        String storagesDir = System.getProperty("mdr.filename");
        if (storagesDir == null) {
            System.out.println("mdr.filename property not specified");
            return 1;
        }
        int index = storagesDir.lastIndexOf(File.separator);
        if (index > 0 && !(dir = new File(dirName = storagesDir.substring(0, index))).exists()) {
            System.out.println("mdr storage directory does not exist: " + dirName);
            return 1;
        }
        for (int x = 0; x < jars.length; ++x) {
            dir = new File(jars[x]);
            if (dir.exists()) continue;
            System.out.println("Jar not found: " + jars[x]);
            return 1;
        }
        if (!destDir.endsWith(File.separator)) {
            destDir = destDir + File.separator;
        }
        try {
            int result;
            String[] jarSimpleNames = new String[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                int pos = jars[i].lastIndexOf(File.separator);
                jarSimpleNames[i] = pos >= 0 ? jars[i].substring(pos + 1) : jars[i];
                pos = jarSimpleNames[i].lastIndexOf(46);
                if (pos >= 0) {
                    jarSimpleNames[i] = jarSimpleNames[i].substring(0, pos);
                }
                if ((result = Main.preparseFile(jars[i], jarSimpleNames[i], deepParse[i])) != 0) {
                    return result;
                }
                if (names[i].length <= 0 || javaPckg == null) continue;
                Main.preparseResources(names[i]);
            }
            MDRepository repository = MDRManager.getDefault().getRepository("org.netbeans.java");
            repository.shutdown();
            for (int i = 0; i < jars.length; ++i) {
                result = Main.saveFile(jars[i], jarSimpleNames[i], destDir);
                if (result == 0) continue;
                return result;
            }
        }
        catch (FileStateInvalidException e) {
            System.out.println("process failed: " + e.getMessage());
            System.out.flush();
            return 1;
        }
        catch (MalformedURLException e) {
            System.out.println("process failed: " + e.getMessage());
            System.out.flush();
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int preparseFile(String filename, String type, boolean preparseFeatures) throws FileStateInvalidException, MalformedURLException {
        System.out.println("preparsing " + filename);
        File file = new File(filename);
        FileObject archive = FileUtil.toFileObject((File)file);
        if (archive == null) {
            System.out.println("file not found: " + filename);
            return 1;
        }
        FileObject archiveRoot = FileUtil.getArchiveRoot((FileObject)archive);
        URL archiveUrl = archiveRoot.getURL();
        MergedClassPathImplementation.getDefault().addRoot(archiveUrl);
        CodebasesResolver.resolve();
        NBMDRepositoryImpl impl = (NBMDRepositoryImpl)JavaMetamodel.getDefaultRepository();
        javaPckg = JavaMetamodel.getManager().getJavaExtent(archiveRoot);
        if (preparseFeatures) {
            Resource[] resources = javaPckg.getResource().refAllOfClass().toArray(new Resource[0]);
            int p = 0;
            int closed = 0;
            impl.beginTrans(true);
            impl.disableEvents();
            try {
                for (int i = 0; i < resources.length; ++i) {
                    resources[i].getImports();
                    resources[i] = null;
                    int newP = i * 100 / resources.length;
                    long free = Runtime.getRuntime().freeMemory();
                    long total = Runtime.getRuntime().totalMemory();
                    if (free < total / 4L) {
                        impl.endTrans();
                        System.gc();
                        impl.beginTrans(true);
                        impl.disableEvents();
                        closed = i;
                    }
                    if (newP == p) continue;
                    if (newP % 10 == 0) {
                        System.out.println(newP + "%");
                        System.out.flush();
                    }
                    p = newP;
                }
                System.out.println("100%");
                System.out.flush();
            }
            catch (Exception e) {
                System.out.println(" ... failed: " + e.getMessage());
                System.out.flush();
                int n = 1;
                return n;
            }
            finally {
                impl.endTrans();
            }
        }
        System.out.println(" ... done");
        String uri = ((JMManager)JMManager.getManager()).getRootURI(archiveRoot);
        JavaModelPackage extent = (JavaModelPackage)impl.getExtent("codebase:" + uri);
        if ((JavaModelPackage)impl.getExtent("codebase:" + type) != null) {
            System.out.println("Cannot rename extent, there is already one of the same name.");
            System.out.println("It seems that storage files already existed in the temp mdr directory (specified by mdr.filename property).");
            return 1;
        }
        impl.renameExtent((RefPackage)extent, "codebase:" + type);
        return 0;
    }

    private static int saveFile(String filename, String type, String saveToDir) throws FileStateInvalidException, MalformedURLException {
        System.out.print("copying storages for " + filename);
        File file = new File(filename);
        FileObject archive = FileUtil.toFileObject((File)file);
        FileObject archiveRoot = FileUtil.getArchiveRoot((FileObject)archive);
        URL archiveUrl = archiveRoot.getURL();
        NBMDRepositoryImpl impl = (NBMDRepositoryImpl)JavaMetamodel.getDefaultRepository();
        try {
            String hash = JMManager.computePreparsedHash((File)file, (int)8192);
            String uri = ((JMManager)JMManager.getManager()).getRootURI(archiveRoot);
            JMManager m = (JMManager)JMManager.getManager();
            String strName = m.getFileName(JMManager.getValidName((String)m.getRootURI(archiveRoot)));
            if (!JMManager.copyStorage((String)strName, (String)(saveToDir + type + "-" + hash), (boolean)true)) {
                return 1;
            }
            System.out.println(" ... done");
        }
        catch (Exception e) {
            System.out.println(" ... failed: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int preparseResources(String[] names) {
        NBMDRepositoryImpl impl = (NBMDRepositoryImpl)JavaMetamodel.getDefaultRepository();
        for (int i = 0; i < names.length; ++i) {
            impl.beginTrans(true);
            impl.disableEvents();
            try {
                Resource r = javaPckg.getResource().resolveResource(names[i], false);
                if (r == null) {
                    System.out.println("null for name: '" + names[i] + "'.");
                    continue;
                }
                System.out.println("name: '" + r.getName() + "'.");
                r.getImports();
                continue;
            }
            catch (Exception e) {
                System.out.println(" ... failed: " + e.getMessage());
                System.out.flush();
                int n = 1;
                return n;
            }
            finally {
                impl.endTrans();
            }
        }
        return 0;
    }

    public static void main(String[] args) throws IOException {
        String[] jdks = new String[args.length - 1];
        for (int x = 1; x < args.length; ++x) {
            jdks[x - 1] = args[x];
        }
        System.exit(Main.prebuildJDKStorages(jdks, args[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        System.setProperty("org.netbeans.javacore.eagerlyParse", "");
        String s = System.getProperty("preparse.files", "");
        if (!"".equals(s)) {
            File f = new File(s);
            StringBuffer classes = new StringBuffer(1024);
            FileInputStream is = null;
            try {
                int bytesread;
                is = new FileInputStream(f);
                byte[] c = new byte[1024];
                while ((bytesread = is.read(c)) > 0) {
                    classes.append(new String(c, 0, bytesread));
                }
                names = classes.toString().split(":");
            }
            catch (FileNotFoundException e) {
                System.err.println("File does not exist.");
                System.err.println(e);
            }
            catch (IOException e) {
                System.err.println("File does not exist.");
                System.err.println(e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        javaPckg = null;
    }
}

