/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.diff;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.EncodedReaderFactory;
import org.openide.filesystems.FileUtil;
import org.openide.util.io.ReaderInputStream;

public abstract class StreamSource {
    public abstract String getName();

    public abstract String getTitle();

    public abstract String getMIMEType();

    public abstract Reader createReader() throws IOException;

    public abstract Writer createWriter(Difference[] var1) throws IOException;

    public void close() {
    }

    public static StreamSource createSource(String string, String string2, String string3, Reader reader) {
        return new Impl(string, string2, string3, reader);
    }

    public static StreamSource createSource(String string, String string2, String string3, File file) {
        return new Impl(string, string2, string3, file);
    }

    private static class Impl
    extends StreamSource {
        private String name;
        private String title;
        private String MIMEType;
        private Reader r;
        private File readerSource;
        private Writer w;
        private File file;
        private String encoding;

        Impl(String string, String string2, String string3, Reader reader) {
            this.name = string;
            this.title = string2;
            this.MIMEType = string3;
            this.r = reader;
            this.readerSource = null;
            this.w = null;
            this.file = null;
            if (reader instanceof InputStreamReader) {
                this.encoding = ((InputStreamReader)reader).getEncoding();
            }
        }

        Impl(String string, String string2, String string3, File file) {
            this.name = string;
            this.title = string2;
            this.MIMEType = string3;
            this.readerSource = null;
            this.w = null;
            this.file = file;
            this.encoding = EncodedReaderFactory.getDefault().getEncoding(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File createReaderSource(Reader reader) throws IOException {
            OutputStream outputStream;
            File file;
            block5: {
                file = null;
                file = FileUtil.normalizeFile((File)File.createTempFile("sss", "tmp"));
                file.deleteOnExit();
                file.createNewFile();
                ReaderInputStream readerInputStream = null;
                outputStream = null;
                try {
                    readerInputStream = this.encoding == null ? new ReaderInputStream(reader) : new ReaderInputStream(reader, this.encoding);
                    outputStream = new FileOutputStream(file);
                    FileUtil.copy((InputStream)readerInputStream, (OutputStream)outputStream);
                    Object var6_5 = null;
                    if (readerInputStream == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (readerInputStream != null) {
                        readerInputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw throwable;
                }
                readerInputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            return file;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMIMEType() {
            return this.MIMEType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reader createReader() throws IOException {
            if (this.file != null) {
                return new BufferedReader(EncodedReaderFactory.getDefault().getReader(this.file, this.MIMEType, this.encoding));
            }
            Impl impl = this;
            synchronized (impl) {
                if (this.r != null) {
                    this.readerSource = this.createReaderSource(this.r);
                    this.r = null;
                }
            }
            if (this.encoding == null) {
                return new BufferedReader(new FileReader(this.readerSource));
            }
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.readerSource), this.encoding));
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            if (differenceArray != null && differenceArray.length > 0) {
                return null;
            }
            if (this.file != null) {
                if (this.encoding == null) {
                    return new BufferedWriter(new FileWriter(this.file));
                }
                return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.encoding));
            }
            return this.w;
        }
    }
}

