/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.diff.EncodedReaderFactory;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public class DiffAction
extends NodeAction {
    public DiffAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage((Class)DiffAction.class, (String)"CTL_DiffActionName");
    }

    static FileObject getFileFromNode(Node node) {
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null) {
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) {
                return project.getProjectDirectory();
            }
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            if (dataObject != null) {
                fileObject = dataObject.getPrimaryFile();
            }
        }
        return fileObject;
    }

    public boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 2) {
            FileObject fileObject = DiffAction.getFileFromNode(nodeArray[0]);
            FileObject fileObject2 = DiffAction.getFileFromNode(nodeArray[1]);
            if (fileObject != null && fileObject2 != null && fileObject.isData() && fileObject2.isData()) {
                Diff diff = Diff.getDefault();
                return diff != null;
            }
        }
        return false;
    }

    protected boolean asynchronous() {
        return true;
    }

    public void performAction(Node[] nodeArray) {
        FileObject fileObject;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < nodeArray.length; ++i) {
            fileObject = DiffAction.getFileFromNode(nodeArray[i]);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        if (arrayList.size() < 2) {
            return;
        }
        FileObject fileObject2 = (FileObject)arrayList.get(0);
        fileObject = (FileObject)arrayList.get(1);
        DiffAction.performAction(fileObject2, fileObject);
    }

    public static void performAction(FileObject fileObject, FileObject fileObject2) {
        DiffAction.performAction(fileObject, fileObject2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void performAction(FileObject fileObject, FileObject fileObject2, FileObject fileObject3) {
        Component component;
        Object object;
        block27: {
            Diff diff = Diff.getDefault();
            if (diff == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)DiffAction.class, (String)"MSG_NoDiffVisualizer")));
                return;
            }
            Reader reader = null;
            Reader reader2 = null;
            object = EncodedReaderFactory.getDefault();
            if (fileObject3 != null) {
                reader = ((EncodedReaderFactory)object).getReader(fileObject, ((EncodedReaderFactory)object).getEncoding(fileObject3), fileObject3);
                reader2 = ((EncodedReaderFactory)object).getReader(fileObject2, ((EncodedReaderFactory)object).getEncoding(fileObject3), fileObject3);
            } else {
                reader = ((EncodedReaderFactory)object).getReader(fileObject, ((EncodedReaderFactory)object).getEncoding(fileObject), fileObject2.getExt());
                reader2 = ((EncodedReaderFactory)object).getReader(fileObject2, ((EncodedReaderFactory)object).getEncoding(fileObject2), fileObject.getExt());
            }
            String string = fileObject3 != null ? fileObject3.getMIMEType() : fileObject.getMIMEType();
            final Thread thread = Thread.currentThread();
            Cancellable cancellable = new Cancellable(){

                public boolean cancel() {
                    thread.interrupt();
                    return true;
                }
            };
            String string2 = NbBundle.getMessage((Class)DiffAction.class, (String)"BK0001");
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string2, (Cancellable)cancellable);
            try {
                progressHandle.start();
                component = diff.createDiff(fileObject.getNameExt(), FileUtil.getFileDisplayName((FileObject)fileObject), reader, fileObject2.getNameExt(), FileUtil.getFileDisplayName((FileObject)fileObject2), reader2, string);
            }
            finally {
                progressHandle.finish();
            }
            Object var15_15 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (reader2 != null) {
                    reader2.close();
                }
                break block27;
            }
            catch (IOException iOException) {}
            break block27;
            {
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    Object var15_16 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    try {
                        if (reader2 != null) {
                            reader2.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (reader2 != null) {
                        reader2.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (component != null) {
            object = component;
            SwingUtilities.invokeLater(new Runnable((Component)object){
                private final /* synthetic */ Component val$ftp;
                {
                    this.val$ftp = component;
                }

                public void run() {
                    if (this.val$ftp instanceof TopComponent) {
                        ((TopComponent)this.val$ftp).open();
                        ((TopComponent)this.val$ftp).requestActive();
                    } else {
                        this.val$ftp.setVisible(true);
                        this.val$ftp.requestFocusInWindow();
                    }
                }
            });
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DiffAction.class);
    }
}

