/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.DiffAction;
import org.netbeans.modules.diff.builtin.Patch;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.io.ReaderInputStream;

public class PatchAction
extends NodeAction {
    private static final String PATCHING_IO_ENCODING = "ISO-8859-1";

    public PatchAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage((Class)PatchAction.class, (String)"CTL_PatchActionName");
    }

    public boolean enable(Node[] nodeArray) {
        FileObject fileObject;
        if (nodeArray.length == 1 && (fileObject = DiffAction.getFileFromNode(nodeArray[0])) != null) {
            try {
                return fileObject.getURL().getProtocol().equals("file");
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return false;
            }
        }
        return false;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodeArray) {
        final FileObject fileObject = DiffAction.getFileFromNode(nodeArray[0]);
        if (fileObject != null) {
            final File file = this.getPatchFor(fileObject);
            if (file == null) {
                return;
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Patch.FileDifferences[] fileDifferencesArray;
                    String string = null;
                    try {
                        Object object;
                        String string2 = PatchAction.PATCHING_IO_ENCODING;
                        String string3 = "# This patch file was generated by NetBeans IDE";
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        String string4 = bufferedReader.readLine();
                        if (string3.equals(string4)) {
                            string2 = "utf8";
                            string4 = bufferedReader.readLine();
                            int n = string4.indexOf((String)(object = (Object)"paths are relative to: "));
                            if (n != -1) {
                                string = string4.substring(n + ((String)object).length());
                            }
                        }
                        bufferedReader.close();
                        object = new byte[string3.length()];
                        FileInputStream fileInputStream = new FileInputStream(file);
                        int n = ((InputStream)fileInputStream).read((byte[])object);
                        ((InputStream)fileInputStream).close();
                        if (n != -1 && string3.equals(new String((byte[])object, "utf8"))) {
                            string2 = "utf8";
                        }
                        fileDifferencesArray = Patch.parse(new InputStreamReader((InputStream)new FileInputStream(file), string2));
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"EXC_PatchParsingFailed", (Object)iOException.getLocalizedMessage()));
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        ErrorManager.getDefault().notify(256, (Throwable)iOException);
                        return;
                    }
                    int n = 0;
                    for (int i = 0; i < fileDifferencesArray.length; ++i) {
                        n += fileDifferencesArray[i].getDifferences().length;
                    }
                    if (n == 0) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"MSG_NoDifferences", (Object)file.getName())));
                        return;
                    }
                    PatchAction.this.applyFileDiffs(fileDifferencesArray, fileObject, string);
                }
            });
        }
    }

    private File getPatchFor(FileObject fileObject) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, (File)new File(System.getProperty("user.home")));
        jFileChooser.setFileSelectionMode(0);
        String string = NbBundle.getMessage((Class)PatchAction.class, (String)(fileObject.isData() ? "TITLE_SelectPatchForFile" : "TITLE_SelectPatchForFolder"), (Object)fileObject.getNameExt());
        jFileChooser.setDialogTitle(string);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith("diff") || file.getName().endsWith("patch") || file.isDirectory();
            }

            public String getDescription() {
                return "Patch Files (*.diff, *.patch)";
            }
        };
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.setApproveButtonText(NbBundle.getMessage((Class)PatchAction.class, (String)"BTN_Patch"));
        jFileChooser.setApproveButtonMnemonic(NbBundle.getMessage((Class)PatchAction.class, (String)"BTN_Patch_mnc").charAt(0));
        jFileChooser.setApproveButtonToolTipText(NbBundle.getMessage((Class)PatchAction.class, (String)"BTN_Patch_tooltip"));
        HelpCtx helpCtx = new HelpCtx(PatchAction.class.getName());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jFileChooser, string, true, new Object[0], null, 0, helpCtx, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PatchAction.class, (String)"ACSD_PatchDialog"));
        ChooserListener chooserListener = new ChooserListener(dialog, jFileChooser);
        jFileChooser.addActionListener(chooserListener);
        dialog.setVisible(true);
        return chooserListener.getFile();
    }

    private void applyFileDiffs(Patch.FileDifferences[] fileDifferencesArray, FileObject fileObject, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
        HashMap<FileObject, FileObject> hashMap = new HashMap<FileObject, FileObject>();
        boolean bl = false;
        for (int i = 0; i < fileDifferencesArray.length; ++i) {
            Object object;
            FileObject fileObject2 = fileObject.isData() ? fileObject : ((object = fileDifferencesArray[i].getIndexName()) != null ? fileObject.getFileObject((String)object) : PatchAction.findChild(fileObject, fileDifferencesArray[i].getFileName()));
            if (fileObject2 == null) {
                object = fileDifferencesArray[i].getDifferences();
                String string2 = fileDifferencesArray[i].getIndexName();
                if (((FileObject)object).length == 1 && object[0].getFirstStart() == 0 && string2 != null) {
                    try {
                        fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string2);
                    }
                    catch (IOException iOException) {
                        ErrorManager errorManager = ErrorManager.getDefault();
                        errorManager.annotate((Throwable)iOException, "Patch can not create new file, skipping...");
                        errorManager.notify(1, (Throwable)iOException);
                    }
                }
            }
            if (fileObject2 == null) {
                object = fileDifferencesArray[i].getIndexName();
                if (object != null) {
                    arrayList.add(FileUtil.getFileDisplayName((FileObject)fileObject) + '/' + (String)object);
                    continue;
                }
                arrayList.add("sourceHostPath:" + fileDifferencesArray[i].getFileName());
                continue;
            }
            object = this.createFileBackup(fileObject2);
            if (this.applyDiffsTo(fileDifferencesArray[i].getDifferences(), fileObject2)) {
                arrayList2.add(fileObject2);
                hashMap.put(fileObject2, (FileObject)object);
                fileObject2.refresh(true);
                continue;
            }
            bl = true;
        }
        if (arrayList.size() > 0) {
            if (arrayList.size() == fileDifferencesArray.length) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(string == null ? NbBundle.getMessage((Class)PatchAction.class, (String)"MSG_WrongPatch") : NbBundle.getMessage((Class)PatchAction.class, (String)"MSG_WrongPatch_Hint", (Object)string))));
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringBuffer.append(arrayList.get(i).toString());
                    if (i >= arrayList.size() - 1) continue;
                    stringBuffer.append(", ");
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)PatchAction.class, (String)"MSG_NotFoundFiles", (Object)stringBuffer)));
            }
        }
        if (arrayList2.size() > 0) {
            String string3 = bl ? NbBundle.getMessage((Class)PatchAction.class, (String)"MSG_PatchAppliedPartially") : NbBundle.getMessage((Class)PatchAction.class, (String)"MSG_PatchAppliedSuccessfully");
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string3, 0));
            if (NotifyDescriptor.YES_OPTION.equals(object)) {
                this.showDiffs(arrayList2, hashMap);
            }
            PatchAction.removeBackups(arrayList2, hashMap);
        }
    }

    private static FileObject findChild(FileObject fileObject, String string) {
        string = string.replace(File.separatorChar, '/');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        FileObject fileObject2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            fileObject2 = fileObject.getFileObject(string2);
            if (fileObject2 == null || !fileObject2.isFolder()) continue;
            fileObject = fileObject2;
            fileObject2 = null;
        }
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private FileObject createFileBackup(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        FileLock fileLock = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        FileObject fileObject3 = fileObject2.getFileObject(fileObject.getNameExt(), "orig");
        if (fileObject3 == null) {
            fileObject3 = fileObject2.createData(fileObject.getNameExt(), "orig");
        }
        inputStream = fileObject.getInputStream();
        fileLock = fileObject3.lock();
        outputStream = fileObject3.getOutputStream(fileLock);
        FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        FileObject fileObject4 = fileObject3;
        Object var9_10 = null;
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileLock != null) {
            fileLock.releaseLock();
        }
        return fileObject4;
        catch (IOException iOException) {
            FileObject fileObject5;
            try {
                fileObject5 = null;
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                block19: {
                    Object var9_12 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    if (fileLock == null) break block19;
                    fileLock.releaseLock();
                }
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            return fileObject5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean applyDiffsTo(Difference[] differenceArray, FileObject fileObject) {
        File file;
        block35: {
            Reader reader;
            OutputStream outputStream;
            InputStream inputStream;
            block34: {
                block32: {
                    try {
                        file = FileUtil.normalizeFile((File)File.createTempFile("patch", "tmp"));
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                        return false;
                    }
                    file.deleteOnExit();
                    inputStream = null;
                    outputStream = null;
                    reader = Patch.apply(differenceArray, new InputStreamReader(fileObject.getInputStream(), PATCHING_IO_ENCODING));
                    inputStream = new ReaderInputStream(reader, PATCHING_IO_ENCODING);
                    outputStream = new FileOutputStream(file);
                    FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                    Object var11_9 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        break block32;
                    }
                    catch (IOException iOException) {}
                    break block32;
                    {
                        catch (IOException iOException) {
                            String string = NbBundle.getMessage((Class)PatchAction.class, (String)"EXC_PatchApplicationFailed", (Object)iOException.getLocalizedMessage(), (Object)fileObject.getNameExt());
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                            ErrorManager.getDefault().log(string);
                            file.delete();
                            boolean bl = false;
                            Object var11_10 = null;
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                if (outputStream != null) {
                                    outputStream.close();
                                }
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            return bl;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (outputStream != null) {
                                outputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                reader = null;
                inputStream = new FileInputStream(file);
                reader = fileObject.lock();
                outputStream = fileObject.getOutputStream((FileLock)reader);
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                Object var14_21 = null;
                if (reader == null) break block34;
                reader.releaseLock();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                break block35;
            }
            catch (IOException iOException) {}
            break block35;
            {
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage((Class)PatchAction.class, (String)"EXC_CopyOfAppliedPatchFailed", (Object)fileObject.getNameExt())));
                    boolean bl = false;
                    Object var14_22 = null;
                    if (reader != null) {
                        reader.releaseLock();
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var14_23 = null;
                if (reader != null) {
                    reader.releaseLock();
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        file.delete();
        return true;
    }

    private void showDiffs(ArrayList arrayList, HashMap hashMap) {
        for (int i = 0; i < arrayList.size(); ++i) {
            FileObject fileObject = (FileObject)arrayList.get(i);
            FileObject fileObject2 = (FileObject)hashMap.get(fileObject);
            DiffAction.performAction(fileObject2, fileObject, fileObject);
        }
    }

    private static void removeBackups(List list, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            FileObject fileObject = (FileObject)list.get(i);
            FileObject fileObject2 = (FileObject)map.get(fileObject);
            if (fileObject.getSize() == 0L) {
                try {
                    fileObject.delete();
                }
                catch (IOException iOException) {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)iOException, "Patch can not delete file, skipping...");
                    errorManager.notify(1, (Throwable)iOException);
                }
            }
            try {
                fileObject2.delete();
                continue;
            }
            catch (IOException iOException) {
                stringBuffer.append(FileUtil.getFileDisplayName((FileObject)fileObject2));
                stringBuffer.append("\n");
                stringBuffer2.append(iOException.getLocalizedMessage());
                stringBuffer2.append("\n");
            }
        }
        if (stringBuffer.length() > 0) {
            ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)new IOException(), NbBundle.getMessage((Class)PatchAction.class, (String)"EXC_CannotRemoveBackup", (Object)stringBuffer, (Object)stringBuffer2)));
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PatchAction.class);
    }

    class ChooserListener
    implements ActionListener {
        private Dialog dialog;
        private JFileChooser chooser;
        private File file = null;

        public ChooserListener(Dialog dialog, JFileChooser jFileChooser) {
            this.dialog = dialog;
            this.chooser = jFileChooser;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == "ApproveSelection") {
                if (this.dialog != null) {
                    this.file = this.chooser.getSelectedFile();
                    this.dialog.setVisible(false);
                }
            } else if (this.dialog != null) {
                this.file = null;
                this.dialog.setVisible(false);
            }
        }

        public File getFile() {
            return this.file;
        }
    }
}

