/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.diff.Difference;

public class HuntDiff {
    private HuntDiff() {
    }

    public static Difference[] diff(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        int n2 = stringArray2.length;
        Line[] lineArray = new Line[n2 + 1];
        for (int i = 1; i <= n2; ++i) {
            lineArray[i] = new Line(i, stringArray2[i - 1]);
        }
        Arrays.sort(lineArray, 1, n2 + 1, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Line)object).line.compareTo(((Line)object2).line);
            }

            public boolean equals(Object object) {
                return object == this;
            }
        });
        int[] nArray = new int[n2 + 1];
        boolean[] blArray = new boolean[n2 + 1];
        for (int i = 1; i <= n2; ++i) {
            Line line = lineArray[i];
            nArray[i] = line.lineNo;
            blArray[i] = i == n2 || !line.line.equals(lineArray[i + 1].line);
        }
        nArray[0] = 0;
        blArray[0] = true;
        int[] nArray2 = new int[n + 1];
        for (int i = 1; i <= n; ++i) {
            nArray2[i] = HuntDiff.findAssoc(stringArray[i - 1], lineArray, blArray);
        }
        lineArray = null;
        Candidate[] candidateArray = new Candidate[Math.min(n, n2) + 2];
        candidateArray[0] = new Candidate(0, 0, null);
        candidateArray[1] = new Candidate(n + 1, n2 + 1, null);
        int n3 = 0;
        for (int i = 1; i <= n; ++i) {
            if (nArray2[i] == 0) continue;
            n3 = HuntDiff.merge(candidateArray, n3, i, nArray, blArray, nArray2[i]);
        }
        int[] nArray3 = new int[n + 2];
        Candidate candidate = candidateArray[n3];
        while (candidate != null) {
            nArray3[((Candidate)candidate).a] = candidate.b;
            candidate = candidate.c;
        }
        List list = HuntDiff.getDifferences(nArray3, stringArray, stringArray2);
        HuntDiff.cleanup(list);
        return list.toArray(new Difference[0]);
    }

    private static int findAssoc(String string, Line[] lineArray, boolean[] blArray) {
        for (int i = 1; i < lineArray.length; ++i) {
            if (!blArray[i - 1] || !string.equals(lineArray[i].line)) continue;
            return i;
        }
        return 0;
    }

    private static int merge(Candidate[] candidateArray, int n, int n2, int[] nArray, boolean[] blArray, int n3) {
        int n4 = 0;
        Candidate candidate = candidateArray[0];
        while (true) {
            int n5;
            int n6 = nArray[n3];
            for (n5 = n4; n5 <= n && (candidateArray[n5].b >= n6 || candidateArray[n5 + 1].b <= n6); ++n5) {
            }
            if (n5 <= n) {
                if (candidateArray[n5 + 1].b > n6) {
                    Candidate candidate2 = new Candidate(n2, n6, candidateArray[n5]);
                    candidateArray[n4] = candidate;
                    n4 = n5 + 1;
                    candidate = candidate2;
                }
                if (n5 == n) {
                    candidateArray[n + 2] = candidateArray[n + 1];
                    ++n;
                    break;
                }
            }
            if (blArray[n3]) break;
            ++n3;
        }
        candidateArray[n4] = candidate;
        return n;
    }

    private static List getDifferences(int[] nArray, String[] stringArray, String[] stringArray2) {
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        int n = stringArray.length;
        int n2 = stringArray2.length;
        int n3 = 1;
        int n4 = 1;
        while (true) {
            int n5;
            StringBuffer stringBuffer;
            if (n3 <= n && nArray[n3] == n4) {
                ++n3;
                ++n4;
                continue;
            }
            if (n3 > n) break;
            if (nArray[n3] < n4) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(stringArray[n3 - 1]).append('\n');
                for (n5 = n3 + 1; n5 <= n && nArray[n5] < n4; ++n5) {
                    String string = stringArray[n5 - 1];
                    stringBuffer.append(string).append('\n');
                }
                arrayList.add(new Difference(0, n3, n5 - 1, n4 - 1, 0, stringBuffer.toString(), null));
                n3 = n5;
            } else {
                n5 = nArray[n3];
                stringBuffer = new StringBuffer();
                for (int i = n4; i < n5; ++i) {
                    String string = stringArray2[i - 1];
                    stringBuffer.append(string).append('\n');
                }
                arrayList.add(new Difference(1, n3 - 1, 0, n4, n5 - 1, null, stringBuffer.toString()));
                n4 = n5;
            }
            if (n3 > n) break;
        }
        if (n4 <= n2) {
            arrayList.add(new Difference(1, n, 0, n4, n2, null, null));
        }
        return arrayList;
    }

    private static void cleanup(List list) {
        Difference difference = null;
        for (int i = 0; i < list.size(); ++i) {
            Difference difference2 = (Difference)list.get(i);
            if (difference != null && (difference2.getType() == 1 && difference.getType() == 0 || difference2.getType() == 0 && difference.getType() == 1)) {
                Difference difference3;
                Difference difference4;
                if (1 == difference2.getType()) {
                    difference4 = difference2;
                    difference3 = difference;
                } else {
                    difference4 = difference;
                    difference3 = difference2;
                }
                int n = difference4.getFirstStart() - (difference3.getFirstEnd() - difference3.getFirstStart());
                int n2 = difference3.getFirstStart();
                if (n == n2) {
                    int n3 = difference4.getSecondStart() - (difference3.getFirstEnd() - difference3.getFirstStart());
                    int n4 = difference3.getSecondStart() + 1;
                    Difference difference5 = new Difference(2, n, difference3.getFirstEnd(), difference4.getSecondStart(), difference4.getSecondEnd(), difference3.getFirstText(), difference4.getSecondText());
                    list.set(i - 1, difference5);
                    list.remove(i);
                    --i;
                    difference2 = difference5;
                }
            }
            difference = difference2;
        }
    }

    private static class Candidate {
        private int a;
        private int b;
        private Candidate c;

        public Candidate(int n, int n2, Candidate candidate) {
            this.a = n;
            this.b = n2;
            this.c = candidate;
        }
    }

    private static class Line {
        public int lineNo;
        public String line;
        public int hash;

        public Line(int n, String string) {
            this.lineNo = n;
            this.line = string;
            this.hash = string.hashCode();
        }
    }
}

