/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.diff.builtin.visualizer.DEditorPane;
import org.netbeans.modules.diff.builtin.visualizer.LinesComponent;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class DiffPanel
extends JPanel
implements CaretListener {
    private int totalHeight = 0;
    private int totalLines = 0;
    private int horizontalScroll1ChangedValue = -1;
    private int horizontalScroll2ChangedValue = -1;
    private LinesComponent linesComp1;
    private LinesComponent linesComp2;
    static final long serialVersionUID = 3683458237532937983L;
    private static final String PLAIN_TEXT_MIME = "text/plain";
    private Hashtable kitActions;
    private PropertyChangeListener copyL;
    private PropertyChangeListener copyP;
    private JViewport jViewport1;
    private JViewport jViewport2;
    final JPanel commandPanel = new JPanel();
    final JPanel editorPanel = new JPanel();
    final JLabel fileLabel1 = new JLabel();
    final JLabel fileLabel2 = new JLabel();
    final JPanel filePanel1 = new JPanel();
    final JPanel filePanel2 = new JPanel();
    final DEditorPane jEditorPane1 = new DEditorPane();
    final DEditorPane jEditorPane2 = new DEditorPane();
    final JScrollPane jScrollPane1 = new JScrollPane();
    final JScrollPane jScrollPane2 = new JScrollPane();
    final JSplitPane jSplitPane1 = new JSplitPane();
    final JButton nextButton = new JButton();
    final JButton prevButton = new JButton();

    public DiffPanel() {
        this.initComponents();
        this.commandPanel.remove(this.prevButton);
        this.commandPanel.remove(this.nextButton);
        JPanel jPanel = new JPanel(new FlowLayout(4, 5, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add(this.prevButton);
        jPanel.add(this.nextButton);
        this.remove(this.commandPanel);
        this.putClientProperty("DiffPresenter.toolbarPanel", jPanel);
        this.setName(NbBundle.getMessage((Class)DiffPanel.class, (String)"DiffComponent.title"));
        this.initActions();
        this.jSplitPane1.setResizeWeight(0.5);
        this.putClientProperty("PersistenceType", "Never");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)DiffPanel.class, (String)"ACS_DiffPanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DiffPanel.class, (String)"ACS_DiffPanelA11yDesc"));
        this.jEditorPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)DiffPanel.class, (String)"ACS_EditorPane1A11yName"));
        this.jEditorPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DiffPanel.class, (String)"ACS_EditorPane1A11yDescr"));
        this.jEditorPane2.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)DiffPanel.class, (String)"ACS_EditorPane2A11yName"));
        this.jEditorPane2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DiffPanel.class, (String)"ACS_EditorPane2A11yDescr"));
    }

    public void addNotify() {
        super.addNotify();
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.jEditorPane1);
        editorUI.removeLayer("highlight-row-layer");
        EditorUI editorUI2 = Utilities.getEditorUI((JTextComponent)this.jEditorPane2);
        editorUI2.removeLayer("highlight-row-layer");
        JComponent jComponent = (JComponent)this.getParent();
        ButtonAction buttonAction = new ButtonAction(this.nextButton);
        ButtonAction buttonAction2 = new ButtonAction(this.prevButton);
        jComponent.getActionMap().put("jumpNext", buttonAction);
        jComponent.getActionMap().put("jumpPrev", buttonAction2);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.commandPanel.setLayout(new GridBagLayout());
        this.prevButton.setIcon(new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/prev.gif", (boolean)true)));
        this.prevButton.setToolTipText(NbBundle.getBundle((Class)DiffPanel.class).getString("DiffComponent.prevButton.toolTipText"));
        this.prevButton.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        this.commandPanel.add((Component)this.prevButton, gridBagConstraints);
        this.nextButton.setIcon(new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/next.gif", (boolean)true)));
        this.nextButton.setToolTipText(NbBundle.getBundle((Class)DiffPanel.class).getString("DiffComponent.nextButton.toolTipText"));
        this.nextButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.commandPanel.add((Component)this.nextButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.commandPanel, gridBagConstraints);
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorPanel.setPreferredSize(new Dimension(700, 600));
        this.jSplitPane1.setDividerSize(4);
        this.filePanel1.setLayout(new GridBagLayout());
        this.jEditorPane1.addCaretListener(this);
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filePanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.fileLabel1.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.filePanel1.add((Component)this.fileLabel1, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.filePanel1);
        this.filePanel2.setLayout(new GridBagLayout());
        this.jEditorPane2.addCaretListener(this);
        this.jScrollPane2.setViewportView(this.jEditorPane2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filePanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        this.fileLabel2.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.filePanel2.add((Component)this.fileLabel2, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.filePanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.editorPanel.add((Component)this.jSplitPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.editorPanel, gridBagConstraints);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() == this.jEditorPane1) {
            this.jEditorPane1CaretUpdate(caretEvent);
        } else if (caretEvent.getSource() == this.jEditorPane2) {
            this.jEditorPane2CaretUpdate(caretEvent);
        }
    }

    private void jEditorPane1CaretUpdate(CaretEvent caretEvent) {
    }

    private void jEditorPane2CaretUpdate(CaretEvent caretEvent) {
    }

    public void setCurrentLine(int n, int n2) {
        if (n > 0) {
            this.showLine(n, n2);
        }
    }

    public void addPrevLineButtonListener(ActionListener actionListener) {
        this.prevButton.addActionListener(actionListener);
    }

    public void addNextLineButtonListener(ActionListener actionListener) {
        this.nextButton.addActionListener(actionListener);
    }

    private void jScrollBar1AdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.exitForm(null);
    }

    private void exitForm(WindowEvent windowEvent) {
    }

    private void initActions() {
        this.jEditorPane1.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                DiffPanel.this.editorActivated(DiffPanel.this.jEditorPane1);
            }

            public void focusLost(FocusEvent focusEvent) {
                DiffPanel.this.editorDeactivated(DiffPanel.this.jEditorPane1);
            }
        });
        this.jEditorPane2.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                DiffPanel.this.editorActivated(DiffPanel.this.jEditorPane2);
            }

            public void focusLost(FocusEvent focusEvent) {
                DiffPanel.this.editorDeactivated(DiffPanel.this.jEditorPane2);
            }
        });
    }

    private Action getAction(String string, JEditorPane jEditorPane) {
        Hashtable<Object, Action> hashtable;
        if (this.kitActions == null) {
            this.kitActions = new Hashtable();
        }
        if ((hashtable = (Hashtable<Object, Action>)this.kitActions.get(jEditorPane)) == null) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit == null) {
                return null;
            }
            Action[] actionArray = editorKit.getActions();
            hashtable = new Hashtable<Object, Action>(actionArray.length);
            int n = actionArray.length;
            for (int i = 0; i < n; ++i) {
                hashtable.put(actionArray[i].getValue("Name"), actionArray[i]);
            }
            this.kitActions.put(jEditorPane, hashtable);
        }
        return (Action)hashtable.get(string);
    }

    private void editorActivated(final JEditorPane jEditorPane) {
        final Action action = this.getAction("copy-to-clipboard", jEditorPane);
        if (action != null) {
            final CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get((Class)CopyAction.class);
            final ActionPerformer actionPerformer = new ActionPerformer(){

                public void performAction(SystemAction systemAction) {
                    action.actionPerformed(new ActionEvent(jEditorPane, 0, ""));
                }
            };
            callbackSystemAction.setActionPerformer((ActionPerformer)(action.isEnabled() ? actionPerformer : null));
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                        if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                            callbackSystemAction.setActionPerformer(actionPerformer);
                        } else if (callbackSystemAction.getActionPerformer() == actionPerformer) {
                            callbackSystemAction.setActionPerformer(null);
                        }
                    }
                }
            };
            action.addPropertyChangeListener(propertyChangeListener);
            if (jEditorPane.equals(this.jEditorPane1)) {
                this.copyL = propertyChangeListener;
            } else {
                this.copyP = propertyChangeListener;
            }
        }
    }

    private void editorDeactivated(JEditorPane jEditorPane) {
        Action action = this.getAction("copy-to-clipboard", jEditorPane);
        PropertyChangeListener propertyChangeListener = jEditorPane.equals(this.jEditorPane1) ? this.copyL : this.copyP;
        if (action != null) {
            action.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void open() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffPanel.this.jSplitPane1.setDividerLocation(0.5);
                DiffPanel.this.openPostProcess();
            }
        });
    }

    protected void openPostProcess() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffPanel.this.expandFolds();
                DiffPanel.this.initGlobalSizes();
                DiffPanel.this.addChangeListeners();
            }
        });
    }

    private void expandFolds() {
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)this.jEditorPane1);
        FoldUtilities.expandAll((FoldHierarchy)foldHierarchy);
        foldHierarchy = FoldHierarchy.get((JTextComponent)this.jEditorPane2);
        FoldUtilities.expandAll((FoldHierarchy)foldHierarchy);
    }

    private void initGlobalSizes() {
        int n;
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        StyledDocument styledDocument2 = (StyledDocument)this.jEditorPane2.getDocument();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)styledDocument.getEndPosition().getOffset());
        int n3 = Math.max(n2, n = NbDocument.findLineNumber((StyledDocument)styledDocument2, (int)styledDocument2.getEndPosition().getOffset()));
        if (n3 < 1) {
            n3 = 1;
        }
        this.totalLines = n3;
        int n4 = this.jEditorPane2.getSize().height;
        int n5 = this.jEditorPane1.getSize().height;
        if (n4 > n5) {
            n5 = n4;
        }
        this.totalHeight = n5;
    }

    private void showLine(int n, int n2) {
        this.linesComp1.setActiveLine(n);
        this.linesComp2.setActiveLine(n);
        this.linesComp2.repaint();
        this.linesComp1.repaint();
        int n3 = 5;
        if (n <= 5) {
            n3 = n / 2;
        }
        int n4 = this.jViewport1.getExtentSize().height;
        this.initGlobalSizes();
        Point point = this.jViewport1.getViewPosition();
        Point point2 = this.jViewport2.getViewPosition();
        int n5 = this.totalHeight * (n - n3 - 1) / (this.totalLines + 1);
        try {
            int n6 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane1.getDocument()), (int)(n - 1));
            int n7 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane2.getDocument()), (int)(n - 1));
            this.jEditorPane1.setCaretPosition(n6);
            this.jEditorPane2.setCaretPosition(n7);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ErrorManager.getDefault().notify((Throwable)indexOutOfBoundsException);
        }
        if (n5 < point.y || n5 + (n2 + n3) * this.totalHeight / this.totalLines > point.y + n4) {
            point.y = n5;
            this.jViewport1.setViewPosition(point);
        }
    }

    private void joinScrollBars() {
        final JScrollBar jScrollBar = this.jScrollPane1.getHorizontalScrollBar();
        final JScrollBar jScrollBar2 = this.jScrollPane1.getVerticalScrollBar();
        final JScrollBar jScrollBar3 = this.jScrollPane2.getHorizontalScrollBar();
        final JScrollBar jScrollBar4 = this.jScrollPane2.getVerticalScrollBar();
        jScrollBar2.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar2.getValue();
                int n2 = jScrollBar4.getValue();
                if (n2 != n) {
                    jScrollBar4.setValue(n);
                }
            }
        });
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
        jScrollBar4.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar4.getValue();
                int n2 = jScrollBar2.getValue();
                if (n2 != n) {
                    jScrollBar2.setValue(n);
                }
            }
        });
        jScrollBar.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar.getValue();
                if (n == DiffPanel.this.horizontalScroll1ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar3.getMaximum();
                int n4 = jScrollBar.getModel().getExtent();
                int n5 = jScrollBar3.getModel().getExtent();
                if (n2 == n4) {
                    DiffPanel.this.horizontalScroll2ChangedValue = 0;
                } else {
                    DiffPanel.this.horizontalScroll2ChangedValue = n * (n3 - n5) / (n2 - n4);
                }
                DiffPanel.this.horizontalScroll1ChangedValue = -1;
                jScrollBar3.setValue(DiffPanel.this.horizontalScroll2ChangedValue);
            }
        });
        jScrollBar3.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar3.getValue();
                if (n == DiffPanel.this.horizontalScroll2ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar3.getMaximum();
                int n4 = jScrollBar.getModel().getExtent();
                int n5 = jScrollBar3.getModel().getExtent();
                if (n3 == n5) {
                    DiffPanel.this.horizontalScroll1ChangedValue = 0;
                } else {
                    DiffPanel.this.horizontalScroll1ChangedValue = n * (n2 - n4) / (n3 - n5);
                }
                DiffPanel.this.horizontalScroll2ChangedValue = -1;
                jScrollBar.setValue(DiffPanel.this.horizontalScroll1ChangedValue);
            }
        });
        this.jSplitPane1.setDividerLocation(0.5);
    }

    private String strCharacters(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void customizeEditor(JEditorPane jEditorPane) {
        StyledDocument styledDocument;
        EditorKit editorKit = jEditorPane.getEditorKit();
        Document document = jEditorPane.getDocument();
        try {
            styledDocument = (StyledDocument)jEditorPane.getDocument();
        }
        catch (ClassCastException classCastException) {
            styledDocument = new DefaultStyledDocument();
            try {
                styledDocument.insertString(0, document.getText(0, document.getLength()), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            jEditorPane.setDocument(styledDocument);
        }
        int n = styledDocument.getEndPosition().getOffset();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = Integer.toString(n2).length();
        for (int i = 0; i <= n2; ++i) {
            int n4 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)i);
            String string = Integer.toString(i + 1);
            if (string.length() >= n3) continue;
            string = this.strCharacters(' ', n3 - string.length()) + string;
        }
    }

    private void addChangeListeners() {
        this.jEditorPane1.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        DiffPanel.access$300(11.access$700(this.this$1));
                        DiffPanel.access$800(11.access$700(this.this$1)).repaint();
                    }
                });
            }

            static /* synthetic */ DiffPanel access$700(11 var0) {
                return var0.DiffPanel.this;
            }
        });
        this.jEditorPane2.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        DiffPanel.access$300(13.access$900(this.this$1));
                        DiffPanel.access$1000(13.access$900(this.this$1)).repaint();
                    }
                });
            }

            static /* synthetic */ DiffPanel access$900(13 var0) {
                return var0.DiffPanel.this;
            }
        });
    }

    public void setSource1(Reader reader) throws IOException {
        EditorKit editorKit = this.jEditorPane1.getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document document = editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane1.setEditorKit(editorKit);
        }
        try {
            editorKit.read(reader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException("Can not locate the beginning of the document.");
        }
        finally {
            reader.close();
        }
        editorKit.install(this.jEditorPane1);
        this.jEditorPane1.setDocument(document);
        this.jEditorPane1.setEditable(false);
        this.customizeEditor(this.jEditorPane1);
        this.linesComp1 = new LinesComponent(this.jEditorPane1);
        this.jScrollPane1.setRowHeaderView(this.linesComp1);
        this.jViewport1 = this.jScrollPane1.getViewport();
    }

    public void setSource2(Reader reader) throws IOException {
        EditorKit editorKit = this.jEditorPane2.getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document document = editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane2.setEditorKit(editorKit);
        }
        try {
            editorKit.read(reader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException("Can not locate the beginning of the document.");
        }
        finally {
            reader.close();
        }
        editorKit.install(this.jEditorPane2);
        this.jEditorPane2.setDocument(document);
        this.jEditorPane2.setEditable(false);
        this.customizeEditor(this.jEditorPane2);
        this.linesComp2 = new LinesComponent(this.jEditorPane2);
        this.jScrollPane2.setRowHeaderView(this.linesComp2);
        this.jViewport2 = this.jScrollPane2.getViewport();
        this.joinScrollBars();
    }

    public void setSource1Title(String string) {
        this.fileLabel1.setText(string);
        this.fileLabel1.setMinimumSize(new Dimension(3, this.fileLabel1.getMinimumSize().height));
    }

    public void setSource2Title(String string) {
        this.fileLabel2.setText(string);
        this.fileLabel2.setMinimumSize(new Dimension(3, this.fileLabel2.getMinimumSize().height));
    }

    public void setMimeType1(String string) {
        this.jEditorPane1.setContentType(string);
        EditorKit editorKit = JEditorPane.createEditorKitForContentType(string);
        if (editorKit == null) {
            editorKit = JEditorPane.createEditorKitForContentType(PLAIN_TEXT_MIME);
        }
        this.jEditorPane1.setEditorKit(editorKit);
    }

    public void setMimeType2(String string) {
        this.jEditorPane2.setContentType(string);
        EditorKit editorKit = JEditorPane.createEditorKitForContentType(string);
        if (editorKit == null) {
            editorKit = JEditorPane.createEditorKitForContentType(PLAIN_TEXT_MIME);
        }
        this.jEditorPane2.setEditorKit(editorKit);
    }

    public void setDocument1(Document document) {
        if (document != null) {
            this.jEditorPane1.setDocument(document);
        }
    }

    public void setDocument2(Document document) {
        if (document != null) {
            this.jEditorPane2.setDocument(document);
        }
    }

    String getDocumentText1() {
        return this.jEditorPane1.getText();
    }

    String getDocumentText2() {
        return this.jEditorPane2.getText();
    }

    private void setHighlight(StyledDocument styledDocument, int n, int n2, Color color) {
        for (int i = n - 1; i < n2; ++i) {
            if (i < 0) continue;
            try {
                int n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)i);
                if (n3 < 0) continue;
                Style style = styledDocument.getLogicalStyle(n3);
                if (style == null) {
                    style = styledDocument.addStyle("diff-style(" + color + "):1500", null);
                }
                style.addAttribute(StyleConstants.ColorConstants.Background, color);
                styledDocument.setLogicalStyle(n3, style);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ErrorManager.getDefault().annotate((Throwable)indexOutOfBoundsException, "#67631 reappreared. Please reopen with details.");
                ErrorManager.getDefault().notify((Throwable)indexOutOfBoundsException);
            }
        }
    }

    private void unhighlight(StyledDocument styledDocument) {
        int n = styledDocument.getEndPosition().getOffset();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        Style style = styledDocument.addStyle("diff-style(white):1500", null);
        style.addAttribute(StyleConstants.ColorConstants.Background, Color.white);
        for (int i = 0; i <= n2; ++i) {
            int n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)i);
            styledDocument.setLogicalStyle(n3, style);
        }
    }

    public void unhighlightAll() {
        this.unhighlight((StyledDocument)this.jEditorPane1.getDocument());
        this.unhighlight((StyledDocument)this.jEditorPane2.getDocument());
    }

    public void highlightRegion1(int n, int n2, Color color) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        this.setHighlight(styledDocument, n, n2, color);
    }

    public void highlightRegion2(int n, int n2, Color color) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane2.getDocument();
        this.setHighlight(styledDocument, n, n2, color);
    }

    private void addEmptyLines(StyledDocument styledDocument, int n, int n2) {
        int n3 = styledDocument.getEndPosition().getOffset();
        int n4 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n3);
        int n5 = n3 - 1;
        if (n <= n4) {
            n5 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
        }
        String string = this.strCharacters('\n', n2);
        try {
            styledDocument.insertString(n5, string, null);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    public void addEmptyLines1(int n, int n2) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        this.addEmptyLines(styledDocument, n, n2);
        this.linesComp1.addEmptyLines(n, n2);
    }

    public void addEmptyLines2(int n, int n2) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane2.getDocument();
        this.addEmptyLines(styledDocument, n, n2);
        this.linesComp2.addEmptyLines(n, n2);
    }

    static /* synthetic */ LinesComponent access$800(DiffPanel diffPanel) {
        return diffPanel.linesComp1;
    }

    static /* synthetic */ LinesComponent access$1000(DiffPanel diffPanel) {
        return diffPanel.linesComp2;
    }

    private static class ButtonAction
    extends AbstractAction {
        final JButton button;

        public ButtonAction(JButton jButton) {
            this.button = jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.button.doClick();
        }
    }
}

