/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.diff.builtin.provider.BuiltInDiffProvider;
import org.netbeans.modules.diff.builtin.visualizer.DEditorPane;
import org.netbeans.modules.diff.builtin.visualizer.GraphicalDiffVisualizer;
import org.netbeans.modules.diff.builtin.visualizer.LinesComponent;
import org.netbeans.spi.diff.DiffProvider;
import org.netbeans.spi.diff.DiffVisualizer;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class DiffViewImpl
extends JPanel
implements DiffView,
CaretListener {
    public static final Color COLOR_MISSING = new Color(255, 160, 180);
    public static final Color COLOR_ADDED = new Color(180, 255, 180);
    public static final Color COLOR_CHANGED = new Color(160, 200, 255);
    private Difference[] diffs = null;
    private int[][] diffShifts;
    private Color colorMissing = COLOR_MISSING;
    private Color colorAdded = COLOR_ADDED;
    private Color colorChanged = COLOR_CHANGED;
    private int currentDiffLine = -1;
    private int totalHeight = 0;
    private int totalLines = 0;
    private int horizontalScroll1ChangedValue = -1;
    private int horizontalScroll2ChangedValue = -1;
    private LinesComponent linesComp1;
    private LinesComponent linesComp2;
    private String source1;
    private String source2;
    private static final String PLAIN_TEXT_MIME = "text/plain";
    private int onLayoutLine;
    private int onLayoutLength;
    private Hashtable kitActions;
    private PropertyChangeListener copyL;
    private PropertyChangeListener copyP;
    private JViewport jViewport1;
    private JViewport jViewport2;
    final JLabel fileLabel1 = new JLabel();
    final JLabel fileLabel2 = new JLabel();
    final JPanel filePanel1 = new JPanel();
    final JPanel filePanel2 = new JPanel();
    final DEditorPane jEditorPane1 = new DEditorPane();
    final DEditorPane jEditorPane2 = new DEditorPane();
    final JScrollPane jScrollPane1 = new JScrollPane();
    final JScrollPane jScrollPane2 = new JScrollPane();
    final JSplitPane jSplitPane1 = new JSplitPane();

    public DiffViewImpl() {
    }

    private static void copyStreamsCloseAll(Writer writer, Reader reader) throws IOException {
        int n;
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray)) > 0) {
            writer.write(cArray, 0, n);
        }
        reader.close();
        writer.close();
    }

    public DiffViewImpl(StreamSource streamSource, StreamSource streamSource2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(DiffVisualizer.class));
        Collection collection = result.allInstances();
        Object object4 = collection.iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            if (!(object3 instanceof GraphicalDiffVisualizer)) continue;
            object2 = (GraphicalDiffVisualizer)object3;
            this.colorAdded = ((GraphicalDiffVisualizer)object2).getColorAdded();
            this.colorChanged = ((GraphicalDiffVisualizer)object2).getColorChanged();
            this.colorMissing = ((GraphicalDiffVisualizer)object2).getColorMissing();
        }
        object4 = streamSource.createReader();
        object3 = streamSource2.createReader();
        object2 = streamSource.getTitle();
        String string = streamSource2.getTitle();
        String string2 = streamSource.getMIMEType();
        String string3 = streamSource2.getMIMEType();
        if (string2 == null) {
            string2 = string3;
        }
        if (string3 == null) {
            string3 = string2;
        }
        this.saveSources((Reader)object4, (Reader)object3);
        this.initComponents();
        this.setName(NbBundle.getMessage((Class)DiffViewImpl.class, (String)"DiffComponent.title"));
        this.initActions();
        this.jSplitPane1.setResizeWeight(0.5);
        this.putClientProperty("PersistenceType", "Never");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)DiffViewImpl.class, (String)"ACS_DiffPanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DiffViewImpl.class, (String)"ACS_DiffPanelA11yDesc"));
        this.jEditorPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)DiffViewImpl.class, (String)"ACS_EditorPane1A11yName"));
        this.jEditorPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DiffViewImpl.class, (String)"ACS_EditorPane1A11yDescr"));
        this.jEditorPane2.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)DiffViewImpl.class, (String)"ACS_EditorPane2A11yName"));
        this.jEditorPane2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DiffViewImpl.class, (String)"ACS_EditorPane2A11yDescr"));
        if (this.source1 == null) {
            this.jEditorPane1.setVisible(false);
        }
        if (this.source2 == null) {
            this.jEditorPane2.setVisible(false);
        }
        if (object4 != null && object3 != null) {
            object = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
            if (object == null) {
                object = new BuiltInDiffProvider();
            }
            this.diffs = ((DiffProvider)object).computeDiff(new StringReader(this.source1), new StringReader(this.source2));
        } else {
            this.diffs = new Difference[0];
        }
        this.diffShifts = new int[this.diffs.length][2];
        this.setSource1Title((String)object2);
        this.setSource2Title(string);
        object = string2;
        String string4 = string3;
        try {
            Runnable runnable = new Runnable((String)object, string4){
                private final /* synthetic */ String val$f1;
                private final /* synthetic */ String val$f2;
                {
                    this.val$f1 = string;
                    this.val$f2 = string2;
                }

                public void run() {
                    DiffViewImpl.this.setMimeType1(this.val$f1);
                    DiffViewImpl.this.setMimeType2(this.val$f2);
                    try {
                        if (DiffViewImpl.this.source1 != null) {
                            DiffViewImpl.this.setSource1(new StringReader(DiffViewImpl.this.source1));
                        }
                        if (DiffViewImpl.this.source2 != null) {
                            DiffViewImpl.this.setSource2(new StringReader(DiffViewImpl.this.source2));
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    DiffViewImpl.this.insertEmptyLines(true);
                    DiffViewImpl.this.setDiffHighlight(true);
                    DiffViewImpl.this.insertEmptyLinesNotReported();
                    Color color = UIManager.getColor("scrollpane_border");
                    if (color == null) {
                        color = UIManager.getColor("controlShadow");
                    }
                    DiffViewImpl.this.jScrollPane1.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
                    DiffViewImpl.this.jScrollPane2.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
                    DiffViewImpl.this.jSplitPane1.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.notify((Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.notify((Throwable)invocationTargetException);
        }
    }

    private void saveSources(Reader reader, Reader reader2) throws IOException {
        StringWriter stringWriter;
        if (reader != null) {
            stringWriter = new StringWriter();
            DiffViewImpl.copyStreamsCloseAll(stringWriter, reader);
            this.source1 = stringWriter.toString();
        }
        if (reader2 != null) {
            stringWriter = new StringWriter();
            DiffViewImpl.copyStreamsCloseAll(stringWriter, reader2);
            this.source2 = stringWriter.toString();
        }
    }

    public boolean requestFocusInWindow() {
        return this.jEditorPane1.requestFocusInWindow();
    }

    public Component getComponent() {
        return this;
    }

    public int getDifferenceCount() {
        return this.diffs.length;
    }

    public boolean canSetCurrentDifference() {
        return true;
    }

    public void setCurrentDifference(int n) throws UnsupportedOperationException {
        if (n < 0 || n >= this.diffs.length) {
            throw new IllegalArgumentException("Illegal difference number: " + n);
        }
        this.currentDiffLine = n;
        this.showCurrentLine();
    }

    public int getCurrentDifference() throws UnsupportedOperationException {
        int n = this.currentDiffLine;
        if (this.jViewport1 != null) {
            int n2 = this.jViewport1.getViewSize().height;
            this.initGlobalSizes();
            Point point = this.jViewport1.getViewPosition();
            int n3 = 2;
            float f = (float)point.y / (float)n2;
            int n4 = (int)(f * (float)this.totalLines) + n3;
            float f2 = (float)(this.jViewport1.getHeight() + point.y) / (float)n2;
            int n5 = (int)(f2 * (float)this.totalLines) - n3;
            for (int i = 0; i < this.diffs.length; ++i) {
                int n6 = this.diffShifts[i][0] + this.diffs[i].getFirstStart();
                int n7 = this.diffShifts[i][0] + this.diffs[i].getFirstEnd();
                if ((n4 >= n6 || n6 >= n5) && (n4 >= n7 || n7 >= n5)) continue;
                if (i == this.currentDiffLine) {
                    return this.currentDiffLine;
                }
                n = i;
            }
        }
        return n;
    }

    public JToolBar getToolBar() {
        return null;
    }

    private void showCurrentLine() {
        Difference difference = this.diffs[this.currentDiffLine];
        int n = difference.getFirstStart() + this.diffShifts[this.currentDiffLine][0];
        if (difference.getType() == 1) {
            ++n;
        }
        int n2 = difference.getFirstEnd() - difference.getFirstStart() + 1;
        int n3 = difference.getSecondEnd() - difference.getSecondStart() + 1;
        int n4 = Math.max(n2, n3);
        this.setCurrentLine(n, n4);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerSize(4);
        this.filePanel1.setLayout(new GridBagLayout());
        this.jEditorPane1.addCaretListener(this);
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filePanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.fileLabel1.setHorizontalAlignment(0);
        this.fileLabel1.setLabelFor(this.jEditorPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.filePanel1.add((Component)this.fileLabel1, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.filePanel1);
        this.filePanel2.setLayout(new GridBagLayout());
        this.jEditorPane2.addCaretListener(this);
        this.jScrollPane2.setViewportView(this.jEditorPane2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filePanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        this.fileLabel2.setHorizontalAlignment(0);
        this.fileLabel2.setLabelFor(this.jEditorPane2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.filePanel2.add((Component)this.fileLabel2, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.filePanel2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() == this.jEditorPane1) {
            this.jEditorPane1CaretUpdate(caretEvent);
        } else if (caretEvent.getSource() == this.jEditorPane2) {
            this.jEditorPane2CaretUpdate(caretEvent);
        }
    }

    private void jEditorPane1CaretUpdate(CaretEvent caretEvent) {
    }

    private void jEditorPane2CaretUpdate(CaretEvent caretEvent) {
    }

    public void setCurrentLine(int n, int n2) {
        if (n > 0) {
            this.showLine(n, n2);
        }
        this.onLayoutLine = n;
        this.onLayoutLength = n2;
    }

    private void initActions() {
        this.jEditorPane1.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                DiffViewImpl.this.editorActivated(DiffViewImpl.this.jEditorPane1);
            }

            public void focusLost(FocusEvent focusEvent) {
                DiffViewImpl.this.editorDeactivated(DiffViewImpl.this.jEditorPane1);
            }
        });
        this.jEditorPane2.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                DiffViewImpl.this.editorActivated(DiffViewImpl.this.jEditorPane2);
            }

            public void focusLost(FocusEvent focusEvent) {
                DiffViewImpl.this.editorDeactivated(DiffViewImpl.this.jEditorPane2);
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.jEditorPane1);
        editorUI.removeLayer("highlight-row-layer");
        EditorUI editorUI2 = Utilities.getEditorUI((JTextComponent)this.jEditorPane2);
        editorUI2.removeLayer("highlight-row-layer");
        ArrayList<Action> arrayList = new ArrayList<Action>(2);
        arrayList.add(this.getActionMap().get("jumpNext"));
        arrayList.add(this.getActionMap().get("jumpPrev"));
        this.jEditorPane1.setPopupActions(arrayList);
        this.jEditorPane2.setPopupActions(arrayList);
        this.expandFolds();
        this.initGlobalSizes();
        this.addChangeListeners();
    }

    public void doLayout() {
        super.doLayout();
        this.setCurrentLine(this.onLayoutLine, this.onLayoutLength);
        this.onLayoutLine = 0;
    }

    private Action getAction(String string, JEditorPane jEditorPane) {
        Hashtable<Object, Action> hashtable;
        if (this.kitActions == null) {
            this.kitActions = new Hashtable();
        }
        if ((hashtable = (Hashtable<Object, Action>)this.kitActions.get(jEditorPane)) == null) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit == null) {
                return null;
            }
            Action[] actionArray = editorKit.getActions();
            hashtable = new Hashtable<Object, Action>(actionArray.length);
            int n = actionArray.length;
            for (int i = 0; i < n; ++i) {
                hashtable.put(actionArray[i].getValue("Name"), actionArray[i]);
            }
            this.kitActions.put(jEditorPane, hashtable);
        }
        return (Action)hashtable.get(string);
    }

    private void editorActivated(final JEditorPane jEditorPane) {
        final Action action = this.getAction("copy-to-clipboard", jEditorPane);
        if (action != null) {
            final CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get((Class)CopyAction.class);
            final ActionPerformer actionPerformer = new ActionPerformer(){

                public void performAction(SystemAction systemAction) {
                    action.actionPerformed(new ActionEvent(jEditorPane, 0, ""));
                }
            };
            callbackSystemAction.setActionPerformer((ActionPerformer)(action.isEnabled() ? actionPerformer : null));
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                        if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                            callbackSystemAction.setActionPerformer(actionPerformer);
                        } else if (callbackSystemAction.getActionPerformer() == actionPerformer) {
                            callbackSystemAction.setActionPerformer(null);
                        }
                    }
                }
            };
            action.addPropertyChangeListener(propertyChangeListener);
            if (jEditorPane.equals(this.jEditorPane1)) {
                this.copyL = propertyChangeListener;
            } else {
                this.copyP = propertyChangeListener;
            }
        }
    }

    private void editorDeactivated(JEditorPane jEditorPane) {
        Action action = this.getAction("copy-to-clipboard", jEditorPane);
        PropertyChangeListener propertyChangeListener = jEditorPane.equals(this.jEditorPane1) ? this.copyL : this.copyP;
        if (action != null) {
            action.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private void expandFolds() {
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)this.jEditorPane1);
        FoldUtilities.expandAll((FoldHierarchy)foldHierarchy);
        foldHierarchy = FoldHierarchy.get((JTextComponent)this.jEditorPane2);
        FoldUtilities.expandAll((FoldHierarchy)foldHierarchy);
    }

    private void initGlobalSizes() {
        int n;
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        StyledDocument styledDocument2 = (StyledDocument)this.jEditorPane2.getDocument();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)styledDocument.getEndPosition().getOffset());
        int n3 = Math.max(n2, n = NbDocument.findLineNumber((StyledDocument)styledDocument2, (int)styledDocument2.getEndPosition().getOffset()));
        if (n3 < 1) {
            n3 = 1;
        }
        this.totalLines = n3;
        int n4 = this.jEditorPane2.getSize().height;
        int n5 = this.jEditorPane1.getSize().height;
        if (n4 > n5) {
            n5 = n4;
        }
        this.totalHeight = n5;
    }

    private void showLine(int n, int n2) {
        this.linesComp1.setActiveLine(n);
        this.linesComp2.setActiveLine(n);
        this.linesComp2.repaint();
        this.linesComp1.repaint();
        int n3 = 5;
        if (n <= 5) {
            n3 = n / 2;
        }
        int n4 = this.jViewport1.getExtentSize().height;
        this.initGlobalSizes();
        Point point = this.jViewport1.getViewPosition();
        Point point2 = this.jViewport2.getViewPosition();
        int n5 = this.totalHeight * (n - n3 - 1) / (this.totalLines + 1);
        try {
            int n6 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane1.getDocument()), (int)(n - 1));
            int n7 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane2.getDocument()), (int)(n - 1));
            this.jEditorPane1.setCaretPosition(n6);
            this.jEditorPane2.setCaretPosition(n7);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ErrorManager.getDefault().notify((Throwable)indexOutOfBoundsException);
        }
        if (n5 < point.y || n5 + (n2 + n3) * this.totalHeight / this.totalLines > point.y + n4) {
            point.y = n5;
            this.jViewport1.setViewPosition(point);
        }
    }

    private void joinScrollBars() {
        final JScrollBar jScrollBar = this.jScrollPane1.getHorizontalScrollBar();
        final JScrollBar jScrollBar2 = this.jScrollPane1.getVerticalScrollBar();
        final JScrollBar jScrollBar3 = this.jScrollPane2.getHorizontalScrollBar();
        final JScrollBar jScrollBar4 = this.jScrollPane2.getVerticalScrollBar();
        jScrollBar2.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar2.getValue();
                int n2 = jScrollBar4.getValue();
                if (n2 != n) {
                    jScrollBar4.setValue(n);
                }
            }
        });
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
        jScrollBar4.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar4.getValue();
                int n2 = jScrollBar2.getValue();
                if (n2 != n) {
                    jScrollBar2.setValue(n);
                }
            }
        });
        jScrollBar.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar.getValue();
                if (n == DiffViewImpl.this.horizontalScroll1ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar3.getMaximum();
                int n4 = jScrollBar.getModel().getExtent();
                int n5 = jScrollBar3.getModel().getExtent();
                if (n2 == n4) {
                    DiffViewImpl.this.horizontalScroll2ChangedValue = 0;
                } else {
                    DiffViewImpl.this.horizontalScroll2ChangedValue = n * (n3 - n5) / (n2 - n4);
                }
                DiffViewImpl.this.horizontalScroll1ChangedValue = -1;
                jScrollBar3.setValue(DiffViewImpl.this.horizontalScroll2ChangedValue);
            }
        });
        jScrollBar3.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar3.getValue();
                if (n == DiffViewImpl.this.horizontalScroll2ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar3.getMaximum();
                int n4 = jScrollBar.getModel().getExtent();
                int n5 = jScrollBar3.getModel().getExtent();
                if (n3 == n5) {
                    DiffViewImpl.this.horizontalScroll1ChangedValue = 0;
                } else {
                    DiffViewImpl.this.horizontalScroll1ChangedValue = n * (n2 - n4) / (n3 - n5);
                }
                DiffViewImpl.this.horizontalScroll2ChangedValue = -1;
                jScrollBar.setValue(DiffViewImpl.this.horizontalScroll1ChangedValue);
            }
        });
        this.jSplitPane1.setDividerLocation(0.5);
    }

    private String strCharacters(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void customizeEditor(JEditorPane jEditorPane) {
        Document document = jEditorPane.getDocument();
        try {
            StyledDocument styledDocument = (StyledDocument)jEditorPane.getDocument();
        }
        catch (ClassCastException classCastException) {
            DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
            try {
                defaultStyledDocument.insertString(0, document.getText(0, document.getLength()), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            jEditorPane.setDocument(defaultStyledDocument);
        }
    }

    private void addChangeListeners() {
        this.jEditorPane1.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        DiffViewImpl.access$1000(10.access$900(this.this$1));
                        DiffViewImpl.access$1100(10.access$900(this.this$1)).repaint();
                    }
                });
            }

            static /* synthetic */ DiffViewImpl access$900(10 var0) {
                return var0.DiffViewImpl.this;
            }
        });
        this.jEditorPane2.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        DiffViewImpl.access$1000(12.access$1200(this.this$1));
                        DiffViewImpl.access$1300(12.access$1200(this.this$1)).repaint();
                    }
                });
            }

            static /* synthetic */ DiffViewImpl access$1200(12 var0) {
                return var0.DiffViewImpl.this;
            }
        });
    }

    public void setSource1(Reader reader) throws IOException {
        EditorKit editorKit = this.jEditorPane1.getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document document = editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane1.setEditorKit(editorKit);
        }
        try {
            editorKit.read(reader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException("Can not locate the beginning of the document.");
        }
        finally {
            reader.close();
        }
        editorKit.install(this.jEditorPane1);
        this.jEditorPane1.setDocument(document);
        this.jEditorPane1.setEditable(false);
        this.customizeEditor(this.jEditorPane1);
        this.linesComp1 = new LinesComponent(this.jEditorPane1);
        this.jScrollPane1.setRowHeaderView(this.linesComp1);
        this.jViewport1 = this.jScrollPane1.getViewport();
    }

    public void setSource2(Reader reader) throws IOException {
        EditorKit editorKit = this.jEditorPane2.getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document document = editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane2.setEditorKit(editorKit);
        }
        try {
            editorKit.read(reader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException("Can not locate the beginning of the document.");
        }
        finally {
            reader.close();
        }
        editorKit.install(this.jEditorPane2);
        this.jEditorPane2.setDocument(document);
        this.jEditorPane2.setEditable(false);
        this.customizeEditor(this.jEditorPane2);
        this.linesComp2 = new LinesComponent(this.jEditorPane2);
        this.jScrollPane2.setRowHeaderView(this.linesComp2);
        this.jViewport2 = this.jScrollPane2.getViewport();
        this.joinScrollBars();
    }

    public void setSource1Title(String string) {
        this.fileLabel1.setText(string);
        this.fileLabel1.setMinimumSize(new Dimension(3, this.fileLabel1.getMinimumSize().height));
    }

    public void setSource2Title(String string) {
        this.fileLabel2.setText(string);
        this.fileLabel2.setMinimumSize(new Dimension(3, this.fileLabel2.getMinimumSize().height));
    }

    public void setMimeType1(String string) {
        this.jEditorPane1.setContentType(string);
        EditorKit editorKit = JEditorPane.createEditorKitForContentType(string);
        if (editorKit == null) {
            editorKit = JEditorPane.createEditorKitForContentType(PLAIN_TEXT_MIME);
        }
        this.jEditorPane1.setEditorKit(editorKit);
    }

    public void setMimeType2(String string) {
        this.jEditorPane2.setContentType(string);
        EditorKit editorKit = JEditorPane.createEditorKitForContentType(string);
        if (editorKit == null) {
            editorKit = JEditorPane.createEditorKitForContentType(PLAIN_TEXT_MIME);
        }
        this.jEditorPane2.setEditorKit(editorKit);
    }

    public void setDocument1(Document document) {
        if (document != null) {
            this.jEditorPane1.setDocument(document);
        }
    }

    public void setDocument2(Document document) {
        if (document != null) {
            this.jEditorPane2.setDocument(document);
        }
    }

    String getDocumentText1() {
        return this.jEditorPane1.getText();
    }

    String getDocumentText2() {
        return this.jEditorPane2.getText();
    }

    private void setHighlight(StyledDocument styledDocument, int n, int n2, Color color) {
        for (int i = n - 1; i < n2; ++i) {
            int n3;
            if (i < 0 || (n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)i)) < 0) continue;
            Style style = styledDocument.getLogicalStyle(n3);
            if (style == null) {
                style = styledDocument.addStyle("diff-style(" + color + "):1500", null);
            }
            style.addAttribute(StyleConstants.ColorConstants.Background, color);
            styledDocument.setLogicalStyle(n3, style);
        }
    }

    private void unhighlight(StyledDocument styledDocument) {
        int n = styledDocument.getEndPosition().getOffset();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        Style style = styledDocument.addStyle("diff-style(white):1500", null);
        style.addAttribute(StyleConstants.ColorConstants.Background, Color.white);
        for (int i = 0; i <= n2; ++i) {
            int n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)i);
            styledDocument.setLogicalStyle(n3, style);
        }
    }

    public void unhighlightAll() {
        this.unhighlight((StyledDocument)this.jEditorPane1.getDocument());
        this.unhighlight((StyledDocument)this.jEditorPane2.getDocument());
    }

    public void highlightRegion1(int n, int n2, Color color) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        this.setHighlight(styledDocument, n, n2, color);
    }

    public void highlightRegion2(int n, int n2, Color color) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane2.getDocument();
        this.setHighlight(styledDocument, n, n2, color);
    }

    private void addEmptyLines(StyledDocument styledDocument, int n, int n2) {
        int n3 = styledDocument.getEndPosition().getOffset();
        int n4 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n3);
        int n5 = n3 - 1;
        if (n <= n4) {
            n5 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
        }
        String string = this.strCharacters('\n', n2);
        try {
            styledDocument.insertString(n5, string, null);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    public void addEmptyLines1(int n, int n2) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        this.addEmptyLines(styledDocument, n, n2);
        this.linesComp1.addEmptyLines(n, n2);
    }

    public void addEmptyLines2(int n, int n2) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane2.getDocument();
        this.addEmptyLines(styledDocument, n, n2);
        this.linesComp2.addEmptyLines(n, n2);
    }

    private void insertEmptyLines(boolean bl) {
        int n = this.diffs.length;
        block5: for (int i = 0; i < n; ++i) {
            Difference difference = this.diffs[i];
            int n2 = difference.getFirstStart() + this.diffShifts[i][0];
            int n3 = difference.getFirstEnd() + this.diffShifts[i][0];
            int n4 = difference.getSecondStart() + this.diffShifts[i][1];
            int n5 = difference.getSecondEnd() + this.diffShifts[i][1];
            if (bl && i < n - 1) {
                this.diffShifts[i + 1][0] = this.diffShifts[i][0];
                this.diffShifts[i + 1][1] = this.diffShifts[i][1];
            }
            switch (difference.getType()) {
                case 0: {
                    this.addEmptyLines2(n4, n3 - n2 + 1);
                    if (!bl || i >= n - 1) continue block5;
                    int[] nArray = this.diffShifts[i + 1];
                    nArray[1] = nArray[1] + (n3 - n2 + 1);
                    continue block5;
                }
                case 1: {
                    this.addEmptyLines1(n2, n5 - n4 + 1);
                    if (!bl || i >= n - 1) continue block5;
                    int[] nArray = this.diffShifts[i + 1];
                    nArray[0] = nArray[0] + (n5 - n4 + 1);
                    continue block5;
                }
                case 2: {
                    int n6 = n3 - n2;
                    int n7 = n5 - n4;
                    if (n6 < n7) {
                        this.addEmptyLines1(n3, n7 - n6);
                        if (!bl || i >= n - 1) continue block5;
                        int[] nArray = this.diffShifts[i + 1];
                        nArray[0] = nArray[0] + (n7 - n6);
                        continue block5;
                    }
                    if (n6 <= n7) continue block5;
                    this.addEmptyLines2(n5, n6 - n7);
                    if (!bl || i >= n - 1) continue block5;
                    int[] nArray = this.diffShifts[i + 1];
                    nArray[1] = nArray[1] + (n6 - n7);
                }
            }
        }
    }

    private void setDiffHighlight(boolean bl) {
        int n = this.diffs.length;
        block5: for (int i = 0; i < n; ++i) {
            Difference difference = this.diffs[i];
            int n2 = difference.getFirstStart() + this.diffShifts[i][0];
            int n3 = difference.getFirstEnd() + this.diffShifts[i][0];
            int n4 = difference.getSecondStart() + this.diffShifts[i][1];
            int n5 = difference.getSecondEnd() + this.diffShifts[i][1];
            switch (difference.getType()) {
                case 0: {
                    if (bl) {
                        this.highlightRegion1(n2, n3, this.colorMissing);
                        continue block5;
                    }
                    this.highlightRegion1(n2, n3, Color.white);
                    continue block5;
                }
                case 1: {
                    if (bl) {
                        this.highlightRegion2(n4, n5, this.colorAdded);
                        continue block5;
                    }
                    this.highlightRegion2(n4, n5, Color.white);
                    continue block5;
                }
                case 2: {
                    if (bl) {
                        this.highlightRegion1(n2, n3, this.colorChanged);
                        this.highlightRegion2(n4, n5, this.colorChanged);
                        continue block5;
                    }
                    this.highlightRegion1(n2, n3, Color.white);
                    this.highlightRegion2(n4, n5, Color.white);
                }
            }
        }
    }

    private void insertEmptyLinesNotReported() {
        String string = this.getDocumentText1();
        String string2 = this.getDocumentText2();
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{-1};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{-1};
        int n = string.length();
        int n2 = string2.length();
        int n3 = 1;
        int n4 = 0;
        do {
            boolean bl;
            int n5;
            int n6;
            int n7 = nArray[0];
            int n8 = nArray3[0];
            String string3 = DiffViewImpl.readLine(nArray, nArray2, string);
            String string4 = DiffViewImpl.readLine(nArray3, nArray4, string2);
            if (string3.length() == 0 && string4.length() > 0) {
                if ((n4 = DiffViewImpl.findDiffForLine(n3, n4, this.diffs, this.diffShifts)) >= this.diffs.length || !DiffViewImpl.isLineInDiff(n3, this.diffs[n4], this.diffShifts[n4])) {
                    if (string4.trim().length() == 0) {
                        n6 = DiffViewImpl.numEmptyLines(nArray[0], string, n4 < this.diffs.length ? this.diffs[n4].getFirstStart() : -1);
                        n5 = DiffViewImpl.numEmptyLines(nArray3[0], string2, n4 < this.diffs.length ? this.diffs[n4].getSecondStart() : -1);
                        bl = n6 > n5;
                    } else {
                        bl = true;
                    }
                    if (bl) {
                        this.addEmptyLines2(n3 - 1, 1);
                        this.shiftDiffs(false, n3);
                        nArray3[0] = n8;
                        nArray4[0] = n8 - 1;
                    }
                }
            } else if (!(string4.length() != 0 || string3.length() <= 0 || (n4 = DiffViewImpl.findDiffForLine(n3, n4, this.diffs, this.diffShifts)) < this.diffs.length && DiffViewImpl.isLineInDiff(n3, this.diffs[n4], this.diffShifts[n4]))) {
                if (string3.trim().length() == 0) {
                    n6 = DiffViewImpl.numEmptyLines(nArray[0], string, n4 < this.diffs.length ? this.diffs[n4].getFirstStart() : -1);
                    n5 = DiffViewImpl.numEmptyLines(nArray3[0], string2, n4 < this.diffs.length ? this.diffs[n4].getSecondStart() : -1);
                    bl = n5 > n6;
                } else {
                    bl = true;
                }
                if (bl) {
                    this.addEmptyLines1(n3 - 1, 1);
                    this.shiftDiffs(true, n3);
                    nArray[0] = n7;
                    nArray2[0] = n7 - 1;
                }
            }
            ++n3;
        } while (nArray[0] < n && nArray3[0] < n2);
    }

    private void shiftDiffs(boolean bl, int n) {
        int n2 = this.diffs.length;
        for (int i = 0; i < n2; ++i) {
            Difference difference = this.diffs[i];
            if (bl) {
                if (difference.getFirstStart() + this.diffShifts[i][0] < n) continue;
                int[] nArray = this.diffShifts[i];
                nArray[0] = nArray[0] + 1;
                continue;
            }
            if (difference.getSecondStart() + this.diffShifts[i][1] < n) continue;
            int[] nArray = this.diffShifts[i];
            nArray[1] = nArray[1] + 1;
        }
    }

    private static int numEmptyLines(int n, String string, int n2) {
        String string2;
        if (n2 >= 0 && n2 <= n) {
            return 0;
        }
        int n3 = 0;
        int[] nArray = new int[]{n};
        int[] nArray2 = new int[]{0};
        while ((string2 = DiffViewImpl.readLine(nArray, nArray2, string)).trim().length() <= 0 && (n2 < 0 || n + ++n3 < n2) && nArray[0] < string.length()) {
        }
        return n3;
    }

    private static int findDiffForLine(int n, int n2, Difference[] differenceArray, int[][] nArray) {
        while (n2 < differenceArray.length && differenceArray[n2].getFirstEnd() + nArray[n2][0] < n && differenceArray[n2].getSecondEnd() + nArray[n2][1] < n) {
            ++n2;
        }
        return n2;
    }

    private static boolean isLineInDiff(int n, Difference difference, int[] nArray) {
        int n2 = difference.getFirstStart() + nArray[0];
        int n3 = difference.getFirstEnd() + nArray[0];
        int n4 = difference.getSecondStart() + nArray[1];
        int n5 = difference.getSecondEnd() + nArray[1];
        return n2 <= n && n3 >= n2 && n3 >= n || n4 <= n && n5 >= n4 && n5 >= n;
    }

    private static String readLine(int[] nArray, int[] nArray2, String string) {
        int n = string.length();
        for (int i = nArray[0]; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\n' && c != '\r') continue;
            nArray2[0] = i;
            break;
        }
        if (nArray2[0] < nArray[0]) {
            nArray2[0] = n;
        }
        String string2 = string.substring(nArray[0], nArray2[0]);
        nArray[0] = nArray2[0] + 1;
        if (nArray[0] < n && string.charAt(nArray2[0]) == '\r' && string.charAt(nArray[0]) == '\n') {
            nArray[0] = nArray[0] + 1;
        }
        return string2;
    }

    static /* synthetic */ void access$1000(DiffViewImpl diffViewImpl) {
        diffViewImpl.initGlobalSizes();
    }

    static /* synthetic */ LinesComponent access$1100(DiffViewImpl diffViewImpl) {
        return diffViewImpl.linesComp1;
    }

    static /* synthetic */ LinesComponent access$1300(DiffViewImpl diffViewImpl) {
        return diffViewImpl.linesComp2;
    }
}

