/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.DiffPresenter;
import org.netbeans.modules.diff.builtin.visualizer.TextDiffEditorSupport;
import org.netbeans.spi.diff.DiffVisualizer;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableOpenSupport;

public class TextDiffVisualizer
extends DiffVisualizer
implements Serializable {
    private boolean contextMode = true;
    private int contextNumLines = 3;
    static final long serialVersionUID = -2481513747957146261L;
    private static final String CONTEXT_MARK1B = "*** ";
    private static final String CONTEXT_MARK1E = " ****\n";
    private static final String CONTEXT_MARK2B = "--- ";
    private static final String CONTEXT_MARK2E = " ----\n";
    private static final String CONTEXT_MARK_DELIMETER = ",";
    private static final String DIFFERENCE_DELIMETER = "***************\n";
    private static final String LINE_PREP = "  ";
    private static final String LINE_PREP_ADD = "+ ";
    private static final String LINE_PREP_REMOVE = "- ";
    private static final String LINE_PREP_CHANGE = "! ";

    public String getDisplayName() {
        return NbBundle.getMessage((Class)TextDiffVisualizer.class, (String)"TextDiffVisualizer.displayName");
    }

    public String getShortDescription() {
        return NbBundle.getMessage((Class)TextDiffVisualizer.class, (String)"TextDiffVisualizer.shortDescription");
    }

    public boolean isContextMode() {
        return this.contextMode;
    }

    public void setContextMode(boolean bl) {
        this.contextMode = bl;
    }

    public int getContextNumLines() {
        return this.contextNumLines;
    }

    public void setContextNumLines(int n) {
        this.contextNumLines = n;
    }

    public Component createView(Difference[] differenceArray, String string, String string2, Reader reader, String string3, String string4, Reader reader2, String string5) throws IOException {
        TextDiffInfo textDiffInfo = new TextDiffInfo(string, string3, string2, string4, reader, reader2, differenceArray);
        textDiffInfo.setContextMode(this.contextMode, this.contextNumLines);
        return ((TextDiffEditorSupport)textDiffInfo.getOpenSupport()).createCloneableTopComponentForMe();
    }

    static InputStream differenceToLineDiffText(Difference[] differenceArray) {
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < differenceArray.length; ++i) {
            Difference difference = differenceArray[i];
            switch (difference.getType()) {
                case 1: {
                    int n4 = difference.getSecondStart();
                    int n2 = difference.getSecondEnd();
                    if (n4 == n2) {
                        stringBuffer.append(difference.getFirstStart() + "a" + n4 + "\n");
                    } else {
                        stringBuffer.append(difference.getFirstStart() + "a" + n4 + CONTEXT_MARK_DELIMETER + n2 + "\n");
                    }
                    TextDiffVisualizer.appendText(stringBuffer, "> ", difference.getSecondText());
                    continue block5;
                }
                case 0: {
                    int n = difference.getFirstStart();
                    int n3 = difference.getFirstEnd();
                    if (n == n3) {
                        stringBuffer.append(n + "d" + difference.getSecondStart() + "\n");
                    } else {
                        stringBuffer.append(n + CONTEXT_MARK_DELIMETER + n3 + "d" + difference.getSecondStart() + "\n");
                    }
                    TextDiffVisualizer.appendText(stringBuffer, "< ", difference.getFirstText());
                    continue block5;
                }
                case 2: {
                    int n = difference.getFirstStart();
                    int n3 = difference.getFirstEnd();
                    int n4 = difference.getSecondStart();
                    int n2 = difference.getSecondEnd();
                    if (n == n3 && n4 == n2) {
                        stringBuffer.append(n + "c" + n4 + "\n");
                    } else if (n == n3) {
                        stringBuffer.append(n + "c" + n4 + CONTEXT_MARK_DELIMETER + n2 + "\n");
                    } else if (n4 == n2) {
                        stringBuffer.append(n + CONTEXT_MARK_DELIMETER + n3 + "c" + n4 + "\n");
                    } else {
                        stringBuffer.append(n + CONTEXT_MARK_DELIMETER + n3 + "c" + n4 + CONTEXT_MARK_DELIMETER + n2 + "\n");
                    }
                    TextDiffVisualizer.appendText(stringBuffer, "< ", difference.getFirstText());
                    stringBuffer.append("---\n");
                    TextDiffVisualizer.appendText(stringBuffer, "> ", difference.getSecondText());
                }
            }
        }
        return new ByteArrayInputStream(stringBuffer.toString().getBytes());
    }

    private static void appendText(StringBuffer stringBuffer, String string, String string2) {
        int n;
        if (string2 == null) {
            return;
        }
        int n2 = 0;
        do {
            if ((n = string2.indexOf(10, n2)) < 0) {
                n = string2.length();
            }
            stringBuffer.append(string + string2.substring(n2, n) + "\n");
        } while ((n2 = n + 1) < string2.length());
    }

    public static InputStream differenceToContextDiffText(TextDiffInfo textDiffInfo) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CONTEXT_MARK1B);
        stringBuffer.append(textDiffInfo.getName1());
        stringBuffer.append("\n");
        stringBuffer.append(CONTEXT_MARK2B);
        stringBuffer.append(textDiffInfo.getName2());
        stringBuffer.append("\n");
        int n = textDiffInfo.getContextNumLines();
        Difference[] differenceArray = textDiffInfo.getDifferences();
        BufferedReader bufferedReader = new BufferedReader(textDiffInfo.createFirstReader());
        BufferedReader bufferedReader2 = new BufferedReader(textDiffInfo.createSecondReader());
        int n2 = 1;
        int n3 = 1;
        for (int i = 0; i < differenceArray.length; ++i) {
            int n4;
            int n5;
            StringBuffer stringBuffer2;
            int n6;
            stringBuffer.append(DIFFERENCE_DELIMETER);
            int[] nArray = TextDiffVisualizer.getContextRange(differenceArray, i, n);
            int n7 = differenceArray[i].getFirstStart() - n;
            if (differenceArray[i].getType() == 1) {
                ++n7;
            }
            if (n7 < 1) {
                n7 = 1;
            }
            int n8 = n6 = (n2 = TextDiffVisualizer.dumpContext(0, differenceArray, i, nArray[0], stringBuffer2 = new StringBuffer(), n, bufferedReader, n2)) <= nArray[1] ? n2 + n : nArray[1];
            if (n2 <= nArray[1] && i == differenceArray.length - 1) {
                String string;
                n5 = n;
                n4 = 0;
                while (n5-- > 0 && (string = bufferedReader.readLine()) != null) {
                    ++n4;
                }
                if (n4 < n) {
                    n6 = n2 + n4 - 1;
                }
            }
            stringBuffer.append(CONTEXT_MARK1B);
            stringBuffer.append(n7);
            stringBuffer.append(CONTEXT_MARK_DELIMETER);
            stringBuffer.append(n6);
            stringBuffer.append(CONTEXT_MARK1E);
            stringBuffer.append(stringBuffer2);
            n7 = differenceArray[i].getSecondStart() - n;
            if (differenceArray[i].getType() == 0) {
                ++n7;
            }
            if (n7 < 1) {
                n7 = 1;
            }
            int n9 = n5 = (n3 = TextDiffVisualizer.dumpContext(1, differenceArray, i, nArray[0], stringBuffer2 = new StringBuffer(), n, bufferedReader2, n3)) <= nArray[2] ? n3 + n : nArray[2];
            if (n3 <= nArray[2] && i == differenceArray.length - 1) {
                String string;
                n4 = n;
                int n10 = 0;
                while (n4-- > 0 && (string = bufferedReader2.readLine()) != null) {
                    ++n10;
                }
                if (n10 < n) {
                    n5 = n3 + n10 - 1;
                }
            }
            stringBuffer.append(CONTEXT_MARK2B);
            stringBuffer.append(n7);
            stringBuffer.append(CONTEXT_MARK_DELIMETER);
            stringBuffer.append(n5);
            stringBuffer.append(CONTEXT_MARK2E);
            stringBuffer.append(stringBuffer2);
            i = nArray[0];
        }
        return new ByteArrayInputStream(stringBuffer.toString().getBytes("utf8"));
    }

    private static int[] getContextRange(Difference[] differenceArray, int n, int n2) {
        Difference difference;
        int n3 = differenceArray[n].getFirstStart();
        int n4 = differenceArray[n].getSecondStart();
        while (n < differenceArray.length && (n3 + 2 * n2 >= (difference = differenceArray[n]).getFirstStart() || n4 + 2 * n2 >= difference.getSecondStart())) {
            n3 = difference.getFirstStart();
            n4 = difference.getSecondStart();
            int n5 = Math.max(0, difference.getFirstEnd() - difference.getFirstStart());
            int n6 = Math.max(0, difference.getSecondEnd() - difference.getSecondStart());
            n3 += n5;
            n4 += n6;
            ++n;
        }
        return new int[]{n - 1, n3 + n2, n4 + n2};
    }

    private static int dumpContext(int n, Difference[] differenceArray, int n2, int n3, StringBuffer stringBuffer, int n4, BufferedReader bufferedReader, int n5) throws IOException {
        int n6;
        if (n == 0) {
            n6 = differenceArray[n2].getFirstStart() - n4;
            if (differenceArray[n2].getType() == 1) {
                ++n6;
            }
        } else {
            n6 = differenceArray[n2].getSecondStart() - n4;
            if (differenceArray[n2].getType() == 0) {
                ++n6;
            }
        }
        while (n5 < n6) {
            bufferedReader.readLine();
            ++n5;
        }
        int n7 = stringBuffer.length();
        boolean bl = false;
        while (n2 <= n3) {
            Difference difference = differenceArray[n2];
            n6 = n == 0 ? difference.getFirstStart() : difference.getSecondStart();
            while (n5 < n6) {
                stringBuffer.append(LINE_PREP);
                stringBuffer.append(bufferedReader.readLine());
                stringBuffer.append("\n");
                ++n5;
            }
            int n8 = 0;
            String string = null;
            switch (differenceArray[n2].getType()) {
                case 1: {
                    if (n != 1) break;
                    string = LINE_PREP_ADD;
                    n8 = difference.getSecondEnd() - difference.getSecondStart() + 1;
                    break;
                }
                case 0: {
                    if (n != 0) break;
                    string = LINE_PREP_REMOVE;
                    n8 = difference.getFirstEnd() - difference.getFirstStart() + 1;
                    break;
                }
                case 2: {
                    string = LINE_PREP_CHANGE;
                    n8 = n == 0 ? difference.getFirstEnd() - difference.getFirstStart() + 1 : difference.getSecondEnd() - difference.getSecondStart() + 1;
                }
            }
            if (string != null) {
                bl = true;
                int n9 = 0;
                while (n9 < n8) {
                    stringBuffer.append(string);
                    stringBuffer.append(bufferedReader.readLine());
                    stringBuffer.append("\n");
                    ++n9;
                    ++n5;
                }
            }
            ++n2;
        }
        if (!bl) {
            stringBuffer.delete(n7, stringBuffer.length());
        } else {
            String string;
            int n10 = 0;
            while (n10 < n4 && (string = bufferedReader.readLine()) != null) {
                stringBuffer.append(LINE_PREP);
                stringBuffer.append(string);
                stringBuffer.append("\n");
                ++n10;
                ++n5;
            }
        }
        return n5;
    }

    public static class TextDiffInfo
    extends DiffPresenter.Info {
        private Reader r1;
        private Reader r2;
        private Difference[] diffs;
        private CloneableOpenSupport openSupport;
        private boolean contextMode;
        private int contextNumLines;

        public TextDiffInfo(String string, String string2, String string3, String string4, Reader reader, Reader reader2, Difference[] differenceArray) {
            super(string, string2, string3, string4, null, false, false);
            this.r1 = reader;
            this.r2 = reader2;
            this.diffs = differenceArray;
        }

        public String getName() {
            String string = this.getName1();
            String string2 = this.getName2();
            if (string2 != null && string2.length() > 0) {
                string = string + " <> " + string2;
            }
            return string;
        }

        public String getTitle() {
            return this.getTitle1() + " <> " + this.getTitle2();
        }

        public Reader createFirstReader() {
            return this.r1;
        }

        public Reader createSecondReader() {
            return this.r2;
        }

        public Difference[] getDifferences() {
            return this.diffs;
        }

        public CloneableOpenSupport getOpenSupport() {
            if (this.openSupport == null) {
                this.openSupport = new TextDiffEditorSupport(this);
            }
            return this.openSupport;
        }

        public void setContextMode(boolean bl, int n) {
            this.contextMode = bl;
            this.contextNumLines = n;
        }

        public boolean isContextMode() {
            return this.contextMode;
        }

        public int getContextNumLines() {
            return this.contextNumLines;
        }
    }
}

