/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.cmdline;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.diff.Difference;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CmdlineDiffProvider
extends DiffProvider
implements Serializable {
    public static final String DIFF_REGEXP = "(^[0-9]+(,[0-9]+|)[d][0-9]+$)|(^[0-9]+(,[0-9]+|)[c][0-9]+(,[0-9]+|)$)|(^[0-9]+[a][0-9]+(,[0-9]+|)$)";
    private static final int BUFF_LENGTH = 1024;
    private String diffCmd;
    private transient Pattern pattern;
    static final long serialVersionUID = 4101521743158176210L;

    public CmdlineDiffProvider(String string) {
        this.diffCmd = string;
        try {
            this.pattern = Pattern.compile(DIFF_REGEXP);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public static CmdlineDiffProvider createDefault() {
        return new CmdlineDiffProvider("diff \"{0}\" \"{1}\"");
    }

    public void setDiffCommand(String string) {
        this.diffCmd = string;
    }

    public String getDiffCommand() {
        return this.diffCmd;
    }

    private static boolean checkEmpty(String string, String string2) {
        return string == null || string.length() == 0;
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)CmdlineDiffProvider.class, (String)"displayName");
    }

    public String getShortDescription() {
        return NbBundle.getMessage((Class)CmdlineDiffProvider.class, (String)"shortDescription");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Difference[] computeDiff(Reader reader, Reader reader2) throws IOException {
        Difference[] differenceArray;
        File file;
        block6: {
            File file2 = null;
            file = null;
            try {
                int n;
                file2 = FileUtil.normalizeFile((File)File.createTempFile("TempDiff".intern(), null));
                file = FileUtil.normalizeFile((File)File.createTempFile("TempDiff".intern(), null));
                FileWriter fileWriter = new FileWriter(file2);
                FileWriter fileWriter2 = new FileWriter(file);
                char[] cArray = new char[1024];
                while ((n = reader.read(cArray)) > 0) {
                    fileWriter.write(cArray, 0, n);
                }
                while ((n = reader2.read(cArray)) > 0) {
                    fileWriter2.write(cArray, 0, n);
                }
                reader.close();
                reader2.close();
                fileWriter.close();
                fileWriter2.close();
                differenceArray = this.createDiff(file2, file);
                Object var11_10 = null;
                if (file2 == null) break block6;
                file2.delete();
            }
            catch (Throwable throwable) {
                block7: {
                    Object var11_11 = null;
                    if (file2 != null) {
                        file2.delete();
                    }
                    if (file == null) break block7;
                    file.delete();
                }
                throw throwable;
            }
        }
        if (file != null) {
            file.delete();
        }
        return differenceArray;
    }

    public Difference[] computeDiff(FileObject fileObject, FileObject fileObject2) throws IOException {
        File file = FileUtil.toFile((FileObject)fileObject);
        File file2 = FileUtil.toFile((FileObject)fileObject2);
        if (file != null && file2 != null) {
            return this.createDiff(file, file2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Difference[] createDiff(File file, File file2) throws IOException {
        final StringBuffer stringBuffer = new StringBuffer();
        final StringBuffer stringBuffer2 = new StringBuffer();
        if (this.pattern == null) {
            try {
                this.pattern = Pattern.compile(DIFF_REGEXP);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(), patternSyntaxException.getLocalizedMessage());
            }
        }
        final String string = MessageFormat.format(this.diffCmd, file.getAbsolutePath(), file2.getAbsolutePath());
        final Process[] processArray = new Process[1];
        final Object[] objectArray = new Object[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ErrorManager.getDefault().log("#69616 CDP: executing: " + string);
                    Object object = processArray;
                    synchronized (processArray) {
                        int n;
                        processArray[0] = Runtime.getRuntime().exec(string);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        object = new InputStreamReader(processArray[0].getInputStream());
                        char[] cArray = new char[1024];
                        StringBuffer stringBuffer3 = new StringBuffer();
                        ArrayList arrayList = new ArrayList();
                        while ((n = ((Reader)object).read(cArray)) > 0) {
                            for (int i = 0; i < n; ++i) {
                                if (cArray[i] == '\n') {
                                    CmdlineDiffProvider.outputLine(stringBuffer3.toString(), CmdlineDiffProvider.this.pattern, arrayList, stringBuffer, stringBuffer2);
                                    stringBuffer3.delete(0, stringBuffer3.length());
                                    continue;
                                }
                                if (cArray[i] == '\r') continue;
                                stringBuffer3.append(cArray[i]);
                            }
                        }
                        if (stringBuffer3.length() > 0) {
                            CmdlineDiffProvider.outputLine(stringBuffer3.toString(), CmdlineDiffProvider.this.pattern, arrayList, stringBuffer, stringBuffer2);
                        }
                        CmdlineDiffProvider.setTextOnLastDifference(arrayList, stringBuffer, stringBuffer2);
                        objectArray[0] = arrayList.toArray(new Difference[arrayList.size()]);
                    }
                }
                catch (IOException iOException) {
                    objectArray[0] = (IOException)ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider == null ? (class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider = CmdlineDiffProvider.class$("org.netbeans.modules.diff.cmdline.CmdlineDiffProvider")) : class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider), (String)"runtimeError", (Object)string));
                }
            }
        };
        Thread thread = new Thread(runnable, "Diff.exec()");
        thread.start();
        try {
            thread.join();
            Object[] objectArray2 = objectArray;
            synchronized (objectArray) {
                if (objectArray[0] instanceof IOException) {
                    throw (IOException)objectArray[0];
                }
                // ** MonitorExit[var10_11] (shouldn't be in output)
                return (Difference[])objectArray[0];
            }
        }
        catch (InterruptedException interruptedException) {
            Process process = processArray[0];
            synchronized (process) {
                processArray[0].destroy();
            }
            throw new InterruptedIOException();
        }
    }

    public static void setTextOnLastDifference(List list, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (list.size() > 0) {
            String string;
            String string2 = stringBuffer.toString();
            if (string2.length() == 0) {
                string2 = null;
            }
            if ((string = stringBuffer2.toString()).length() == 0) {
                string = null;
            }
            Difference difference = (Difference)list.remove(list.size() - 1);
            list.add(new Difference(difference.getType(), difference.getFirstStart(), difference.getFirstEnd(), difference.getSecondStart(), difference.getSecondEnd(), string2, string));
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer2.delete(0, stringBuffer2.length());
        }
    }

    public static void outputLine(String string, Pattern pattern, List list, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (!pattern.matcher(string).matches()) {
            if (string.startsWith("< ")) {
                stringBuffer.append(string.substring(2) + "\n");
            }
            if (string.startsWith("> ")) {
                stringBuffer2.append(string.substring(2) + "\n");
            }
            return;
        }
        CmdlineDiffProvider.setTextOnLastDifference(list, stringBuffer, stringBuffer2);
        n = string.indexOf(97);
        if (n >= 0) {
            try {
                n3 = Integer.parseInt(string.substring(0, n));
                n2 = string.indexOf(44, ++n);
                if (n2 < 0) {
                    String string2 = string.substring(n, string.length());
                    if (CmdlineDiffProvider.checkEmpty(string2, string)) {
                        return;
                    }
                    n6 = n5 = Integer.parseInt(string2);
                } else {
                    String string3 = string.substring(n, n2);
                    if (CmdlineDiffProvider.checkEmpty(string3, string)) {
                        return;
                    }
                    n5 = Integer.parseInt(string3);
                    string3 = string.substring(n2 + 1, string.length());
                    n6 = string3 == null || string3.length() == 0 ? n5 : Integer.parseInt(string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            list.add(new Difference(1, n3, 0, n5, n6));
        } else {
            n = string.indexOf(100);
            if (n >= 0) {
                n2 = string.lastIndexOf(44, n);
                try {
                    String string4;
                    if (n2 < 0) {
                        n4 = n3 = Integer.parseInt(string.substring(0, n));
                    } else {
                        string4 = string.substring(0, n2);
                        if (CmdlineDiffProvider.checkEmpty(string4, string)) {
                            return;
                        }
                        n3 = Integer.parseInt(string4);
                        string4 = string.substring(n2 + 1, n);
                        if (CmdlineDiffProvider.checkEmpty(string4, string)) {
                            return;
                        }
                        n4 = Integer.parseInt(string4);
                    }
                    string4 = string.substring(n + 1, string.length());
                    if (CmdlineDiffProvider.checkEmpty(string4, string)) {
                        return;
                    }
                    n5 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                list.add(new Difference(0, n3, n4, n5, 0));
            } else {
                n = string.indexOf(99);
                if (n >= 0) {
                    n2 = string.lastIndexOf(44, n);
                    try {
                        String string5;
                        if (n2 < 0) {
                            n4 = n3 = Integer.parseInt(string.substring(0, n));
                        } else {
                            string5 = string.substring(0, n2);
                            if (CmdlineDiffProvider.checkEmpty(string5, string)) {
                                return;
                            }
                            n3 = Integer.parseInt(string5);
                            string5 = string.substring(n2 + 1, n);
                            if (CmdlineDiffProvider.checkEmpty(string5, string)) {
                                return;
                            }
                            n4 = Integer.parseInt(string5);
                        }
                        n2 = string.indexOf(44, ++n);
                        if (n2 < 0) {
                            string5 = string.substring(n, string.length());
                            if (CmdlineDiffProvider.checkEmpty(string5, string)) {
                                return;
                            }
                            n6 = n5 = Integer.parseInt(string5);
                        } else {
                            string5 = string.substring(n, n2);
                            if (CmdlineDiffProvider.checkEmpty(string5, string)) {
                                return;
                            }
                            n5 = Integer.parseInt(string5);
                            string5 = string.substring(n2 + 1, string.length());
                            n6 = string5 == null || string5.length() == 0 ? n5 : Integer.parseInt(string5);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                    list.add(new Difference(2, n3, n4, n5, n6));
                }
            }
        }
    }
}

