/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.CLIHandler;
import org.netbeans.Main;

public abstract class CLIHandler {
    private static final int KEY_LENGTH = 10;
    private static final int REPLY_OK = 1;
    private static final int REPLY_EXIT = 2;
    private static final int REPLY_FAIL = 0;
    private static final int REPLY_DELAY = 3;
    private static final int REPLY_READ = 10;
    private static final int REPLY_WRITE = 11;
    private static final int REPLY_AVAILABLE = 12;
    private static final int REPLY_ERROR = 13;
    public static final int WHEN_BOOT = 1;
    public static final int WHEN_INIT = 2;
    private static Server server;
    private static PrintStream OUTPUT;
    private int when;
    private static List doLater;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected CLIHandler(int n) {
        this.when = n;
    }

    protected abstract int cli(Args var1);

    private static void showHelp(PrintWriter printWriter, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((CLIHandler)iterator.next()).usage(printWriter);
        }
    }

    protected abstract void usage(PrintWriter var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enterState(int n, Integer n2) {
        Object object;
        PrintStream printStream = OUTPUT;
        if (printStream != null) {
            object = printStream;
            synchronized (object) {
                printStream.print("state: ");
                printStream.print(n);
                printStream.print(" thread: ");
                printStream.print(Thread.currentThread());
                if (n2 == null) {
                    printStream.println();
                }
            }
        }
        if (n2 == null) {
            return;
        }
        object = n2;
        synchronized (object) {
            if (n == n2) {
                if (printStream != null) {
                    printStream.println(" blocked");
                }
                n2.notifyAll();
                try {
                    n2.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException();
                }
            } else if (printStream != null) {
                printStream.println(" not blocked");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int notifyHandlers(Args args, Collection collection, int n, boolean bl, boolean bl2) {
        try {
            int n2;
            String[] stringArray = args.getArguments();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!$assertionsDisabled && stringArray[n2] == null) {
                    throw new AssertionError();
                }
                if (!stringArray[n2].equals("-?") && !stringArray[n2].equals("--help") && !stringArray[n2].equals("-help")) continue;
                PrintWriter printWriter = new PrintWriter(args.getOutputStream());
                CLIHandler.showHelp(printWriter, collection);
                printWriter.flush();
                int n3 = 2;
                return n3;
            }
            n2 = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                CLIHandler cLIHandler = (CLIHandler)iterator.next();
                if (cLIHandler.when != n || (n2 = cLIHandler.cli(args)) == 0) continue;
                int n4 = n2;
                return n4;
            }
            if (bl) {
                stringArray = args.getArguments();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    PrintWriter printWriter = new PrintWriter(args.getOutputStream());
                    printWriter.println("Ignored unknown option: " + stringArray[i]);
                    printWriter.flush();
                    int n5 = 2;
                    return n5;
                }
            }
            int n6 = 0;
            return n6;
        }
        finally {
            args.reset(bl2);
        }
    }

    static Status initialize(String[] stringArray, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, Main.BootClassLoader bootClassLoader, boolean bl, boolean bl2, Runnable runnable) {
        return CLIHandler.initialize(new Args(stringArray, inputStream, outputStream, outputStream2, System.getProperty("user.dir")), null, bootClassLoader.allCLIs(), bl, bl2, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int registerFinishInstallation(Execute execute) {
        boolean bl;
        Class clazz = CLIHandler.class;
        synchronized (clazz) {
            if (doLater != null) {
                doLater.add(execute);
                bl = false;
            } else {
                bl = true;
            }
        }
        if (bl) {
            return execute.exec();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int finishInitialization(boolean bl) {
        List list;
        Object object = CLIHandler.class;
        synchronized (object) {
            list = doLater;
            List list2 = doLater = bl ? new ArrayList() : null;
            if (!bl) {
                CLIHandler.class.notifyAll();
            }
        }
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                Execute execute = (Execute)object.next();
                int n = execute.exec();
                if (n == 0) continue;
                return n;
            }
        }
        return 0;
    }

    private static synchronized boolean waitFinishInstallationIsOver(int n) {
        if (doLater != null) {
            try {
                CLIHandler.class.wait(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return doLater == null;
    }

    public static synchronized void stopServer() {
        Server server = CLIHandler.server;
        if (server != null) {
            server.stopServer();
        }
    }

    static void registerDebug(PrintStream printStream) {
        OUTPUT = printStream;
    }

    private static InetAddress localHostAddress() throws IOException {
        NetworkInterface networkInterface = NetworkInterface.getByName("lo");
        if (networkInterface == null || !networkInterface.getInetAddresses().hasMoreElements()) {
            return InetAddress.getLocalHost();
        }
        return networkInterface.getInetAddresses().nextElement();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Status initialize(final Args args, Integer n, final Collection collection, final boolean bl, boolean bl2, Runnable runnable) {
        int n2 = CLIHandler.notifyHandlers(args, collection, 1, false, bl);
        if (n2 != 0) {
            return new Status(n2);
        }
        String string = System.getProperty("netbeans.user");
        if (string == null) {
            string = System.getProperty("user.home");
            System.setProperty("netbeans.user", string);
        }
        if (runnable != null) {
            runnable.run();
        }
        File file = new File(string, "lock");
        for (int i = 0; i < 5; ++i) {
            Object object;
            try {
                if (file.exists()) {
                    CLIHandler.enterState(5, n);
                    throw new IOException("EXISTS");
                }
                file.getParentFile().mkdirs();
                file.createNewFile();
                file.deleteOnExit();
                CLIHandler.secureAccess(file);
                CLIHandler.enterState(10, n);
                byte[] byArray = new byte[10];
                try {
                    SecureRandom.getInstance("SHA1PRNG").nextBytes(byArray);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    try {
                        SecureRandom.getInstance("IBMSecureRandom").nextBytes(byArray);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                        System.err.println("WARNING: remote IDE automation features cannot be cryptographically secured, so disabling; please reopen http://www.netbeans.org/issues/show_bug.cgi?id=36966");
                        noSuchAlgorithmException.printStackTrace();
                        return new Status();
                    }
                }
                server = new Server(byArray, n, collection, bl);
                object = new DataOutputStream(new FileOutputStream(file));
                int n3 = server.getLocalPort();
                ((DataOutputStream)object).writeInt(n3);
                CLIHandler.enterState(20, n);
                ((FilterOutputStream)object).write(byArray);
                ((DataOutputStream)object).flush();
                try {
                    byte[] byArray2 = InetAddress.getLocalHost().getAddress();
                    if (n != null && n == 667) {
                        throw new UnknownHostException("dhcppc0");
                    }
                    for (int j = 0; j < byArray2.length; ++j) {
                        ((DataOutputStream)object).write(byArray2[j]);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    unknownHostException.printStackTrace();
                }
                ((FilterOutputStream)object).close();
                int n4 = CLIHandler.registerFinishInstallation(new Execute(){

                    public int exec() {
                        return CLIHandler.notifyHandlers(args, collection, 2, bl, bl);
                    }
                });
                CLIHandler.enterState(0, n);
                return new Status(file, server.getLocalPort(), n4);
            }
            catch (IOException iOException) {
                Object object2;
                Closeable closeable;
                if (!"EXISTS".equals(iOException.getMessage())) {
                    iOException.printStackTrace();
                }
                object = null;
                Object object3 = null;
                int n5 = -1;
                try {
                    CLIHandler.enterState(21, n);
                    closeable = new DataInputStream(new FileInputStream(file));
                    n5 = ((DataInputStream)closeable).readInt();
                    CLIHandler.enterState(22, n);
                    object = new byte[10];
                    ((DataInputStream)closeable).readFully((byte[])object);
                    CLIHandler.enterState(23, n);
                    object2 = new byte[4];
                    ((DataInputStream)closeable).readFully((byte[])object2);
                    CLIHandler.enterState(24, n);
                    object3 = object2;
                    ((FilterInputStream)closeable).close();
                    CLIHandler.enterState(25, n);
                }
                catch (IOException iOException2) {
                    CLIHandler.enterState(26, n);
                }
                if (object != null && n5 != -1) {
                    try {
                        CLIHandler.enterState(28, n);
                        closeable = new Socket(CLIHandler.localHostAddress(), n5);
                        ((Socket)closeable).setSoTimeout(5000);
                        object2 = new DataOutputStream(((Socket)closeable).getOutputStream());
                        ((FilterOutputStream)object2).write((byte[])object);
                        ((DataOutputStream)object2).flush();
                        CLIHandler.enterState(30, n);
                        DataInputStream dataInputStream = new DataInputStream(((Socket)closeable).getInputStream());
                        byte[] byArray = new byte[4096];
                        block31: while (true) {
                            CLIHandler.enterState(32, n);
                            int n6 = dataInputStream.read();
                            CLIHandler.enterState(34, n);
                            switch (n6) {
                                case 0: {
                                    CLIHandler.enterState(36, n);
                                    break block31;
                                }
                                case 1: {
                                    int n7;
                                    CLIHandler.enterState(38, n);
                                    String[] stringArray = args.getArguments();
                                    ((DataOutputStream)object2).writeInt(stringArray.length);
                                    for (n7 = 0; n7 < stringArray.length; ++n7) {
                                        ((DataOutputStream)object2).writeUTF(stringArray[n7]);
                                    }
                                    ((DataOutputStream)object2).writeUTF(args.getCurrentDirectory().toString());
                                    ((DataOutputStream)object2).flush();
                                    continue block31;
                                }
                                case 2: {
                                    int n7 = dataInputStream.readInt();
                                    if (n7 == 0) {
                                        n7 = -1;
                                    }
                                    ((FilterOutputStream)object2).close();
                                    dataInputStream.close();
                                    CLIHandler.enterState(0, n);
                                    return new Status(file, n5, n7);
                                }
                                case 10: {
                                    CLIHandler.enterState(42, n);
                                    int n8 = dataInputStream.readInt();
                                    if (n8 > byArray.length) {
                                        byArray = new byte[n8];
                                    }
                                    int n9 = args.getInputStream().read(byArray, 0, n8);
                                    ((DataOutputStream)object2).write(n9);
                                    if (n9 > 0) {
                                        ((DataOutputStream)object2).write(byArray, 0, n9);
                                    }
                                    ((DataOutputStream)object2).flush();
                                    continue block31;
                                }
                                case 11: {
                                    CLIHandler.enterState(44, n);
                                    int n8 = dataInputStream.readInt();
                                    if (n8 > byArray.length) {
                                        byArray = new byte[n8];
                                    }
                                    dataInputStream.read(byArray, 0, n8);
                                    args.getOutputStream().write(byArray, 0, n8);
                                    continue block31;
                                }
                                case 13: {
                                    CLIHandler.enterState(45, n);
                                    int n8 = dataInputStream.readInt();
                                    if (n8 > byArray.length) {
                                        byArray = new byte[n8];
                                    }
                                    dataInputStream.read(byArray, 0, n8);
                                    args.getErrorStream().write(byArray, 0, n8);
                                    continue block31;
                                }
                                case 12: {
                                    CLIHandler.enterState(46, n);
                                    ((DataOutputStream)object2).writeInt(args.getInputStream().available());
                                    ((DataOutputStream)object2).flush();
                                    continue block31;
                                }
                                case 3: {
                                    CLIHandler.enterState(47, n);
                                    continue block31;
                                }
                                case -1: {
                                    CLIHandler.enterState(48, n);
                                    continue block31;
                                }
                                default: {
                                    CLIHandler.enterState(49, n);
                                    if (!$assertionsDisabled) throw new AssertionError(n6);
                                    continue block31;
                                }
                            }
                            break;
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        CLIHandler.enterState(33, n);
                    }
                    catch (ConnectException connectException) {
                        CLIHandler.enterState(33, n);
                    }
                    catch (IOException iOException3) {
                        iOException3.printStackTrace();
                        CLIHandler.enterState(33, n);
                    }
                    boolean bl3 = false;
                    if (object3 != null) {
                        try {
                            bl3 = Arrays.equals(InetAddress.getLocalHost().getAddress(), object3);
                        }
                        catch (UnknownHostException unknownHostException) {
                            CLIHandler.enterState(999, n);
                        }
                    }
                    if (!bl2 && !bl3) return new Status(-255);
                    file.delete();
                }
                try {
                    CLIHandler.enterState(83, n);
                    Thread.sleep((int)(Math.random() * 1000.0));
                    CLIHandler.enterState(85, n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return new Status();
    }

    private static void secureAccess(File file) throws IOException {
        Object object;
        boolean bl = false;
        String string = System.getProperty("java.version");
        if (string != null && string.startsWith("1.6")) {
            try {
                object = File.class.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
                Object object2 = ((Method)object).invoke((Object)file, Boolean.FALSE, Boolean.FALSE);
                Object object3 = ((Method)object).invoke((Object)file, Boolean.TRUE, Boolean.TRUE);
                bl = Boolean.TRUE.equals(object2) && Boolean.TRUE.equals(object3);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        if (bl) {
            return;
        }
        try {
            int n;
            object = new File("/bin/chmod");
            if (!((File)object).isFile()) {
                object = new File("/usr/bin/chmod");
            }
            if (((File)object).isFile() && (n = Runtime.getRuntime().exec(new String[]{((File)object).getAbsolutePath(), "go-rwx", file.getAbsolutePath()}).waitFor()) != 0) {
                throw new IOException("could not run " + object + " go-rwx " + file);
            }
        }
        catch (InterruptedException interruptedException) {
            throw (IOException)new IOException(interruptedException.toString()).initCause(interruptedException);
        }
    }

    static {
        $assertionsDisabled = !CLIHandler.class.desiredAssertionStatus();
        OUTPUT = Integer.getInteger("org.netbeans.CLIHandler", 0) < 0 ? System.err : null;
        doLater = new ArrayList();
    }

    private static final class Server
    extends Thread {
        private byte[] key;
        private ServerSocket socket;
        private Integer block;
        private Collection handlers;
        private Socket work;
        private static volatile int counter;
        private final boolean failOnUnknownOptions;

        public Server(byte[] byArray, Integer n, Collection collection, boolean bl) throws IOException {
            super("CLI Requests Server");
            this.key = byArray;
            this.setDaemon(true);
            this.block = n;
            this.handlers = collection;
            this.failOnUnknownOptions = bl;
            this.socket = new ServerSocket(0, 50, CLIHandler.localHostAddress());
            this.start();
        }

        public Server(Socket socket, byte[] byArray, Integer n, Collection collection, boolean bl) throws IOException {
            super("CLI Handler Thread Handler: " + ++counter);
            this.key = byArray;
            this.setDaemon(true);
            this.block = n;
            this.handlers = collection;
            this.work = socket;
            this.failOnUnknownOptions = bl;
            this.start();
        }

        public int getLocalPort() {
            return this.socket.getLocalPort();
        }

        public void run() {
            if (this.work != null) {
                try {
                    this.handleConnect(this.work);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            ServerSocket serverSocket = this.socket;
            if (serverSocket == null) {
                return;
            }
            while (this.socket != null) {
                try {
                    CLIHandler.enterState(65, this.block);
                    Socket socket = this.socket.accept();
                    if (this.socket == null) {
                        CLIHandler.enterState(66, this.block);
                        socket.getOutputStream().write(0);
                        CLIHandler.enterState(67, this.block);
                        socket.close();
                        continue;
                    }
                    new Server(socket, this.key, this.block, this.handlers, this.failOnUnknownOptions);
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.socket == null) continue;
                    interruptedIOException.printStackTrace();
                }
                catch (SocketException socketException) {
                    if (this.socket == null) continue;
                    socketException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        final void stopServer() {
            this.socket = null;
            this.interrupt();
        }

        private void handleConnect(Socket socket) throws IOException {
            byte[] byArray = new byte[this.key.length];
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            CLIHandler.enterState(70, this.block);
            dataInputStream.readFully(byArray);
            CLIHandler.enterState(90, this.block);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            if (Arrays.equals(byArray, this.key)) {
                while (!CLIHandler.waitFinishInstallationIsOver(2000)) {
                    dataOutputStream.write(3);
                    dataOutputStream.flush();
                }
                CLIHandler.enterState(93, this.block);
                dataOutputStream.write(1);
                dataOutputStream.flush();
                int n = dataInputStream.readInt();
                String[] stringArray = new String[n];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = dataInputStream.readUTF();
                }
                String string = dataInputStream.readUTF();
                Args args = new Args(stringArray, new IS(dataInputStream, dataOutputStream), new OS(dataInputStream, dataOutputStream, 11), new OS(dataInputStream, dataOutputStream, 13), string);
                class ComputingAndNotifying
                extends Thread {
                    public int res;
                    public boolean finished;
                    private final /* synthetic */ Args val$arguments;
                    private final /* synthetic */ DataOutputStream val$os;
                    private final /* synthetic */ Server this$0;

                    public ComputingAndNotifying(Server server, Args args, DataOutputStream dataOutputStream) {
                        this.this$0 = server;
                        this.val$arguments = args;
                        this.val$os = dataOutputStream;
                        super("Computes values in handlers");
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ComputingAndNotifying computingAndNotifying;
                        try {
                            this.res = CLIHandler.access$000(this.val$arguments, Server.access$400(this.this$0), 2, Server.access$500(this.this$0), false);
                            if (this.res == 0) {
                                CLIHandler.access$200(98, Server.access$600(this.this$0));
                            } else {
                                CLIHandler.access$200(99, Server.access$600(this.this$0));
                            }
                            Object var2_1 = null;
                            computingAndNotifying = this;
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            ComputingAndNotifying computingAndNotifying2 = this;
                            synchronized (computingAndNotifying2) {
                                this.finished = true;
                                this.notifyAll();
                            }
                            throw throwable;
                        }
                        synchronized (computingAndNotifying) {
                            this.finished = true;
                            this.notifyAll();
                        }
                    }

                    public synchronized void waitForResultAndNotifyOthers() {
                        this.start();
                        while (!this.finished) {
                            try {
                                this.wait(1000L);
                                this.val$os.write(3);
                                this.val$os.flush();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                }
                ComputingAndNotifying computingAndNotifying = new ComputingAndNotifying(this, args, dataOutputStream);
                computingAndNotifying.waitForResultAndNotifyOthers();
                dataOutputStream.write(2);
                dataOutputStream.writeInt(computingAndNotifying.res);
            } else {
                CLIHandler.enterState(103, this.block);
                dataOutputStream.write(0);
            }
            CLIHandler.enterState(120, this.block);
            dataOutputStream.close();
            dataInputStream.close();
        }

        static /* synthetic */ Collection access$400(Server server) {
            return server.handlers;
        }

        static /* synthetic */ boolean access$500(Server server) {
            return server.failOnUnknownOptions;
        }

        static /* synthetic */ Integer access$600(Server server) {
            return server.block;
        }

        private static final class OS
        extends OutputStream {
            private DataOutputStream os;
            private int type;

            public OS(DataInputStream dataInputStream, DataOutputStream dataOutputStream, int n) {
                this.os = dataOutputStream;
                this.type = n;
            }

            public void write(int n) throws IOException {
                byte[] byArray = new byte[]{(byte)n};
                this.write(byArray);
            }

            public void write(byte[] byArray) throws IOException {
                this.write(byArray, 0, byArray.length);
            }

            public void close() throws IOException {
                super.close();
            }

            public void flush() throws IOException {
                this.os.flush();
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                this.os.write(this.type);
                this.os.writeInt(n2);
                this.os.write(byArray, n, n2);
            }
        }

        private static final class IS
        extends InputStream {
            private DataInputStream is;
            private DataOutputStream os;

            public IS(DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
                this.is = dataInputStream;
                this.os = dataOutputStream;
            }

            public int read() throws IOException {
                byte[] byArray = new byte[1];
                if (this.read(byArray) == 1) {
                    return byArray[0];
                }
                return -1;
            }

            public void close() throws IOException {
                super.close();
            }

            public int available() throws IOException {
                this.os.write(12);
                this.os.flush();
                return this.is.readInt();
            }

            public int read(byte[] byArray) throws IOException {
                return this.read(byArray, 0, byArray.length);
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                this.os.write(10);
                this.os.writeInt(n2);
                this.os.flush();
                int n3 = this.is.read();
                if (n3 > 0) {
                    return this.is.read(byArray, n, n3);
                }
                return n3;
            }
        }
    }

    public static final class Args {
        private String[] args;
        private final String[] argsBackup;
        private InputStream is;
        private OutputStream os;
        private OutputStream err;
        private File currentDir;

        Args(String[] stringArray, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, String string) {
            this.argsBackup = stringArray;
            this.reset(false);
            this.is = inputStream;
            this.os = outputStream;
            this.err = outputStream2;
            this.currentDir = new File(string);
        }

        void reset(boolean bl) {
            if (bl) {
                String[] stringArray = this.args;
                if (stringArray == null) {
                    stringArray = this.argsBackup;
                }
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                arrayList.removeAll(Collections.singleton(null));
                this.args = arrayList.toArray(new String[arrayList.size()]);
            } else {
                this.args = (String[])this.argsBackup.clone();
            }
        }

        public String[] getArguments() {
            return this.args;
        }

        public OutputStream getOutputStream() {
            return this.os;
        }

        public OutputStream getErrorStream() {
            return this.err;
        }

        public File getCurrentDirectory() {
            return this.currentDir;
        }

        public InputStream getInputStream() {
            return this.is;
        }
    }

    static interface Execute {
        public int exec();
    }

    static final class Status {
        public static final int CANNOT_CONNECT = -255;
        private final File lockFile;
        private final int port;
        private int exitCode;

        Status() {
            this(0);
        }

        Status(int n) {
            this(null, 0, n);
        }

        Status(File file, int n, int n2) {
            this.lockFile = file;
            this.port = n;
            this.exitCode = n2;
        }

        public File getLockFile() {
            return this.lockFile;
        }

        public int getServerPort() {
            return this.port;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

