/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.ChangeFirer;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.Module;
import org.netbeans.ModuleFactory;
import org.netbeans.ModuleInstaller;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public final class ModuleManager {
    public static final String PROP_MODULES = "modules";
    public static final String PROP_ENABLED_MODULES = "enabledModules";
    public static final String PROP_CLASS_LOADER = "classLoader";
    static boolean PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES = !Boolean.getBoolean("suppress.topological.exception");
    private final HashSet modules = new HashSet(100);
    private final Map modulesByName = new HashMap(100);
    private final Map moduleProblems = new HashMap(100);
    private final Map providersOf = new HashMap(25);
    private final ModuleInstaller installer;
    private ModuleFactory moduleFactory;
    private SystemClassLoader classLoader;
    private List classLoaderPatches;
    private final Object classLoaderLock = new String("ModuleManager.classLoaderLock");
    private final Events ev;
    private final Mutex.Privileged MUTEX_PRIVILEGED = new Mutex.Privileged();
    private final Mutex MUTEX = new Mutex(this.MUTEX_PRIVILEGED);
    private ChangeFirer firer = new ChangeFirer(this);
    private boolean readOnly = false;
    private PropertyChangeSupport changeSupport;
    private final Util.ModuleLookup lookup = new Util.ModuleLookup();
    private static final Object PROBING_IN_PROCESS = new Object();

    public ModuleManager(ModuleInstaller moduleInstaller, Events events) {
        this.installer = moduleInstaller;
        this.ev = events;
        String string = System.getProperty("netbeans.systemclassloader.patches");
        if (string != null) {
            System.err.println("System class loader patches: " + string);
            this.classLoaderPatches = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                if (file.isDirectory()) {
                    this.classLoaderPatches.add(file);
                    continue;
                }
                try {
                    this.classLoaderPatches.add(new JarFile(file));
                }
                catch (IOException iOException) {
                    Util.err.annotate((Throwable)iOException, 0, "Problematic file: " + file, null, null, null);
                    Util.err.notify((Throwable)iOException);
                }
            }
        } else {
            this.classLoaderPatches = Collections.EMPTY_LIST;
        }
        this.classLoader = new SystemClassLoader(this.classLoaderPatches, new ClassLoader[]{moduleInstaller.getClass().getClassLoader()}, Collections.EMPTY_SET);
        ModuleManager.updateContextClassLoaders(this.classLoader, true);
        this.moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        if (this.moduleFactory == null) {
            this.moduleFactory = new ModuleFactory();
        }
    }

    public final Events getEvents() {
        return this.ev;
    }

    public final Mutex mutex() {
        return this.MUTEX;
    }

    public final Mutex.Privileged mutexPrivileged() {
        return this.MUTEX_PRIVILEGED;
    }

    void readOnly(boolean bl) {
        this.readOnly = bl;
    }

    void assertWritable() throws IllegalThreadStateException {
        if (this.readOnly) {
            throw new IllegalThreadStateException("You are attempting to make changes to " + this + " in a property change callback. This is illegal. You may only make module system changes while holding a write mutex and not inside a change callback. See #16328.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    final void firePropertyChange(String string, Object object, Object object2) {
        if (Util.err.isLoggable(1)) {
            Util.err.log("ModuleManager.propertyChange: " + string + ": " + object + " -> " + object2);
        }
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    final void fireReloadable(Module module) {
        this.firer.change(new ChangeFirer.Change((Object)module, "reloadable", null, null));
        this.firer.fire();
    }

    public Lookup getModuleLookup() {
        return this.lookup;
    }

    final void fireModulesCreatedDeleted(Set set, Set set2) {
        Util.err.log("lookup created: " + set + " deleted: " + set2);
        this.lookup.changed();
    }

    public Set getModules() {
        return (Set)this.modules.clone();
    }

    public final Set getEnabledModules() {
        HashSet hashSet = new HashSet(this.modules);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            if (module.isEnabled()) continue;
            iterator.remove();
        }
        return hashSet;
    }

    public final Module get(String string) {
        return (Module)((Object)this.modulesByName.get(string));
    }

    public Set getModuleInterdependencies(Module module, boolean bl, boolean bl2) {
        return Util.moduleInterdependencies(module, bl, bl2, this.modules, this.modulesByName, this.providersOf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        Object object = this.classLoaderLock;
        synchronized (object) {
            return this.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateClassLoader() {
        SystemClassLoader systemClassLoader;
        ClassLoader[] classLoaderArray;
        HashSet<ClassLoader> hashSet = this.classLoaderLock;
        synchronized (hashSet) {
            this.classLoader.destroy();
        }
        hashSet = new HashSet<ClassLoader>(this.modules.size() * 4 / 3 + 2);
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(this.modules.size() + 1);
        ClassLoader classLoader = ModuleManager.class.getClassLoader();
        hashSet.add(classLoader);
        arrayList.add(classLoader);
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            classLoaderArray = (ClassLoader[])iterator.next();
            if (!classLoaderArray.isEnabled() || !hashSet.add(classLoaderArray.getClassLoader())) continue;
            arrayList.add(classLoaderArray.getClassLoader());
        }
        if (this.moduleFactory.removeBaseClassLoader()) {
            arrayList.remove(classLoader);
        }
        classLoaderArray = arrayList.toArray(new ClassLoader[arrayList.size()]);
        try {
            systemClassLoader = new SystemClassLoader(this.classLoaderPatches, classLoaderArray, this.modules);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Util.err.notify((Throwable)illegalArgumentException);
            systemClassLoader = new SystemClassLoader(this.classLoaderPatches, new ClassLoader[]{ModuleManager.class.getClassLoader()}, Collections.EMPTY_SET);
        }
        Object object = this.classLoaderLock;
        synchronized (object) {
            this.classLoader = systemClassLoader;
            ModuleManager.updateContextClassLoaders(this.classLoader, false);
        }
        this.firer.change(new ChangeFirer.Change(this, PROP_CLASS_LOADER, null, null));
    }

    private static void updateContextClassLoaders(ClassLoader classLoader, boolean bl) {
        int n;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        while (true) {
            int n2;
            Thread[] threadArray;
            if ((n = threadGroup.enumerate(threadArray = new Thread[n2 = threadGroup.activeCount() + 1], true)) < n2) {
                for (int i = 0; i < n; ++i) {
                    if (bl || threadArray[i].getContextClassLoader() instanceof SystemClassLoader) {
                        threadArray[i].setContextClassLoader(classLoader);
                        continue;
                    }
                    Util.err.log("Not touching context class loader " + threadArray[i].getContextClassLoader() + " on thread " + threadArray[i].getName());
                }
                break;
            }
            Util.err.log("Race condition getting all threads, restarting...");
        }
        Util.err.log("Set context class loader on " + n + " threads");
    }

    public Module create(File file, Object object, boolean bl, boolean bl2) throws IOException, DuplicateException {
        return this.create(file, object, bl, bl2, false);
    }

    public Module create(File file, Object object, boolean bl, boolean bl2, boolean bl3) throws IOException, DuplicateException {
        List list;
        this.assertWritable();
        this.ev.log("startCreateRegularModule", file);
        Module module = this.moduleFactory.create(file.getAbsoluteFile(), object, bl, bl2, bl3, this, this.ev);
        this.ev.log("finishCreateRegularModule", file);
        this.subCreate(module);
        if (module.isEager() && !(list = this.simulateEnable(Collections.EMPTY_SET)).isEmpty()) {
            if (!list.contains((Object)module)) {
                throw new IllegalStateException("Can immediately enable modules " + list + ", but not including " + (Object)((Object)module));
            }
            boolean bl4 = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Module module2 = (Module)((Object)iterator.next());
                if (module2.isAutoload() || module2.isEager()) continue;
                bl4 = false;
                break;
            }
            if (bl4) {
                Util.err.log("Enabling " + (Object)((Object)module) + " immediately");
                this.enable(Collections.EMPTY_SET);
            }
        }
        return module;
    }

    public Module createFixed(Manifest manifest, Object object, ClassLoader classLoader) throws InvalidException, DuplicateException {
        this.assertWritable();
        if (manifest == null || classLoader == null) {
            throw new IllegalArgumentException("null manifest or loader");
        }
        this.ev.log("startCreateBootModule", object);
        Module module = this.moduleFactory.createFixed(manifest, object, classLoader, this, this.ev);
        this.ev.log("finishCreateBootModule", object);
        this.subCreate(module);
        return module;
    }

    void refineDependencies(Module module, Set set) {
        this.installer.refineDependencies(module, set);
    }

    String[] refineProvides(Module module) {
        return this.installer.refineProvides(module);
    }

    public void refineClassLoader(Module module, List list) {
        this.installer.refineClassLoader(module, list);
    }

    public boolean shouldDelegateResource(Module module, Module module2, String string) {
        Module.PackageExport[] packageExportArray;
        Module.PackageExport[] packageExportArray2 = packageExportArray = module2 == null ? null : module2.getPublicPackages();
        if (packageExportArray != null) {
            int n;
            boolean bl = false;
            if (module2.isDeclaredAsFriend(module)) {
                for (n = 0; n < packageExportArray.length; ++n) {
                    if (!(packageExportArray[n].recursive ? string.startsWith(packageExportArray[n].pkg) : string.equals(packageExportArray[n].pkg))) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                n = 0;
                Dependency[] dependencyArray = module.getDependenciesArray();
                for (int i = 0; i < dependencyArray.length; ++i) {
                    if (dependencyArray[i].getType() != 1 || dependencyArray[i].getComparison() != 2 || !dependencyArray[i].getName().equals(module2.getCodeName())) continue;
                    n = 1;
                    break;
                }
                if (n == 0) {
                    if (Util.err.isLoggable(1)) {
                        Util.err.log("Refusing to load non-public package " + string + " for " + (Object)((Object)module) + " from parent module " + (Object)((Object)module2) + " without an impl dependency");
                    }
                    return false;
                }
            }
        }
        if (string.startsWith("META-INF/")) {
            return false;
        }
        return this.installer.shouldDelegateResource(module, module2, string);
    }

    public boolean isSpecialResource(String string) {
        return this.installer.isSpecialResource(string);
    }

    Manifest loadManifest(File file) throws IOException {
        return this.installer.loadManifest(file);
    }

    private void subCreate(Module module) throws DuplicateException {
        Util.err.log("created: " + (Object)((Object)module));
        Module module2 = this.get(module.getCodeNameBase());
        if (module2 != null) {
            throw new DuplicateException(module2, module);
        }
        this.modules.add(module);
        this.modulesByName.put(module.getCodeNameBase(), module);
        this.possibleProviderAdded(module);
        this.lookup.add(module);
        this.firer.created(module);
        this.firer.change(new ChangeFirer.Change(this, PROP_MODULES, null, null));
        this.clearProblemCache();
        this.firer.fire();
    }

    private void possibleProviderAdded(Module module) {
        String[] stringArray = module.getProvides();
        for (int i = 0; i < stringArray.length; ++i) {
            HashSet<Module> hashSet = (HashSet<Module>)this.providersOf.get(stringArray[i]);
            if (hashSet == null) {
                hashSet = new HashSet<Module>(10);
                this.providersOf.put(stringArray[i], hashSet);
            }
            hashSet.add(module);
        }
    }

    public void delete(Module module) throws IllegalArgumentException {
        this.assertWritable();
        if (module.isFixed()) {
            throw new IllegalArgumentException("fixed module: " + (Object)((Object)module));
        }
        if (module.isEnabled()) {
            throw new IllegalArgumentException("enabled module: " + (Object)((Object)module));
        }
        this.ev.log("deleteModule", (Object)module);
        this.modules.remove((Object)module);
        this.modulesByName.remove(module.getCodeNameBase());
        this.possibleProviderRemoved(module);
        this.lookup.remove(module);
        this.firer.deleted(module);
        this.firer.change(new ChangeFirer.Change(this, PROP_MODULES, null, null));
        this.firer.change(new ChangeFirer.Change((Object)module, "valid", Boolean.TRUE, Boolean.FALSE));
        this.clearProblemCache();
        module.destroy();
        this.firer.fire();
    }

    private void possibleProviderRemoved(Module module) {
        String[] stringArray = module.getProvides();
        for (int i = 0; i < stringArray.length; ++i) {
            Set set = (Set)this.providersOf.get(stringArray[i]);
            if (set == null) continue;
            set.remove((Object)module);
            if (!set.isEmpty()) continue;
            this.providersOf.remove(stringArray[i]);
        }
    }

    public void reload(Module module) throws IllegalArgumentException, IOException {
        this.assertWritable();
        Util.err.log("reload: " + (Object)((Object)module));
        if (module.isFixed()) {
            throw new IllegalArgumentException("reload fixed module: " + (Object)((Object)module));
        }
        if (module.isEnabled()) {
            throw new IllegalArgumentException("reload enabled module: " + (Object)((Object)module));
        }
        this.possibleProviderRemoved(module);
        try {
            module.reload();
        }
        catch (IOException iOException) {
            this.delete(module);
            throw iOException;
        }
        this.possibleProviderAdded(module);
        this.firer.change(new ChangeFirer.Change((Object)module, "manifest", null, null));
        this.moduleProblems.remove((Object)module);
        this.firer.change(new ChangeFirer.Change((Object)module, "problems", null, null));
        this.clearProblemCache();
        this.firer.fire();
    }

    public final void enable(Module module) throws IllegalArgumentException, InvalidException {
        this.enable(Collections.singleton(module));
    }

    public final void disable(Module module) throws IllegalArgumentException {
        this.disable(Collections.singleton(module));
    }

    public void enable(Set set) throws IllegalArgumentException, InvalidException {
        Dependency[] dependencyArray;
        Object object;
        Object object2;
        Module module;
        this.assertWritable();
        Util.err.log("enable: " + set);
        this.ev.log("perfStart", "ModuleManager.enable");
        List list = this.simulateEnable(set);
        this.ev.log("perfTick", "checked the required ordering and autoloads");
        Util.err.log("enable: toEnable=" + list);
        Object object3 = new HashSet(list);
        if (!object3.containsAll(set)) {
            HashSet hashSet = new HashSet(set);
            hashSet.removeAll((Collection<?>)object3);
            throw new IllegalArgumentException("Not all requested modules can be enabled: " + hashSet);
        }
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            module = (Module)((Object)iterator.next());
            if (set.contains((Object)module) || module.isAutoload() || module.isEager()) continue;
            throw new IllegalArgumentException("Would also need to enable " + (Object)((Object)module));
        }
        Util.err.log("enable: verified dependencies");
        this.ev.log("perfTick", "verified dependencies");
        this.ev.log("startEnableModules", list);
        object3 = new LinkedList();
        boolean bl = false;
        module = null;
        try {
            object2 = list.iterator();
            this.ev.log("perfStart", "module preparation");
            while (object2.hasNext()) {
                object = (Module)((Object)object2.next());
                ((LinkedList)object3).addFirst((Module)((Object)object));
                Util.err.log("enable: bringing up: " + object);
                this.ev.log("perfStart", "bringing up classloader on " + ((Module)((Object)object)).getCodeName());
                try {
                    dependencyArray = ((Module)((Object)object)).getDependenciesArray();
                    HashSet<Module> hashSet = new HashSet<Module>(dependencyArray.length * 4 / 3 + 1);
                    for (int i = 0; i < dependencyArray.length; ++i) {
                        Dependency dependency = dependencyArray[i];
                        if (dependency.getType() != 1) continue;
                        String string = (String)Util.parseCodeName(dependency.getName())[0];
                        Module module2 = this.get(string);
                        if (module2 == null) {
                            throw new IOException("Parent " + string + " not found!");
                        }
                        hashSet.add(module2);
                    }
                    ((Module)((Object)object)).classLoaderUp(hashSet);
                }
                catch (IOException iOException) {
                    bl = true;
                    InvalidException invalidException = new InvalidException((Module)((Object)object), iOException.toString());
                    Util.err.annotate((Throwable)invalidException, (Throwable)iOException);
                    throw invalidException;
                }
                ((Module)((Object)object)).setEnabled(true);
                this.ev.log("perfEnd", "bringing up classloader on " + ((Module)((Object)object)).getCodeName());
                this.ev.log("perfStart", "package dependency check on " + ((Module)((Object)object)).getCodeName());
                Util.err.log("enable: checking package dependencies for " + object);
                dependencyArray = ((Module)((Object)object)).getDependenciesArray();
                for (int i = 0; i < dependencyArray.length; ++i) {
                    Dependency dependency = dependencyArray[i];
                    if (dependency.getType() != 2) continue;
                    if (!Util.checkPackageDependency(dependency, ((Module)((Object)object)).getClassLoader())) {
                        module = dependency;
                        throw new InvalidException((Module)((Object)object), "Dependency failed on " + dependency);
                    }
                    Util.err.log("Successful check for: " + dependency);
                }
                this.ev.log("perfEnd", "package dependency check on " + ((Module)((Object)object)).getCodeName());
                this.ev.log("perfStart", "ModuleInstaller.prepare " + ((Module)((Object)object)).getCodeName());
                this.installer.prepare((Module)((Object)object));
                this.ev.log("perfEnd", "ModuleInstaller.prepare " + ((Module)((Object)object)).getCodeName());
            }
            this.ev.log("perfEnd", "module preparation");
        }
        catch (InvalidException invalidException) {
            Module module3 = invalidException.getModule();
            if (module3 == null) {
                throw new IllegalStateException("Problem with no associated module: " + invalidException);
            }
            Set set2 = (Set)this.moduleProblems.get((Object)module3);
            if (set2 == null) {
                throw new IllegalStateException("Were trying to install a module that had never been checked: " + (Object)((Object)module3));
            }
            if (!set2.isEmpty()) {
                throw new IllegalStateException("Were trying to install a module that was known to be bad: " + (Object)((Object)module3));
            }
            if (module != null) {
                set2.add(module);
            } else {
                set2.add(invalidException);
            }
            this.clearProblemCache();
            this.firer.change(new ChangeFirer.Change((Object)module3, "problems", Collections.EMPTY_SET, Collections.singleton(set2.iterator().next())));
            Util.err.log("enable: will roll back from: " + invalidException);
            Iterator iterator2 = ((AbstractSequentialList)object3).iterator();
            while (iterator2.hasNext()) {
                Module module4 = (Module)((Object)iterator2.next());
                if (module4.isFixed()) continue;
                module4.setEnabled(false);
                if (bl) {
                    bl = false;
                    continue;
                }
                module4.classLoaderDown();
                System.gc();
                System.runFinalization();
                module4.cleanup();
            }
            this.firer.fire();
            throw invalidException;
        }
        if (this.classLoader != null) {
            Util.err.log("enable: adding to system classloader");
            object2 = new ArrayList(list.size());
            object = list.iterator();
            if (this.moduleFactory.removeBaseClassLoader()) {
                dependencyArray = ModuleManager.class.getClassLoader();
                object2.add(this.moduleFactory.getClasspathDelegateClassLoader(this, (ClassLoader)dependencyArray));
                while (object.hasNext()) {
                    ClassLoader classLoader = ((Module)((Object)object.next())).getClassLoader();
                    if (classLoader == dependencyArray) continue;
                    object2.add(classLoader);
                }
            } else {
                while (object.hasNext()) {
                    object2.add(((Module)((Object)object.next())).getClassLoader());
                }
            }
            this.classLoader.append(object2.toArray(new ClassLoader[object2.size()]), list);
        } else {
            Util.err.log("enable: no class loader yet, not appending");
        }
        Util.err.log("enable: continuing to installation");
        this.installer.load(list);
        Util.err.log("enable: firing changes");
        this.firer.change(new ChangeFirer.Change(this, PROP_ENABLED_MODULES, null, null));
        object3 = list.iterator();
        while (object3.hasNext()) {
            Module module5 = (Module)((Object)object3.next());
            this.firer.change(new ChangeFirer.Change((Object)module5, "enabled", Boolean.FALSE, Boolean.TRUE));
            if (module5.isFixed()) continue;
            this.firer.change(new ChangeFirer.Change((Object)module5, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishEnableModules", list);
        this.firer.fire();
    }

    public void disable(Set set) throws IllegalArgumentException {
        Module module;
        this.assertWritable();
        Util.err.log("disable: " + set);
        if (set.isEmpty()) {
            return;
        }
        List list = this.simulateDisable(set);
        Util.err.log("disable: toDisable=" + list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            module = (Module)((Object)iterator.next());
            if (set.contains((Object)module) || module.isAutoload() || module.isEager()) continue;
            throw new IllegalArgumentException("Would also need to disable: " + (Object)((Object)module));
        }
        Util.err.log("disable: verified dependencies");
        this.ev.log("startDisableModules", list);
        this.installer.unload(list);
        iterator = list.iterator();
        while (iterator.hasNext()) {
            module = (Module)((Object)iterator.next());
            this.installer.dispose(module);
            module.setEnabled(false);
            module.classLoaderDown();
        }
        System.gc();
        System.runFinalization();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            module = (Module)((Object)iterator.next());
            module.cleanup();
        }
        Util.err.log("disable: finished, will notify changes");
        this.firer.change(new ChangeFirer.Change(this, PROP_ENABLED_MODULES, null, null));
        this.invalidateClassLoader();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            module = (Module)((Object)iterator.next());
            this.firer.change(new ChangeFirer.Change((Object)module, "enabled", Boolean.TRUE, Boolean.FALSE));
            this.firer.change(new ChangeFirer.Change((Object)module, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishDisableModules", list);
        this.firer.fire();
    }

    public List simulateEnable(Set set) throws IllegalArgumentException {
        Object object;
        Object object2;
        HashSet hashSet = new HashSet(set.size() * 2 + 1);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (Module)((Object)iterator.next());
            if (object2.isAutoload()) {
                throw new IllegalArgumentException("Cannot simulate enabling an autoload: " + (Object)object2);
            }
            if (object2.isEager()) {
                throw new IllegalArgumentException("Cannot simulate enabling an eager module: " + (Object)object2);
            }
            if (object2.isEnabled()) {
                throw new IllegalArgumentException("Already enabled: " + (Object)object2);
            }
            if (!object2.isValid()) {
                throw new IllegalArgumentException("Not managed by me: " + (Object)object2 + " in " + (Object)object2);
            }
            this.maybeAddToEnableList(hashSet, set, (Module)((Object)object2), true);
        }
        object2 = new HashSet(this.modules);
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (Module)((Object)iterator.next());
            if (!object.isEnabled() && !hashSet.contains(object)) continue;
            iterator.remove();
        }
        while (this.searchForPossibleEager(hashSet, (Set)object2, set)) {
        }
        object = Util.moduleDependencies(hashSet, this.modulesByName, this.providersOf);
        try {
            List list = Utilities.topologicalSort(hashSet, (Map)object);
            Collections.reverse(list);
            return list;
        }
        catch (TopologicalSortException topologicalSortException) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.notify(1, (Throwable)topologicalSortException);
            }
            Util.err.log(16, "Cyclic module dependencies, will refuse to enable: " + (Object)object);
            return Collections.EMPTY_LIST;
        }
    }

    private void maybeAddToEnableList(Set set, Set set2, Module module, boolean bl) {
        if (!this.missingDependencies(module).isEmpty()) {
            if (!bl) {
                throw new IllegalStateException("Module was supposed to be OK: " + (Object)((Object)module));
            }
            return;
        }
        if (set.contains((Object)module)) {
            return;
        }
        set.add(module);
        Dependency[] dependencyArray = module.getDependenciesArray();
        for (int i = 0; i < dependencyArray.length; ++i) {
            Module module2;
            Object object;
            String string;
            Dependency dependency = dependencyArray[i];
            if (dependency.getType() == 1) {
                string = (String)Util.parseCodeName(dependency.getName())[0];
                object = this.get(string);
                if (object == null) {
                    throw new IllegalStateException("Should have found module: " + string);
                }
                if (object.isEnabled()) continue;
                this.maybeAddToEnableList(set, set2, (Module)((Object)object), false);
                continue;
            }
            if (dependency.getType() != 5) continue;
            string = dependency.getName();
            object = (Set)this.providersOf.get(string);
            if (object == null) {
                throw new IllegalStateException("Should have found a provider of: " + string);
            }
            Iterator iterator = object.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                module2 = (Module)((Object)iterator.next());
                if (!module2.isEnabled() && (!module2.getProblems().isEmpty() || !set2.contains((Object)module2))) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            iterator = object.iterator();
            while (iterator.hasNext()) {
                module2 = (Module)((Object)iterator.next());
                this.maybeAddToEnableList(set, set2, module2, true);
                if (bl2 || !set.contains((Object)module2)) continue;
                bl2 = true;
            }
            if (bl2) continue;
            throw new IllegalStateException("Should have found a nonproblematic provider of: " + string);
        }
    }

    private boolean searchForPossibleEager(Set set, Set set2, Set set3) {
        boolean bl = false;
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            if (set.contains((Object)module)) {
                iterator.remove();
                continue;
            }
            if (!module.isEager() || !this.couldBeEnabledWithEagers(module, set, new HashSet())) continue;
            bl = true;
            iterator.remove();
            this.maybeAddToEnableList(set, set3, module, false);
        }
        return bl;
    }

    private boolean couldBeEnabledWithEagers(Module module, Set set, Set set2) {
        if (module.isEnabled() || set.contains((Object)module)) {
            return true;
        }
        if (!module.isAutoload() && !module.isEager()) {
            return false;
        }
        if (!module.getProblems().isEmpty()) {
            return false;
        }
        if (!set2.add(module)) {
            return true;
        }
        Dependency[] dependencyArray = module.getDependenciesArray();
        for (int i = 0; i < dependencyArray.length; ++i) {
            Object object;
            Object object2;
            Dependency dependency = dependencyArray[i];
            if (dependency.getType() == 1) {
                object2 = (String)Util.parseCodeName(dependency.getName())[0];
                object = this.get((String)object2);
                if (object == null) {
                    throw new IllegalStateException("Should have found module: " + (String)object2);
                }
                if (this.couldBeEnabledWithEagers((Module)((Object)object), set, set2)) continue;
                return false;
            }
            if (dependency.getType() != 5) continue;
            object2 = (Set)this.providersOf.get(dependency.getName());
            if (object2 == null) {
                throw new IllegalStateException("Should have found a provider of: " + dependency.getName());
            }
            object = object2.iterator();
            boolean bl = false;
            while (object.hasNext()) {
                Module module2 = (Module)((Object)object.next());
                if (!this.couldBeEnabledWithEagers(module2, set, set2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public List simulateDisable(Set set) throws IllegalArgumentException {
        Object object;
        if (set.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashSet hashSet = new HashSet(20);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (Module)((Object)iterator.next());
            if (object.isAutoload()) {
                throw new IllegalArgumentException("Cannot disable autoload: " + (Object)object);
            }
            if (object.isEager()) {
                throw new IllegalArgumentException("Cannot disable eager module: " + (Object)object);
            }
            if (object.isFixed()) {
                throw new IllegalArgumentException("Cannot disable fixed module: " + (Object)object);
            }
            if (!object.isEnabled()) {
                throw new IllegalArgumentException("Already disabled: " + (Object)object);
            }
            this.addToDisableList(hashSet, (Module)((Object)object));
        }
        object = new HashSet(this.getEnabledModules());
        object.removeAll(hashSet);
        while (this.searchForUnusedAutoloads(hashSet, (Set)object)) {
        }
        Map map = Util.moduleDependencies(hashSet, this.modulesByName, this.providersOf);
        try {
            return Utilities.topologicalSort(hashSet, (Map)map);
        }
        catch (TopologicalSortException topologicalSortException) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.notify(1, (Throwable)topologicalSortException);
            }
            Util.err.log(16, "Cyclic module dependencies, will turn them off in a random order: " + map);
            return new ArrayList(hashSet);
        }
    }

    private void addToDisableList(Set set, Module module) {
        if (set.contains((Object)module)) {
            return;
        }
        set.add(module);
        Iterator iterator = this.modules.iterator();
        block0: while (iterator.hasNext()) {
            Module module2 = (Module)((Object)iterator.next());
            if (module2.isFixed() || !module2.isEnabled() || set.contains((Object)module2)) continue;
            Dependency[] dependencyArray = module2.getDependenciesArray();
            for (int i = 0; i < dependencyArray.length; ++i) {
                Dependency dependency = dependencyArray[i];
                if (dependency.getType() == 1) {
                    if (!dependency.getName().equals(module.getCodeName())) continue;
                    this.addToDisableList(set, module2);
                    continue block0;
                }
                if (dependency.getType() != 5 || !module.provides(dependency.getName())) continue;
                Iterator iterator2 = this.getEnabledModules().iterator();
                boolean bl = false;
                while (iterator2.hasNext()) {
                    Module module3 = (Module)((Object)iterator2.next());
                    if (!module3.isEnabled() || set.contains((Object)module3) || !module3.provides(dependency.getName())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.addToDisableList(set, module2);
                continue block0;
            }
        }
    }

    private boolean searchForUnusedAutoloads(Set set, Set set2) {
        boolean bl = false;
        Iterator iterator = set2.iterator();
        block0: while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            if (!module.isAutoload()) continue;
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                Module module2 = (Module)((Object)iterator2.next());
                Dependency[] dependencyArray = module2.getDependenciesArray();
                for (int i = 0; i < dependencyArray.length; ++i) {
                    Dependency dependency = dependencyArray[i];
                    if (dependency.getType() == 1 ? dependency.getName().equals(module.getCodeName()) : dependency.getType() == 5 && module.provides(dependency.getName())) continue block0;
                }
            }
            bl = true;
            iterator.remove();
            set.add(module);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set missingDependencies(Module module) {
        Map map = this.moduleProblems;
        synchronized (map) {
            return this._missingDependencies(module);
        }
    }

    private Set _missingDependencies(Module module) {
        HashSet<Object> hashSet = (HashSet<Object>)this.moduleProblems.get((Object)module);
        if (hashSet == null) {
            hashSet = new HashSet<Object>(8);
            hashSet.add(PROBING_IN_PROCESS);
            this.moduleProblems.put(module, hashSet);
            Dependency[] dependencyArray = module.getDependenciesArray();
            for (int i = 0; i < dependencyArray.length; ++i) {
                Module module2;
                int n;
                Object object;
                Object object2;
                Dependency dependency = dependencyArray[i];
                if (dependency.getType() == 2) continue;
                if (dependency.getType() == 1) {
                    object2 = Util.parseCodeName(dependency.getName());
                    object = (String)object2[0];
                    int n2 = object2[1] != null ? (Integer)object2[1] : -1;
                    n = object2[2] != null ? (Integer)object2[2] : n2;
                    module2 = this.get((String)object);
                    if (module2 == null) {
                        hashSet.add(dependency);
                        continue;
                    }
                    if (n2 == n) {
                        if (n2 != module2.getCodeNameRelease()) {
                            hashSet.add(dependency);
                            continue;
                        }
                        if (dependency.getComparison() == 2 && !Utilities.compareObjects((Object)dependency.getVersion(), (Object)module2.getImplementationVersion())) {
                            hashSet.add(dependency);
                            continue;
                        }
                        if (dependency.getComparison() == 1 && new SpecificationVersion(dependency.getVersion()).compareTo((Object)module2.getSpecificationVersion()) > 0) {
                            hashSet.add(dependency);
                            continue;
                        }
                    } else if (n2 < n) {
                        int n3 = module2.getCodeNameRelease();
                        if (n3 < n2 || n3 > n) {
                            hashSet.add(dependency);
                            continue;
                        }
                        if (dependency.getComparison() == 2) {
                            throw new IllegalStateException("No such thing as ranged impl dep");
                        }
                        if (dependency.getComparison() == 1 && n3 == n2 && new SpecificationVersion(dependency.getVersion()).compareTo((Object)module2.getSpecificationVersion()) > 0) {
                            hashSet.add(dependency);
                            continue;
                        }
                    } else {
                        throw new IllegalStateException("Upside-down rel vers range");
                    }
                    if (module2.isEnabled() || this._missingDependencies(module2).isEmpty()) continue;
                    hashSet.add(dependency);
                    continue;
                }
                if (dependency.getType() == 5) {
                    object2 = dependency.getName();
                    object = (Set)this.providersOf.get(object2);
                    if (object == null) {
                        hashSet.add(dependency);
                        continue;
                    }
                    Iterator iterator = object.iterator();
                    n = 0;
                    while (iterator.hasNext()) {
                        module2 = (Module)((Object)iterator.next());
                        if (module2.isEnabled()) {
                            n = 1;
                            continue;
                        }
                        if (!this._missingDependencies(module2).isEmpty()) continue;
                        n = 1;
                    }
                    if (n != 0) continue;
                    hashSet.add(dependency);
                    continue;
                }
                if (Util.checkJavaDependency(dependency)) continue;
                hashSet.add(dependency);
            }
            hashSet.remove(PROBING_IN_PROCESS);
        }
        return hashSet;
    }

    private void clearProblemCache() {
        Iterator iterator = this.moduleProblems.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Set set;
            Map.Entry entry = iterator.next();
            Module module = (Module)((Object)entry.getKey());
            if (module.isEnabled() || (set = (Set)entry.getValue()) == null) continue;
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Dependency dependency;
                Object e = iterator2.next();
                if (!(e instanceof InvalidException) && ((dependency = (Dependency)e).getType() == 1 || dependency.getType() == 5)) continue;
                continue block0;
            }
            iterator.remove();
            this.firer.change(new ChangeFirer.Change((Object)module, "problems", null, null));
        }
    }

    public boolean shutDown() {
        return this.shutDown(null);
    }

    public boolean shutDown(Runnable runnable) {
        List list;
        this.assertWritable();
        Set set = this.getEnabledModules();
        Map map = Util.moduleDependencies(set, this.modulesByName, this.providersOf);
        try {
            list = Utilities.topologicalSort((Collection)set, (Map)map);
        }
        catch (TopologicalSortException topologicalSortException) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.notify(1, (Throwable)topologicalSortException);
            }
            Util.err.log(16, "Cyclic module dependencies, will not shut down cleanly: " + map);
            return true;
        }
        if (!this.installer.closing(list)) {
            return false;
        }
        if (runnable != null) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                Util.err.notify((Throwable)runtimeException);
            }
            catch (LinkageError linkageError) {
                Util.err.notify((Throwable)linkageError);
            }
        }
        this.installer.close(list);
        return true;
    }

    private final class SystemClassLoader
    extends JarClassLoader {
        private final PermissionCollection allPermissions;
        private final StringBuffer debugme;
        private boolean empty;

        public SystemClassLoader(List list, ClassLoader[] classLoaderArray, Set set) throws IllegalArgumentException {
            super(list, classLoaderArray, false);
            this.empty = true;
            this.allPermissions = new Permissions();
            this.allPermissions.add(new AllPermission());
            this.allPermissions.setReadOnly();
            this.debugme = new StringBuffer(100 + 50 * set.size());
            this.debugme.append("SystemClassLoader[");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                String string = e instanceof File ? ((File)e).getAbsolutePath() : ((JarFile)e).getName();
                if (this.empty) {
                    this.empty = false;
                } else {
                    this.debugme.append(',');
                }
                this.debugme.append(string);
            }
            this.record(set);
            this.debugme.append(']');
        }

        private void record(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.empty) {
                    this.empty = false;
                } else {
                    this.debugme.append(',');
                }
                Module module = (Module)((Object)iterator.next());
                this.debugme.append(module.getCodeNameBase());
            }
        }

        public void append(ClassLoader[] classLoaderArray, List list) throws IllegalArgumentException {
            super.append(classLoaderArray);
            this.debugme.deleteCharAt(this.debugme.length() - 1);
            this.record(list);
            this.debugme.append(']');
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.log("Collected system class loader");
        }

        public String toString() {
            if (this.debugme == null) {
                return "SystemClassLoader";
            }
            return this.debugme.toString();
        }

        protected boolean isSpecialResource(String string) {
            if (ModuleManager.this.installer.isSpecialResource(string)) {
                return true;
            }
            return super.isSpecialResource(string);
        }

        protected PermissionCollection getPermissions(CodeSource codeSource) {
            return this.allPermissions;
        }
    }
}

