/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.client;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.tasklist.client.SuggestionAgent;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;
import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;

public abstract class Suggestion {
    SuggestionAgent agent;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    public static final String PROP_SUMMARY = "summary";
    public static final String PROP_ICON = "icon";
    public static final String PROP_DETAILS = "details";
    public static final String PROP_PRIORITY = "priority";
    public static final String PROP_VALID = "valid";
    private boolean valid;
    private Image icon = null;
    private String summary = null;
    private String details = null;
    private SuggestionPriority priority = SuggestionPriority.MEDIUM;
    private String type = null;
    private Line line = null;
    private SuggestionPerformer action = null;
    private FileObject fo;

    protected Suggestion(FileObject fileObject, String string, String string2, SuggestionPerformer suggestionPerformer) {
        this.fo = fileObject;
        this.type = string;
        this.summary = string2;
        this.action = suggestionPerformer;
        this.valid = true;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    protected void setFileObject(FileObject fileObject) {
        this.fo = fileObject;
    }

    protected void setSummary(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = this.getSummary();
        if (string2.equals(string)) {
            return;
        }
        this.summary = string;
        this.firePropertyChange(PROP_SUMMARY, string2, string);
    }

    public String getSummary() {
        if (this.summary == null) {
            this.summary = "";
        }
        return this.summary;
    }

    protected void setDetails(String string) {
        String string2 = this.getDetails();
        if (string2.equals(string)) {
            return;
        }
        this.details = string;
        this.firePropertyChange(PROP_DETAILS, string2, string);
    }

    public String getDetails() {
        if (this.details == null) {
            this.details = "";
        }
        return this.details;
    }

    protected void setPriority(SuggestionPriority suggestionPriority) {
        SuggestionPriority suggestionPriority2 = this.getPriority();
        if (suggestionPriority2 == suggestionPriority) {
            return;
        }
        this.priority = suggestionPriority;
        this.firePropertyChange(PROP_PRIORITY, suggestionPriority2, suggestionPriority);
    }

    public SuggestionPriority getPriority() {
        return this.priority;
    }

    protected void setIcon(Image image) {
        Image image2 = this.getIcon();
        if (image2 == image) {
            return;
        }
        this.icon = image;
        this.firePropertyChange(PROP_ICON, image2, image);
    }

    public Image getIcon() {
        return this.icon;
    }

    protected void setLine(Line line) {
        this.line = line;
    }

    public Line getLine() {
        return this.line;
    }

    protected final void setAction(SuggestionPerformer suggestionPerformer) {
        this.action = suggestionPerformer;
    }

    public SuggestionPerformer getAction() {
        return this.action;
    }

    protected void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public abstract Object getSeed();

    public boolean isValid() {
        return this.valid;
    }

    void invalidate() {
        if (!this.valid) {
            return;
        }
        this.valid = false;
        this.supp.firePropertyChange(PROP_VALID, true, false);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.supp.removePropertyChangeListener(propertyChangeListener);
        this.supp.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.supp.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.supp.firePropertyChange(string, object, object2);
    }
}

