/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.providers;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.tasklist.providers.JavaSuggestionContext;
import org.netbeans.modules.tasklist.providers.PropertiesSuggestionContext;
import org.netbeans.modules.tasklist.providers.XMLSuggestionContext;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class SuggestionContext {
    private final DataObject dataObject;
    private String cachedString;
    private static boolean linkageError;
    static /* synthetic */ Class class$org$netbeans$modules$tasklist$providers$SuggestionContext;

    SuggestionContext(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    public CharSequence getCharSequence() {
        if (this.cachedString == null) {
            EditorCookie editorCookie;
            FileObject fileObject = this.getFileObject();
            if (!linkageError && fileObject.hasExt("java")) {
                try {
                    this.cachedString = JavaSuggestionContext.getContent(fileObject);
                    return this.cachedString;
                }
                catch (LinkageError linkageError) {
                    linkageError.printStackTrace();
                    SuggestionContext.linkageError = true;
                }
            }
            if (fileObject.hasExt("properties") && !this.dataObject.isModified()) {
                this.cachedString = PropertiesSuggestionContext.getContent(fileObject);
                return this.cachedString;
            }
            if ("xml".equalsIgnoreCase(fileObject.getExt()) && !this.dataObject.isModified()) {
                this.cachedString = XMLSuggestionContext.getContent(fileObject);
                if (this.cachedString != null) {
                    return this.cachedString;
                }
            }
            if ((editorCookie = (EditorCookie)this.dataObject.getCookie(EditorCookie.class)) != null) {
                try {
                    StyledDocument styledDocument = editorCookie.openDocument();
                    this.cachedString = SuggestionContext.extractString(styledDocument);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
        return this.cachedString;
    }

    public Document getDocument() {
        EditorCookie editorCookie = (EditorCookie)this.dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            try {
                return editorCookie.openDocument();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public FileObject getFileObject() {
        return this.dataObject.getPrimaryFile();
    }

    private static String extractString(final Document document) {
        final String[] stringArray = new String[1];
        document.render(new Runnable(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void run() {
                block2: {
                    try {
                        stringArray[0] = document.getText(0, document.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)badLocationException);
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$tasklist$providers$SuggestionContext == null ? (class$org$netbeans$modules$tasklist$providers$SuggestionContext = SuggestionContext.class$("org.netbeans.modules.tasklist.providers.SuggestionContext")) : class$org$netbeans$modules$tasklist$providers$SuggestionContext).desiredAssertionStatus();
            }
        });
        return stringArray[0];
    }
}

