/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefBaseObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.ResourceClass;
import org.netbeans.lib.java.parser.Factory;
import org.netbeans.lib.java.parser.JScanner;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.modules.javacore.ClassIndexStorage;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.LazyImmutableList;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.JarFileSystem;

public class ClassIndex {
    private static final boolean DEBUG = false;
    private static final Map codebaseIndexes = Collections.synchronizedMap(new HashMap());
    private static boolean shutdownListenerRegistered = false;
    private static final ShutdownL shutdownListener = new ShutdownL();
    private final ClassIndexStorage storage;
    private final String storageId;
    private final NBMDRepositoryImpl rep;
    private long lastSaved;
    private HashMap changeLogSN;
    private HashMap changeLogFQN;
    private HashMap changeLogI;
    static /* synthetic */ Class class$org$netbeans$modules$javacore$ClassIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassIndex(String string, String string2) {
        this.storageId = string2;
        this.rep = (NBMDRepositoryImpl)JavaMetamodel.getDefaultRepository();
        this.storage = new CISImpl(string);
        if (!shutdownListenerRegistered) {
            ShutdownL shutdownL = shutdownListener;
            synchronized (shutdownL) {
                if (!shutdownListenerRegistered) {
                    ((NBMDRepositoryImpl)JavaMetamodel.getDefaultRepository()).addShutdownListener((NBMDRepositoryImpl.ShutdownListener)shutdownListener);
                    shutdownListenerRegistered = true;
                }
            }
        }
    }

    static void commit() {
        Iterator iterator = codebaseIndexes.values().iterator();
        while (iterator.hasNext()) {
            ((ClassIndex)iterator.next()).commitChanges();
        }
    }

    static void rollback() {
        Iterator iterator = codebaseIndexes.values().iterator();
        while (iterator.hasNext()) {
            ((ClassIndex)iterator.next()).rollbackChanges();
        }
    }

    private void commitChanges() {
        this.changeLogSN = null;
        this.changeLogFQN = null;
        this.changeLogI = null;
    }

    private void rollbackChanges() {
        JavaClass javaClass;
        long l;
        Map.Entry entry;
        Iterator iterator;
        if (this.changeLogSN != null) {
            iterator = this.changeLogSN.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                iterator.remove();
                l = (Long)entry.getKey();
                if (entry.getValue() == null) {
                    javaClass = (JavaClass)this.rep.getByMofId(this.makeMofId(l));
                    if (javaClass == null) continue;
                    this.addClass(javaClass, javaClass.getName(), javaClass.getSimpleName());
                    continue;
                }
                this.removeFromIndex(true, (String)entry.getValue(), l);
            }
        }
        if (this.changeLogFQN != null) {
            iterator = this.changeLogFQN.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                iterator.remove();
                l = (Long)entry.getKey();
                javaClass = (JavaClass)this.rep.getByMofId(this.makeMofId(l));
                if (entry.getValue() != null) {
                    this.removeFromIndex(false, (String)entry.getValue(), l);
                }
                if (javaClass == null) continue;
                this.addClass(javaClass, javaClass.getName(), javaClass.getSimpleName());
            }
        }
        if (this.changeLogI != null) {
            iterator = this.changeLogI.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                iterator.remove();
                this.storage.setIdentifiers((Long)entry.getKey(), (int[])entry.getValue());
            }
        }
    }

    public static ClassIndex getIndex(JavaModelPackage javaModelPackage) {
        return (ClassIndex)codebaseIndexes.get(javaModelPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveAllIndexes() {
        MDRepository mDRepository = JavaMetamodel.getDefaultRepository();
        mDRepository.beginTrans(false);
        try {
            Map map = codebaseIndexes;
            synchronized (map) {
                Iterator iterator = codebaseIndexes.values().iterator();
                while (iterator.hasNext()) {
                    ClassIndex classIndex = (ClassIndex)iterator.next();
                    classIndex.storage.unmount();
                }
            }
        }
        finally {
            mDRepository.endTrans();
        }
    }

    static void removeIndex(JavaModelPackage javaModelPackage) {
        ClassIndex classIndex = (ClassIndex)codebaseIndexes.remove(javaModelPackage);
        classIndex.storage.unmount();
    }

    static ClassIndex addIndex(JavaModelPackage javaModelPackage, String string) {
        ClassIndex classIndex = new ClassIndex(string, ((BaseObjectHandler)javaModelPackage)._getDelegate().getMofId().getStorageID());
        codebaseIndexes.put(javaModelPackage, classIndex);
        return classIndex;
    }

    static boolean loadIndex(String string, JavaModelPackage javaModelPackage) {
        ClassIndex classIndex = ClassIndex.addIndex(javaModelPackage, string);
        return classIndex.storage.mount();
    }

    public void renameClass(JavaClass javaClass, String string) {
        long l = this.getMofId(javaClass);
        String string2 = javaClass.getName();
        String string3 = javaClass.getSimpleName();
        String string4 = JavaClassImpl.getSimpleName(string);
        if (JMManager.INCONSISTENCY_DEBUG) {
            System.err.println("ClassIndex: Renaming class: " + string2 + " to: " + string + " MOFID: " + javaClass.refMofId());
        }
        this.removeFromIndex(false, string2, l);
        Long l2 = new Long(l);
        this.logFQNChange(l2, string);
        if (!string3.equals(string4)) {
            this.removeFromIndex(true, string3, l);
            this.logSNChange(l2, string4);
        }
        this.addClass(javaClass, string, string4);
    }

    private static HashMap logChange(HashMap hashMap, Long l, Object object) {
        if (hashMap == null) {
            hashMap = new HashMap<Long, Object>();
        }
        hashMap.put(l, object);
        return hashMap;
    }

    private void logFQNChange(Long l, String string) {
        this.changeLogFQN = ClassIndex.logChange(this.changeLogFQN, l, string);
    }

    private void logSNChange(Long l, String string) {
        this.changeLogSN = ClassIndex.logChange(this.changeLogSN, l, string);
    }

    public void addClass(JavaClass javaClass, String string, String string2) {
        if (JMManager.INCONSISTENCY_DEBUG) {
            System.err.println("ClassIndex: Adding class " + string + " MOFID: " + javaClass.refMofId());
        }
        long l = this.getMofId(javaClass);
        this.addToIndex(true, string2, l);
        this.addToIndex(false, string, l);
    }

    public long getTimestamp() {
        return this.lastSaved;
    }

    public void setTimestamp() {
        this.lastSaved = System.currentTimeMillis();
    }

    public Set getClassesByFqn(String string) {
        HashSet<JavaClass> hashSet = new HashSet<JavaClass>();
        long[] lArray = this.storage.getIDsForName(string, false);
        if (lArray != null) {
            Object var4_4 = null;
            int n = 0;
            for (int i = 0; i < lArray.length; ++i) {
                JavaClass javaClass = (JavaClass)this.rep.getByMofId(this.makeMofId(lArray[i]));
                if (javaClass == null) {
                    this.logFQNChange(new Long(lArray[i]), null);
                    continue;
                }
                lArray[n] = lArray[i];
                ++n;
                hashSet.add(javaClass);
            }
            if (n == 0) {
                this.storage.setIDsForName(string, false, null);
            } else if (n < lArray.length) {
                long[] lArray2 = new long[n];
                System.arraycopy(lArray, 0, lArray2, 0, n);
                this.storage.setIDsForName(string, false, lArray2);
            }
        }
        return hashSet;
    }

    public JavaClass getClassByFqn(String string) {
        JavaClass javaClass;
        JavaClass javaClass2 = null;
        do {
            javaClass = javaClass2;
        } while ((javaClass2 = this.tryToGetClassByFqn(string)) != null && !javaClass2.isValid() && javaClass != javaClass2);
        if (javaClass2 != null && javaClass == javaClass2) {
            try {
                JMManager.getLog().notify(1, (Throwable)new RuntimeException("Class was not cleaned from index: " + javaClass2.getName()));
            }
            catch (InvalidObjectException invalidObjectException) {
                JMManager.getLog().notify(1, (Throwable)invalidObjectException);
            }
            javaClass2 = null;
        }
        return javaClass2;
    }

    private JavaClass tryToGetClassByFqn(String string) {
        long[] lArray = this.storage.getIDsForName(string, false);
        if (lArray != null) {
            JavaClass javaClass = null;
            JavaClass javaClass2 = null;
            int n = 0;
            for (int i = 0; i < lArray.length; ++i) {
                JavaClass javaClass3 = (JavaClass)this.rep.getByMofId(this.makeMofId(lArray[i]));
                if (javaClass3 == null) {
                    this.logFQNChange(new Long(lArray[i]), null);
                    continue;
                }
                lArray[n] = lArray[i];
                ++n;
                javaClass = javaClass3;
            }
            if (n == 0) {
                this.storage.setIDsForName(string, false, null);
            } else if (n < lArray.length) {
                long[] lArray2 = new long[n];
                System.arraycopy(lArray, 0, lArray2, 0, n);
                this.storage.setIDsForName(string, false, lArray2);
            }
            return javaClass2 == null ? javaClass : javaClass2;
        }
        return null;
    }

    public LazyImmutableList getClassesByFQNPrefix(String string) {
        return new LazyImmutableList(new ClassesByFQNPrefixIterator(this.storage.getFirstForNamePrefix(string, false)));
    }

    public LazyImmutableList getClassesByFQNPrefix(String string, boolean bl) {
        if (bl) {
            return this.getClassesByFQNPrefix(string);
        }
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n + 1);
        return new LazyImmutableList(new ClassesByFQNPrefixCIIterator(this.storage.getFirstForNamePrefix(string2, false), string));
    }

    public LazyImmutableList getClassesBySNPrefix(String string) {
        return this.getClassesBySNPrefix(string, true);
    }

    public LazyImmutableList getClassesBySNPrefix(String string, boolean bl) {
        boolean bl2;
        ClassIndexStorage.QueryItem queryItem;
        if (string.length() > 1 && string.equals(string.toUpperCase())) {
            queryItem = this.storage.getFirstForNamePrefix(string.substring(0, 1), true);
            bl2 = true;
        } else {
            queryItem = this.storage.getFirstForNamePrefix(string.toUpperCase(), true);
            bl2 = false;
        }
        return new LazyImmutableList(new ClassesBySNPrefixIterator(queryItem, string, bl, bl2));
    }

    public boolean doesnotExist(String string) {
        return !this.storage.existsFQN(string);
    }

    public boolean hasClass(String string) {
        return this.getClassByFqn(string) != null;
    }

    public Collection getClassesBySimpleName(String string) {
        return this.getClassesBySimpleName(string, true);
    }

    public Collection getClassesBySimpleName(String string, boolean bl) {
        String string2 = string.toUpperCase();
        long[] lArray = this.storage.getIDsForName(string2, true);
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        if (lArray != null) {
            int n = 0;
            for (int i = 0; i < lArray.length; ++i) {
                JavaClass javaClass = (JavaClass)this.rep.getByMofId(this.makeMofId(lArray[i]));
                if (javaClass == null) {
                    this.logSNChange(new Long(lArray[i]), null);
                    continue;
                }
                lArray[n] = lArray[i];
                ++n;
                if (bl && !string.equals(javaClass.getSimpleName())) continue;
                arrayList.add(javaClass);
            }
            if (n == 0) {
                this.storage.setIDsForName(string2, true, null);
            } else if (n < lArray.length) {
                long[] lArray2 = new long[n];
                System.arraycopy(lArray, 0, lArray2, 0, n);
                this.storage.setIDsForName(string2, true, lArray2);
            }
        }
        return arrayList;
    }

    public static boolean hasClass(String string, ClassPath classPath) {
        FileObject[] fileObjectArray = classPath.getRoots();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            JavaModelPackage javaModelPackage = JavaMetamodel.getManager().getJavaExtent(fileObjectArray[i]);
            if (javaModelPackage == null || !ClassIndex.getIndex(javaModelPackage).hasClass(string)) continue;
            return true;
        }
        return false;
    }

    public static JavaClass getClassByFqn(String string, ClassPath classPath) {
        FileObject[] fileObjectArray = classPath.getRoots();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            JavaClass javaClass;
            ClassIndex classIndex;
            JavaModelPackage javaModelPackage = JavaMetamodel.getManager().getJavaExtent(fileObjectArray[i]);
            if (javaModelPackage == null || (classIndex = ClassIndex.getIndex(javaModelPackage)) == null || (javaClass = classIndex.getClassByFqn(string)) == null) continue;
            return javaClass;
        }
        return null;
    }

    public void setIdentifiers(Resource resource, int[] nArray) {
        Arrays.sort(nArray);
        this.storage.setIdentifiers(this.getMofId(resource), nArray);
    }

    private long getMofId(Object object) {
        return ((BaseObjectHandler)object)._getMofId().getSerialNumber();
    }

    private MOFID makeMofId(long l) {
        return new MOFID(l, this.storageId);
    }

    public void removeResource(Resource resource) {
        long l = this.getMofId(resource);
        int[] nArray = this.storage.removeIdentifiers(l);
        this.changeLogI = ClassIndex.logChange(this.changeLogI, new Long(l), nArray);
    }

    void updateIdentifiersInResource(Resource resource, String string) {
        Object object;
        FileObject fileObject = JavaMetamodel.getManager().getFileObject(resource);
        String string2 = SourceLevelQuery.getSourceLevel((FileObject)fileObject);
        JScanner jScanner = Factory.getDefault().getScanner(new StringReader(string), string2);
        int[] nArray = this.storage.getIdentifiers(this.getMofId(resource));
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        try {
            int n;
            while ((n = jScanner.yylex()) != 0) {
                int n2;
                if (n != 361 || Arrays.binarySearch(nArray, n2 = ((String)(object = jScanner.yytext())).hashCode()) >= 0) continue;
                arrayList.add(object);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        int n = arrayList.size();
        if (n > 0) {
            object = new int[nArray.length + n];
            String[] stringArray = arrayList.toArray(new String[n]);
            for (int i = 0; i < n; ++i) {
                object[i] = stringArray[i].hashCode();
            }
            System.arraycopy(nArray, 0, object, n, nArray.length);
            this.setIdentifiers(resource, (int[])object);
        }
    }

    public Collection findResourcesForIdent(String string) {
        long[] lArray = this.storage.getIDsForIdentifier(string.hashCode());
        ArrayList<RefBaseObject> arrayList = new ArrayList<RefBaseObject>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            RefBaseObject refBaseObject = this.rep.getByMofId(this.makeMofId(lArray[i]));
            if (refBaseObject == null) {
                this.storage.removeIdentifiers(lArray[i]);
                continue;
            }
            arrayList.add(refBaseObject);
        }
        return arrayList;
    }

    public static Resource[] findResourcesForIdentifier(String string, boolean bl) {
        JMManager cfr_ignored_0 = (JMManager)JavaMetamodel.getManager();
        List list = JMManager.getTransactionMutex().getSearchScope();
        FileObject[] fileObjectArray = list == null ? JavaMetamodel.getManager().getClassPath().getRoots() : (list.size() == 1 ? ((ClassPath)list.get(0)).getRoots() : ClassPathSupport.createProxyClassPath((ClassPath[])list.toArray(new ClassPath[list.size()])).getRoots());
        ArrayList arrayList = new ArrayList();
        HashSet<FileObject> hashSet = new HashSet<FileObject>((int)((double)fileObjectArray.length / 0.7));
        JavaMetamodel javaMetamodel = JavaMetamodel.getManager();
        boolean bl2 = string.startsWith("@");
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject = fileObjectArray[i];
            if (!hashSet.add(fileObject)) continue;
            try {
                JavaModelPackage javaModelPackage;
                if (!bl && fileObject.getFileSystem() instanceof JarFileSystem || (javaModelPackage = javaMetamodel.getJavaExtent(fileObject)) == null) continue;
                if (bl2) {
                    ResourceClass resourceClass = javaModelPackage.getResource();
                    arrayList.addAll(resourceClass.refAllOfClass());
                    continue;
                }
                arrayList.addAll(ClassIndex.getIndex(javaModelPackage).findResourcesForIdent(string));
                continue;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
        return arrayList.toArray(new Resource[arrayList.size()]);
    }

    public static Resource[] findResourcesForIdentifier(String string) {
        return ClassIndex.findResourcesForIdentifier(string, false);
    }

    public static void updateIdentifiers(Resource resource, String string) {
        JavaModelPackage javaModelPackage = (JavaModelPackage)resource.refOutermostPackage();
        ClassIndex.getIndex(javaModelPackage).updateIdentifiersInResource(resource, string);
    }

    public static boolean containsIdentifier(Resource resource, int n) {
        JavaModelPackage javaModelPackage = (JavaModelPackage)resource.refOutermostPackage();
        ClassIndex classIndex = ClassIndex.getIndex(javaModelPackage);
        int[] nArray = classIndex.storage.getIdentifiers(classIndex.getMofId(resource));
        if (nArray == null) {
            JMManager.getLog().log("ids is null for " + resource.getName());
            return false;
        }
        return Arrays.binarySearch(nArray, n) >= 0;
    }

    private void addToIndex(boolean bl, String string, long l) {
        long[] lArray;
        int n;
        long[] lArray2;
        if (bl) {
            string = string.toUpperCase();
        }
        if ((lArray2 = this.storage.getIDsForName(string, bl)) == null) {
            n = 0;
            lArray = new long[n + 1];
        } else {
            long[] lArray3 = lArray2;
            n = lArray3.length;
            lArray = new long[n + 1];
            for (int i = 0; i < n; ++i) {
                if (lArray3[i] == l) {
                    lArray = lArray3;
                    break;
                }
                lArray[i] = lArray3[i];
            }
        }
        if (lArray != lArray2) {
            lArray[n] = l;
            this.storage.setIDsForName(string, bl, lArray);
        }
    }

    private void removeFromIndex(boolean bl, String string, long l) {
        long[] lArray;
        if (bl) {
            string = string.toUpperCase();
        }
        if ((lArray = this.storage.getIDsForName(string, bl)) != null) {
            int n;
            long[] lArray2 = lArray;
            int n2 = lArray2.length;
            long[] lArray3 = new long[n2 - 1];
            int n3 = 0;
            for (n = 0; n < n2 && n3 < n2 - 1; ++n) {
                if (lArray2[n] == l) continue;
                lArray3[n3++] = lArray2[n];
            }
            if (n < n2 && lArray2[n] != l) {
                if (n3 < n2 - 1) {
                    lArray3[n3] = lArray2[n];
                } else {
                    lArray3 = lArray2;
                }
            }
            if (lArray2 != lArray3) {
                if (lArray3.length == 0) {
                    lArray3 = null;
                }
                this.storage.setIDsForName(string, bl, lArray3);
            }
        }
    }

    private class StreamBasedSortedMap
    implements SortedMap {
        private int size;
        InputStream stream;

        private StreamBasedSortedMap(InputStream inputStream) throws IOException {
            this.stream = inputStream;
            this.size = IOUtils.readInt((InputStream)this.stream);
        }

        public Comparator comparator() {
            return null;
        }

        public SortedMap subMap(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public SortedMap headMap(Object object) {
            throw new UnsupportedOperationException();
        }

        public SortedMap tailMap(Object object) {
            throw new UnsupportedOperationException();
        }

        public Object firstKey() {
            throw new UnsupportedOperationException();
        }

        public Object lastKey() {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public boolean containsKey(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object object) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            return new EntrySet();
        }

        private class EntrySet
        extends AbstractSet {
            private EntrySet() {
            }

            public Iterator iterator() {
                return new EntrySetIterator();
            }

            public int size() {
                return StreamBasedSortedMap.this.size;
            }

            private class EntrySetIterator
            implements Iterator,
            Map.Entry {
                private int index;
                private String key;
                private long[] value;

                private EntrySetIterator() {
                }

                public boolean hasNext() {
                    return this.index < StreamBasedSortedMap.this.size;
                }

                public Object next() {
                    try {
                        this.key = IOUtils.readString((InputStream)((EntrySet)EntrySet.this).StreamBasedSortedMap.this.stream);
                        int n = IOUtils.readInt((InputStream)((EntrySet)EntrySet.this).StreamBasedSortedMap.this.stream);
                        this.value = new long[n];
                        for (int i = 0; i < n; ++i) {
                            this.value[i] = IOUtils.readLong((InputStream)((EntrySet)EntrySet.this).StreamBasedSortedMap.this.stream);
                        }
                        ++this.index;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        this.index = StreamBasedSortedMap.this.size;
                    }
                    return this;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public Object getKey() {
                    return this.key;
                }

                public Object getValue() {
                    return this.value;
                }

                public Object setValue(Object object) {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private class CISImpl
    implements ClassIndexStorage {
        private static final int VERSION = 2;
        private static final String INDEX_SUFFIX = ".cdx";
        private final SortedMap fqnMap;
        private final SortedMap simpleMap;
        private Map identifiersMap;
        private final String filename;
        private transient boolean isDirty;
        static final /* synthetic */ boolean $assertionsDisabled;

        CISImpl(String string) {
            this.filename = string;
            this.fqnMap = new TreeMap();
            this.simpleMap = new TreeMap();
            this.identifiersMap = new HashMap();
            this.isDirty = true;
        }

        private ClassIndexStorage.QueryItem createNextCIIImpl(Iterator iterator, int n) throws ConcurrentModificationException {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (((String)entry.getKey()).lastIndexOf(46) >= n) continue;
                return new CIIImpl(iterator, entry, n);
            }
            return null;
        }

        public ClassIndexStorage.QueryItem createNextCIISNImpl(Iterator iterator) throws ConcurrentModificationException {
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                return new CIISNImpl(iterator, entry);
            }
            return null;
        }

        public ClassIndexStorage.QueryItem getFirstForNamePrefix(String string, boolean bl) {
            SortedMap sortedMap = string == null || string.length() == 0 ? (bl ? this.simpleMap : this.fqnMap) : (bl ? this.simpleMap : this.fqnMap).subMap(string, string + '\uffff');
            if (bl) {
                return this.createNextCIISNImpl(sortedMap.entrySet().iterator());
            }
            int n = string.length();
            return this.createNextCIIImpl(sortedMap.entrySet().iterator(), n);
        }

        public boolean existsFQN(String string) {
            return this.fqnMap.get(string) != null;
        }

        public void setIdentifiers(long l, int[] nArray) {
            if (!$assertionsDisabled && nArray == null) {
                throw new AssertionError();
            }
            this.isDirty = true;
            this.identifiersMap.put(new Long(l), nArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean mount() {
            long l = 0L;
            try {
                if (JMManager.PERF_DEBUG) {
                    l = System.currentTimeMillis();
                }
                File file = new File(this.filename.concat(INDEX_SUFFIX));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 65536);
                try {
                    this.read(bufferedInputStream);
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
                this.isDirty = false;
                boolean bl = true;
                Object var7_8 = null;
                if (JMManager.PERF_DEBUG) {
                    System.err.println("loading index " + this.filename + " took: " + (System.currentTimeMillis() - l) + "ms");
                }
                return bl;
            }
            catch (Exception exception) {
                try {
                    JMManager.getLog().notify(1, (Throwable)exception);
                    boolean bl = false;
                    Object var7_9 = null;
                    if (JMManager.PERF_DEBUG) {
                        System.err.println("loading index " + this.filename + " took: " + (System.currentTimeMillis() - l) + "ms");
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    block11: {
                        Object var7_10 = null;
                        if (!JMManager.PERF_DEBUG) break block11;
                        System.err.println("loading index " + this.filename + " took: " + (System.currentTimeMillis() - l) + "ms");
                    }
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unmount() {
            if (!this.isDirty) {
                return;
            }
            if (JMManager.PERF_DEBUG) {
                System.err.println("saving index " + this.filename);
            }
            ClassIndex.this.rep.beginTrans(false);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.filename.concat(INDEX_SUFFIX));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 65536);
                try {
                    this.write(bufferedOutputStream);
                }
                finally {
                    bufferedOutputStream.close();
                }
                this.isDirty = false;
            }
            catch (Exception exception) {
                JMManager.getLog().notify(1, (Throwable)exception);
            }
            finally {
                ClassIndex.this.rep.endTrans();
            }
        }

        private void read(InputStream inputStream) throws IOException {
            if (2 != IOUtils.readInt((InputStream)inputStream)) {
                return;
            }
            if (!ClassIndex.this.storageId.equals(IOUtils.readString((InputStream)inputStream))) {
                return;
            }
            this.readMap(inputStream, this.fqnMap);
            this.readMap(inputStream, this.simpleMap);
            int n = IOUtils.readInt((InputStream)inputStream);
            this.identifiersMap = new HashMap(n * 4 / 3 + 1);
            for (int i = 0; i < n; ++i) {
                Long l = new Long(IOUtils.readLong((InputStream)inputStream));
                int n2 = IOUtils.readInt((InputStream)inputStream);
                int[] nArray = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    nArray[j] = IOUtils.readInt((InputStream)inputStream);
                }
                this.identifiersMap.put(l, nArray);
            }
            ClassIndex.this.lastSaved = IOUtils.readLong((InputStream)inputStream);
        }

        private void write(OutputStream outputStream) throws IOException {
            if (JMManager.PERF_DEBUG) {
                System.err.println("fqnMap: " + this.fqnMap.size() + " records; identifiersMap: " + this.identifiersMap.size() + "records");
            }
            IOUtils.writeInt((OutputStream)outputStream, (int)2);
            IOUtils.writeString((OutputStream)outputStream, (String)ClassIndex.this.storageId);
            this.writeMap(outputStream, this.fqnMap);
            this.writeMap(outputStream, this.simpleMap);
            IOUtils.writeInt((OutputStream)outputStream, (int)this.identifiersMap.size());
            Iterator iterator = this.identifiersMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                IOUtils.writeLong((OutputStream)outputStream, (long)((Long)entry.getKey()));
                int[] nArray = (int[])entry.getValue();
                IOUtils.writeInt((OutputStream)outputStream, (int)nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    IOUtils.writeInt((OutputStream)outputStream, (int)nArray[i]);
                }
            }
            IOUtils.writeLong((OutputStream)outputStream, (long)System.currentTimeMillis());
        }

        private void readMap(InputStream inputStream, Map map) throws IOException {
            map.putAll(new StreamBasedSortedMap(inputStream));
        }

        private void writeMap(OutputStream outputStream, Map map) throws IOException {
            IOUtils.writeInt((OutputStream)outputStream, (int)map.size());
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                IOUtils.writeString((OutputStream)outputStream, (String)((String)entry.getKey()));
                long[] lArray = (long[])entry.getValue();
                IOUtils.writeInt((OutputStream)outputStream, (int)lArray.length);
                for (int i = 0; i < lArray.length; ++i) {
                    IOUtils.writeLong((OutputStream)outputStream, (long)lArray[i]);
                }
            }
        }

        public long[] getIDsForName(String string, boolean bl) {
            return (long[])(bl ? this.simpleMap : this.fqnMap).get(string);
        }

        public long[] getIDsForIdentifier(int n) {
            Map.Entry entry;
            Iterator iterator = this.identifiersMap.entrySet().iterator();
            ArrayList arrayList = new ArrayList(50);
            while (iterator.hasNext()) {
                entry = iterator.next();
                int[] nArray = (int[])entry.getValue();
                if (nArray == null) {
                    this.isDirty = true;
                    iterator.remove();
                    continue;
                }
                if (Arrays.binarySearch(nArray, n) < 0) continue;
                arrayList.add(entry.getKey());
            }
            entry = (Map.Entry)new long[arrayList.size()];
            iterator = arrayList.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                entry[n2] = (Long)((Object)iterator.next());
                ++n2;
            }
            return entry;
        }

        public void setIDsForName(String string, boolean bl, long[] lArray) {
            SortedMap sortedMap;
            this.isDirty = true;
            SortedMap sortedMap2 = sortedMap = bl ? this.simpleMap : this.fqnMap;
            if (lArray == null || lArray.length == 0) {
                sortedMap.remove(string);
            } else {
                sortedMap.put(string, lArray);
            }
        }

        public int[] getIdentifiers(long l) {
            return (int[])this.identifiersMap.get(new Long(l));
        }

        public int[] removeIdentifiers(long l) {
            this.isDirty = true;
            return (int[])this.identifiersMap.remove(new Long(l));
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$javacore$ClassIndex == null ? (class$org$netbeans$modules$javacore$ClassIndex = ClassIndex.class$("org.netbeans.modules.javacore.ClassIndex")) : class$org$netbeans$modules$javacore$ClassIndex).desiredAssertionStatus();
        }

        private class CIISNImpl
        extends AbstractCIIImpl {
            CIISNImpl(Iterator iterator, Map.Entry entry) {
                super(iterator, entry);
            }

            protected ClassIndexStorage.QueryItem createNext(Iterator iterator) throws ConcurrentModificationException {
                return CISImpl.this.createNextCIISNImpl(iterator);
            }

            protected void remove() {
                CISImpl.this.setIDsForName(this.getName(), true, null);
            }
        }

        private class CIIImpl
        extends AbstractCIIImpl {
            private final int length;

            CIIImpl(Iterator iterator, Map.Entry entry, int n) {
                super(iterator, entry);
                this.length = n;
            }

            protected ClassIndexStorage.QueryItem createNext(Iterator iterator) throws ConcurrentModificationException {
                return CISImpl.this.createNextCIIImpl(iterator, this.length);
            }

            protected void remove() {
                CISImpl.this.setIDsForName(this.getName(), false, null);
            }
        }

        private abstract class AbstractCIIImpl
        implements ClassIndexStorage.QueryItem {
            private Iterator it;
            private final Map.Entry entry;
            private ClassIndexStorage.QueryItem next;

            AbstractCIIImpl(Iterator iterator, Map.Entry entry) {
                this.it = iterator;
                this.entry = entry;
            }

            public final void setIDs(long[] lArray) throws ConcurrentModificationException {
                CISImpl.this.isDirty = true;
                this.entry.setValue(lArray);
                if (lArray == null) {
                    if (this.it == null) {
                        for (ClassIndexStorage.QueryItem queryItem = this.getNext(); queryItem != null; queryItem = queryItem.getNext()) {
                        }
                        this.remove();
                    } else {
                        this.it.remove();
                    }
                }
            }

            public final String getName() {
                return (String)this.entry.getKey();
            }

            public final long[] getIDs() {
                return (long[])this.entry.getValue();
            }

            public final ClassIndexStorage.QueryItem getNext() throws ConcurrentModificationException {
                if (this.it != null) {
                    this.next = this.createNext(this.it);
                    this.it = null;
                }
                return this.next;
            }

            protected abstract ClassIndexStorage.QueryItem createNext(Iterator var1) throws ConcurrentModificationException;

            protected abstract void remove();
        }
    }

    private static class ShutdownL
    implements NBMDRepositoryImpl.ShutdownListener {
        private ShutdownL() {
        }

        public void shutdown() {
            ClassIndex.saveAllIndexes();
        }

        public void stepFinished() {
        }
    }

    private class ClassesByFQNPrefixCIIterator
    extends ClassesByFQNPrefixIterator {
        private final String namePrefix;

        ClassesByFQNPrefixCIIterator(ClassIndexStorage.QueryItem queryItem, String string) {
            super(queryItem);
            this.namePrefix = string.toUpperCase();
        }

        protected boolean accept(ClassIndexStorage.QueryItem queryItem) {
            return this.namePrefix.length() == 0 || queryItem.getName().toUpperCase().startsWith(this.namePrefix);
        }
    }

    private class ClassesByFQNPrefixIterator
    extends ClassesByPrefixIterator {
        ClassesByFQNPrefixIterator(ClassIndexStorage.QueryItem queryItem) {
            super(queryItem);
        }

        protected int evaluateItem(long[] lArray, int n, int n2, JavaClass javaClass, Collection collection) {
            if (javaClass == null) {
                ClassIndex.this.logFQNChange(new Long(lArray[n]), null);
                return 0;
            }
            if (((JavaClassImpl)javaClass).hasComposite()) {
                collection.add(javaClass);
            } else {
                JMManager.getTransactionMutex().invalidateAtCommit((Element)javaClass);
            }
            lArray[n2] = lArray[n];
            return 1;
        }
    }

    private class ClassesBySNPrefixIterator
    extends ClassesByPrefixIterator {
        private final String prefix;
        private final boolean matchName;
        private final boolean camelCase;

        ClassesBySNPrefixIterator(ClassIndexStorage.QueryItem queryItem, String string, boolean bl, boolean bl2) {
            super(queryItem);
            this.prefix = string;
            this.matchName = bl && string.length() > 0;
            this.camelCase = bl2;
        }

        protected boolean accept(ClassIndexStorage.QueryItem queryItem) {
            return !this.camelCase || queryItem.getName().startsWith(this.prefix) || this.matchIndexEntry(queryItem.getName());
        }

        private boolean matchIndexEntry(String string) {
            int n = -1;
            for (int i = 0; i < this.prefix.length(); ++i) {
                n = string.indexOf(this.prefix.charAt(i), n + 1);
                if (n >= 0) continue;
                return false;
            }
            return true;
        }

        private boolean matchName(String string) {
            if (!this.matchName && string.toUpperCase().startsWith(this.prefix)) {
                return true;
            }
            int n = 0;
            for (int i = 0; i < string.length() && n < this.prefix.length(); ++i) {
                char c = string.charAt(i);
                if (!Character.isUpperCase(c) || c == this.prefix.charAt(n++)) continue;
                return false;
            }
            return n == this.prefix.length();
        }

        protected int evaluateItem(long[] lArray, int n, int n2, JavaClass javaClass, Collection collection) {
            if (javaClass == null) {
                ClassIndex.this.logSNChange(new Long(lArray[n]), null);
                return 0;
            }
            lArray[n2] = lArray[n];
            if (!this.matchName && !this.camelCase || this.matchName && javaClass.getSimpleName().startsWith(this.prefix) || this.camelCase && this.matchName(javaClass.getSimpleName())) {
                if (((JavaClassImpl)javaClass).hasComposite()) {
                    collection.add(javaClass);
                } else {
                    JMManager.getTransactionMutex().invalidateAtCommit((Element)javaClass);
                }
            }
            return 1;
        }
    }

    private abstract class ClassesByPrefixIterator
    extends LazyImmutableList.LazyIterator {
        private int maxSize = -1;
        private int currentSize = 0;
        protected ClassIndexStorage.QueryItem currentItem;
        private Object next;
        private boolean hasNext = true;
        private Iterator inner = Collections.EMPTY_LIST.iterator();

        ClassesByPrefixIterator(ClassIndexStorage.QueryItem queryItem) {
            this.currentItem = queryItem;
        }

        public final Object next() {
            if (this.next == null) {
                this.findNext();
            }
            Object object = this.next;
            this.next = null;
            return object;
        }

        public final boolean hasNext() {
            this.findNext();
            return this.hasNext;
        }

        protected final int maxEstimatedSize() {
            if (this.maxSize == -1) {
                this.computeSize();
            }
            return this.maxSize;
        }

        private void computeSize() {
            this.maxSize = this.currentSize;
            for (ClassIndexStorage.QueryItem queryItem = this.currentItem; queryItem != null; queryItem = queryItem.getNext()) {
                this.maxSize += queryItem.getIDs().length;
            }
        }

        private void findNext() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            while (this.next == null && this.hasNext) {
                if (this.inner.hasNext()) {
                    this.next = this.inner.next();
                    continue;
                }
                while (this.currentItem != null && !this.accept(this.currentItem)) {
                    this.currentItem = this.currentItem.getNext();
                }
                if (this.currentItem != null) {
                    this.inner = this.getClassesByPrefix().iterator();
                    continue;
                }
                this.hasNext = false;
            }
        }

        private Collection getClassesByPrefix() {
            ArrayList arrayList = new ArrayList();
            long[] lArray = this.currentItem.getIDs();
            this.currentSize += lArray.length;
            int n = 0;
            for (int i = 0; i < lArray.length; ++i) {
                JavaClass javaClass = (JavaClass)ClassIndex.this.rep.getByMofId(ClassIndex.this.makeMofId(lArray[i]));
                n += this.evaluateItem(lArray, i, n, javaClass, arrayList);
            }
            if (n == 0) {
                this.currentItem.setIDs(null);
            } else if (n < lArray.length) {
                long[] lArray2 = new long[n];
                System.arraycopy(lArray, 0, lArray2, 0, n);
                this.currentItem.setIDs(lArray2);
            }
            this.currentItem = this.currentItem.getNext();
            return arrayList;
        }

        protected boolean accept(ClassIndexStorage.QueryItem queryItem) {
            return true;
        }

        protected abstract int evaluateItem(long[] var1, int var2, int var3, JavaClass var4, Collection var5);
    }
}

