/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.util.ArrayList;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.modules.javacore.internalapi.GuardedResolver;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.parser.MDRParser;
import org.openide.text.PositionBounds;

public final class FileGuardedResolver
implements GuardedResolver {
    private static final String GEN_BEGIN = "//GEN-BEGIN";
    private static final String GEN_END = "//GEN-END";
    private static final String GEN_HEADER = "//GEN-HEADER";
    private static final String GEN_HEADEREND = "//GEN-HEADEREND";
    private static final String GEN_LINE = "//GEN-LINE";
    private static final String GEN_FIRST = "//GEN-FIRST";
    private static final String GEN_LAST = "//GEN-LAST";
    private static final int GUARDED_BEGIN = 0;
    private static final int GUARDED_END = 1;
    private static final int GUARDED_LINE = 2;
    private static final int GUARDED_NONE = -1;
    private static FileGuardedResolver instance = null;

    private FileGuardedResolver() {
    }

    public static synchronized FileGuardedResolver getDefault() {
        if (instance == null) {
            instance = new FileGuardedResolver();
        }
        return instance;
    }

    public final boolean isSectionGuarded(Resource resource, PositionBounds positionBounds) {
        MDRParser mDRParser = ((ResourceImpl)resource).getParser();
        if (mDRParser.guardedBlocksBorders == null) {
            mDRParser.guardedBlocksBorders = this.findGuardedBlocks(resource);
        }
        return this.isGuarded(mDRParser.guardedBlocksBorders, positionBounds.getBegin().getOffset()) || this.isGuarded(mDRParser.guardedBlocksBorders, positionBounds.getEnd().getOffset());
    }

    private int[] findGuardedBlocks(Resource resource) {
        Object object;
        MDRParser mDRParser = ((ResourceImpl)resource).getParser();
        int n = 0;
        ASTree aSTree = mDRParser.getASTree();
        if (aSTree != null) {
            n = aSTree.getLastToken();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            object = mDRParser.getToken(i);
            Token[] tokenArray = object.getPadding();
            if (tokenArray == null) continue;
            block6: for (int j = 0; j < tokenArray.length; ++j) {
                int n3 = tokenArray[j].getType();
                if (n3 == 366) {
                    n2 = tokenArray[j].getEndOffset();
                    continue;
                }
                if (n3 != 363) continue;
                String string = mDRParser.getText(tokenArray[j]);
                int n4 = this.guardedId(string);
                switch (n4) {
                    case 0: {
                        arrayList.add(new Integer(n2));
                        continue block6;
                    }
                    case 1: {
                        arrayList.add(new Integer(tokenArray[j].getEndOffset()));
                        continue block6;
                    }
                    case 2: {
                        arrayList.add(new Integer(n2));
                        arrayList.add(new Integer(tokenArray[j].getEndOffset()));
                    }
                }
            }
        }
        int[] nArray = new int[arrayList.size()];
        object = arrayList.iterator();
        int n5 = 0;
        while (object.hasNext()) {
            nArray[n5] = (Integer)object.next();
            ++n5;
        }
        return nArray.length > 0 ? mDRParser.getDocumentOffsets(nArray) : nArray;
    }

    private int guardedId(String string) {
        if (string == null) {
            return -1;
        }
        if (string.indexOf(GEN_BEGIN) > -1 || string.indexOf(GEN_HEADER) > -1) {
            return 0;
        }
        if (string.indexOf(GEN_END) > -1 || string.indexOf(GEN_HEADEREND) > -1) {
            return 1;
        }
        if (string.indexOf(GEN_LINE) > -1 || string.indexOf(GEN_FIRST) > -1 || string.indexOf(GEN_LAST) > -1) {
            return 2;
        }
        return -1;
    }

    private boolean isGuarded(int[] nArray, int n, int n2) {
        int n3;
        if (nArray.length == 0) {
            return false;
        }
        if (n < nArray[0]) {
            return n2 < nArray[0];
        }
        for (n3 = 0; n3 < nArray.length && nArray[n3] < n; ++n3) {
        }
        if (n3 == nArray.length) {
            return false;
        }
        if (nArray[n3] == n) {
            return true;
        }
        if (n3 % 2 == 0) {
            return n2 < nArray[n3];
        }
        return true;
    }

    private boolean isGuarded(int[] nArray, int n) {
        if (nArray.length == 0 || n < nArray[0]) {
            return false;
        }
        for (int i = 0; i < nArray.length / 2; ++i) {
            if (n < nArray[2 * i] || n > nArray[2 * i + 1]) continue;
            return true;
        }
        return false;
    }
}

