/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LazyImmutableList
extends AbstractSequentialList {
    private LazyIterator internal;
    private boolean complete = false;
    private final Object[] array;
    private int nextIndex = 0;

    public LazyImmutableList(LazyIterator lazyIterator) {
        this.internal = lazyIterator;
        this.array = new Object[lazyIterator.maxEstimatedSize()];
    }

    public int size() {
        while (this.internal != null) {
            this.nextItem();
        }
        return this.nextIndex;
    }

    public ListIterator listIterator(int n) {
        return new LazyImmutableIterator(n);
    }

    public int maxEstimatedSize() {
        return this.internal == null ? this.nextIndex : this.internal.maxEstimatedSize();
    }

    private void nextItem() {
        if (this.internal != null && this.internal.hasNext()) {
            this.array[this.nextIndex] = this.internal.next();
            ++this.nextIndex;
        } else {
            this.internal = null;
        }
    }

    public static abstract class LazyIterator
    implements Iterator {
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract int maxEstimatedSize();
    }

    private class LazyImmutableIterator
    implements ListIterator {
        private int currentIndex;

        public LazyImmutableIterator(int n) {
            this.currentIndex = n;
        }

        public boolean hasNext() {
            while (LazyImmutableList.this.nextIndex <= this.currentIndex && LazyImmutableList.this.internal != null) {
                LazyImmutableList.this.nextItem();
            }
            return LazyImmutableList.this.nextIndex > this.currentIndex;
        }

        public int previousIndex() {
            return this.currentIndex - 1;
        }

        public Object previous() {
            if (this.hasPrevious()) {
                --this.currentIndex;
                return LazyImmutableList.this.array[this.currentIndex];
            }
            throw new NoSuchElementException();
        }

        public boolean hasPrevious() {
            return this.currentIndex > 0;
        }

        public Object next() {
            if (this.hasNext()) {
                ++this.currentIndex;
                return LazyImmutableList.this.array[this.currentIndex - 1];
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this.currentIndex;
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

