/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.ResourceClass;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.Util;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.GeneralException;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public class RepositoryUpdater
implements FileChangeListener {
    private static final boolean DEBUG = false;
    private static RepositoryUpdater updater;
    private final Set nonArchiveExts;
    private final JMManager manager = (JMManager)JavaMetamodel.getManager();
    private final Set fileObjectsToSave = Collections.synchronizedSet(new HashSet());
    private boolean changesDisabled = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    private RepositoryUpdater() {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList("JAVA", "CLASS", "LOG", "TXT", "XML", "HTML", "FORM", "PROPERTIES"));
        this.nonArchiveExts = Collections.unmodifiableSet(hashSet);
        Util.addFileSystemsListener(this);
    }

    public static RepositoryUpdater getDefault() {
        if (updater == null) {
            updater = new RepositoryUpdater();
        }
        return updater;
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
        try {
            if (this.changesDisabled) {
                return;
            }
            if (!this.isJavaFile(fileEvent)) {
                try {
                    URL uRL = this.getRootURL(fileEvent);
                    if (uRL != null) {
                        this.manager.getMergedClassPathImpl().updateRoot(uRL);
                    }
                }
                catch (Exception exception) {
                    JMManager.getLog().notify(1, (Throwable)exception);
                }
                return;
            }
            this.updateResource(fileEvent.getFile());
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private URL getRootURL(FileEvent fileEvent) throws FileStateInvalidException, MalformedURLException {
        return this.getRootURL(fileEvent.getFile());
    }

    private URL getRootURL(FileObject fileObject) throws FileStateInvalidException, MalformedURLException {
        URL uRL;
        if (fileObject.isFolder()) {
            uRL = fileObject.getURL();
        } else if (this.mayBeArchiveFile(fileObject) && FileUtil.isArchiveFile((FileObject)fileObject)) {
            uRL = FileUtil.getArchiveRoot((URL)fileObject.getURL());
        } else {
            return null;
        }
        if (!$assertionsDisabled && !uRL.toExternalForm().endsWith("/")) {
            throw new AssertionError((Object)("Bogus URL: " + uRL + " returned for FileObject: " + fileObject.getName() + " (isArchiveFile = " + FileUtil.isArchiveFile((FileObject)fileObject) + ", isFolder = " + fileObject.isFolder() + ", isValid = " + fileObject.isValid() + ")"));
        }
        return uRL;
    }

    public void setListenOnChanges(boolean bl) {
        this.changesDisabled = !bl;
    }

    public void addFileObjectToSave(FileObject fileObject) {
        this.fileObjectsToSave.add(fileObject);
    }

    static void updateTimeStamp(FileObject fileObject) {
        ResourceImpl resourceImpl;
        if (fileObject != null && (resourceImpl = (ResourceImpl)JavaMetamodel.getManager().getResource(fileObject)) != null) {
            Date date = fileObject.lastModified();
            if (!$assertionsDisabled && date == null) {
                throw new AssertionError((Object)("FileObject.lastModified() returned null for " + fileObject));
            }
            resourceImpl.setTimestamp(date.getTime(), false);
        }
    }

    private void updateResource(FileObject fileObject) {
        boolean bl;
        boolean bl2 = this.fileObjectsToSave.remove(fileObject);
        RepositoryUpdater repositoryUpdater = this;
        boolean bl3 = bl = Thread.currentThread() == repositoryUpdater.manager.getTransactionMutex().getThread();
        if (bl2) {
            if (bl) {
                RepositoryUpdater.updateTimeStamp(fileObject);
            } else {
                RepositoryUpdater repositoryUpdater2 = this;
                repositoryUpdater2.manager.getTransactionMutex().addUpdateTS(fileObject);
            }
        } else if (bl) {
            this.createOrUpdateResource(fileObject);
        } else {
            RepositoryUpdater repositoryUpdater3 = this;
            repositoryUpdater3.manager.getTransactionMutex().addModifiedRW(fileObject);
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        try {
            if (!Util.isJavaFile(fileObject)) {
                this.fileCreated(fileObject);
                return;
            }
            this.updateResource(fileObject);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private void fileCreated(FileObject fileObject) {
        try {
            URL uRL = this.getRootURL(fileObject);
            if (uRL != null) {
                this.manager.getMergedClassPathImpl().removeMissingRoot(uRL);
            }
        }
        catch (Exception exception) {
            JMManager.getLog().notify(1, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createOrUpdateResource(FileObject fileObject) {
        if (!fileObject.isValid()) {
            return;
        }
        FileObject fileObject2 = this.manager.getMergedClassPathImpl().findOwnerRoot(fileObject);
        if (fileObject2 == null) {
            return;
        }
        boolean bl = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            String string = this.manager.getResourceName(fileObject);
            if (string == null) {
                bl = false;
                return;
            }
            JavaModelPackage javaModelPackage = this.manager.resolveJavaExtent(fileObject2);
            if (javaModelPackage == null) {
                ErrorManager.getDefault().notify(1, (Throwable)((Object)new GeneralException(fileObject.getPath() + " was not found in any extent. There is no resource to update.")));
                bl = false;
                return;
            }
            ResourceClass resourceClass = javaModelPackage.getResource();
            Resource resource = resourceClass.resolveResource(string, false);
            if (resource == null || !string.equals(resource.getName())) {
                String string2;
                if (string.endsWith(".java")) {
                    String string3 = string.substring(0, string.length() - ".java".length()) + ".class";
                    resource = resourceClass.resolveResource(string3, false);
                    if (resource != null) {
                        resource.refDelete();
                    }
                } else if (string.endsWith(".class") && resourceClass.resolveResource(string2 = string.substring(0, string.length() - ".class".length()) + ".java", false) != null) {
                    bl = false;
                    return;
                }
                resource = ((ResourceClassImpl)resourceClass).resolveResource(string, true, false);
            }
            ((ResourceImpl)resource).updateFromFileObject(fileObject, true);
            bl = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(bl);
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        try {
            if (!Util.isJavaFile(fileEvent.getFile(), true)) {
                try {
                    URL uRL = this.getRootURL(fileEvent);
                    if (uRL != null) {
                        this.manager.getMergedClassPathImpl().addMissingRoot(uRL);
                    }
                }
                catch (Exception exception) {
                    JMManager.getLog().notify(1, (Throwable)exception);
                }
                return;
            }
            RepositoryUpdater repositoryUpdater = this;
            repositoryUpdater.manager.getTransactionMutex().addDeleted(fileEvent.getFile());
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private boolean isJavaFile(FileEvent fileEvent) {
        return Util.isJavaFile(fileEvent.getFile());
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.folderCreated(fileEvent.getFile());
    }

    public void folderCreated(FileObject fileObject) {
        FileObject fileObject2 = Util.getCPRoot(fileObject);
        if (fileObject2 == null) {
            FileObject[] fileObjectArray;
            try {
                fileObjectArray = this.getRootURL(fileObject);
                if (fileObjectArray != null && this.manager.getMergedClassPathImpl().removeMissingRoot((URL)fileObjectArray)) {
                    return;
                }
            }
            catch (Exception exception) {
                JMManager.getLog().notify(1, (Throwable)exception);
            }
            fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (fileObjectArray[i].isFolder()) {
                    this.folderCreated(fileObjectArray[i]);
                    continue;
                }
                this.fileCreated(fileObjectArray[i]);
            }
            return;
        }
        Enumeration enumeration = fileObject.getChildren(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject3 = (FileObject)enumeration.nextElement();
            if (!Util.isJavaFile(fileObject3)) continue;
            this.updateResource(fileObject3);
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        block7: {
            try {
                if (this.isJavaFile((FileEvent)fileRenameEvent)) {
                    this.javaFileRenamed(fileRenameEvent);
                    break block7;
                }
                try {
                    URL uRL = this.getRootURL((FileEvent)fileRenameEvent);
                    if (uRL != null && this.manager.getMergedClassPathImpl().removeMissingRoot(uRL)) {
                        return;
                    }
                }
                catch (Exception exception) {
                    JMManager.getLog().notify(1, (Throwable)exception);
                }
                if (fileRenameEvent.getFile().isFolder()) {
                    this.folderRenamed(fileRenameEvent);
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void javaFileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject = fileRenameEvent.getFile();
        boolean bl = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            String string = fileRenameEvent.getName();
            FileObject fileObject2 = Util.getCPRoot(fileObject);
            if (fileObject2 == null) {
                bl = false;
                return;
            }
            JavaModelPackage javaModelPackage = this.manager.getJavaExtent(fileObject2);
            if (javaModelPackage != null) {
                Resource resource;
                String string2 = this.manager.getResourceName(fileObject.getParent());
                String string3 = string + '.' + fileRenameEvent.getExt();
                if (string2.length() > 0) {
                    string2 = string2 + '/';
                    string3 = string2 + string3;
                }
                if ((resource = javaModelPackage.getResource().resolveResource(string3, false)) != null) {
                    resource.setName(string2 + fileObject.getNameExt());
                } else {
                    ((ResourceClassImpl)javaModelPackage.getResource()).resolveResource(string2 + fileObject.getNameExt(), true, false);
                }
            }
            bl = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void folderRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject = fileRenameEvent.getFile();
        boolean bl = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            Enumeration enumeration = fileObject.getChildren(true);
            FileObject fileObject2 = Util.getCPRoot(fileObject);
            if (fileObject2 == null || fileObject2.equals(fileObject)) {
                bl = false;
                return;
            }
            String string = JMManager.getResourceName(fileObject2, fileObject);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject3 = (FileObject)enumeration.nextElement();
                if (!"java".equals(fileObject3.getExt()) || fileObject3.isVirtual()) continue;
                String string2 = JMManager.getResourceName(fileObject2, fileObject3);
                String string3 = RepositoryUpdater.replaceStart(string2, string, fileRenameEvent.getName());
                string3 = RepositoryUpdater.replaceEnd(string, fileRenameEvent.getName());
                string3 = RepositoryUpdater.replaceStart(string2, string, string3);
                this.manager.getResource(fileObject2, string3).setName(string2);
            }
            bl = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(bl);
        }
    }

    private static final String replaceStart(String string, String string2, String string3) {
        return string3.concat(string.substring(string2.length()));
    }

    private static final String replaceEnd(String string, String string2) {
        int n = string.lastIndexOf(47);
        if (n > 0) {
            return string.substring(0, n + 1).concat(string2);
        }
        return string2;
    }

    private boolean mayBeArchiveFile(FileObject fileObject) {
        return !this.nonArchiveExts.contains(fileObject.getExt().toUpperCase(Locale.US));
    }

    static {
        $assertionsDisabled = !RepositoryUpdater.class.desiredAssertionStatus();
        updater = null;
    }
}

