/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.jmi.javamodel.Codebase;
import org.netbeans.jmi.javamodel.CodebaseClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.classpath.MergedClassPathImplementation;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.scanning.FileScanner;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;

public class RescanAction
extends CallableSystemAction
implements Runnable {
    private RequestProcessor.Task scanningTask;
    private Runnable start;
    private Runnable stop;

    public String getName() {
        return NbBundle.getMessage((Class)RescanAction.class, (String)"LBL_RescanAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RescanAction.class);
    }

    public void performAction() {
        this.postRequest();
    }

    private void postRequest() {
        this.init();
        this.scanningTask.schedule(0);
    }

    private void init() {
        if (this.scanningTask == null) {
            this.scanningTask = new RequestProcessor("Rescanning RP").create((Runnable)this);
            this.start = new Runnable(){

                public void run() {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$javacore$RescanAction == null ? (class$org$netbeans$modules$javacore$RescanAction = RescanAction.class$("org.netbeans.modules.javacore.RescanAction")) : class$org$netbeans$modules$javacore$RescanAction), (String)"LBL_Rescanning"));
                }
            };
            this.stop = new Runnable(){

                public void run() {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$javacore$RescanAction == null ? (class$org$netbeans$modules$javacore$RescanAction = RescanAction.class$("org.netbeans.modules.javacore.RescanAction")) : class$org$netbeans$modules$javacore$RescanAction), (String)"LBL_RescanningFinished"));
                }
            };
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Set set = MergedClassPathImplementation.getDefault().getRoots();
        SwingUtilities.invokeLater(this.start);
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                JMManager.getDefaultRepository().beginTrans(false);
                try {
                    JavaModelPackage javaModelPackage = JavaMetamodel.getManager().getJavaExtent(fileObject);
                    if (javaModelPackage == null) continue;
                    CodebaseClass codebaseClass = javaModelPackage.getCodebase();
                    Codebase codebase = (Codebase)codebaseClass.refAllOfClass().iterator().next();
                    try {
                        URL uRL = fileObject.getURL();
                        String string = SourceLevelQuery.getSourceLevel((FileObject)fileObject);
                        new FileScanner(uRL, string, codebase, true).scan();
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans();
                }
            }
        }
        finally {
            SwingUtilities.invokeLater(this.stop);
        }
    }
}

