/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.jmi.reflect.RefObject;

public class Snapshot
implements InvocationHandler {
    private final HashMap results = new HashMap();
    private RefObject wrappedObject;
    private HashSet snapshots;

    private Snapshot(RefObject refObject) {
        this.wrappedObject = refObject;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        if (this.wrappedObject == null) {
            object2 = this.results.get(method);
            if (object2 == null && !this.results.containsKey(method)) {
                throw new IllegalStateException("Value for " + method + " not cached.");
            }
        } else {
            object2 = method.invoke((Object)this.wrappedObject, objectArray);
            object2 = this.wrap(object2);
            this.results.put(method, object2);
        }
        return object2;
    }

    private void addSnapshot(Object object) {
        if (this.snapshots == null) {
            this.snapshots = new HashSet();
        }
        this.snapshots.add(object);
    }

    private Object wrap(Object object) {
        if (object instanceof Collection) {
            return this.wrapCollection((Collection)object);
        }
        if (object instanceof RefObject) {
            RefObject refObject = Snapshot.createSnapshot((RefObject)object);
            this.addSnapshot(refObject);
            return refObject;
        }
        return object;
    }

    private Object wrapCollection(Collection collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.wrap(iterator.next()));
        }
        return arrayList;
    }

    private void freeze() {
        if (this.snapshots != null) {
            Iterator iterator = this.snapshots.iterator();
            while (iterator.hasNext()) {
                ((Snapshot)iterator.next()).freeze();
            }
            this.snapshots = null;
        }
        this.wrappedObject = null;
    }

    public static RefObject createSnapshot(RefObject refObject) {
        Snapshot snapshot = new Snapshot(refObject);
        Class<?> clazz = refObject.getClass();
        return (RefObject)Proxy.newProxyInstance(clazz.getClassLoader(), clazz.getInterfaces(), (InvocationHandler)snapshot);
    }

    public static void freeze(RefObject refObject) {
        ((Snapshot)Proxy.getInvocationHandler(refObject)).freeze();
    }
}

