/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.io.File;
import java.util.LinkedHashSet;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public class Util {
    private static FileSystem[] fileSystems;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static FileSystem[] getFileSystems() {
        if (fileSystems != null) {
            return fileSystems;
        }
        File[] fileArray = File.listRoots();
        LinkedHashSet<FileSystem> linkedHashSet = new LinkedHashSet<FileSystem>();
        if (!($assertionsDisabled || fileArray != null && fileArray.length > 0)) {
            throw new AssertionError((Object)"Could not list file roots");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) continue;
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                linkedHashSet.add(fileSystem);
                if (fileSystem == null) continue;
                break;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                throw new AssertionError((Object)fileStateInvalidException);
            }
        }
        FileSystem[] fileSystemArray = new FileSystem[linkedHashSet.size()];
        linkedHashSet.toArray(fileSystemArray);
        if (!$assertionsDisabled && fileSystemArray.length <= 0) {
            throw new AssertionError((Object)"Could not get any filesystem");
        }
        fileSystems = fileSystemArray;
        return fileSystemArray;
    }

    public static void addFileSystemsListener(FileChangeListener fileChangeListener) {
        FileSystem[] fileSystemArray = Util.getFileSystems();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            fileSystemArray[i].addFileChangeListener(fileChangeListener);
        }
    }

    public static void removeFileSystemsListener(FileChangeListener fileChangeListener) {
        FileSystem[] fileSystemArray = Util.getFileSystems();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            fileSystemArray[i].removeFileChangeListener(fileChangeListener);
        }
    }

    public static FileObject getCPRoot(FileObject fileObject) {
        return ((JMManager)JavaMetamodel.getManager()).getMergedClassPathImpl().findOwnerRoot(fileObject);
    }

    public static boolean isJavaFile(FileObject fileObject) {
        return Util.isJavaFile(fileObject, false);
    }

    public static boolean isJavaFile(FileObject fileObject, boolean bl) {
        if (!bl && fileObject.isVirtual()) {
            return false;
        }
        if (fileObject.isFolder()) {
            return false;
        }
        String string = fileObject.getExt();
        return ("java".equals(string) || "class".equals(string)) && Util.getCPRoot(fileObject) != null;
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
    }
}

