/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class MergedClassPathImplementation
implements ClassPathImplementation {
    public static final String PROP_UNRESOLVED_ROOTS = "unresolvedRoots";
    private Set roots;
    private PropertyChangeSupport support;
    private GlobalPathRegistry reg;
    private final ArrayList cachedResources;
    private List unresolvedRoots;
    private List missingRoots;
    private ClassPathMap resourceMap;
    private GlobalPathRegistryListener gprListener;
    private PropertyChangeListener pcListener = new PropertyChangeListener(){
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!$assertionsDisabled && propertyChangeEvent == null) {
                throw new AssertionError((Object)"event == null");
            }
            MergedClassPathImplementation mergedClassPathImplementation = MergedClassPathImplementation.this;
            synchronized (mergedClassPathImplementation) {
                MergedClassPathImplementation.this.roots = null;
            }
            if ("entries".equals(propertyChangeEvent.getPropertyName())) {
                MergedClassPathImplementation.this.updateEntries((ClassPath)propertyChangeEvent.getSource());
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$javacore$classpath$MergedClassPathImplementation == null ? (class$org$netbeans$modules$javacore$classpath$MergedClassPathImplementation = MergedClassPathImplementation.class$("org.netbeans.modules.javacore.classpath.MergedClassPathImplementation")) : class$org$netbeans$modules$javacore$classpath$MergedClassPathImplementation).desiredAssertionStatus();
        }
    };
    private WeakHashMap sfbResultListeners = new WeakHashMap(100);
    private static MergedClassPathImplementation instance;
    static final /* synthetic */ boolean $assertionsDisabled;

    private MergedClassPathImplementation() {
        this.support = new PropertyChangeSupport(this);
        this.cachedResources = new ArrayList();
        this.missingRoots = new ArrayList();
        this.reg = GlobalPathRegistry.getDefault();
        this.gprListener = new GlobalPathRegistryListener(){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void pathsAdded(GlobalPathRegistryEvent globalPathRegistryEvent) {
                if (!$assertionsDisabled && globalPathRegistryEvent == null) {
                    throw new AssertionError((Object)"event == null");
                }
                MergedClassPathImplementation mergedClassPathImplementation = MergedClassPathImplementation.this;
                synchronized (mergedClassPathImplementation) {
                    MergedClassPathImplementation.this.roots = null;
                }
                MergedClassPathImplementation.this.updateEntries(globalPathRegistryEvent);
                MergedClassPathImplementation.this.firePropertyChange(MergedClassPathImplementation.PROP_UNRESOLVED_ROOTS);
            }

            public void pathsRemoved(GlobalPathRegistryEvent globalPathRegistryEvent) {
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$javacore$classpath$MergedClassPathImplementation == null ? (class$org$netbeans$modules$javacore$classpath$MergedClassPathImplementation = MergedClassPathImplementation.class$("org.netbeans.modules.javacore.classpath.MergedClassPathImplementation")) : class$org$netbeans$modules$javacore$classpath$MergedClassPathImplementation).desiredAssertionStatus();
            }
        };
        this.reg.addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create((Class)GlobalPathRegistryListener.class, (EventListener)this.gprListener, (Object)this.reg));
        if (!$assertionsDisabled && this.reg == null) {
            throw new AssertionError((Object)"GloabalPathRegistry.getDefault()==null");
        }
    }

    public synchronized List getResources() {
        return Collections.unmodifiableList((List)this.cachedResources.clone());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!$assertionsDisabled && propertyChangeListener == null) {
            throw new AssertionError((Object)"gprListener == null");
        }
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!$assertionsDisabled && propertyChangeListener == null) {
            throw new AssertionError((Object)"gprListener == null");
        }
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassPaths(ClassPath[] classPathArray) {
        if (!$assertionsDisabled && classPathArray == null) {
            throw new AssertionError((Object)"addClassPath called with null");
        }
        for (int i = 0; i < classPathArray.length; ++i) {
            if (classPathArray[i] == null) continue;
            this.addClassPath(classPathArray[i]);
        }
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            this.roots = null;
        }
        this.firePropertyChange(PROP_UNRESOLVED_ROOTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoot(URL uRL) {
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            if (this.unresolvedRoots == null) {
                this.initEntries();
            }
            PathResourceImplementation pathResourceImplementation = ClassPathSupport.createResource((URL)uRL);
            this.unresolvedRoots.add(pathResourceImplementation);
            this.roots = null;
        }
        this.firePropertyChange(PROP_UNRESOLVED_ROOTS);
    }

    public synchronized PathResourceImplementation[] getUnresolvedRoots() {
        if (this.unresolvedRoots == null) {
            this.initEntries();
        }
        return this.unresolvedRoots.toArray(new PathResourceImplementation[this.unresolvedRoots.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classPathRootResolved(PathResourceImplementation pathResourceImplementation) {
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            if (this.unresolvedRoots.remove(pathResourceImplementation)) {
                this.cachedResources.add(pathResourceImplementation);
            }
            this.roots = null;
        }
        this.firePropertyChange("resources");
    }

    public synchronized void removeRoot(PathResourceImplementation pathResourceImplementation) {
        this.unresolvedRoots.remove(pathResourceImplementation);
        this.missingRoots.add(pathResourceImplementation.getRoots()[0]);
        this.roots = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMissingRoot(URL uRL) {
        boolean bl = false;
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            while (this.missingRoots.remove(uRL)) {
                PathResourceImplementation pathResourceImplementation = ClassPathSupport.createResource((URL)uRL);
                if (!$assertionsDisabled && pathResourceImplementation == null) {
                    throw new AssertionError((Object)"ClassPathSupport.createResource() returned null");
                }
                this.unresolvedRoots.add(pathResourceImplementation);
                bl = true;
                this.roots = null;
            }
        }
        if (bl) {
            this.firePropertyChange(PROP_UNRESOLVED_ROOTS);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMissingRoot(URL uRL) {
        boolean bl = false;
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            PathResourceImplementation pathResourceImplementation = ClassPathSupport.createResource((URL)uRL);
            while (this.cachedResources.remove(pathResourceImplementation)) {
                this.missingRoots.add(uRL);
                bl = true;
                this.roots = null;
            }
        }
        if (bl) {
            this.firePropertyChange("resources");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRoot(URL uRL) {
        boolean bl = false;
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            PathResourceImplementation pathResourceImplementation = ClassPathSupport.createResource((URL)uRL);
            while (this.cachedResources.remove(pathResourceImplementation)) {
                this.unresolvedRoots.add(pathResourceImplementation);
                bl = true;
                this.roots = null;
            }
        }
        if (bl) {
            this.firePropertyChange("resources");
            this.firePropertyChange(PROP_UNRESOLVED_ROOTS);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnresolvedRoots(List list) {
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            this.unresolvedRoots.addAll(list);
            this.roots = null;
        }
        this.firePropertyChange(PROP_UNRESOLVED_ROOTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classPathRootResolved(URL uRL) {
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            Iterator iterator = this.unresolvedRoots.iterator();
            while (iterator.hasNext()) {
                PathResourceImplementation pathResourceImplementation = (PathResourceImplementation)iterator.next();
                if (!pathResourceImplementation.getRoots()[0].equals(uRL)) continue;
                iterator.remove();
                this.cachedResources.add(pathResourceImplementation);
                break;
            }
            this.roots = null;
        }
        this.firePropertyChange("resources");
    }

    private synchronized void initEntries() {
        HashSet hashSet = new HashSet();
        this.roots = null;
        this.unresolvedRoots = new ArrayList();
        this.resourceMap = new ClassPathMap();
        hashSet.addAll(this.reg.getPaths("classpath/source"));
        hashSet.addAll(this.reg.getPaths("classpath/compile"));
        hashSet.addAll(this.reg.getPaths("classpath/boot"));
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ClassPath classPath = (ClassPath)iterator.next();
            this.addClassPath(classPath);
        }
    }

    private synchronized void updateEntries(GlobalPathRegistryEvent globalPathRegistryEvent) {
        if (this.cachedResources == null) {
            return;
        }
        Iterator iterator = globalPathRegistryEvent.getChangedPaths().iterator();
        while (iterator.hasNext()) {
            ClassPath classPath = (ClassPath)iterator.next();
            this.addClassPath(classPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntries(ClassPath classPath) {
        boolean bl = false;
        MergedClassPathImplementation mergedClassPathImplementation = this;
        synchronized (mergedClassPathImplementation) {
            PathResourceImplementation pathResourceImplementation;
            List list = (List)this.resourceMap.remove(classPath);
            if (!$assertionsDisabled && list == null) {
                throw new AssertionError((Object)"Change in unknown classpath");
            }
            List list2 = this.addClassPathResources(classPath);
            HashSet hashSet = new HashSet(list);
            hashSet.removeAll(list2);
            list2.removeAll(list);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                pathResourceImplementation = (PathResourceImplementation)iterator.next();
                list.remove(pathResourceImplementation);
                if (!this.cachedResources.remove(pathResourceImplementation)) {
                    if (this.unresolvedRoots.remove(pathResourceImplementation)) continue;
                    this.missingRoots.remove(pathResourceImplementation.getRoots()[0]);
                    continue;
                }
                bl = true;
            }
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                pathResourceImplementation = (PathResourceImplementation)iterator.next();
                list.add(pathResourceImplementation);
            }
            this.resourceMap.put(classPath, list);
            this.unresolvedRoots.addAll(list2);
        }
        if (bl) {
            this.firePropertyChange("resources");
        }
        this.firePropertyChange(PROP_UNRESOLVED_ROOTS);
    }

    private synchronized void addClassPath(ClassPath classPath) {
        if (this.resourceMap == null) {
            this.initEntries();
        }
        if (this.resourceMap.containsKey(classPath)) {
            return;
        }
        List list = this.addClassPathResources(classPath);
        this.resourceMap.put(classPath, list);
        this.unresolvedRoots.addAll(list);
        classPath.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)PropertyChangeListener.class, (EventListener)this.pcListener, (Object)classPath));
    }

    private void firePropertyChange(String string) {
        this.support.firePropertyChange(string, null, null);
    }

    private List addClassPathResources(ClassPath classPath) {
        ArrayList arrayList = new ArrayList();
        WeakReference weakReference = (WeakReference)this.sfbResultListeners.get(classPath);
        SFBQListener sFBQListener = weakReference == null ? null : weakReference.get();
        if (sFBQListener == null) {
            sFBQListener = new SFBQListener(classPath);
            this.sfbResultListeners.put(classPath, new WeakReference<SFBQListener>(sFBQListener));
        }
        Iterator iterator = classPath.entries().iterator();
        while (iterator.hasNext()) {
            ClassPath.Entry entry = (ClassPath.Entry)iterator.next();
            URL uRL = entry.getURL();
            if (!$assertionsDisabled && uRL == null) {
                throw new AssertionError((Object)"ClassPath.Entry.getURL() returned null");
            }
            MergedClassPathImplementation.addResources(uRL, sFBQListener, arrayList);
        }
        return arrayList;
    }

    private static void addResources(URL uRL, SFBQListener sFBQListener, List list) {
        PathResourceImplementation pathResourceImplementation = ClassPathSupport.createResource((URL)uRL);
        if (!$assertionsDisabled && pathResourceImplementation == null) {
            throw new AssertionError((Object)"ClassPathSupport.createResource() returned null");
        }
        boolean bl = true;
        SourceForBinaryQuery.Result result = sFBQListener.getResult(uRL);
        FileObject[] fileObjectArray = result.getRoots();
        List<FileObject> list2 = Arrays.asList(fileObjectArray);
        if (list2.contains(null)) {
            ErrorManager.getDefault().log(16, "Warning: " + result.getClass().getName() + " illegally returned a null element from getResult(URL): " + list2);
            return;
        }
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>(fileObjectArray.length);
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                URL uRL2 = fileObjectArray[i].getURL();
                if ("file".equals(uRL2.getProtocol())) {
                    bl = false;
                }
                PathResourceImplementation pathResourceImplementation2 = ClassPathSupport.createResource((URL)uRL2);
                if (!$assertionsDisabled && pathResourceImplementation2 == null) {
                    throw new AssertionError((Object)"ClassPathSupport.createResource() returned null");
                }
                arrayList.add(pathResourceImplementation2);
                continue;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
        if (bl) {
            list.add(pathResourceImplementation);
        }
        list.addAll(arrayList);
    }

    public static synchronized MergedClassPathImplementation getDefault() {
        if (instance == null) {
            instance = new MergedClassPathImplementation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getRoots() {
        List list;
        Object object = this;
        synchronized (object) {
            if (this.roots != null) {
                return this.roots;
            }
            list = this.getResources();
        }
        object = new HashSet();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            PathResourceImplementation pathResourceImplementation = (PathResourceImplementation)object2.next();
            URL[] uRLArray = pathResourceImplementation.getRoots();
            for (int i = 0; i < uRLArray.length; ++i) {
                FileObject fileObject = URLMapper.findFileObject((URL)uRLArray[i]);
                if (fileObject == null) continue;
                object.add(fileObject);
            }
        }
        object2 = this;
        synchronized (object2) {
            if (this.roots == null) {
                this.roots = Collections.unmodifiableSet(object);
            }
            return this.roots;
        }
    }

    public boolean contains(FileObject fileObject) {
        return this.findOwnerRoot(fileObject) != null;
    }

    public FileObject findOwnerRoot(FileObject fileObject) {
        Set set = this.getRoots();
        for (FileObject fileObject2 = fileObject; fileObject2 != null; fileObject2 = fileObject2.getParent()) {
            if (!set.contains(fileObject2)) continue;
            return fileObject2;
        }
        return null;
    }

    static {
        $assertionsDisabled = !MergedClassPathImplementation.class.desiredAssertionStatus();
    }

    private class ClassPathMap {
        private List data = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(Object object, Object object2) {
            MergedClassPathImplementation mergedClassPathImplementation = MergedClassPathImplementation.this;
            synchronized (mergedClassPathImplementation) {
                WeakPair weakPair = new WeakPair(object, object2);
                this.data.add(weakPair);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object object) {
            if (object == null) {
                return null;
            }
            MergedClassPathImplementation mergedClassPathImplementation = MergedClassPathImplementation.this;
            synchronized (mergedClassPathImplementation) {
                Iterator iterator = this.data.iterator();
                while (iterator.hasNext()) {
                    WeakPair weakPair = (WeakPair)iterator.next();
                    Object object2 = weakPair.getKey();
                    if (!object.equals(object2)) continue;
                    iterator.remove();
                    return weakPair.getValue();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object object) {
            Iterator iterator;
            if (object == null) {
                return false;
            }
            Object object2 = MergedClassPathImplementation.this;
            synchronized (object2) {
                iterator = new ArrayList(this.data).iterator();
            }
            while (iterator.hasNext()) {
                object2 = (WeakPair)iterator.next();
                Object object3 = ((WeakPair)object2).getKey();
                if (!object.equals(object3)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUp(WeakPair weakPair) {
            boolean bl = false;
            MergedClassPathImplementation mergedClassPathImplementation = MergedClassPathImplementation.this;
            synchronized (mergedClassPathImplementation) {
                Iterator iterator = this.data.iterator();
                while (iterator.hasNext()) {
                    WeakPair weakPair2 = (WeakPair)iterator.next();
                    if (weakPair2 != weakPair) continue;
                    iterator.remove();
                    Iterator iterator2 = ((Collection)weakPair2.getValue()).iterator();
                    while (iterator2.hasNext()) {
                        PathResourceImplementation pathResourceImplementation = (PathResourceImplementation)iterator2.next();
                        if (!MergedClassPathImplementation.this.cachedResources.remove(pathResourceImplementation)) {
                            if (MergedClassPathImplementation.this.unresolvedRoots.remove(pathResourceImplementation)) continue;
                            MergedClassPathImplementation.this.missingRoots.remove(pathResourceImplementation.getRoots()[0]);
                            continue;
                        }
                        bl = true;
                        MergedClassPathImplementation.this.roots = null;
                    }
                    break block3;
                }
            }
            if (bl) {
                MergedClassPathImplementation.this.firePropertyChange("resources");
            }
        }

        private class WeakPair
        extends WeakReference
        implements Runnable {
            private Object value;

            public WeakPair(Object object, Object object2) {
                super(object, Utilities.activeReferenceQueue());
                this.value = object2;
            }

            public Object getKey() {
                return this.get();
            }

            public Object getValue() {
                return this.value;
            }

            public void run() {
                ClassPathMap.this.cleanUp(this);
            }
        }
    }

    private class SFBQListener
    implements ChangeListener,
    PropertyChangeListener {
        private final WeakReference cp;
        private Map results;

        public SFBQListener(ClassPath classPath) {
            this.cp = new WeakReference<ClassPath>(classPath);
            classPath.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        public SourceForBinaryQuery.Result getResult(URL uRL) {
            SourceForBinaryQuery.Result result;
            Reference reference;
            if (this.results == null) {
                this.results = new HashMap();
            }
            if ((reference = (Reference)this.results.get(uRL)) == null || (result = (SourceForBinaryQuery.Result)reference.get()) == null) {
                result = SourceForBinaryQuery.findSourceRoots((URL)uRL);
                this.results.put(uRL, new WeakReference<SourceForBinaryQuery.Result>(result));
                result.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)result));
            }
            return result;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ClassPath classPath = (ClassPath)this.cp.get();
            if (classPath != null) {
                MergedClassPathImplementation.this.updateEntries(classPath);
            }
        }
    }
}

