/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.internalapi;

import java.io.IOException;
import javax.swing.text.StyledDocument;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.FileGuardedResolver;
import org.netbeans.modules.javacore.internalapi.GuardedResolver;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;

public final class GuardedQuery {
    private static GuardedResolver fileResolver = null;
    private static GuardedResolver documentResolver = null;

    private GuardedQuery() {
    }

    public static boolean isSectionGuarded(Resource resource, PositionBounds positionBounds) {
        ResourceImpl resourceImpl = (ResourceImpl)resource;
        DataObject dataObject = JavaMetamodel.getManager().getDataObject(resourceImpl);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        StyledDocument styledDocument = null;
        if (editorCookie != null && (styledDocument = editorCookie.getDocument()) == null && resourceImpl.getParser().isFromDocument()) {
            try {
                styledDocument = editorCookie.openDocument();
            }
            catch (IOException iOException) {
                throw (RuntimeException)ErrorManager.getDefault().annotate((Throwable)new RuntimeException(), (Throwable)iOException);
            }
        }
        if (styledDocument != null) {
            return GuardedQuery.getDocumentGuardedResolver().isSectionGuarded(resourceImpl, positionBounds);
        }
        return GuardedQuery.getFileGuardedResolver().isSectionGuarded(resourceImpl, positionBounds);
    }

    private static GuardedResolver getDocumentGuardedResolver() {
        if (documentResolver == null) {
            return GuardedQuery.getFileGuardedResolver();
        }
        return documentResolver;
    }

    private static GuardedResolver getFileGuardedResolver() {
        return FileGuardedResolver.getDefault();
    }

    public static void setDocumentGuardedResolver(GuardedResolver guardedResolver) {
        documentResolver = guardedResolver;
    }
}

