/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.internalapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Catch;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.Invocation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.MultipartIdClass;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.ThrowStatement;
import org.netbeans.jmi.javamodel.TryStatement;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeArgument;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MethodImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ParameterizedTypeImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;
import org.netbeans.modules.javacore.parser.Scope;
import org.netbeans.modules.javacore.parser.TypeRef;

public class JavaModelUtil {
    private JavaModelUtil() {
    }

    public static Set getExceptionsFromStatements(List list) {
        return JavaModelUtil.computeAllExceptions(list, new HashSet());
    }

    private static Set computeAllExceptions(List list, Set set) {
        Iterator iterator = list.iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            Iterator iterator2;
            List list2;
            CallableFeature callableFeature;
            Invocation invocation;
            Object e = iterator.next();
            if (e instanceof Invocation) {
                invocation = (Invocation)e;
                callableFeature = (CallableFeature)invocation.getElement();
                if (callableFeature != null && !(list2 = callableFeature.getExceptions()).isEmpty()) {
                    iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        JavaModelUtil.addException((JavaClass)iterator2.next(), hashSet, set);
                    }
                }
            } else {
                if (e instanceof MultipartId) continue;
                if (e instanceof ThrowStatement) {
                    invocation = (ThrowStatement)e;
                    callableFeature = invocation.getExpression();
                    if (callableFeature != null) {
                        JavaModelUtil.addException((JavaClass)callableFeature.getType(), hashSet, set);
                    }
                } else if (e instanceof TryStatement && (callableFeature = (invocation = (TryStatement)e).getBody()) != null) {
                    list2 = invocation.getCatches();
                    iterator2 = list2.iterator();
                    HashSet hashSet2 = new HashSet(set);
                    StatementBlock statementBlock = invocation.getFinalizer();
                    while (iterator2.hasNext()) {
                        Catch catch_ = (Catch)iterator2.next();
                        JavaClass javaClass = (JavaClass)catch_.getParameter().getType();
                        JavaModelUtil.addException(javaClass, hashSet2, Collections.EMPTY_SET);
                    }
                    hashSet.addAll(JavaModelUtil.computeAllExceptions(Collections.singletonList(callableFeature), hashSet2));
                    hashSet.addAll(JavaModelUtil.computeAllExceptions(list2, set));
                    if (statementBlock != null) {
                        hashSet.addAll(JavaModelUtil.computeAllExceptions(Collections.singletonList(statementBlock), set));
                    }
                    return hashSet;
                }
            }
            hashSet.addAll(JavaModelUtil.computeAllExceptions(((Element)e).getChildren(), set));
        }
        return hashSet;
    }

    private static void addException(JavaClass javaClass, Set set, Set set2) {
        JavaClass javaClass2;
        if (javaClass == null || javaClass instanceof UnresolvedClass) {
            return;
        }
        if (set2.contains(javaClass) || set.contains(javaClass)) {
            return;
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            javaClass2 = (JavaClass)iterator.next();
            if (!javaClass.isSubTypeOf((ClassDefinition)javaClass2)) continue;
            return;
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            javaClass2 = (JavaClass)iterator.next();
            if (!javaClass.isSubTypeOf((ClassDefinition)javaClass2)) continue;
            return;
        }
        set.add(javaClass);
    }

    public static List getSelectedStatements(Resource resource, int n, int n2) {
        List<Statement> list;
        Statement statement = JavaModelUtil.getStatement(resource, n);
        Statement statement2 = JavaModelUtil.getStatement(resource, n2 - 1);
        if (statement == null || statement2 == null) {
            return null;
        }
        statement = JavaModelUtil.adjustFirstStatement(n, statement);
        statement2 = JavaModelUtil.adjustLastStatement(n2, statement2);
        if (statement == null || statement2 == null) {
            return null;
        }
        Element element = (Element)statement.refImmediateComposite();
        Element element2 = (Element)statement2.refImmediateComposite();
        int n3 = element2.getEndOffset();
        while (!element.equals(element2)) {
            if (!(element2 instanceof Statement) || element2.getEndOffset() != n3) {
                return null;
            }
            statement2 = (Statement)element2;
            element2 = (Element)statement2.refImmediateComposite();
        }
        if (statement.equals(statement2)) {
            list = Collections.singletonList(statement);
        } else {
            Object e;
            StatementBlock statementBlock = (StatementBlock)element;
            List list2 = statementBlock.getStatements();
            int n4 = list2.indexOf(statement);
            ListIterator listIterator = list2.listIterator(n4);
            list = new ArrayList<Statement>();
            do {
                e = listIterator.next();
                list.add((Statement)e);
            } while (!e.equals(statement2));
        }
        return list;
    }

    private static Statement getStatement(Resource resource, int n) {
        Element element = resource.getElementByOffset(n);
        if (element instanceof Feature || element instanceof Resource) {
            return null;
        }
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset();
        while (element != null && !(element instanceof Statement)) {
            if (!((element = (Element)element.refImmediateComposite()) instanceof Feature) && (element.getStartOffset() == n2 || element.getEndOffset() == n3)) continue;
            return null;
        }
        return (Statement)element;
    }

    private static Statement adjustFirstStatement(int n, Statement statement) {
        JavaMetamodel javaMetamodel = JavaMetamodel.getManager();
        if (javaMetamodel.getElementPosition((Element)statement).getBegin().getOffset() == n) {
            return statement;
        }
        Iterator iterator = statement.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!(element instanceof Statement) || javaMetamodel.getElementPosition(element).getBegin().getOffset() <= n) continue;
            return (Statement)element;
        }
        return null;
    }

    private static Statement adjustLastStatement(int n, Statement statement) {
        JavaMetamodel javaMetamodel = JavaMetamodel.getManager();
        if (javaMetamodel.getElementPosition((Element)statement).getEnd().getOffset() == n) {
            return statement;
        }
        List list = statement.getChildren();
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            Element element = (Element)listIterator.previous();
            if (!(element instanceof Statement) || javaMetamodel.getElementPosition(element).getEnd().getOffset() >= n) continue;
            return (Statement)element;
        }
        return null;
    }

    public static MultipartId resolveImportsForClass(Element element, JavaClass javaClass) {
        return (MultipartId)JavaModelUtil.typeToTypeReference(element, (Type)javaClass);
    }

    public static TypeReference resolveImportsForType(Element element, Type type) {
        return (TypeReference)JavaModelUtil.typeToTypeReference(element, type);
    }

    private static Element typeToTypeReference(Element element, Type type) {
        if (type == null) {
            return null;
        }
        element = JavaModelUtil.unwrapElement(element);
        JavaModelPackage javaModelPackage = (JavaModelPackage)element.refImmediatePackage();
        MultipartIdClass multipartIdClass = javaModelPackage.getMultipartId();
        if (type instanceof TypeParameter) {
            return multipartIdClass.createMultipartId(type.getName(), null, null);
        }
        if (type instanceof ParameterizedType) {
            String string;
            ParameterizedTypeImpl parameterizedTypeImpl = (ParameterizedTypeImpl)type;
            Type[] typeArray = parameterizedTypeImpl.getParameters().toArray(new Type[0]);
            TypeArgument[] typeArgumentArray = new TypeArgument[typeArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                typeArgumentArray[i] = (TypeArgument)JavaModelUtil.typeToTypeReference(element, typeArray[i]);
                int n = parameterizedTypeImpl.getWildCardStatus(i);
                if (n == 0) continue;
                typeArgumentArray[i] = javaModelPackage.getWildCard().createWildCard(n == 1, n == 3 ? null : (MultipartId)typeArgumentArray[i]);
            }
            MultipartId multipartId = (MultipartId)JavaModelUtil.typeToTypeReference(element, (Type)parameterizedTypeImpl.getDeclaringClass());
            JavaClass javaClass = parameterizedTypeImpl.getDefinition();
            if (multipartId == null) {
                MultipartId multipartId2 = JavaModelUtil.createImportsForClass(element, javaClass);
                if (typeArray.length == 0) {
                    return multipartId2;
                }
                string = multipartId2.getName();
            } else {
                string = javaClass.getSimpleName();
            }
            return multipartIdClass.createMultipartId(string, multipartId, Arrays.asList(typeArgumentArray));
        }
        if (type instanceof Array) {
            int n = 0;
            Type type2 = type;
            while (type2 instanceof Array) {
                ++n;
                type2 = ((Array)type2).getType();
            }
            return javaModelPackage.getArrayReference().createArrayReference(null, (MultipartId)JavaModelUtil.typeToTypeReference(element, type2), n);
        }
        if (type instanceof JavaClass) {
            if (type instanceof JavaClassImpl && ((JavaClassImpl)type).isTransient()) {
                return multipartIdClass.createMultipartId(type.getName(), null, null);
            }
            return JavaModelUtil.createImportsForClass(element, (JavaClass)type);
        }
        if (type instanceof PrimitiveType) {
            return multipartIdClass.createMultipartId(type.getName(), null, null);
        }
        throw new IllegalArgumentException("Unable to convert to typeref: " + type.getClass().getName());
    }

    private static MultipartId createImportsForClass(Element element, JavaClass javaClass) {
        String string;
        JavaModelPackage javaModelPackage = (JavaModelPackage)element.refImmediatePackage();
        MultipartIdClass multipartIdClass = javaModelPackage.getMultipartId();
        if (javaClass instanceof UnresolvedClass) {
            return multipartIdClass.createMultipartId(javaClass.getName(), null, null);
        }
        Scope scope = Scope.computeTypeScope(element);
        Object object = scope.lookup(string = javaClass.getSimpleName());
        if (object != null) {
            if (javaClass.getName().equals(object)) {
                return multipartIdClass.createMultipartId(string, null, null);
            }
            return multipartIdClass.createMultipartId(javaClass.getName(), null, null);
        }
        Import import_ = javaModelPackage.getImport().createImport(javaClass.getName(), null, false, false);
        element.getResource().addImport(import_);
        return multipartIdClass.createMultipartId(string, null, null);
    }

    public static Feature getDeclaringFeature(Element element) {
        while (!(element instanceof Feature) && element != null) {
            element = (Element)element.refImmediateComposite();
        }
        return (Feature)element;
    }

    public static Element duplicateInScope(Element element, Element element2) {
        element = JavaModelUtil.unwrapElement(element);
        JavaModelPackage javaModelPackage = (JavaModelPackage)element.refImmediatePackage();
        MetadataElement metadataElement = (MetadataElement)JavaModelUtil.unwrapElement(element2).duplicate(javaModelPackage);
        metadataElement.fixImports(element, element2);
        return metadataElement;
    }

    private static MetadataElement unwrapElement(Element element) {
        if (element instanceof MetadataElement) {
            return (MetadataElement)element;
        }
        if (element instanceof ParameterizedType) {
            return (MetadataElement)((ParameterizedType)element).getDefinition();
        }
        if (element instanceof ParameterizedTypeImpl.Wrapper) {
            return (MetadataElement)((Object)((ParameterizedTypeImpl.Wrapper)element).getWrappedObject());
        }
        throw new IllegalArgumentException("Unknown type " + element.getClass());
    }

    public static Collection getOverriddenMethods(Method method) {
        MethodImpl methodImpl = (MethodImpl)JavaModelUtil.unwrapElement((Element)method);
        return methodImpl.getOverriddenMethods();
    }

    public static TypeReference createTypeReferenceFromType(Type type) {
        JavaModelPackage javaModelPackage = JavaModel.getDefaultExtent();
        TypeRef typeRef = SemiPersistentElement.typeToTypeRef(type);
        return (TypeReference)SemiPersistentElement.typeRefToTypeReference(javaModelPackage, typeRef, 0);
    }
}

