/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.internalapi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.ExclusiveMutex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.RepositoryUpdater;
import org.netbeans.modules.javacore.Util;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.InvalidationListener;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;

public class UndoManager
extends FileChangeAdapter
implements DocumentListener,
ChangeListener,
GlobalPathRegistryListener {
    private LinkedList undoList;
    private LinkedList redoList;
    private final HashSet allCES = new HashSet();
    private final HashMap documentToCES = new HashMap();
    private final HashMap listenerToCES = new HashMap();
    private boolean listenersRegistered = false;
    public static final String PROP_STATE = "state";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean wasUndo = false;
    private boolean wasRedo = false;
    private boolean transactionStart;
    private boolean dontDeleteUndo = false;
    private IdentityHashMap descriptionMap;
    private String description;
    private HashSet modifiedResources;
    private JMManager manager;
    private ProgressListener progress;
    private int stepCounter = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UndoManager() {
        this.undoList = new LinkedList();
        this.redoList = new LinkedList();
        this.descriptionMap = new IdentityHashMap();
        this.modifiedResources = new HashSet();
        this.manager = (JMManager)JMManager.getManager();
    }

    public UndoManager(ProgressListener progressListener) {
        this();
        this.progress = progressListener;
    }

    public void setUndoDescription(String string) {
        this.description = string;
    }

    public String getUndoDescription() {
        if (this.undoList.isEmpty()) {
            return null;
        }
        return (String)this.descriptionMap.get(this.undoList.getFirst());
    }

    public String getRedoDescription() {
        if (this.redoList.isEmpty()) {
            return null;
        }
        return (String)this.descriptionMap.get(this.redoList.getFirst());
    }

    public void transactionStarted() {
        this.modifiedResources.clear();
        this.transactionStart = true;
        this.unregisterListeners();
        RepositoryUpdater.getDefault().setListenOnChanges(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionEnded(boolean bl) {
        try {
            this.description = null;
            this.parseModified();
            this.dontDeleteUndo = true;
            if (bl && !this.undoList.isEmpty()) {
                this.undoList.removeFirst();
            } else if (this.isUndoAvailable() && this.getUndoDescription() == null) {
                this.descriptionMap.remove(this.undoList.removeFirst());
                this.dontDeleteUndo = false;
            }
            this.invalidate(null);
            this.dontDeleteUndo = false;
        }
        finally {
            RepositoryUpdater.getDefault().setListenOnChanges(true);
            this.registerListeners();
        }
        this.fireStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void undo() {
        if (!this.isUndoAvailable()) return;
        JavaMetamodel.getDefaultRepository().beginTrans(true);
        boolean bl = true;
        try {
            try {
                JMManager.getTransactionMutex().disableModifications();
                this.transactionStarted();
                this.wasUndo = true;
                LinkedList linkedList = (LinkedList)this.undoList.getFirst();
                this.fireProgressListenerStart(0, linkedList.size());
                this.undoList.removeFirst();
                Iterator iterator = linkedList.iterator();
                this.redoList.addFirst(new LinkedList());
                this.descriptionMap.put(this.redoList.getFirst(), this.descriptionMap.remove(linkedList));
                while (iterator.hasNext()) {
                    this.fireProgressListenerStep();
                    UndoItem undoItem = (UndoItem)iterator.next();
                    undoItem.undo();
                    if (undoItem instanceof ExternalUndoItem) {
                        this.addItem(undoItem);
                        continue;
                    }
                    this.modifiedResources.add(this.manager.getFileObject(((ResourceUndoItem)undoItem).getResource()));
                }
                bl = false;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                Object var6_7 = null;
                this.wasUndo = false;
                JavaMetamodel.getDefaultRepository().endTrans(bl);
                this.transactionEnded(bl);
                this.fireProgressListenerStop();
                this.fireStateChange();
                return;
            }
            Object var6_6 = null;
            this.wasUndo = false;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.wasUndo = false;
            JavaMetamodel.getDefaultRepository().endTrans(bl);
            this.transactionEnded(bl);
            this.fireProgressListenerStop();
            this.fireStateChange();
            throw throwable;
        }
        JavaMetamodel.getDefaultRepository().endTrans(bl);
        this.transactionEnded(bl);
        this.fireProgressListenerStop();
        this.fireStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void redo() {
        if (!this.isRedoAvailable()) return;
        JavaMetamodel.getDefaultRepository().beginTrans(true);
        boolean bl = true;
        try {
            try {
                JMManager.getTransactionMutex().disableModifications();
                this.transactionStarted();
                this.wasRedo = true;
                LinkedList linkedList = (LinkedList)this.redoList.getFirst();
                this.fireProgressListenerStart(1, linkedList.size());
                this.redoList.removeFirst();
                Iterator iterator = linkedList.iterator();
                this.description = (String)this.descriptionMap.remove(linkedList);
                while (iterator.hasNext()) {
                    this.fireProgressListenerStep();
                    UndoItem undoItem = (UndoItem)iterator.next();
                    undoItem.redo();
                    if (undoItem instanceof ExternalUndoItem) {
                        this.addItem(undoItem);
                        continue;
                    }
                    this.modifiedResources.add(this.manager.getFileObject(((ResourceUndoItem)undoItem).getResource()));
                }
                bl = false;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                Object var6_7 = null;
                this.wasRedo = false;
                JavaMetamodel.getDefaultRepository().endTrans(bl);
                this.transactionEnded(bl);
                this.fireProgressListenerStop();
                this.fireStateChange();
                return;
            }
            Object var6_6 = null;
            this.wasRedo = false;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.wasRedo = false;
            JavaMetamodel.getDefaultRepository().endTrans(bl);
            this.transactionEnded(bl);
            this.fireProgressListenerStop();
            this.fireStateChange();
            throw throwable;
        }
        JavaMetamodel.getDefaultRepository().endTrans(bl);
        this.transactionEnded(bl);
        this.fireProgressListenerStop();
        this.fireStateChange();
    }

    public void clear() {
        this.undoList.clear();
        this.redoList.clear();
        this.descriptionMap.clear();
        this.fireStateChange();
    }

    public void addItem(Resource resource, ResourceImpl.DiffList diffList) {
        this.addItem(new ResourceUndoItem(resource, diffList));
    }

    public void addItem(ExternalChange externalChange) {
        this.addItem(new ExternalUndoItem(externalChange));
    }

    public void addItem(UndoItem undoItem) {
        if (this.wasUndo) {
            LinkedList linkedList = (LinkedList)this.redoList.getFirst();
            linkedList.addFirst(undoItem);
        } else {
            if (this.transactionStart) {
                this.undoList.addFirst(new LinkedList());
                this.descriptionMap.put(this.undoList.getFirst(), this.description);
                this.transactionStart = false;
            }
            LinkedList linkedList = (LinkedList)this.undoList.getFirst();
            linkedList.addFirst(undoItem);
        }
        if (!this.wasUndo && !this.wasRedo) {
            this.redoList.clear();
        }
    }

    public boolean isUndoAvailable() {
        return !this.undoList.isEmpty();
    }

    public boolean isRedoAvailable() {
        return !this.redoList.isEmpty();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireStateChange() {
        this.pcs.firePropertyChange(PROP_STATE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(Collection collection, InvalidationListener invalidationListener) {
        Object object = this.allCES;
        synchronized (object) {
            this.registerListeners();
        }
        object = collection.iterator();
        while (object.hasNext()) {
            final CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)object.next();
            final StyledDocument styledDocument = cloneableEditorSupport.getDocument();
            if (styledDocument != null) {
                NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        HashSet hashSet = UndoManager.this.allCES;
                        synchronized (hashSet) {
                            if (UndoManager.this.allCES.add(cloneableEditorSupport)) {
                                cloneableEditorSupport.addChangeListener((ChangeListener)UndoManager.this);
                                styledDocument.addDocumentListener(UndoManager.this);
                                UndoManager.this.documentToCES.put(styledDocument, cloneableEditorSupport);
                            }
                        }
                    }
                });
                continue;
            }
            HashSet hashSet = this.allCES;
            synchronized (hashSet) {
                if (this.allCES.add(cloneableEditorSupport)) {
                    cloneableEditorSupport.addChangeListener((ChangeListener)this);
                }
            }
        }
        object = this.allCES;
        synchronized (object) {
            if (invalidationListener != null) {
                this.listenerToCES.put(invalidationListener, collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatching(InvalidationListener invalidationListener) {
        HashSet hashSet = this.allCES;
        synchronized (hashSet) {
            this.listenerToCES.remove(invalidationListener);
            this.clearIfPossible();
        }
    }

    public void pathsAdded(GlobalPathRegistryEvent globalPathRegistryEvent) {
    }

    public void pathsRemoved(GlobalPathRegistryEvent globalPathRegistryEvent) {
        if (!$assertionsDisabled && globalPathRegistryEvent == null) {
            throw new AssertionError((Object)"event == null");
        }
        if (globalPathRegistryEvent.getId().equals("classpath/source")) {
            this.clear();
        }
    }

    private void registerListeners() {
        if (this.listenersRegistered) {
            return;
        }
        GlobalPathRegistry.getDefault().addGlobalPathRegistryListener((GlobalPathRegistryListener)this);
        Util.addFileSystemsListener((FileChangeListener)this);
        Iterator<Object> iterator = this.allCES.iterator();
        while (iterator.hasNext()) {
            ((CloneableEditorSupport)iterator.next()).addChangeListener((ChangeListener)this);
        }
        iterator = this.documentToCES.keySet().iterator();
        while (iterator.hasNext()) {
            ((Document)iterator.next()).addDocumentListener(this);
        }
        this.listenersRegistered = true;
    }

    private void unregisterListeners() {
        if (!this.listenersRegistered) {
            return;
        }
        Util.removeFileSystemsListener((FileChangeListener)this);
        GlobalPathRegistry.getDefault().removeGlobalPathRegistryListener((GlobalPathRegistryListener)this);
        Iterator<Object> iterator = this.allCES.iterator();
        while (iterator.hasNext()) {
            ((CloneableEditorSupport)iterator.next()).removeChangeListener((ChangeListener)this);
        }
        iterator = this.documentToCES.keySet().iterator();
        while (iterator.hasNext()) {
            ((Document)iterator.next()).removeDocumentListener(this);
        }
        this.listenersRegistered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(CloneableEditorSupport cloneableEditorSupport) {
        LinkedList linkedList = this.undoList;
        synchronized (linkedList) {
            if (!(this.wasRedo || this.wasUndo || this.dontDeleteUndo)) {
                this.clear();
            }
            HashSet hashSet = this.allCES;
            synchronized (hashSet) {
                if (cloneableEditorSupport == null) {
                    Iterator iterator = this.listenerToCES.keySet().iterator();
                    while (iterator.hasNext()) {
                        ((InvalidationListener)iterator.next()).invalidateObject();
                    }
                    this.listenerToCES.clear();
                } else {
                    Iterator iterator = this.listenerToCES.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (!((HashSet)entry.getValue()).contains(cloneableEditorSupport)) continue;
                        ((InvalidationListener)entry.getKey()).invalidateObject();
                        iterator.remove();
                    }
                }
                this.clearIfPossible();
            }
        }
    }

    private void clearIfPossible() {
        if (this.listenerToCES.isEmpty() && this.undoList.isEmpty() && this.redoList.isEmpty()) {
            this.unregisterListeners();
            this.allCES.clear();
            this.documentToCES.clear();
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        if (!Util.isJavaFile(fileObject)) {
            return;
        }
        if (fileObject != null) {
            CloneableEditorSupport cloneableEditorSupport;
            DataObject dataObject;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return;
            }
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie != null && (cloneableEditorSupport = (CloneableEditorSupport)this.documentToCES.get(editorCookie.getDocument())) != null) {
                this.invalidate(cloneableEditorSupport);
            }
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        if (Util.isJavaFile(fileEvent.getFile(), true)) {
            this.invalidate(null);
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        if (Util.isJavaFile(fileRenameEvent.getFile(), true)) {
            this.invalidate(null);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.invalidate((CloneableEditorSupport)this.documentToCES.get(documentEvent.getDocument()));
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.invalidate((CloneableEditorSupport)this.documentToCES.get(documentEvent.getDocument()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent changeEvent) {
        HashSet hashSet = this.allCES;
        synchronized (hashSet) {
            CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)changeEvent.getSource();
            StyledDocument styledDocument = cloneableEditorSupport.getDocument();
            Iterator iterator = this.documentToCES.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getValue() != cloneableEditorSupport) continue;
                ((Document)entry.getKey()).removeDocumentListener(this);
                iterator.remove();
                break;
            }
            if (styledDocument != null) {
                this.documentToCES.put(styledDocument, cloneableEditorSupport);
                styledDocument.addDocumentListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        HashSet hashSet = this.allCES;
        synchronized (hashSet) {
            this.unregisterListeners();
        }
        try {
            LifecycleManager.getDefault().saveAll();
        }
        finally {
            hashSet = this.allCES;
            synchronized (hashSet) {
                this.registerListeners();
            }
        }
    }

    private void parseModified() {
        FileObject fileObject;
        UndoManager undoManager = this;
        ExclusiveMutex exclusiveMutex = undoManager.manager.getTransactionMutex();
        Iterator iterator = this.modifiedResources.iterator();
        while (iterator.hasNext()) {
            fileObject = (FileObject)iterator.next();
            if (!fileObject.isValid()) continue;
            exclusiveMutex.addModified(fileObject);
            UndoManager undoManager2 = this;
            undoManager2.manager.getDefaultRepository().beginTrans(true);
            UndoManager undoManager3 = this;
            undoManager3.manager.getDefaultRepository().endTrans();
        }
        iterator = this.modifiedResources.iterator();
        while (iterator.hasNext()) {
            fileObject = (FileObject)iterator.next();
            if (!fileObject.isValid()) continue;
            exclusiveMutex.addModified(fileObject);
            UndoManager undoManager4 = this;
            undoManager4.manager.getDefaultRepository().beginTrans(true);
            UndoManager undoManager5 = this;
            undoManager5.manager.getDefaultRepository().endTrans();
        }
        this.modifiedResources.clear();
    }

    private void fireProgressListenerStart(int n, int n2) {
        this.stepCounter = 0;
        if (this.progress == null) {
            return;
        }
        this.progress.start(new ProgressEvent(this, 1, n, n2));
    }

    private void fireProgressListenerStep() {
        if (this.progress == null) {
            return;
        }
        this.progress.step(new ProgressEvent(this, 2, 0, ++this.stepCounter));
    }

    private void fireProgressListenerStop() {
        if (this.progress == null) {
            return;
        }
        this.progress.stop(new ProgressEvent(this, 4));
    }

    static {
        $assertionsDisabled = !UndoManager.class.desiredAssertionStatus();
    }

    private final class ExternalUndoItem
    implements UndoItem {
        private ExternalChange change;

        public ExternalUndoItem(ExternalChange externalChange) {
            this.change = externalChange;
        }

        public void undo() {
            this.change.undoExternalChange();
        }

        public void redo() {
            this.change.performExternalChange();
        }
    }

    private final class ResourceUndoItem
    implements UndoItem {
        private JavaModelPackage model;
        private String resourceName = null;
        private ResourceImpl.DiffList diffList;

        public ResourceUndoItem(Resource resource, ResourceImpl.DiffList diffList) {
            this.model = (JavaModelPackage)resource.refImmediatePackage();
            this.resourceName = resource.getName();
            this.diffList = diffList;
        }

        public ResourceImpl.DiffList getDiffList() {
            return this.diffList;
        }

        public void setDiffList(ResourceImpl.DiffList diffList) {
            this.diffList = diffList;
        }

        public Resource getResource() {
            return this.model.getResource().resolveResource(this.resourceName, false);
        }

        public void setResource(Resource resource) {
            this.model = (JavaModelPackage)resource.refImmediatePackage();
            this.resourceName = resource.getName();
        }

        public void undo() {
            this.applyDiff();
        }

        private void applyDiff() {
            ((ResourceImpl)this.getResource()).applyDiff(this.diffList);
        }

        public void redo() {
            this.applyDiff();
        }
    }

    private static interface UndoItem {
        public void undo();

        public void redo();
    }
}

