/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefClass;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.ElementPartKindEnum;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.MultipartIdClass;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.jmiimpl.javamodel.DiffElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MultipartIdImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TransientElement;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.MDRParser;
import org.openide.util.Utilities;

public abstract class ImportImpl
extends SemiPersistentElement
implements Import {
    private static final ElementInfo DEFAULT_INFO = new ElementInfo(null, 54, null);
    private String name = null;
    private boolean isStatic = false;
    private boolean isOnDemand = false;
    private MultipartId identifier = null;

    public ImportImpl(StorableObject storableObject) {
        super(storableObject);
    }

    protected void matchPersistent(ElementInfo elementInfo) {
    }

    protected ElementInfo getDefaultInfo() {
        return DEFAULT_INFO;
    }

    protected void matchElementInfo(ElementInfo elementInfo) {
        super.matchElementInfo(elementInfo);
        ElementInfo elementInfo2 = this.getElementInfo();
        if (!Utilities.compareObjects((Object)elementInfo2.name, (Object)elementInfo.name)) {
            this.setName(elementInfo.name);
        }
        this.resetChildren();
    }

    protected void resetChildren() {
        super.resetChildren();
        if (this.identifier != null) {
            MultipartId multipartId = this.identifier;
            this.identifier = null;
            multipartId.refDelete();
            this.childrenInited = false;
        }
    }

    public String getName() {
        if (this.isChanged(2)) {
            return this.name;
        }
        return this.getElementInfo().name;
    }

    public void setName(String string) {
        this.objectChanged(2);
        this.name = string;
        MultipartId multipartId = this.createIdentifier();
        this.changeChild((Element)this.getIdentifier(), (Element)multipartId);
        this.identifier = multipartId;
    }

    private MultipartId createIdentifier() {
        if (this.name == null) {
            return null;
        }
        MultipartIdClass multipartIdClass = ((JavaModelPackage)this.refImmediatePackage()).getMultipartId();
        return multipartIdClass.createMultipartId(this.name, null, null);
    }

    void setData(String string, boolean bl, boolean bl2, MultipartId multipartId) {
        this.name = string;
        if (multipartId == null) {
            this.identifier = this.createIdentifier();
        } else {
            this.identifier = multipartId;
            if (string == null) {
                string = multipartId.getName();
            }
        }
        this.changeChild(null, (Element)this.identifier);
        this.isOnDemand = bl;
        this.isStatic = bl2;
        this.childrenInited = true;
    }

    public boolean isStatic() {
        if (this.isChanged(4)) {
            return this.isStatic;
        }
        ASTree aSTree = this.getASTree();
        if (aSTree == null) {
            return false;
        }
        return aSTree.getSubTrees()[0] != null;
    }

    public void setStatic(boolean bl) {
        this.objectChanged(4);
        this.isStatic = bl;
    }

    public boolean isOnDemand() {
        if (this.isChanged(8)) {
            return this.isOnDemand;
        }
        return this.getElementInfo().infoType == 68;
    }

    public void setOnDemand(boolean bl) {
        this.objectChanged(8);
        this.isOnDemand = bl;
    }

    protected ASTree getPartTree(ElementPartKind elementPartKind) {
        if (ElementPartKindEnum.NAME.equals((Object)elementPartKind)) {
            return this.getASTree().getSubTrees()[1];
        }
        throw new IllegalArgumentException("Invalid part for this element: " + elementPartKind);
    }

    String getRawText() {
        MetadataElement metadataElement;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("import ");
        if (this.isStatic()) {
            stringBuffer.append("static ");
        }
        stringBuffer.append((metadataElement = (MetadataElement)this.getIdentifier()) == null ? this.getName() : metadataElement.getSourceText());
        if (this.isOnDemand()) {
            stringBuffer.append(".*");
        }
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public void getDiff(List list) {
        int n;
        int n2;
        MDRParser mDRParser = this.getParser();
        ASTree aSTree = this.getASTree();
        ASTree[] aSTreeArray = aSTree.getSubTrees();
        if (this.isChanged(4)) {
            n2 = mDRParser.getToken(aSTreeArray[1].getFirstToken()).getStartOffset();
            if (this.isStatic) {
                if (aSTreeArray[0] == null) {
                    n = n2;
                    list.add(new DiffElement(n, n2, "static "));
                }
            } else if (aSTreeArray[0] != null) {
                n = mDRParser.getToken(aSTreeArray[0].getFirstToken()).getStartOffset();
                list.add(new DiffElement(n, n2, ""));
            }
        }
        this.getChildDiff(list, mDRParser, aSTreeArray[1], (MetadataElement)this.getIdentifier(), 2);
        if (this.isChanged(8)) {
            n = mDRParser.getToken(aSTreeArray[1].getLastToken()).getEndOffset();
            n2 = mDRParser.getToken(aSTree.getLastToken()).getStartOffset();
            list.add(new DiffElement(n, n2, this.isOnDemand() ? ".*" : ""));
        }
    }

    public void replaceChild(Element element, Element element2) {
        if (this.childrenInited && element.equals(this.identifier)) {
            this.setIdentifier((MultipartId)element2);
            return;
        }
    }

    public MultipartId getIdentifier() {
        this.checkUpToDate();
        if (!this.childrenInited) {
            this.initChildren();
        }
        return this.identifier;
    }

    public void setIdentifier(MultipartId multipartId) {
        this.objectChanged(2);
        this.changeChild((Element)this.getIdentifier(), (Element)multipartId);
        this.identifier = multipartId;
        this.name = multipartId != null ? ((MultipartIdImpl)multipartId).getSourceText() : "";
    }

    protected void initChildren() {
        this.childrenInited = false;
        ElementInfo elementInfo = this.getElementInfo();
        ASTree aSTree = elementInfo.getTypeAST(this);
        if (this.identifier != null) {
            ((TransientElement)this.identifier).init(aSTree);
        } else {
            this.identifier = (MultipartId)this.createElement(aSTree, (RefClass)((JavaModelPackage)this.refImmediatePackage()).getMultipartId());
        }
        this.childrenInited = true;
    }

    public List getChildren() {
        ArrayList arrayList = new ArrayList(1);
        ImportImpl.addIfNotNull(arrayList, this.getIdentifier());
        return arrayList;
    }

    public NamedElement getImportedNamespace() {
        JavaModelPackage javaModelPackage = (JavaModelPackage)this.refImmediatePackage();
        MultipartId multipartId = this.getIdentifier();
        if (multipartId == null) {
            return null;
        }
        return multipartId.getElement();
    }

    public Collection getReferences() {
        return Collections.EMPTY_LIST;
    }

    private String getSignature(Feature feature) {
        if (feature instanceof Method) {
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = ((Method)feature).getParameters().toArray();
            stringBuffer.append(feature.getName());
            for (int i = 0; i < objectArray.length; ++i) {
                Parameter parameter = (Parameter)objectArray[i];
                stringBuffer.append(parameter.getType().getName());
                stringBuffer.append(';');
            }
            stringBuffer.append('.');
            return stringBuffer.toString();
        }
        return feature.getName();
    }

    private void getAllStaticWithName(JavaClass javaClass, String string, Map map, Set set) {
        Object[] objectArray;
        if (!set.add(javaClass)) {
            return;
        }
        JavaClass javaClass2 = javaClass.getSuperClass();
        Iterator iterator = javaClass.getInterfaces().iterator();
        if (javaClass2 != null) {
            this.getAllStaticWithName(javaClass2, string, map, set);
        }
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            if (objectArray == null) continue;
            this.getAllStaticWithName((JavaClass)objectArray, string, map, set);
        }
        objectArray = javaClass.getFeatures().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Feature feature = (Feature)objectArray[i];
            if (!Modifier.isStatic(feature.getModifiers()) || string != null && !string.equals(feature.getName()) || !(feature instanceof Field) && !(feature instanceof Method)) continue;
            map.put(this.getSignature(feature), feature);
        }
    }

    public Collection getImportedElements() {
        if (this.isStatic()) {
            HashMap hashMap = new HashMap();
            if (this.isOnDemand()) {
                this.getAllStaticWithName((JavaClass)this.getImportedNamespace(), null, hashMap, new HashSet());
            } else {
                ASTree aSTree;
                ASTree[] aSTreeArray;
                MDRParser mDRParser = this.getParser();
                Object object = mDRParser.getSemanticInfo((aSTreeArray = (aSTree = this.getPartTree((ElementPartKind)ElementPartKindEnum.NAME)).getSubTrees())[0], this);
                if (object instanceof JavaClass) {
                    String string = (String)((Token)aSTreeArray[1]).getValue();
                    this.getAllStaticWithName((JavaClass)object, string, hashMap, new HashSet());
                }
            }
            return hashMap.values();
        }
        if (this.isOnDemand()) {
            NamedElement namedElement = this.getImportedNamespace();
            ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
            if (namedElement instanceof JavaPackage) {
                Iterator iterator = ((JavaPackage)namedElement).getResources().iterator();
                while (iterator.hasNext()) {
                    Iterator iterator2 = ((Resource)iterator.next()).getClassifiers().iterator();
                    while (iterator2.hasNext()) {
                        JavaClass javaClass = (JavaClass)iterator2.next();
                        if (!Modifier.isPublic(javaClass.getModifiers())) continue;
                        arrayList.add(javaClass);
                    }
                }
            } else if (namedElement instanceof JavaClass && !(namedElement instanceof UnresolvedClass)) {
                JavaClass javaClass = (JavaClass)namedElement;
                ClassIndex classIndex = ClassIndex.getIndex((JavaModelPackage)javaClass.refImmediatePackage());
                Iterator iterator = classIndex.getClassesByFQNPrefix(javaClass.getName().concat(".")).iterator();
                while (iterator.hasNext()) {
                    JavaClass javaClass2 = (JavaClass)iterator.next();
                    if (!javaClass2.getDeclaringClass().equals(javaClass)) continue;
                    arrayList.add(javaClass2);
                }
            }
            return arrayList;
        }
        return Collections.singletonList(this.getImportedNamespace());
    }

    protected void hardRefParent(boolean bl) {
    }

    protected void parentChanged() {
    }

    public Element duplicate(JavaModelPackage javaModelPackage) {
        return javaModelPackage.getImport().createImport(this.getName(), (MultipartId)ImportImpl.duplicateElement((Element)this.getIdentifier(), javaModelPackage), this.isStatic(), this.isOnDemand());
    }

    protected void _delete() {
        if (this.childrenInited) {
            this.deleteChild((Element)this.identifier);
        }
        super._delete();
    }
}

