/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ChangeNotificationListener;

public class NotifierList
implements List {
    private List innerList;
    private ChangeNotificationListener notificationListener;

    public NotifierList(List list, ChangeNotificationListener changeNotificationListener) {
        this.setInnerList(list);
        this.setNotificationListener(changeNotificationListener);
    }

    public NotifierList(List list) {
        this.setInnerList(list);
        this.setNotificationListener(null);
    }

    public void setInnerList(List list) {
        this.innerList = list;
    }

    public void setNotificationListener(ChangeNotificationListener changeNotificationListener) {
        this.notificationListener = changeNotificationListener;
    }

    private void notifyChange(boolean bl, Object object) {
        if (this.notificationListener != null) {
            this.notificationListener.notifyChange(bl, object);
        }
    }

    private void notifyChange(boolean bl, Collection collection) {
        if (this.notificationListener != null) {
            this.notificationListener.notifyChange(bl, collection);
        }
    }

    public boolean remove(Object object) {
        boolean bl = this.innerList.remove(object);
        if (bl) {
            this.notifyChange(false, object);
        }
        return bl;
    }

    public Object set(int n, Object object) {
        Object object2 = this.innerList.set(n, object);
        this.notifyChange(true, object);
        if (object2 != null) {
            this.notifyChange(false, object2);
        }
        return object2;
    }

    public Object remove(int n) {
        Object e = this.innerList.remove(n);
        if (e != null) {
            this.notifyChange(false, e);
        }
        return e;
    }

    public void add(int n, Object object) {
        this.innerList.add(n, object);
        this.notifyChange(true, object);
    }

    public boolean add(Object object) {
        boolean bl = this.innerList.add(object);
        this.notifyChange(true, object);
        return bl;
    }

    public ListIterator listIterator(int n) {
        return new NotifierListIterator(this.innerList.listIterator(n));
    }

    public Iterator iterator() {
        return new NotifierListIterator(this.innerList.listIterator());
    }

    public ListIterator listIterator() {
        return new NotifierListIterator(this.innerList.listIterator());
    }

    public List subList(int n, int n2) {
        return new NotifierList(this.innerList.subList(n, n2), this.notificationListener);
    }

    public boolean contains(Object object) {
        return this.innerList.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.innerList.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        boolean bl = this.innerList.addAll(collection);
        if (bl) {
            this.notifyChange(true, collection);
        }
        return bl;
    }

    public void clear() {
        this.notifyChange(false, null);
        this.innerList.clear();
    }

    public boolean isEmpty() {
        return this.innerList.isEmpty();
    }

    public boolean removeAll(Collection collection) {
        this.notifyChange(false, null);
        return this.innerList.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        this.notifyChange(false, null);
        return this.innerList.retainAll(collection);
    }

    public int size() {
        return this.innerList.size();
    }

    public Object[] toArray() {
        return this.innerList.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.innerList.toArray(objectArray);
    }

    public boolean addAll(int n, Collection collection) {
        boolean bl = this.innerList.addAll(n, collection);
        if (bl) {
            this.notifyChange(true, collection);
        }
        return bl;
    }

    public Object get(int n) {
        return this.innerList.get(n);
    }

    public int indexOf(Object object) {
        return this.innerList.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.innerList.lastIndexOf(object);
    }

    class NotifierListIterator
    implements ListIterator {
        private Object lastRead;
        private ListIterator innerIterator;

        NotifierListIterator(ListIterator listIterator) {
            this.innerIterator = listIterator;
        }

        public void remove() {
            this.innerIterator.remove();
            if (this.lastRead != null) {
                NotifierList.this.notifyChange(false, this.lastRead);
            }
        }

        public void add(Object object) {
            this.innerIterator.add(object);
            NotifierList.this.notifyChange(true, object);
        }

        public void set(Object object) {
            this.innerIterator.set(object);
            NotifierList.this.notifyChange(true, object);
            if (this.lastRead != null) {
                NotifierList.this.notifyChange(false, this.lastRead);
            }
        }

        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        public boolean hasPrevious() {
            return this.innerIterator.hasPrevious();
        }

        public Object next() {
            this.lastRead = this.innerIterator.next();
            return this.lastRead;
        }

        public int nextIndex() {
            return this.innerIterator.nextIndex();
        }

        public Object previous() {
            this.lastRead = this.innerIterator.previous();
            return this.lastRead;
        }

        public int previousIndex() {
            return this.innerIterator.previousIndex();
        }
    }
}

