/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ProgressSupport;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ElementNavigator;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TypeClassImpl;
import org.openide.util.Cancellable;

public class UsageFinder {
    private NamedElement what;
    private ElementNavigator navigator;
    private Collection usages;
    private static final int MAX_COUNT = 30;
    private Set declaringClasses;
    private boolean overriders = false;
    private boolean findUsages = true;

    public UsageFinder(NamedElement namedElement) {
        this.what = namedElement instanceof ParameterizedType ? UsageFinder.convert((Type)this.getRealClassDefinition((ClassDefinition)((ParameterizedType)namedElement))) : UsageFinder.convert(namedElement);
    }

    private static List getParameters(CallableFeature callableFeature) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Iterator iterator = callableFeature.getParameters().iterator();
        while (iterator.hasNext()) {
            arrayList.add(UsageFinder.convert(TypeClassImpl.getRawType(((Parameter)iterator.next()).getType())));
        }
        return arrayList;
    }

    private static NamedElement convert(NamedElement namedElement) {
        ClassDefinition classDefinition;
        if (namedElement instanceof TypeParameter) {
            return namedElement;
        }
        if (namedElement instanceof JavaClass) {
            return UsageFinder.convert((Type)((JavaClass)namedElement));
        }
        Field field = null;
        if (namedElement instanceof ClassMember && (classDefinition = ((ClassMember)namedElement).getDeclaringClass()) instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)UsageFinder.convert((Type)classDefinition);
            if (javaClass.equals(classDefinition)) {
                return namedElement;
            }
            if (namedElement instanceof Field) {
                field = javaClass.getField(namedElement.getName(), false);
            } else if (namedElement instanceof Method) {
                field = javaClass.getMethod(namedElement.getName(), UsageFinder.getParameters((CallableFeature)namedElement), false);
            } else if (namedElement instanceof Constructor) {
                field = javaClass.getConstructor(UsageFinder.getParameters((CallableFeature)namedElement), false);
            }
        }
        return field == null ? namedElement : field;
    }

    private static Type convert(Type type) {
        if (type instanceof JavaClassImpl && ((JavaClassImpl)type).isTransient()) {
            return type;
        }
        return JavaMetamodel.getManager().getDefaultExtent().getType().resolve(type.getName());
    }

    public UsageFinder(CallableFeature callableFeature, boolean bl, boolean bl2, boolean bl3) {
        this((NamedElement)callableFeature);
        this.overriders = bl3;
        this.findUsages = bl;
        this.declaringClasses = new HashSet();
        ClassDefinition classDefinition = callableFeature.getDeclaringClass();
        this.declaringClasses.add(this.getRealClassDefinition(classDefinition));
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Object object = callableFeature.getParameters().iterator();
        while (object.hasNext()) {
            arrayList.add(TypeClassImpl.getRawType(((Parameter)object.next()).getType()));
        }
        if (bl2) {
            object = new LinkedList();
            ((LinkedList)object).add(classDefinition);
            HashSet<ClassDefinition> hashSet = new HashSet<ClassDefinition>();
            while (!((AbstractCollection)object).isEmpty()) {
                classDefinition = (ClassDefinition)((LinkedList)object).removeFirst();
                if (!hashSet.add(classDefinition)) continue;
                Object object2 = null;
                object2 = callableFeature instanceof Method ? classDefinition.getMethod(callableFeature.getName(), arrayList, false) : classDefinition.getConstructor(arrayList, false);
                if (object2 != null) {
                    this.declaringClasses.add(this.getRealClassDefinition(classDefinition));
                }
                ((LinkedList)object).addAll(classDefinition.getInterfaces());
                if ((classDefinition = classDefinition.getSuperClass()) == null) continue;
                ((LinkedList)object).add(classDefinition);
            }
        }
    }

    private ClassDefinition getRealClassDefinition(ClassDefinition classDefinition) {
        return (ClassDefinition)TypeClassImpl.getRawType((Type)classDefinition);
    }

    private Collection getUsers(MetadataElement metadataElement) {
        this.usages = new ArrayList();
        ArrayList<MetadataElement> arrayList = new ArrayList<MetadataElement>(1);
        arrayList.add(metadataElement);
        this.getUsers(arrayList);
        return this.usages;
    }

    public Collection getUsers(Resource[] resourceArray) {
        return new LazyCollection(resourceArray);
    }

    private void getUsers(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MetadataElement metadataElement = (MetadataElement)((Object)iterator.next());
            if (!(metadataElement instanceof Resource) && !this.navigator.containsIdentifierIn(metadataElement)) continue;
            if (this.isMatch((Element)this.what, metadataElement)) {
                this.usages.add(metadataElement);
            }
            this.getUsers(metadataElement.getChildren());
        }
    }

    private boolean isMatch(Element element, Element element2) {
        if (element.equals(element2)) {
            return false;
        }
        Element element3 = element2;
        if (this.findUsages) {
            if (element3 instanceof ElementReference) {
                element3 = ((ElementReference)element2).getElement();
            } else if (!this.overriders) {
                return false;
            }
        }
        if (!(element instanceof Method)) {
            if (element3 instanceof ParameterizedType) {
                element3 = this.getRealClassDefinition((ClassDefinition)((ParameterizedType)element3));
            }
            return element.equals(element3);
        }
        if (!(element3 instanceof Method)) {
            return false;
        }
        if (!this.overriders && element.equals(element3)) {
            return true;
        }
        Method method = (Method)element3;
        if (method.signatureEquals((Method)element)) {
            ClassDefinition classDefinition = this.getRealClassDefinition(method.getDeclaringClass());
            Iterator iterator = this.declaringClasses.iterator();
            while (iterator.hasNext()) {
                ClassDefinition classDefinition2 = (ClassDefinition)iterator.next();
                if (!classDefinition.isSubTypeOf(classDefinition2)) continue;
                return true;
            }
        }
        return false;
    }

    private void lock() {
        JavaMetamodel.getDefaultRepository().beginTrans(false);
    }

    private void unlock() {
        JavaMetamodel.getDefaultRepository().endTrans(false);
    }

    private class LazyIterator
    implements Iterator,
    Cancellable {
        MOFID[] res;
        Collection currentUsages = Collections.EMPTY_LIST;
        Iterator inner;
        int currentIndex;
        Object next;
        boolean hasNext;
        float step;
        int last;
        ProgressSupport progressSupport;
        private boolean cancelRequest;

        LazyIterator(MOFID[] mOFIDArray) {
            this.res = mOFIDArray;
            this.inner = this.currentUsages.iterator();
            this.currentIndex = -1;
            this.hasNext = true;
            this.step = 1.0f;
            if (mOFIDArray.length > 30) {
                this.step = 30.0f / (float)mOFIDArray.length;
            }
            this.last = 0;
            this.progressSupport = JavaMetamodel.getManager().getProgressSupport();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            UsageFinder.this.lock();
            try {
                if (this.next == null) {
                    this.findNext();
                }
                Object object = this.next;
                this.next = null;
                Object object2 = object;
                return object2;
            }
            finally {
                UsageFinder.this.unlock();
            }
        }

        private void findNext() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            while (this.next == null && this.hasNext) {
                if (!this.inner.hasNext()) {
                    if (this.cancelRequest) {
                        return;
                    }
                    ++this.currentIndex;
                    if (this.currentIndex == 0) {
                        this.progressSupport.fireProgressListenerStart(0, Math.min(this.res.length, 30));
                    }
                    if (this.currentIndex < this.res.length) {
                        MOFID mOFID = this.res[this.currentIndex];
                        if (mOFID != null) {
                            ResourceImpl resourceImpl = (ResourceImpl)((NBMDRepositoryImpl)JMManager.getDefaultRepository()).getByMofId(mOFID);
                            try {
                                if (resourceImpl != null && !resourceImpl.getName().endsWith("class")) {
                                    UsageFinder.this.navigator = new ElementNavigator(resourceImpl, UsageFinder.this.what);
                                    this.currentUsages = UsageFinder.this.getUsers(resourceImpl);
                                    this.inner = this.currentUsages.iterator();
                                    if (!this.inner.hasNext()) {
                                        this.res[this.currentIndex] = null;
                                    }
                                } else {
                                    this.res[this.currentIndex] = null;
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JMManager.getLog().notify(1, (Throwable)new Exception("Resource " + (Object)((Object)resourceImpl) == null ? null : resourceImpl.getName() + " is not parsable.", illegalArgumentException));
                            }
                        }
                        if ((float)this.currentIndex * this.step >= (float)this.last) {
                            this.progressSupport.fireProgressListenerStep();
                            ++this.last;
                        }
                    } else {
                        this.hasNext = false;
                        this.progressSupport.fireProgressListenerStop();
                    }
                }
                if (!this.inner.hasNext()) continue;
                this.next = this.inner.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            UsageFinder.this.lock();
            try {
                this.findNext();
                if (this.cancelRequest) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.hasNext;
                return bl;
            }
            finally {
                UsageFinder.this.unlock();
            }
        }

        public boolean cancel() {
            this.cancelRequest = true;
            return true;
        }
    }

    private class LazyCollection
    extends AbstractCollection {
        MOFID[] res;

        public LazyCollection(Resource[] resourceArray) {
            this.res = new MOFID[resourceArray.length];
            for (int i = 0; i < resourceArray.length; ++i) {
                this.res[i] = ((MetadataElement)resourceArray[i])._getMofId();
            }
        }

        public Iterator iterator() {
            return new LazyIterator(this.res);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            UsageFinder.this.lock();
            try {
                int n = 0;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    ++n;
                }
                int n2 = n;
                return n2;
            }
            finally {
                UsageFinder.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            UsageFinder.this.lock();
            try {
                boolean bl = !this.iterator().hasNext();
                return bl;
            }
            finally {
                UsageFinder.this.unlock();
            }
        }
    }
}

