/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefObject;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.lib.java.parser.ASTContext;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.lib.java.parser.ErrConsumer;
import org.netbeans.lib.java.parser.Factory;
import org.netbeans.lib.java.parser.JParser;
import org.netbeans.lib.java.parser.ParserTokens;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.parser.ASTRepairer;
import org.netbeans.modules.javacore.parser.Util;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

public class ASTProvider
implements ParserTokens,
ASTreeTypes,
ASTContext {
    FileObject fobj;
    private CloneableEditorSupport editor;
    private ASTree topNode;
    private Token[] tokens;
    private String sourceText;
    private Resource rsc;
    static ASTree[] NULL_TREE;
    boolean documentPositions;
    boolean hasSyntaxErrors;
    private static final Pattern docRegExp;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ASTProvider(Resource resource, FileObject fileObject) {
        this.rsc = resource;
        this.fobj = fileObject;
        if (fileObject == null) {
            throw new InvalidObjectException((RefObject)resource);
        }
    }

    protected ASTProvider(Resource resource, FileObject fileObject, String string, boolean bl) {
        this(resource, fileObject);
        this.sourceText = string;
        this.documentPositions = bl;
    }

    private void createASTree() {
        Reader reader;
        int n = -1;
        this.hasSyntaxErrors = false;
        try {
            reader = this.getReader();
        }
        catch (Exception exception) {
            JMManager.getLog().log(16, "Error opening stream for: " + this.getResource().getName() + "; " + exception.toString());
            ErrorManager.getDefault().notify((Throwable)exception);
            return;
        }
        JParser jParser = Factory.getDefault().getParser(this, reader, this.fobj.getName());
        try {
            if (JMManager.PERF_DEBUG) {
                System.err.println("Parsing file: " + this.fobj.getName());
                Thread.dumpStack();
            }
            n = jParser.parse(false);
        }
        catch (Exception exception) {
            JMManager.getLog().notify(1, (Throwable)exception);
            this.dumpSource(exception);
        }
        this.tokens = jParser.getTokens();
        if (this.tokens == null) {
            this.tokens = new Token[0];
        }
        if (n != 0) {
            this.hasSyntaxErrors = true;
            this.topNode = new ASTRepairer(this, jParser).fixTree();
        } else {
            this.topNode = jParser.getASTree();
        }
    }

    Token[] getTokens() {
        return this.tokens;
    }

    public Token getTokenByOffset(int n) {
        int n2;
        if (n >= this.sourceText.length()) {
            return null;
        }
        int n3 = 0;
        int n4 = this.tokens.length;
        while (true) {
            if (n3 >= n4) {
                return null;
            }
            n2 = (n4 - n3) / 2 + n3;
            int n5 = this.checkToken(this.tokens[n2], n);
            if (n5 < 0) {
                n4 = n2;
                continue;
            }
            if (n5 <= 0) break;
            n3 = n2 + 1;
        }
        Token token = this.tokens[n2];
        Token[] tokenArray = token.getPadding();
        if (tokenArray != null) {
            for (int i = tokenArray.length - 1; i >= 0; --i) {
                if (tokenArray[i].getEndOffset() <= n) continue;
                token = tokenArray[i];
            }
        }
        return token;
    }

    private int checkToken(Token token, int n) {
        Token[] tokenArray = token.getPadding();
        int n2 = tokenArray != null && tokenArray.length > 0 ? tokenArray[0].getStartOffset() : token.getStartOffset();
        int n3 = token.getEndOffset();
        if (n < n2) {
            return -1;
        }
        if (n >= n3) {
            return 1;
        }
        return 0;
    }

    public ASTree getASTree() {
        if (!this.fobj.isValid()) {
            return null;
        }
        if (this.topNode == null) {
            this.createASTree();
        }
        return this.topNode;
    }

    public boolean hasSyntaxError() {
        return this.hasSyntaxErrors;
    }

    FileObject getFileObject() {
        return this.fobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRealSource(boolean bl) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        StyledDocument styledDocument = null;
        DataObject dataObject = Util.getModifiedDataObject(this.fobj);
        if (dataObject != null) {
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie != null) {
                styledDocument = editorCookie.getDocument();
            }
            if (!$assertionsDisabled && styledDocument == null) {
                throw new AssertionError((Object)("Modified DO " + this.fobj.getPath() + " without document"));
            }
            if (bl) {
                this.documentPositions = true;
            }
            final String[] stringArray = new String[1];
            final StyledDocument styledDocument2 = styledDocument;
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        stringArray[0] = styledDocument2.getText(0, styledDocument2.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            };
            styledDocument.render(runnable);
            return stringArray[0];
        }
        InputStream inputStream = this.fobj.getInputStream();
        String string = Util.getFileEncoding(this.fobj);
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        try {
            String string2 = Util.readContents(inputStreamReader, this.fobj.getSize());
            return string2;
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    Reader getFileReader(boolean bl) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        return new StringReader(this.getRealSource(bl));
    }

    public Reader getReader() throws FileNotFoundException, UnsupportedEncodingException, IOException {
        if (this.sourceText == null) {
            this.sourceText = this.getRealSource(true);
        }
        return new StringReader(this.sourceText);
    }

    public Resource getResource() {
        return this.rsc;
    }

    public String getJavaDoc(ASTree aSTree) {
        String string = null;
        Token token = this.getComment(aSTree);
        if (token.getType() == 364) {
            string = this.getText(token);
        }
        return ASTProvider.removeJavadocStars(string);
    }

    public ASTree findTree(ASTree aSTree, int n, int n2, int n3) {
        ASTree[] aSTreeArray = aSTree.getSubTrees();
        for (int i = 0; i < aSTreeArray.length; ++i) {
            ASTree aSTree2 = aSTreeArray[i];
            if (aSTree2 == null) continue;
            int n4 = aSTree2.getFirstToken();
            int n5 = aSTree2.getLastToken();
            if (n4 == n && n5 == n2 && n3 == aSTree2.getType()) {
                return aSTree2;
            }
            if (n4 > n || n5 < n2) continue;
            return this.findTree(aSTree2, n, n2, n3);
        }
        throw new IllegalArgumentException("Child tree not found (type: " + n3 + " firstToken: " + n + " lastToken: " + n2 + " resource: " + this.getResource().getName() + ")");
    }

    public Token getComment(ASTree aSTree) {
        Token token = this.getToken(aSTree.getFirstToken());
        Token[] tokenArray = token.getPadding();
        for (int i = tokenArray.length - 1; i >= 0; --i) {
            Token token2 = tokenArray[i];
            if (token2.getType() != 364) continue;
            return token2;
        }
        return token;
    }

    ASTree[] check(ASTree aSTree) {
        if (aSTree == null || aSTree.getType() == 313) {
            return null;
        }
        return NULL_TREE;
    }

    public ASTree[] filterParts(ASTree[] aSTreeArray) {
        if (aSTreeArray != null) {
            ArrayList<Object> arrayList = null;
            for (int i = aSTreeArray.length - 1; i >= 0; --i) {
                ASTree aSTree = aSTreeArray[i];
                ASTree[] aSTreeArray2 = this.check(aSTree);
                if (aSTreeArray2 == NULL_TREE) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>(Arrays.asList((Object[])aSTreeArray));
                }
                if (aSTreeArray2 == null) {
                    arrayList.remove(i);
                    continue;
                }
                arrayList.addAll(i, Arrays.asList((Object[])aSTreeArray2));
            }
            if (arrayList != null) {
                return arrayList.toArray(new ASTree[arrayList.size()]);
            }
        }
        return aSTreeArray;
    }

    public String getText(ASTree aSTree) {
        if (aSTree == null) {
            return null;
        }
        return this.getText(aSTree, aSTree);
    }

    public String getText(ASTree aSTree, ASTree aSTree2) {
        int n = this.getToken(aSTree.getFirstToken()).getStartOffset();
        int n2 = this.getToken(aSTree2.getLastToken()).getEndOffset();
        return this.sourceText.substring(n, n2);
    }

    public String getText(Token token) {
        int n = token.getStartOffset();
        int n2 = token.getEndOffset();
        return this.sourceText.substring(n, n2);
    }

    public Token getToken(int n) {
        return n >= 0 && n < this.tokens.length ? this.tokens[n] : null;
    }

    public ASTree getParent(ASTree aSTree) {
        ASTree aSTree2 = this.getASTree();
        int n = aSTree.getFirstToken();
        while (true) {
            int n2;
            ASTree[] aSTreeArray = aSTree2.getSubTrees();
            ASTree aSTree3 = null;
            for (n2 = 0; n2 < aSTreeArray.length && ((aSTree3 = aSTreeArray[n2]) == null || aSTree3.getFirstToken() > n || aSTree3.getLastToken() < n); ++n2) {
            }
            if (n2 == aSTreeArray.length) {
                return aSTree2;
            }
            if (aSTree3 == aSTree) {
                return aSTree2;
            }
            aSTree2 = aSTree3;
        }
    }

    public boolean isFromDocument() {
        return this.documentPositions;
    }

    public PositionBounds createBounds(ASTree aSTree, ASTree aSTree2, boolean bl) {
        Token token = bl ? this.getComment(aSTree) : this.getToken(aSTree.getFirstToken());
        Token token2 = this.getToken(aSTree2.getLastToken());
        if (token == null || token2 == null) {
            String string = null;
            String string2 = null;
            try {
                string = aSTree.toString();
                string2 = aSTree2.toString();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            RuntimeException runtimeException = token == null ? new RuntimeException("First token is null for ASTree: " + string + " of type: " + aSTree.getType() + ";\ncalling startTree.getFirstToken() returns " + aSTree.getFirstToken()) : new RuntimeException("Last token is null for ASTree: " + string2 + " of type: " + aSTree2.getType() + ";\ncalling endTree.getLastToken() returns " + aSTree2.getLastToken());
            runtimeException.printStackTrace();
            this.dumpSource(runtimeException);
        }
        return this.createBounds(new int[]{token.getStartOffset(), token2.getEndOffset()});
    }

    public PositionBounds createBounds(int n, int n2) {
        return this.createBounds(new int[]{n, n2});
    }

    public PositionBounds createBounds(int[] nArray) {
        Object object;
        if (this.editor == null) {
            try {
                object = DataObject.find((FileObject)this.fobj);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
                return null;
            }
            this.editor = Util.findCloneableEditorSupport((DataObject)object);
        }
        object = this.getDocumentOffsets(nArray);
        PositionRef positionRef = this.editor.createPositionRef(object[0], Position.Bias.Forward);
        PositionRef positionRef2 = this.editor.createPositionRef(object[1], Position.Bias.Backward);
        return new PositionBounds(positionRef, positionRef2);
    }

    public int[] getDocumentOffsets(int[] nArray) {
        if (!this.isFromDocument()) {
            return this.convertToDocumentOffsets(nArray);
        }
        return nArray;
    }

    public int[] convertToDocumentOffsets(int[] nArray) {
        int n = -1;
        int n2 = 0;
        int[] nArray2 = (int[])nArray.clone();
        int n3 = this.sourceText.length() - 1;
        while (n < nArray[nArray.length - 1] && (n = this.sourceText.indexOf(13, n + 1)) != -1) {
            if (n < n3 && this.sourceText.charAt(n + 1) != '\n') continue;
            while (n2 < nArray.length && nArray[n2] <= n) {
                ++n2;
            }
            int n4 = n2;
            while (n4 < nArray.length) {
                int n5 = n4++;
                nArray2[n5] = nArray2[n5] - 1;
            }
        }
        return nArray2;
    }

    public String getSourceText() {
        if (this.sourceText == null) {
            try {
                this.getReader();
            }
            catch (Exception exception) {
                JMManager.getLog().log(16, "Error opening stream for: " + this.getResource().getName() + "; " + exception.toString());
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return this.sourceText;
    }

    private static String removeJavadocStars(String string) {
        if (string == null) {
            return null;
        }
        string = "\n".concat(string.substring(1, string.length() - 2));
        String[] stringArray = docRegExp.split(string, Integer.MAX_VALUE);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 1; i < stringArray.length; ++i) {
            if (i + 1 == stringArray.length) {
                if (stringArray[i].trim().length() == 0) continue;
                stringBuffer.append(stringArray[i]);
                continue;
            }
            stringBuffer.append(stringArray[i]).append('\n');
        }
        return stringBuffer.toString();
    }

    public ASTree getRootTree() {
        return this.getASTree();
    }

    public String getSourceLevel() {
        return SourceLevelQuery.getSourceLevel((FileObject)this.fobj);
    }

    public String getClassPath() {
        return null;
    }

    public ErrConsumer getErrorConsumer() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSource(Exception exception) {
        String string = System.getProperty("netbeans.user") + "/var/log/";
        String string2 = this.getSourceText();
        String string3 = this.getResource() == null ? "null" : this.getResource().getName();
        int n = string3.lastIndexOf(47);
        String string4 = n >= 0 ? string3.substring(n + 1) : string3;
        String string5 = null;
        File file = new File(string + string4 + ".dump");
        for (int i = 1; i < 255 && file.exists(); ++i) {
            file = new File(string + string4 + '_' + i + ".dump");
        }
        if (!file.exists()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
                try {
                    printWriter.println(string2);
                    printWriter.println("----- Original exception ---------------------------------------------");
                    exception.printStackTrace(printWriter);
                    string5 = file.getName();
                }
                finally {
                    printWriter.close();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, 0, "Error when writing parser dump file!", null, null, null);
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                string5 = null;
            }
        }
        if (string5 != null) {
            ErrorManager.getDefault().notify(1, (Throwable)new RuntimeException("Invalid AST returned from parser or error parsing '" + string3 + "'. Please report a bug against java module and attach dump file '" + string + string5 + "'."));
        } else {
            ErrorManager.getDefault().log(16, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to '" + string + "' and " + "clean all *.dump files in that directory.");
        }
    }

    public String toString() {
        return "ASTProvider@" + System.identityHashCode(this) + " for \"" + this.getResource().getName() + "\"";
    }

    static {
        $assertionsDisabled = !ASTProvider.class.desiredAssertionStatus();
        NULL_TREE = new ASTree[0];
        docRegExp = Pattern.compile("\\r?\\n(\\s*\\*+)?");
    }
}

