/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.lib.java.parser.CompilerException;
import org.netbeans.lib.java.parser.ECRequestDesc;
import org.netbeans.lib.java.parser.ErrConsumer;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class ECRequestDescImpl
implements ECRequestDesc {
    private final String sourcePath;
    private final String classPath;
    private final String bootPath;
    private final String fileName;
    private final ASTProvider provider;
    private final ErrConsumer consumer;
    private Map modifiedMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ECRequestDescImpl(String string, ASTProvider aSTProvider, ErrConsumer errConsumer) throws CompilerException {
        this.provider = aSTProvider;
        this.consumer = errConsumer;
        this.fileName = string;
        StringBuffer stringBuffer = new StringBuffer(241);
        StringBuffer stringBuffer2 = new StringBuffer(246);
        FileObject fileObject = aSTProvider.getFileObject();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (!fileObject.isValid()) {
            throw new CompilerException(new RuntimeException("FileObject " + fileObject.getPath() + " is no more valid. EC request cancelled."));
        }
        ClassPath classPath4 = ECRequestDescImpl.getCompileClassPathWithCompiledSrc(classPath, classPath2, classPath3);
        HashSet hashSet = new HashSet();
        this.getCompileAndSourcePath(classPath4, stringBuffer2, stringBuffer, hashSet);
        this.getSourcePath(classPath3, stringBuffer2, hashSet);
        this.sourcePath = stringBuffer2.toString();
        this.classPath = stringBuffer.toString();
        this.bootPath = this.getClassPathString(ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot"));
    }

    private Map getModifiedMap() {
        if (this.modifiedMap == null) {
            this.modifiedMap = new HashMap();
            DataObject[] dataObjectArray = DataObject.getRegistry().getModified();
            for (int i = 0; i < dataObjectArray.length; ++i) {
                FileObject fileObject = dataObjectArray[i].getPrimaryFile();
                if (fileObject == null || !fileObject.isValid()) continue;
                String string = fileObject.getPath();
                this.modifiedMap.put(string, dataObjectArray[i]);
            }
        }
        return this.modifiedMap;
    }

    public String getBootClassPath() {
        return this.bootPath;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public ErrConsumer getErrConsumer() {
        return this.consumer;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Reader getReader() {
        try {
            return this.provider.getFileReader(false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileNotFoundException);
            return null;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return null;
        }
    }

    public String getSourceClassPath() {
        return this.sourcePath;
    }

    public String getSourceLevel() {
        return this.provider.getSourceLevel();
    }

    private void getCompileAndSourcePath(ClassPath classPath, StringBuffer stringBuffer, StringBuffer stringBuffer2, Set set) {
        if (classPath != null) {
            Iterator iterator = classPath.entries().iterator();
            while (iterator.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)iterator.next();
                FileObject fileObject = entry.getRoot();
                if (fileObject != null) {
                    set.add(fileObject);
                    this.getFileName(fileObject, stringBuffer2);
                }
                FileObject[] fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    FileObject fileObject2 = fileObjectArray[i];
                    if (set.contains(fileObject2)) continue;
                    set.add(fileObject2);
                    this.getFileName(fileObject2, stringBuffer);
                }
            }
        }
    }

    private void getSourcePath(ClassPath classPath, StringBuffer stringBuffer, Set set) {
        if (classPath != null) {
            Iterator iterator = classPath.entries().iterator();
            while (iterator.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)iterator.next();
                FileObject fileObject = entry.getRoot();
                if (fileObject == null || !set.add(fileObject)) continue;
                this.getFileName(fileObject, stringBuffer);
            }
        }
    }

    void getFileName(FileObject fileObject, StringBuffer stringBuffer) {
        try {
            URL uRL = fileObject.getURL();
            if (uRL.getProtocol().equals("jar")) {
                fileObject = FileUtil.getArchiveFile((FileObject)fileObject);
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(file.getAbsolutePath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    String getClassPathString(ClassPath classPath) {
        FileObject[] fileObjectArray = classPath.getRoots();
        if (fileObjectArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(237);
        for (int i = 0; i < fileObjectArray.length; ++i) {
            this.getFileName(fileObjectArray[i], stringBuffer);
        }
        return stringBuffer.toString();
    }

    public Reader getReader(String string) {
        Object object;
        FileObject fileObject;
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        Reader reader = null;
        DataObject dataObject = (DataObject)this.getModifiedMap().get(string);
        if (dataObject == null) {
            fileObject = this.provider.getFileObject();
            object = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            FileObject[] fileObjectArray = object.getRoots();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                String string2 = fileObjectArray[i].getPath();
                if (!string.startsWith(string2)) continue;
                string = string.substring(string2.length() + 1);
                break;
            }
            fileObject = object.findResource(string);
        } else {
            fileObject = dataObject.getPrimaryFile();
        }
        if (fileObject != null) {
            try {
                object = new ASTProvider(null, fileObject);
                reader = ((ASTProvider)object).getFileReader(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return reader;
    }

    public boolean isModified(String string) {
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        return this.getModifiedMap().containsKey(string);
    }

    private static ClassPath getCompileClassPathWithCompiledSrc(ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
        ArrayList<PathResourceImplementation> arrayList;
        if (!$assertionsDisabled && classPath3 == null) {
            throw new AssertionError((Object)"Source path can not be null");
        }
        if (classPath2 == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<PathResourceImplementation>(5);
            Iterator iterator = classPath2.entries().iterator();
            block0: while (iterator.hasNext()) {
                URL uRL = ((ClassPath.Entry)iterator.next()).getURL();
                FileObject[] fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    if (!classPath3.contains(fileObjectArray[i])) continue;
                    arrayList.add(ClassPathSupport.createResource((URL)uRL));
                    continue block0;
                }
            }
        }
        if (arrayList.size() == 0) {
            return classPath;
        }
        if (classPath == null) {
            return ClassPathSupport.createClassPath(arrayList);
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath, ClassPathSupport.createClassPath(arrayList)});
    }

    static {
        $assertionsDisabled = !ECRequestDescImpl.class.desiredAssertionStatus();
    }
}

