/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class JavaDocParser {
    private static final String TEXT_TAG_NAME = "@@@@@";
    protected String rawText;
    protected JavaDocTag[] tags;
    private static final String lineSeparator;
    private static final int lineSeparatorLength;

    public JavaDocParser(String string) {
        this.rawText = string;
        this.tags = null;
    }

    public JavaDocParser(JavaDocTag[] javaDocTagArray) {
        this.rawText = null;
        this.tags = javaDocTagArray;
    }

    public JavaDocParser(String string, JavaDocTag[] javaDocTagArray) {
        this.rawText = null;
        if (string == null) {
            this.tags = javaDocTagArray;
        } else {
            int n = javaDocTagArray != null ? javaDocTagArray.length + 1 : 1;
            JavaDocTag[] javaDocTagArray2 = new JavaDocTag[n];
            javaDocTagArray2[0] = new JavaDocTag(TEXT_TAG_NAME, string);
            if (javaDocTagArray != null) {
                System.arraycopy(javaDocTagArray, 0, javaDocTagArray2, 1, javaDocTagArray.length);
            }
            this.tags = javaDocTagArray2;
        }
    }

    public String getRawText() {
        return this.getRawText(false);
    }

    public String getRawText(boolean bl) {
        if (this.rawText != null && !bl) {
            return this.rawText;
        }
        if (this.rawText != null) {
            this.tags = this.getTags();
        }
        if (bl) {
            Arrays.sort(this.tags);
        }
        String string = this.buildComment(this.tags);
        return string;
    }

    public void clearJavaDoc() {
        this.rawText = null;
    }

    public boolean isEmpty() {
        return this.rawText == null;
    }

    public JavaDocTag[] getTags() {
        if (this.tags != null) {
            return this.tags;
        }
        if (this.rawText == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        int[] nArray = this.removeJavaDocStars(this.getRawText());
        this.parseComment(arrayList, this.getRawText(), nArray);
        JavaDocTag[] javaDocTagArray = new JavaDocTag[arrayList.size()];
        arrayList.toArray(javaDocTagArray);
        return javaDocTagArray;
    }

    public JavaDocTag[] getTags(String string) {
        JavaDocTag[] javaDocTagArray = this.getTags();
        ArrayList<JavaDocTag> arrayList = new ArrayList<JavaDocTag>(javaDocTagArray.length);
        for (int i = 0; i < javaDocTagArray.length; ++i) {
            if (!javaDocTagArray[i].getName().equals(string)) continue;
            arrayList.add(javaDocTagArray[i]);
        }
        JavaDocTag[] javaDocTagArray2 = new JavaDocTag[arrayList.size()];
        arrayList.toArray(javaDocTagArray2);
        return javaDocTagArray2;
    }

    private void parseComment(List list, String string, int[] nArray) {
        int n = 1;
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        String string2 = this.rebuildText(string, nArray);
        int n7 = string2.length();
        for (int i = 0; i < n7; ++i) {
            char c = string2.charAt(i);
            boolean bl2 = Character.isWhitespace(c);
            switch (n) {
                case 1: {
                    if (!bl || c != '@') break;
                    this.parseCommentComponent(list, string2, nArray, -1, -1, 0, n5);
                    n2 = i;
                    n = 3;
                    break;
                }
                case 3: {
                    if (!bl2) break;
                    n3 = i;
                    n = 2;
                    break;
                }
                case 2: {
                    if (bl2) break;
                    n4 = i;
                    n = 4;
                }
                case 4: {
                    if (!bl || c != '@') break;
                    this.parseCommentComponent(list, string2, nArray, n2, n3, n4, n6 + 1);
                    n2 = i;
                    n = 3;
                }
            }
            if (lineSeparator != null && i + lineSeparatorLength <= n7 && string2.regionMatches(i, lineSeparator, 0, lineSeparatorLength)) {
                bl = true;
                if (n == 1) {
                    n5 = i;
                }
                i += lineSeparatorLength - 1;
                continue;
            }
            if (c == '\n') {
                bl = true;
                if (n != 1) continue;
                n5 = i;
                continue;
            }
            if (bl2) continue;
            n6 = i;
            bl = false;
        }
        switch (n) {
            case 3: {
                n3 = n7;
            }
            case 2: {
                n4 = n7;
            }
            case 1: 
            case 4: {
                this.parseCommentComponent(list, string2, nArray, n2, n3, n4, n6 + 1);
            }
        }
    }

    private void parseCommentComponent(List list, String string, int[] nArray, int n, int n2, int n3, int n4) {
        String string2;
        String string3 = n < 0 || n2 < 0 || n > n2 || n == 0 && n2 == 0 ? TEXT_TAG_NAME : string.substring(n, n2);
        String string4 = string2 = n3 < 0 || n4 < 0 || n3 > n4 ? "" : string.substring(n3, n4);
        if (TEXT_TAG_NAME.equals(string3)) {
            JavaDocTag javaDocTag = new JavaDocTag(TEXT_TAG_NAME, string2, -1, -1, nArray != null ? nArray[n3] : n3, nArray != null ? nArray[n4] : n4);
            list.add(javaDocTag);
        } else {
            JavaDocTag javaDocTag = new JavaDocTag(string3, string2, nArray != null ? nArray[n] : n, nArray != null ? nArray[n2] : n2, nArray != null ? nArray[n3] : n3, nArray != null ? nArray[n4] : n4);
            list.add(javaDocTag);
        }
    }

    public int[] removeJavaDocStars(String string) {
        int[] nArray;
        if (string == null || string.length() < 4) {
            return null;
        }
        int n = string.length();
        int[] nArray2 = new int[n];
        int n2 = 0;
        int n3 = 2;
        int n4 = string.indexOf("/*");
        int n5 = string.lastIndexOf("*/");
        if (n4 == -1 || n5 == -1 || n4 + 2 > n5) {
            return null;
        }
        int n6 = -1;
        for (int i = n4 + 2; i < n5; ++i) {
            char c = string.charAt(i);
            if (c == '\n' || c == '\r') {
                n6 = i;
            } else if (c == '*' && n6 >= 0) {
                n6 = -1;
            }
            switch (n3) {
                case 1: {
                    if (c == '*') {
                        n3 = 2;
                        break;
                    }
                    if (c == '\n' || c == '\r') {
                        n3 = 5;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    n3 = 4;
                    break;
                }
                case 3: {
                    if (c == '\n' || c == '\r') {
                        n3 = 5;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    n3 = 4;
                    break;
                }
                case 2: {
                    if (c == '\n' || c == '\r') {
                        n3 = 5;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        n3 = 3;
                        break;
                    }
                    if (c == '*') break;
                    n3 = 4;
                    break;
                }
                case 4: {
                    if (c != '\n' && c != '\r') break;
                    n3 = 5;
                    break;
                }
                case 5: {
                    if (c == '*') {
                        n3 = 2;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        n3 = 1;
                        break;
                    }
                    if (c == '\n' || c == '\r') break;
                    n3 = 4;
                }
            }
            if (n3 == 5 || n3 == 3) {
                nArray2[n2++] = i;
                continue;
            }
            if (n3 != 4) continue;
            if (n6 != -1) {
                int n7 = n6 + 1;
                while (n7 <= i) {
                    nArray2[n2++] = n7++;
                }
                n6 = -1;
                continue;
            }
            nArray2[n2++] = i;
        }
        if (n2 < n) {
            nArray = new int[n2];
            System.arraycopy(nArray2, 0, nArray, 0, n2);
        } else {
            nArray = nArray2;
        }
        return nArray;
    }

    private String rebuildText(String string, int[] nArray) {
        String string2 = string;
        if (nArray != null) {
            char[] cArray = new char[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                cArray[i] = string.charAt(nArray[i]);
            }
            string2 = new String(cArray, 0, cArray.length);
        }
        return string2;
    }

    private String buildComment(JavaDocTag[] javaDocTagArray) {
        if (javaDocTagArray == null) {
            return null;
        }
        if (javaDocTagArray.length == 0) {
            return "";
        }
        String string = lineSeparator != null ? lineSeparator : "\n";
        String string2 = string + string;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < javaDocTagArray.length; ++i) {
            String string3;
            if (TEXT_TAG_NAME.equals(javaDocTagArray[i].getName())) {
                string3 = javaDocTagArray[i].getValue();
                stringBuffer.append(string3);
                if (string3.endsWith(string2)) continue;
                if (!string3.endsWith(string)) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append('\n');
                continue;
            }
            string3 = javaDocTagArray[i].getValue();
            stringBuffer.append(javaDocTagArray[i].getName()).append(" ").append(string3);
            if (string3.endsWith(string)) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String surroundWithJavaDocStars(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "\n";
        StringBuffer stringBuffer = new StringBuffer("/**\n *");
        String[] stringArray = string.split(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(" ")) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(string2).append(" *");
        }
        stringBuffer.append('/');
        return stringBuffer.toString();
    }

    static {
        String string = System.getProperty("line.separator");
        if (string == null || string.equals("\n")) {
            lineSeparator = null;
            lineSeparatorLength = 0;
        } else {
            lineSeparator = string;
            lineSeparatorLength = string.length();
        }
    }

    public static class JavaDocTag
    implements Comparable {
        public static final HashMap nameValues = new HashMap();
        String name;
        String text;
        private int startName;
        private int endName;
        private int startText;
        private int endText;

        public JavaDocTag(String string, String string2) {
            this.name = string;
            this.text = string2;
            this.endText = -1;
            this.startText = -1;
            this.endName = -1;
            this.startName = -1;
        }

        JavaDocTag(String string, String string2, int n, int n2, int n3, int n4) {
            this.name = string;
            this.text = string2;
            this.startName = n;
            this.endName = n2;
            this.startText = n3;
            this.endText = n4;
        }

        public String toString() {
            return this.name + " " + this.text;
        }

        public String toInfo() {
            return this.startName + "," + this.endName + "{" + this.name + "} " + this.startText + "," + this.endText + "{" + this.text + "}";
        }

        public String getName() {
            return this.name;
        }

        public String getKind() {
            return this.name;
        }

        public boolean isText() {
            return JavaDocParser.TEXT_TAG_NAME.equals(this.getName());
        }

        public String getValue() {
            return this.text;
        }

        public int getStartName() {
            return this.startName;
        }

        public int getEndName() {
            return this.endName;
        }

        public int getStartText() {
            return this.startText;
        }

        public int getEndText() {
            return this.endText;
        }

        private int getNameValue(String string) {
            Integer n = (Integer)nameValues.get(string);
            if (n != null) {
                return n;
            }
            return 0;
        }

        public int compareTo(Object object) {
            if (object == null || !(object instanceof JavaDocTag)) {
                return -1;
            }
            String string = this.getName();
            String string2 = ((JavaDocTag)object).getName();
            int n = this.getNameValue(string);
            int n2 = this.getNameValue(string2);
            if (n > 0 && n2 > 0) {
                return n - n2;
            }
            if (n > 0) {
                return -100;
            }
            if (n2 > 0) {
                return 100;
            }
            return string.compareTo(string2);
        }

        static {
            nameValues.put(JavaDocParser.TEXT_TAG_NAME, new Integer(1));
            nameValues.put("@author", new Integer(2));
            nameValues.put("@version", new Integer(3));
            nameValues.put("@param", new Integer(4));
            nameValues.put("@return", new Integer(5));
            nameValues.put("@exception", new Integer(6));
            nameValues.put("@see", new Integer(7));
            nameValues.put("@since", new Integer(8));
            nameValues.put("@serial", new Integer(9));
            nameValues.put("@deprecated", new Integer(10));
        }
    }
}

