/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ArrayClass;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.GenericElement;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.JavaPackageClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeClass;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.AnnotationTypeClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaEnumClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ParameterImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ParameterizedTypeImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TypeClassImpl;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.AnnotationInfo;
import org.netbeans.modules.javacore.parser.AnnotationTypeInfo;
import org.netbeans.modules.javacore.parser.AnnotationValueInfo;
import org.netbeans.modules.javacore.parser.ArrayRef;
import org.netbeans.modules.javacore.parser.AttributeInfo;
import org.netbeans.modules.javacore.parser.ClassInfo;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.EnumInfo;
import org.netbeans.modules.javacore.parser.FeatureInfo;
import org.netbeans.modules.javacore.parser.FieldGroupInfo;
import org.netbeans.modules.javacore.parser.FieldInfo;
import org.netbeans.modules.javacore.parser.LocalClassScope;
import org.netbeans.modules.javacore.parser.LocalVarScope;
import org.netbeans.modules.javacore.parser.MethodInfo;
import org.netbeans.modules.javacore.parser.MethodScope;
import org.netbeans.modules.javacore.parser.NameRef;
import org.netbeans.modules.javacore.parser.ParameterInfo;
import org.netbeans.modules.javacore.parser.PrimitiveTypeRef;
import org.netbeans.modules.javacore.parser.ResourceInfo;
import org.netbeans.modules.javacore.parser.Scope;
import org.netbeans.modules.javacore.parser.TypeParamInfo;
import org.netbeans.modules.javacore.parser.TypeParamRef;
import org.netbeans.modules.javacore.parser.TypeParamScope;
import org.netbeans.modules.javacore.parser.TypeRef;
import org.netbeans.modules.javacore.parser.WildCardRef;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class MDRParser
extends ASTProvider {
    private Map semanticInfo;
    private ClassPath classPath;
    private JMManager manager;
    private JavaPackageClass jpckClass;
    private JavaClassClassImpl jclsClass;
    private TypeClass typeClass;
    private JavaEnumClassImpl enumClass;
    private AnnotationTypeClassImpl annotClass;
    private ClassDefinition currentClass;
    private Feature currentFeature;
    private String jpck;
    private Stack typeScopeInfo;
    private Stack variableScope;
    private Scope enumSwitchScope;
    private ClassIndex index;
    private TreeMap attributionToDo;
    private List localSuperInfo;
    private MDRepository rep;
    private Scope staticImpScope;
    private int javaFeatures;
    private boolean running;
    private boolean resolveClassName;
    private static final boolean DEBUG = false;
    private static Map superInfoMap = new HashMap();
    private static final ModifiersInfo NO_MODIFIERS = new ModifiersInfo(0, null);
    private static final RequestProcessor PARSE_AFTER_SCAN_RP = new RequestProcessor("Parse-After-Scan Request Processor");
    public static final int M_ENUM = 16384;
    public static final int M_ANNOTATION = 8192;
    public Map mofidToBounds;
    public int[] guardedBlocksBorders;

    public MDRParser(Resource resource, FileObject fileObject) {
        super(resource, fileObject);
        this.init();
    }

    public MDRParser(Resource resource, FileObject fileObject, String string, boolean bl) {
        super(resource, fileObject, string, bl);
        this.init();
    }

    private void init() {
        JavaModelPackage javaModelPackage = (JavaModelPackage)this.getResource().refImmediatePackage();
        this.jpckClass = javaModelPackage.getJavaPackage();
        this.jclsClass = (JavaClassClassImpl)javaModelPackage.getJavaClass();
        this.typeClass = javaModelPackage.getType();
        this.enumClass = (JavaEnumClassImpl)javaModelPackage.getJavaEnum();
        this.annotClass = (AnnotationTypeClassImpl)javaModelPackage.getAnnotationType();
        this.index = ClassIndex.getIndex(javaModelPackage);
        this.semanticInfo = new HashMap();
        this.typeScopeInfo = new Stack();
        this.variableScope = new Stack();
        this.attributionToDo = MDRParser.getAttributionToDoMap();
        this.localSuperInfo = new ArrayList();
        this.manager = (JMManager)JavaMetamodel.getManager();
        this.rep = JavaMetamodel.getDefaultRepository();
    }

    private static void reparseAfterScan(final FileObject fileObject) {
        PARSE_AFTER_SCAN_RP.post(new Runnable(){

            public void run() {
                JMManager jMManager = (JMManager)JavaMetamodel.getManager();
                if (jMManager.waitScanFinished()) {
                    jMManager.addModified(fileObject);
                    JavaMetamodel.getDefaultRepository().beginTrans(true);
                    JavaMetamodel.getDefaultRepository().endTrans(false);
                }
            }
        });
    }

    private static TreeMap getAttributionToDoMap() {
        return new TreeMap(new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = ((ASTree)object).getFirstToken();
                if (n2 < (n = ((ASTree)object2).getFirstToken())) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                n2 = ((ASTree)object).getLastToken();
                if (n2 < (n = ((ASTree)object2).getLastToken())) {
                    return 1;
                }
                if (n2 > n) {
                    return -1;
                }
                return 0;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSemanticInfo(ASTree aSTree, Element element) {
        Object object;
        Object v = this.semanticInfo.get(aSTree);
        if (v == null) {
            if (!this.attributionToDo.isEmpty()) {
                ASTree aSTree2;
                object = this.attributionToDo.keySet().iterator();
                while (object.hasNext() && (aSTree2 = (ASTree)object.next()).getFirstToken() <= aSTree.getFirstToken()) {
                    if (aSTree2.getLastToken() < aSTree.getLastToken()) continue;
                    this.doAttribution();
                    v = this.semanticInfo.get(aSTree);
                    break;
                }
            }
            if (v == null) {
                return null;
            }
        }
        boolean bl = JMManager.getTransactionMutex().isSafeTrans();
        this.manager.setSafeTrans(true);
        try {
            object = this.getModelElement(aSTree, element, v);
            return object;
        }
        finally {
            this.manager.setSafeTrans(bl);
        }
    }

    private void doAttribution() {
        TreeMap treeMap = this.attributionToDo;
        this.attributionToDo = MDRParser.getAttributionToDoMap();
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Element element = (Element)entry.getValue();
            if (!element.isValid()) continue;
            this.enterBody(element, (ASTree)entry.getKey());
        }
    }

    public void prepareForAttribution(MetadataElement metadataElement, ASTree aSTree) {
        this.attributionToDo.put(aSTree, metadataElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void enterBody(Element element, ASTree aSTree) {
        if (this.running) {
            ErrorManager.getDefault().notify(1, (Throwable)new Exception("Recursion in enterBody"));
            return;
        }
        this.running = true;
        boolean bl = JMManager.getTransactionMutex().isSafeTrans();
        this.manager.setSafeTrans(true);
        if (JMManager.PERF_DEBUG) {
            try {
                Feature feature = JavaModelUtil.getDeclaringFeature(element);
                System.err.println("Attributing method: " + feature.getDeclaringClass().getName() + '.' + feature.getName() + '.' + aSTree.getFirstToken());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        long l = System.currentTimeMillis();
        try {
            Feature feature = JavaModelUtil.getDeclaringFeature(element);
            this.classPath = this.manager.getClassPath();
            this.currentClass = feature.getDeclaringClass();
            this.computeScope(this.currentClass);
            this.semanticInfo.put(aSTree, element);
            this.currentFeature = feature;
            this.processASTBody(aSTree);
            this.typeScopeInfo.pop();
            this.variableScope.pop();
            Object var8_8 = null;
            superInfoMap.keySet().removeAll(this.localSuperInfo);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            superInfoMap.keySet().removeAll(this.localSuperInfo);
            this.localSuperInfo.clear();
            this.typeScopeInfo.clear();
            this.variableScope.clear();
            this.currentFeature = null;
            this.currentClass = null;
            this.manager.setSafeTrans(bl);
            this.running = false;
            throw throwable;
        }
        this.localSuperInfo.clear();
        this.typeScopeInfo.clear();
        this.variableScope.clear();
        this.currentFeature = null;
        this.currentClass = null;
        this.manager.setSafeTrans(bl);
        this.running = false;
        if (JMManager.PERF_DEBUG) {
            System.out.println("    finished: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResourceInfo enterMembers() {
        boolean bl;
        block5: {
            ResourceInfo resourceInfo;
            if (this.running) {
                ErrorManager.getDefault().notify(1, (Throwable)new Exception("Recursion in enterMembers"));
                return null;
            }
            this.running = true;
            bl = JMManager.getTransactionMutex().isSafeTrans();
            this.manager.setSafeTrans(true);
            try {
                this.classPath = this.manager.getClassPath();
                ASTree aSTree = this.getASTree();
                if (aSTree == null) break block5;
                if (this.getPackage("java.lang") == null) {
                    MDRParser.reparseAfterScan(this.getFileObject());
                }
                resourceInfo = (ResourceInfo)this.processAST(aSTree);
                Object var5_4 = null;
                superInfoMap.keySet().removeAll(this.localSuperInfo);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                superInfoMap.keySet().removeAll(this.localSuperInfo);
                this.localSuperInfo.clear();
                this.manager.setSafeTrans(bl);
                this.running = false;
                throw throwable;
            }
            this.localSuperInfo.clear();
            this.manager.setSafeTrans(bl);
            this.running = false;
            return resourceInfo;
        }
        Object var5_5 = null;
        superInfoMap.keySet().removeAll(this.localSuperInfo);
        this.localSuperInfo.clear();
        this.manager.setSafeTrans(bl);
        this.running = false;
        return null;
    }

    public int getJavaFeatures() {
        return this.javaFeatures;
    }

    private void computeScope(ClassDefinition classDefinition) {
        Scope scope;
        Scope scope2;
        if (classDefinition == null) {
            Resource resource = this.getResource();
            scope2 = Scope.createTypeScope(resource, this.classPath);
            scope = new Scope(null);
            this.staticImpScope = Scope.createStaticImpScope(resource);
        } else if (classDefinition instanceof JavaClassImpl && ((JavaClassImpl)classDefinition).isTransient() && ((JavaClassImpl)classDefinition).getDeclaringClass() == null) {
            ASTree[] aSTreeArray = ((MetadataElement)classDefinition).getASTree().getSubTrees();
            Token token = this.getToken(aSTreeArray[aSTreeArray.length - 1].getFirstToken());
            Scope[] scopeArray = (Scope[])this.semanticInfo.get(token);
            scope2 = new Scope(scopeArray[0]);
            scope = new Scope(scopeArray[1]);
            scope2.addMember(Scope.createMemberTypeScope(classDefinition, this));
            scope.addMember(Scope.createFieldScope(classDefinition));
        } else if (classDefinition instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)classDefinition;
            ClassDefinition classDefinition2 = javaClass.getDeclaringClass();
            this.computeScope(classDefinition2);
            scope2 = new Scope((Scope)this.typeScopeInfo.pop());
            scope = new Scope((Scope)this.variableScope.pop());
            scope2.addMember(Scope.createMemberTypeScope(classDefinition, this));
            scope.addMember(Scope.createFieldScope(classDefinition));
            Iterator iterator = javaClass.getTypeParameters().iterator();
            while (iterator.hasNext()) {
                TypeParameter typeParameter = (TypeParameter)iterator.next();
                scope2.addMember(new TypeParamScope(typeParameter));
            }
        } else {
            ASTree aSTree = ((MetadataElement)classDefinition).getASTree();
            Token token = this.getToken(aSTree.getFirstToken());
            Scope[] scopeArray = (Scope[])this.semanticInfo.get(token);
            scope2 = new Scope(scopeArray[0]);
            scope = new Scope(scopeArray[1]);
            scope2.addMember(Scope.createMemberTypeScope(classDefinition, this));
            scope.addMember(Scope.createFieldScope(classDefinition));
        }
        this.typeScopeInfo.push(scope2);
        this.variableScope.push(scope);
    }

    private JavaPackage getPackage(String string) {
        return this.jpckClass.resolvePackage(string);
    }

    Object processAST(ASTree aSTree) {
        return this.processAST(aSTree, null);
    }

    Object processAST(ASTree aSTree, String string) {
        if (aSTree == null) {
            return null;
        }
        ASTree[] aSTreeArray = aSTree.getSubTrees();
        int n = aSTree.getType();
        switch (n) {
            case 15: {
                this.typeScopeInfo.push(new Scope(null));
                this.processAST(aSTreeArray[0]);
                this.jpck = this.getResource().getPackageName();
                ElementInfo[] elementInfoArray = (ElementInfo[])this.processAST(aSTreeArray[1]);
                this.typeScopeInfo.pop();
                this.typeScopeInfo.push(Scope.createTypeScope(this.jpck, this.classPath, elementInfoArray));
                Object object = this.processAST(aSTreeArray[2], this.jpck);
                this.typeScopeInfo.pop();
                return new ResourceInfo(aSTree, n, this.getResource(), (ClassInfo[])object, elementInfoArray);
            }
            case 46: {
                return this.resolveTypeName(aSTreeArray[1]);
            }
            case 54: 
            case 68: {
                String string2 = n == 54 && aSTreeArray[0] != null ? this.resolveStaticImport(aSTreeArray[1]) : ((NameRef)this.resolveTypeName((ASTree)aSTreeArray[1])).name;
                return new ElementInfo(aSTree, n, string2);
            }
            case 34: {
                ElementInfo[] elementInfoArray = null;
                if (aSTreeArray != null) {
                    elementInfoArray = new ElementInfo[aSTreeArray.length];
                    for (int i = 0; i < elementInfoArray.length; ++i) {
                        elementInfoArray[i] = (ElementInfo)this.processAST(aSTreeArray[i]);
                    }
                }
                return elementInfoArray;
            }
            case 67: {
                ClassInfo[] classInfoArray = null;
                if (aSTreeArray != null) {
                    int n2;
                    ASTree[] aSTreeArray2 = this.filterParts(aSTreeArray);
                    for (n2 = 0; n2 < aSTreeArray2.length; ++n2) {
                        this.resolveSuperTypes(aSTreeArray2[n2], string);
                    }
                    classInfoArray = new ClassInfo[aSTreeArray2.length];
                    for (n2 = 0; n2 < classInfoArray.length; ++n2) {
                        classInfoArray[n2] = (ClassInfo)this.processAST(aSTreeArray2[n2], string);
                    }
                }
                return classInfoArray;
            }
            case 82: {
                return new FeatureInfo(aSTree, n, this.getText(aSTreeArray[0]), 0, null);
            }
            case 83: {
                ElementInfo[] elementInfoArray = null;
                if (aSTreeArray != null) {
                    ASTree[] aSTreeArray3 = this.filterParts(aSTreeArray);
                    elementInfoArray = new ElementInfo[aSTreeArray3.length];
                    for (int i = 0; i < aSTreeArray3.length; ++i) {
                        elementInfoArray[i] = (ElementInfo)this.processAST(aSTreeArray3[i], string);
                    }
                }
                return elementInfoArray;
            }
            case 12: 
            case 38: 
            case 81: 
            case 88: {
                FeatureInfo[] featureInfoArray = null;
                if (aSTreeArray != null) {
                    int n3;
                    ASTree[] aSTreeArray4 = this.filterParts(aSTreeArray);
                    for (n3 = 0; n3 < aSTreeArray4.length; ++n3) {
                        this.resolveSuperTypes(aSTreeArray4[n3], string);
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>(aSTreeArray4.length);
                    for (n3 = 0; n3 < aSTreeArray4.length; ++n3) {
                        Object object = this.processAST(aSTreeArray4[n3], string);
                        if (object instanceof FieldInfo[]) {
                            arrayList.addAll(Arrays.asList((Object[])object));
                            continue;
                        }
                        arrayList.add(object);
                    }
                    featureInfoArray = arrayList.toArray(new FeatureInfo[arrayList.size()]);
                }
                return featureInfoArray;
            }
            case 84: {
                ModifiersInfo modifiersInfo = this.getModifiers(aSTreeArray[0]);
                int n4 = modifiersInfo != NO_MODIFIERS ? modifiersInfo.modifiers : this.getDeprecated(aSTree);
                ASTree aSTree2 = aSTreeArray[3];
                ASTree aSTree3 = aSTreeArray[2];
                NameRef[] nameRefArray = null;
                Scope scope = new Scope((Scope)this.typeScopeInfo.peek());
                JavaEnum javaEnum = (JavaEnum)this.semanticInfo.get(aSTree);
                String string3 = javaEnum.getName();
                scope.addMember(Scope.createMemberTypeScope((ClassDefinition)javaEnum, this));
                this.typeScopeInfo.push(scope);
                n4 |= 0x4000;
                this.javaFeatures |= 2;
                if (aSTree3 != null) {
                    nameRefArray = (NameRef[])this.semanticInfo.get(aSTree3);
                }
                ASTree aSTree4 = aSTree2.getSubTrees()[0];
                ASTree aSTree5 = aSTree2.getSubTrees()[1];
                ElementInfo[] elementInfoArray = aSTree4 == null ? null : (ElementInfo[])this.processAST(aSTree4, string3);
                FeatureInfo[] featureInfoArray = aSTree5 == null ? null : (FeatureInfo[])this.processAST(aSTree5, string3);
                EnumInfo enumInfo = new EnumInfo(aSTree, n, string3, n4, featureInfoArray, nameRefArray, elementInfoArray, modifiersInfo.annotations);
                this.typeScopeInfo.pop();
                return enumInfo;
            }
            case 89: {
                ModifiersInfo modifiersInfo = this.getModifiers(aSTreeArray[0]);
                int n5 = modifiersInfo != NO_MODIFIERS ? modifiersInfo.modifiers : this.getDeprecated(aSTree);
                ASTree aSTree6 = aSTreeArray[2];
                Object var12_117 = null;
                Scope scope = new Scope((Scope)this.typeScopeInfo.peek());
                AnnotationType annotationType = (AnnotationType)this.semanticInfo.get(aSTree);
                this.javaFeatures |= 4;
                String string4 = annotationType.getName();
                scope.addMember(Scope.createMemberTypeScope((ClassDefinition)annotationType, this));
                this.typeScopeInfo.push(scope);
                FeatureInfo[] featureInfoArray = (FeatureInfo[])this.processAST(aSTree6, string4);
                AnnotationTypeInfo annotationTypeInfo = new AnnotationTypeInfo(aSTree, n, string4, n5, featureInfoArray, modifiersInfo.annotations);
                this.typeScopeInfo.pop();
                return annotationTypeInfo;
            }
            case 13: 
            case 37: {
                ModifiersInfo modifiersInfo = this.getModifiers(aSTreeArray[0]);
                int n6 = modifiersInfo != NO_MODIFIERS ? modifiersInfo.modifiers : this.getDeprecated(aSTree);
                ASTree aSTree7 = aSTreeArray[5];
                ASTree aSTree8 = aSTreeArray[4];
                TypeParamInfo[] typeParamInfoArray = (TypeParamInfo[])this.processAST(aSTreeArray[2]);
                NameRef nameRef = (NameRef)this.semanticInfo.get(aSTreeArray[1]);
                NameRef[] nameRefArray = null;
                Scope scope = new Scope((Scope)this.typeScopeInfo.peek());
                JavaClass javaClass = (JavaClass)this.semanticInfo.get(aSTree);
                String string5 = javaClass.getName();
                scope.addMember(Scope.createMemberTypeScope((ClassDefinition)javaClass, this));
                this.typeScopeInfo.push(scope);
                if (n == 37) {
                    n6 |= 0x200;
                }
                if (aSTree8 != null) {
                    nameRefArray = (NameRef[])this.semanticInfo.get(aSTree8);
                }
                typeParamInfoArray = (TypeParamInfo[])this.processAST(aSTreeArray[2], string5);
                FeatureInfo[] featureInfoArray = (FeatureInfo[])this.processAST(aSTree7, string5);
                ClassInfo classInfo = new ClassInfo(aSTree, n, string5, n6, featureInfoArray, nameRef, nameRefArray, typeParamInfoArray, modifiersInfo.annotations);
                this.typeScopeInfo.pop();
                return classInfo;
            }
            case 18: 
            case 41: {
                ModifiersInfo modifiersInfo = this.getModifiers(aSTreeArray[0]);
                int n7 = modifiersInfo != NO_MODIFIERS ? modifiersInfo.modifiers : this.getDeprecated(aSTree);
                TypeParamRef[] typeParamRefArray = null;
                TypeParamInfo[] typeParamInfoArray = (TypeParamInfo[])this.processAST(aSTreeArray[1]);
                TypeRef typeRef = this.resolveTypeName(aSTreeArray[2]);
                Object[] objectArray = (Object[])this.processAST(aSTreeArray[3]);
                ASTree aSTree9 = aSTreeArray[4];
                String string6 = null;
                ParameterInfo[] parameterInfoArray = (ParameterInfo[])objectArray[1];
                if (n == 41) {
                    string6 = (String)objectArray[0];
                }
                if (aSTree9 != null) {
                    ASTree[] aSTreeArray5 = aSTree9.getSubTrees();
                    typeParamRefArray = new TypeParamRef[aSTreeArray5.length];
                    for (int i = 0; i < aSTreeArray5.length; ++i) {
                        typeParamRefArray[i] = (TypeParamRef)this.resolveTypeName(aSTreeArray5[i]);
                    }
                }
                return new MethodInfo(aSTree, n, string6, n7, typeRef == null ? null : MDRParser.fullType(typeRef, objectArray[2]), parameterInfoArray, typeParamRefArray, typeParamInfoArray, modifiersInfo.annotations);
            }
            case 19: 
            case 70: {
                return new Object[]{this.processAST(aSTreeArray[0]), this.processAST(aSTreeArray[1])};
            }
            case 42: {
                return new Object[]{this.processAST(aSTreeArray[0]), this.processAST(aSTreeArray[1]), this.processAST(aSTreeArray[2])};
            }
            case 31: {
                ParameterInfo[] parameterInfoArray = new ParameterInfo[aSTreeArray.length];
                for (int i = 0; i < parameterInfoArray.length; ++i) {
                    parameterInfoArray[i] = (ParameterInfo)this.processAST(aSTreeArray[i], string);
                }
                return parameterInfoArray;
            }
            case 30: {
                ModifiersInfo modifiersInfo = this.getModifiers(aSTreeArray[0]);
                boolean bl = false;
                TypeRef typeRef = this.resolveTypeName(aSTreeArray[1]);
                Object[] objectArray = (Object[])this.processAST(aSTreeArray[3]);
                TypeRef typeRef2 = MDRParser.fullType(typeRef, objectArray[1]);
                String string7 = (String)objectArray[0];
                if (modifiersInfo != null) {
                    bl = Modifier.isFinal(modifiersInfo.modifiers);
                }
                return new ParameterInfo(aSTree, n, string7, bl, typeRef2, aSTreeArray[2] != null, modifiersInfo.annotations);
            }
            case 78: {
                TypeParamInfo[] typeParamInfoArray = new TypeParamInfo[aSTreeArray.length];
                this.javaFeatures |= 1;
                this.createTypeParametrScope(aSTree);
                for (int i = 0; i < typeParamInfoArray.length; ++i) {
                    typeParamInfoArray[i] = (TypeParamInfo)this.processAST(aSTreeArray[i]);
                }
                return typeParamInfoArray;
            }
            case 77: {
                String string8 = (String)this.processAST(aSTreeArray[0]);
                TypeParamRef[] typeParamRefArray = (TypeParamRef[])this.processAST(aSTreeArray[1]);
                return new TypeParamInfo(aSTree, aSTree.getType(), string8, typeParamRefArray);
            }
            case 74: {
                TypeParamRef[] typeParamRefArray = new TypeParamRef[aSTreeArray.length];
                for (int i = 0; i < aSTreeArray.length; ++i) {
                    typeParamRefArray[i] = (TypeParamRef)this.resolveTypeName(aSTreeArray[i]);
                }
                return typeParamRefArray;
            }
            case 75: {
                Object[] objectArray = new Object[aSTreeArray.length];
                this.javaFeatures |= 1;
                for (int i = 0; i < aSTreeArray.length; ++i) {
                    ASTree aSTree10 = aSTreeArray[i];
                    objectArray[i] = aSTree10.getType() == 361 ? this.resolveTypeName(aSTree10) : this.processAST(aSTree10);
                }
                return objectArray;
            }
            case 28: {
                ModifiersInfo modifiersInfo = this.getModifiers(aSTreeArray[0]);
                int n8 = modifiersInfo != NO_MODIFIERS ? modifiersInfo.modifiers : this.getDeprecated(aSTree);
                TypeRef typeRef = this.resolveTypeName(aSTreeArray[1]);
                ASTree aSTree11 = aSTreeArray[2];
                Object[] objectArray = (Object[])this.processAST(aSTree11);
                if (aSTree11.getType() == 70) {
                    TypeRef typeRef3 = MDRParser.fullType(typeRef, objectArray[1]);
                    String string9 = (String)objectArray[0];
                    return new FieldInfo(aSTree, n, string9, n8, typeRef3, -1, modifiersInfo.annotations);
                }
                FieldInfo[] fieldInfoArray = new FieldInfo[objectArray.length];
                ASTree[] aSTreeArray6 = aSTree11.getSubTrees();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object[] objectArray2 = (Object[])objectArray[i];
                    fieldInfoArray[i] = new FieldInfo(aSTreeArray6[i], 28, (String)objectArray2[0], n8, MDRParser.fullType(typeRef, objectArray2[1]), i, modifiersInfo.annotations);
                }
                return new FieldGroupInfo(aSTree, 71, n8, typeRef, fieldInfoArray, modifiersInfo.annotations);
            }
            case 87: {
                ModifiersInfo modifiersInfo = this.getModifiers(aSTreeArray[0]);
                int n9 = modifiersInfo != NO_MODIFIERS ? modifiersInfo.modifiers : this.getDeprecated(aSTree);
                TypeRef typeRef = this.resolveTypeName(aSTreeArray[1]);
                String string10 = (String)this.processAST(aSTreeArray[2]);
                AnnotationValueInfo annotationValueInfo = (AnnotationValueInfo)this.processAST(aSTreeArray[3]);
                return new AttributeInfo(aSTree, n, string10, n9, typeRef, annotationValueInfo, modifiersInfo.annotations);
            }
            case 36: 
            case 56: {
                ASTree aSTree12 = aSTreeArray[0];
                ModifiersInfo modifiersInfo = this.getModifiers(aSTreeArray[0]);
                int n10 = modifiersInfo.modifiers;
                return new FeatureInfo(aSTree, n, null, n10, modifiersInfo.annotations);
            }
            case 86: {
                NameRef nameRef = (NameRef)this.resolveTypeName(aSTreeArray[0]);
                ASTree aSTree13 = aSTreeArray[1];
                ASTree[] aSTreeArray7 = aSTree13 != null ? aSTree13.getSubTrees() : new ASTree[]{};
                AnnotationValueInfo[] annotationValueInfoArray = new AnnotationValueInfo[aSTreeArray7.length];
                this.javaFeatures |= 8;
                for (int i = 0; i < annotationValueInfoArray.length; ++i) {
                    AnnotationValueInfo annotationValueInfo;
                    Object[] objectArray;
                    ASTree[] aSTreeArray8 = aSTreeArray7[i].getSubTrees();
                    String string11 = (String)this.processAST(aSTreeArray8[0]);
                    ASTree aSTree14 = aSTreeArray8[1];
                    int n11 = aSTree14.getType();
                    if (n11 == 86) {
                        objectArray = this.processAST(aSTree14);
                        annotationValueInfo = new AnnotationValueInfo(aSTreeArray7[i], 4096, string11, objectArray);
                    } else if (n11 == 4) {
                        objectArray = MDRParser.getArray(this.processAST(aSTree14));
                        annotationValueInfo = new AnnotationValueInfo(aSTreeArray7[i], 4098, string11, objectArray);
                    } else {
                        objectArray = this.getText(aSTree14);
                        annotationValueInfo = new AnnotationValueInfo(aSTreeArray7[i], 4097, string11, objectArray);
                    }
                    annotationValueInfoArray[i] = annotationValueInfo;
                }
                return new AnnotationInfo(aSTree, n, nameRef, annotationValueInfoArray);
            }
            case 52: {
                ASTree aSTree15 = aSTreeArray[1];
                ASTree aSTree16 = aSTreeArray[0];
                TypeRef typeRef = aSTree16.getType() != 51 ? this.resolveTypeName(aSTree16) : (TypeRef)this.processAST(aSTree16);
                if (aSTree15 != null && typeRef != null) {
                    int n12 = (Integer)this.processAST(aSTree15);
                    typeRef = new ArrayRef((PrimitiveTypeRef)typeRef, n12);
                }
                return typeRef;
            }
            case 51: {
                return this.getPrimitiveType(aSTreeArray[0]);
            }
            case 22: {
                return new Integer((aSTree.getLastToken() - aSTree.getFirstToken() + 1) / 2);
            }
            case 79: {
                ASTree aSTree17 = aSTreeArray[0];
                if (aSTree17 == null) {
                    return new WildCardRef(false, null);
                }
                boolean bl = aSTree17.getType() == 273;
                TypeRef typeRef = this.resolveTypeName(aSTreeArray[1]);
                return new WildCardRef(bl, typeRef);
            }
            case 45: {
                ASTree aSTree18 = aSTreeArray[0];
                ASTree aSTree19 = aSTreeArray[1];
                String string12 = (String)this.processAST(aSTree19);
                NameRef nameRef = null;
                NameRef nameRef2 = null;
                if (aSTree18 != null) {
                    TypeRef[] typeRefArray;
                    TypeParamRef typeParamRef = aSTree18.getType() == 361 ? (TypeParamRef)this.resolveTypeName(aSTree18) : (TypeParamRef)this.processAST(aSTree18);
                    Object v = this.semanticInfo.get(aSTree18);
                    if (v instanceof String && ((String)v).charAt(0) == '*') {
                        typeRefArray = (TypeRef[])typeParamRef;
                        String string13 = typeRefArray.name.concat(".").concat(string12);
                        nameRef = this.getPackage(string13);
                        if (nameRef != null) {
                            nameRef2 = new NameRef(string13);
                        }
                    }
                    Object[] objectArray = MDRParser.getArray(this.processAST(aSTreeArray[2]));
                    if (nameRef == null) {
                        typeRefArray = new TypeRef[objectArray.length];
                        System.arraycopy(objectArray, 0, typeRefArray, 0, objectArray.length);
                        nameRef = nameRef2 = new NameRef(string12, typeParamRef, typeRefArray);
                    }
                    this.storeSemanticInfo(aSTree19, nameRef);
                } else {
                    Object[] objectArray = MDRParser.getArray(this.processAST(aSTreeArray[2]));
                    TypeParamRef typeParamRef = (TypeParamRef)this.resolveTypeName(aSTree19);
                    TypeRef[] typeRefArray = new TypeRef[objectArray.length];
                    System.arraycopy(objectArray, 0, typeRefArray, 0, objectArray.length);
                    nameRef = nameRef2 = new NameRef(typeParamRef.name, null, typeRefArray);
                }
                this.storeSemanticInfo(aSTree, nameRef);
                return nameRef2;
            }
            case 361: {
                return ((Token)aSTree).getValue();
            }
            case 44: {
                Object object;
                int n13 = 0;
                int n14 = 0;
                AnnotationInfo[] annotationInfoArray = new AnnotationInfo[aSTreeArray.length];
                for (int i = 0; i < aSTreeArray.length; ++i) {
                    Object object2;
                    object = aSTreeArray[i];
                    if (object.getType() == 86) {
                        object2 = (AnnotationInfo)this.processAST((ASTree)object);
                        annotationInfoArray[n14++] = object2;
                        if (!((AnnotationInfo)object2).type.name.equals("Deprecated") && !((AnnotationInfo)object2).type.name.equals("java.lang.Deprecated")) continue;
                        n13 |= Integer.MIN_VALUE;
                        continue;
                    }
                    object2 = (Token)object;
                    n13 |= ((Integer)object2.getValue()).intValue();
                    if (!object2.getDeprecatedFlag()) continue;
                    n13 |= Integer.MIN_VALUE;
                }
                object = new AnnotationInfo[n14];
                System.arraycopy(annotationInfoArray, 0, object, 0, n14);
                return new ModifiersInfo(n13, (AnnotationInfo[])object);
            }
            case 92: {
                return new AnnotationValueInfo(aSTree, 4097, null, null);
            }
        }
        if (aSTreeArray != null) {
            Object[] objectArray = null;
            Object[] objectArray3 = null;
            int n15 = 0;
            for (int i = 0; i < aSTreeArray.length; ++i) {
                Object[] objectArray4 = this.processAST(aSTreeArray[i]);
                if (objectArray4 == null) continue;
                if (objectArray == null) {
                    objectArray = objectArray4;
                    continue;
                }
                if (n15 == 0) {
                    objectArray3 = new Object[aSTreeArray.length - i + 1];
                    objectArray3[0] = objectArray;
                    objectArray3[1] = objectArray4;
                    n15 = 2;
                    continue;
                }
                objectArray3[n15++] = objectArray4;
            }
            return n15 == 0 ? objectArray : objectArray3;
        }
        return null;
    }

    private String resolveStaticImport(ASTree aSTree) {
        ASTree[] aSTreeArray;
        String string = null;
        if (aSTree != null && (aSTreeArray = aSTree.getSubTrees()) != null) {
            NameRef nameRef = (NameRef)this.resolveTypeName(aSTreeArray[0]);
            ASTree aSTree2 = aSTreeArray[1];
            String string2 = (String)this.processAST(aSTree2);
            JavaClass javaClass = (JavaClass)((SemiPersistentElement)this.getResource()).resolveType(nameRef);
            Feature feature = null;
            if (javaClass != null) {
                Object[] objectArray = javaClass.getFeatures().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Feature feature2 = (Feature)objectArray[i];
                    if (!string2.equals(feature2.getName())) continue;
                    feature = feature2;
                    break;
                }
            }
            this.storeSemanticInfo(aSTree, feature);
            this.storeSemanticInfo(aSTree2, feature);
            string = nameRef.name.concat(".").concat(string2);
        }
        return string;
    }

    private Object getModelElement(ASTree aSTree, Element element, Object object) {
        if (object instanceof String) {
            String string;
            String string2 = (String)object;
            char c = string2.charAt(0);
            switch (c) {
                case '*': 
                case '<': 
                case '@': 
                case '^': {
                    string = string2.substring(1);
                    break;
                }
                default: {
                    return this.typeClass.resolve(string2);
                }
            }
            switch (c) {
                case '*': {
                    return this.getPackage(string);
                }
                case '@': {
                    return this.resolveClass(string);
                }
                case '<': {
                    return this.resolveTypeParameter(aSTree, string);
                }
                case '^': {
                    return this.rep.getByMofId(string);
                }
            }
            return null;
        }
        if (object.getClass().equals(TypeParamRef.class)) {
            TypeParamRef typeParamRef = (TypeParamRef)object;
            return ((MetadataElement)element).resolveType(typeParamRef);
        }
        if (object instanceof TypeRef) {
            Type type;
            if (element == null) {
                element = this.getResource();
            }
            if ((type = ((MetadataElement)element).resolveType((TypeRef)object)) instanceof ParameterizedType) {
                return ((ParameterizedType)type).getDefinition();
            }
            if (type instanceof ParameterizedTypeImpl.Wrapper) {
                ParameterizedTypeImpl.Wrapper wrapper = (ParameterizedTypeImpl.Wrapper)type;
                return (Element)wrapper.getWrappedObject();
            }
            return type;
        }
        if (object instanceof FieldRefInfo) {
            String string;
            FieldRefInfo fieldRefInfo = (FieldRefInfo)object;
            ClassDefinition classDefinition = (ClassDefinition)this.getModelElement(null, null, fieldRefInfo.declClass);
            if (classDefinition == null) {
                return null;
            }
            Feature feature = (Feature)this.rep.getByMofId(fieldRefInfo.mofid);
            if (feature != null && (string = (JavaClass)feature.getDeclaringClass()).equals(classDefinition)) {
                return feature;
            }
            string = fieldRefInfo.name;
            if (fieldRefInfo instanceof CallableRefInfo) {
                CallableRefInfo callableRefInfo = (CallableRefInfo)fieldRefInfo;
                Object[] objectArray = classDefinition.getContents().toArray();
                if (string == null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        ClassMember classMember = (ClassMember)objectArray[i];
                        if (!(classMember instanceof Constructor) || !MDRParser.parametersMatch((CallableFeature)classMember, callableRefInfo.parTypes)) continue;
                        return classMember;
                    }
                } else {
                    for (int i = 0; i < objectArray.length; ++i) {
                        ClassMember classMember = (ClassMember)objectArray[i];
                        if (!(classMember instanceof Method) || !string.equals(classMember.getName()) || !MDRParser.parametersMatch((CallableFeature)classMember, callableRefInfo.parTypes)) continue;
                        return classMember;
                    }
                }
            } else {
                Object[] objectArray = classDefinition.getFeatures().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    ClassMember classMember = (ClassMember)objectArray[i];
                    if (!(classMember instanceof Field) || !string.equals(classMember.getName())) continue;
                    return classMember;
                }
            }
            ErrorManager.getDefault().log(16, fieldRefInfo + " not found in " + this.getResource().getName());
            return null;
        }
        if (object instanceof LocalVarRefInfo) {
            LocalVarRefInfo localVarRefInfo = (LocalVarRefInfo)object;
            if (localVarRefInfo.var == null) {
                List<Resource> list = Collections.singletonList(this.getResource());
                localVarRefInfo.var = (Variable)this.getModelElement(list, localVarRefInfo.varDeclAST);
            }
            return localVarRefInfo.var;
        }
        if (!(object instanceof MetadataElement) || ((MetadataElement)((Object)object)).isTransient()) {
            return object;
        }
        JMManager.getLog().log("Invalid type :" + object);
        return null;
    }

    private TypeParameter resolveTypeParameter(ASTree aSTree, String string) {
        int n = aSTree.getFirstToken();
        int n2 = aSTree.getLastToken();
        TypeParameter typeParameter = null;
        Iterator<Object> iterator = Collections.singletonList(this.getResource()).iterator();
        while (iterator.hasNext()) {
            MetadataElement metadataElement = (MetadataElement)iterator.next();
            ASTree aSTree2 = metadataElement.getASTree();
            if (aSTree2 == aSTree) {
                return typeParameter;
            }
            if (n < aSTree2.getFirstToken() || n2 > aSTree2.getLastToken()) continue;
            if (metadataElement instanceof GenericElement) {
                Iterator iterator2 = ((GenericElement)metadataElement).getTypeParameters().iterator();
                while (iterator2.hasNext()) {
                    TypeParameter typeParameter2 = (TypeParameter)iterator2.next();
                    if (!typeParameter2.getName().equals(string)) continue;
                    typeParameter = typeParameter2;
                }
            }
            iterator = metadataElement.getChildren().iterator();
        }
        return null;
    }

    private JavaClass resolveClass(TypeParamRef typeParamRef) {
        SemiPersistentElement semiPersistentElement = (SemiPersistentElement)this.getResource();
        JavaClass javaClass = (JavaClass)semiPersistentElement.resolveType(typeParamRef);
        if (javaClass instanceof ParameterizedType) {
            return ((ParameterizedType)javaClass).getDefinition();
        }
        return javaClass;
    }

    private JavaClass resolveClass(String string) {
        JavaClass javaClass = this.jclsClass.resolveClass(string, true);
        if (javaClass == null) {
            // empty if block
        }
        return javaClass;
    }

    private MetadataElement getModelElement(Collection collection, ASTree aSTree) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        int n = aSTree.getFirstToken();
        int n2 = aSTree.getLastToken();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MetadataElement metadataElement = (MetadataElement)((Object)iterator.next());
            ASTree aSTree2 = metadataElement.getASTree();
            if (aSTree2 == aSTree) {
                return metadataElement;
            }
            if (aSTree2.getFirstToken() > n || aSTree2.getLastToken() < n2) continue;
            MetadataElement metadataElement2 = this.getModelElement(metadataElement.getChildren(), aSTree);
            if (metadataElement2 == null) {
                throw new IllegalArgumentException("Tree not found! (Tree type = " + aSTree.getType() + "; Bounds: " + n + ", " + n2 + "; Element type: " + aSTree2.getType() + "; Bounds: " + aSTree2.getFirstToken() + ", " + aSTree2.getLastToken() + ")");
            }
            return metadataElement2;
        }
        return null;
    }

    public boolean isVariableAccess(ASTree aSTree) {
        Object v;
        if (aSTree == null) {
            return false;
        }
        if (!this.attributionToDo.isEmpty()) {
            this.doAttribution();
        }
        if ((v = this.semanticInfo.get(aSTree)) == null) {
            if (aSTree.getType() == 45) {
                return this.isVariableAccess(aSTree.getSubTrees()[0]);
            }
            return false;
        }
        if (v.getClass().equals(FieldRefInfo.class) || v instanceof LocalVarRefInfo) {
            return true;
        }
        if (v instanceof String) {
            String string = (String)v;
            if (string.charAt(0) != '^') {
                return false;
            }
            Object object = this.getSemanticInfo(aSTree, null);
            return object instanceof Variable;
        }
        return false;
    }

    static boolean parametersMatch(CallableFeature callableFeature, TypeRef[] typeRefArray) {
        Object[] objectArray = callableFeature.getParameters().toArray();
        if (objectArray.length != typeRefArray.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ParameterImpl parameterImpl = (ParameterImpl)((Object)objectArray[i]);
            ParameterInfo parameterInfo = (ParameterInfo)parameterImpl.getElementInfo();
            if (typeRefArray[i++].equals(parameterInfo.type)) continue;
            return false;
        }
        return true;
    }

    void createTypeParametrScope(ASTree aSTree) {
        if (aSTree == null) {
            return;
        }
        if (aSTree.getType() != 78) {
            throw new IllegalArgumentException("Type " + aSTree.getType());
        }
        ASTree[] aSTreeArray = aSTree.getSubTrees();
        Scope scope = (Scope)this.typeScopeInfo.peek();
        for (int i = 0; i < aSTreeArray.length; ++i) {
            ASTree aSTree2 = aSTreeArray[i];
            String string = (String)this.processAST(aSTree2.getSubTrees()[0]);
            scope.addMember(new TypeParamScope(string));
        }
    }

    void resolveSuperTypes(ASTree aSTree, String string) {
        int n = aSTree.getType();
        this.typeScopeInfo.push(new Scope((Scope)this.typeScopeInfo.peek()));
        switch (n) {
            case 84: {
                JavaClass javaClass;
                ASTree[] aSTreeArray = aSTree.getSubTrees();
                String string2 = (String)this.processAST(aSTreeArray[1]);
                ASTree aSTree2 = aSTreeArray[2];
                ArrayList<JavaClass> arrayList = Collections.EMPTY_LIST;
                String string3 = string.length() == 0 ? string2 : string.concat(".").concat(string2);
                JavaClass javaClass2 = null;
                NameRef nameRef = NameRef.java_lang_Enum;
                this.semanticInfo.put(aSTreeArray[1], nameRef);
                if (aSTree2 != null) {
                    javaClass = aSTree2.getSubTrees();
                    NameRef[] nameRefArray = new NameRef[((ASTree[])javaClass).length];
                    arrayList = new ArrayList<JavaClass>();
                    for (int i = 0; i < ((JavaClass)javaClass).length; ++i) {
                        nameRefArray[i] = (NameRef)this.resolveTypeName((ASTree)javaClass[i]);
                        arrayList.add(this.resolveClass(nameRefArray[i]));
                    }
                    this.semanticInfo.put(aSTree2, nameRefArray);
                }
                if (this.semanticInfo.get(aSTree) == null) {
                    javaClass = this.getClassByFqn(string3);
                    if (javaClass == null) {
                        JMManager.getLog().log("Enum not found in index: " + string3 + ". Recovering...");
                        Thread.dumpStack();
                        javaClass = this.enumClass.create(string3, 0, false);
                        this.setParent(javaClass, string);
                    } else if (!(javaClass instanceof JavaEnum)) {
                        JMManager.getLog().log(1, "Wrong type of object found in index. Expected: JavaEnum, found: " + javaClass.getClass().getName());
                        JMManager.getLog().log(1, "Recovering...");
                        Thread.dumpStack();
                        JavaClass javaClass3 = javaClass;
                        javaClass = this.enumClass.create(string3, javaClass3.getModifiers(), false);
                        this.swapChild(javaClass3, javaClass);
                    }
                    this.semanticInfo.put(aSTree, javaClass);
                }
                if (nameRef != null) {
                    javaClass2 = this.resolveClass(nameRef);
                }
                superInfoMap.put(string3, new SuperInfo(javaClass2, arrayList));
                this.localSuperInfo.add(string3);
                break;
            }
            case 13: 
            case 37: 
            case 89: {
                JavaClass javaClass;
                ASTree aSTree3;
                ASTree aSTree4;
                ASTree[] aSTreeArray = aSTree.getSubTrees();
                String string4 = (String)this.processAST(aSTreeArray[1]);
                ArrayList<JavaClass> arrayList = Collections.EMPTY_LIST;
                NameRef nameRef = null;
                String string5 = string.length() == 0 ? string4 : string.concat(".").concat(string4);
                JavaClass javaClass4 = null;
                if (n == 89) {
                    aSTree4 = null;
                    aSTree3 = null;
                    nameRef = NameRef.java_lang_Annotation;
                } else {
                    this.createTypeParametrScope(aSTreeArray[2]);
                    aSTree4 = aSTreeArray[3];
                    aSTree3 = aSTreeArray[4];
                    if (aSTree4 != null) {
                        nameRef = (NameRef)this.resolveTypeName(aSTree4.getSubTrees()[0]);
                    } else if (!(string4.equals("Object") && this.jpck.equals("java.lang") || n != 13)) {
                        nameRef = NameRef.java_lang_Object;
                    }
                }
                if (nameRef != null) {
                    this.semanticInfo.put(aSTreeArray[1], nameRef);
                }
                if (aSTree3 != null) {
                    javaClass = aSTree3.getSubTrees();
                    NameRef[] nameRefArray = new NameRef[((ASTree[])javaClass).length];
                    arrayList = new ArrayList<JavaClass>();
                    for (int i = 0; i < ((JavaClass)javaClass).length; ++i) {
                        nameRefArray[i] = (NameRef)this.resolveTypeName((ASTree)javaClass[i]);
                        arrayList.add(this.resolveClass(nameRefArray[i]));
                    }
                    this.semanticInfo.put(aSTree3, nameRefArray);
                }
                if (this.semanticInfo.get(aSTree) == null) {
                    javaClass = this.getClassByFqn(string5);
                    if (javaClass == null) {
                        JMManager.getLog().notify(1, (Throwable)new Exception((n == 89 ? "Annotation" : "Class") + " not found in index: " + string5 + ". Recovering..."));
                        javaClass = n == 89 ? this.annotClass.create(string5, 0, false) : this.jclsClass.create(string5, 0, null, null, false);
                        this.setParent(javaClass, string);
                    } else if (n == 89 && !(javaClass instanceof AnnotationType)) {
                        JMManager.getLog().log(16, "Wrong type of object found in index. Expected: AnnotationType, found: " + javaClass.getClass().getName());
                        JMManager.getLog().notify(1, (Throwable)new Exception("Recovering..."));
                        JavaClass javaClass5 = javaClass;
                        javaClass = this.annotClass.create(string5, javaClass5.getModifiers(), false);
                        this.swapChild(javaClass5, javaClass);
                    } else if (n != 89 && (javaClass instanceof AnnotationType || javaClass instanceof JavaEnum)) {
                        JMManager.getLog().log(16, "Wrong type of object found in index. Expected: JavaClass, found: " + javaClass.getClass().getName());
                        JMManager.getLog().notify(1, (Throwable)new Exception("Recovering..."));
                        JavaClass javaClass6 = javaClass;
                        javaClass = this.jclsClass.create(string5, javaClass6.getModifiers(), null, null, false);
                        this.swapChild(javaClass6, javaClass);
                    }
                    this.semanticInfo.put(aSTree, javaClass);
                }
                if (nameRef != null) {
                    javaClass4 = this.resolveClass(nameRef);
                }
                superInfoMap.put(string5, new SuperInfo(javaClass4, arrayList));
                this.localSuperInfo.add(string5);
            }
        }
        this.typeScopeInfo.pop();
    }

    private JavaClass getClassByFqn(String string) {
        JavaClass javaClass = null;
        Set set = this.index.getClassesByFqn(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass2 = (JavaClass)iterator.next();
            if (!javaClass2.isValid() || !this.getResource().equals(javaClass2.getResource())) continue;
            javaClass = javaClass2;
            break;
        }
        return javaClass;
    }

    private void swapChild(JavaClass javaClass, JavaClass javaClass2) {
        RefFeatured refFeatured = javaClass.refImmediateComposite();
        if (refFeatured instanceof ResourceImpl) {
            ListIterator<JavaClass> listIterator = ((ResourceImpl)refFeatured).getPersistentClassifiers().listIterator();
            while (listIterator.hasNext()) {
                JavaClass javaClass3 = (JavaClass)listIterator.next();
                if (!javaClass3.equals(javaClass)) continue;
                listIterator.set(javaClass2);
                javaClass.refDelete();
                if (((ResourceImpl)refFeatured).classifiersInited()) {
                    ((ResourceImpl)refFeatured).reinitClassifiers();
                }
                return;
            }
            JMManager.getLog().log("Old type wasn't found in classifiers of its parent resource. Adding newType to the end of the resource classifiers list...");
            listIterator.add(javaClass2);
            javaClass.refDelete();
            return;
        }
        if (refFeatured instanceof JavaClassImpl) {
            JavaClassImpl javaClassImpl = (JavaClassImpl)refFeatured;
            boolean bl = javaClassImpl.contentsInited();
            boolean bl2 = javaClassImpl.getPersistentContents().isEmpty();
            if (bl || !bl2) {
                ListIterator<JavaClass> listIterator = javaClassImpl.getPersistentContents().listIterator();
                while (listIterator.hasNext()) {
                    Element element = (Element)listIterator.next();
                    if (!element.equals(javaClass)) continue;
                    listIterator.set(javaClass2);
                    javaClass.refDelete();
                    if (bl) {
                        javaClassImpl.reinitContents();
                    }
                    return;
                }
                JMManager.getLog().log("Old type wasn't found in classifiers of its parent resource. Adding newType to the end of the resource classifiers list...");
                listIterator.add(javaClass2);
            } else {
                ((JavaClassImpl)javaClass2).setParentClass(javaClassImpl);
            }
            ((JavaClassImpl)javaClass).setParentClass(null);
            javaClass.refDelete();
            return;
        }
        JMManager.getLog().log("Parent of newType has not been set since parent of the oldType is: " + refFeatured.getClass().getName());
    }

    private void setParent(JavaClass javaClass, String string) {
        if (string.equals(this.jpck)) {
            ResourceImpl resourceImpl = (ResourceImpl)this.getResource();
            resourceImpl.getPersistentClassifiers().add(javaClass);
            if (resourceImpl.classifiersInited()) {
                resourceImpl.reinitClassifiers();
            }
        } else {
            JavaClassImpl javaClassImpl = (JavaClassImpl)this.getClassByFqn(string);
            if (javaClassImpl == null) {
                JMManager.getLog().log("Could not find parent class: " + string);
                JMManager.getLog().log("Setting resource as a parent...");
                ResourceImpl resourceImpl = (ResourceImpl)this.getResource();
                resourceImpl.getPersistentClassifiers().add(javaClass);
                if (resourceImpl.classifiersInited()) {
                    resourceImpl.reinitClassifiers();
                }
            } else {
                boolean bl = javaClassImpl.contentsInited();
                boolean bl2 = javaClassImpl.getPersistentContents().isEmpty();
                if (bl || !bl2) {
                    javaClassImpl.getPersistentContents().add(javaClass);
                    if (bl) {
                        javaClassImpl.reinitContents();
                    }
                } else {
                    ((JavaClassImpl)javaClass).setParentClass(javaClassImpl);
                }
            }
        }
    }

    ModifiersInfo getModifiers(ASTree aSTree) {
        ModifiersInfo modifiersInfo = (ModifiersInfo)this.processAST(aSTree);
        return modifiersInfo == null ? NO_MODIFIERS : modifiersInfo;
    }

    private int getDeprecated(ASTree aSTree) {
        Token token = this.getToken(aSTree.getFirstToken());
        return token.getDeprecatedFlag() ? Integer.MIN_VALUE : 0;
    }

    public static TypeRef fullType(Object object, Object object2) {
        TypeRef typeRef = (TypeRef)object;
        if (object2 != null) {
            int n = (Integer)object2;
            if (typeRef instanceof ArrayRef) {
                ArrayRef arrayRef = (ArrayRef)typeRef;
                return new ArrayRef(arrayRef.parent, arrayRef.dimCount + n);
            }
            return new ArrayRef((PrimitiveTypeRef)typeRef, n);
        }
        return typeRef;
    }

    Type fullType(Type type, Object object) {
        if (object != null) {
            int n = (Integer)object;
            ArrayClass arrayClass = ((JavaModelPackage)type.refImmediatePackage()).getArray();
            for (int i = 0; i < n; ++i) {
                type = arrayClass.resolveArray(type);
            }
        }
        return type;
    }

    private static Object[] getArray(Object object) {
        if (object == null) {
            return new Object[0];
        }
        if (object.getClass().isArray()) {
            return (Object[])object;
        }
        return new Object[]{object};
    }

    TypeRef resolveTypeName(ASTree aSTree) {
        if (aSTree != null) {
            int n = aSTree.getType();
            if (n == 361) {
                Object object = this.resolveTypeName((String)this.processAST(aSTree));
                this.storeSemanticInfo(aSTree, object);
                if (object instanceof TypeRef) {
                    return (TypeRef)object;
                }
                if (object instanceof Type) {
                    return SemiPersistentElement.typeToTypeRef((Type)object);
                }
                String string = object instanceof JavaPackage ? ((JavaPackage)object).getName() : (String)object;
                return new NameRef(string, null, null);
            }
            return (TypeRef)this.processAST(aSTree);
        }
        return null;
    }

    Object resolveTypeName(String string) {
        Scope scope = (Scope)this.typeScopeInfo.peek();
        Object object = scope.lookup(string);
        if (object == null) {
            JavaPackage javaPackage = this.getPackage(string);
            if (javaPackage != null) {
                return javaPackage;
            }
            return string;
        }
        return object;
    }

    private PrimitiveTypeRef getPrimitiveType(ASTree aSTree) {
        switch (aSTree.getType()) {
            case 261: {
                return PrimitiveTypeRef.BYTE;
            }
            case 293: {
                return PrimitiveTypeRef.SHORT;
            }
            case 283: {
                return PrimitiveTypeRef.INT;
            }
            case 285: {
                return PrimitiveTypeRef.LONG;
            }
            case 264: {
                return PrimitiveTypeRef.CHAR;
            }
            case 276: {
                return PrimitiveTypeRef.FLOAT;
            }
            case 270: {
                return PrimitiveTypeRef.DOUBLE;
            }
            case 259: {
                return PrimitiveTypeRef.BOOLEAN;
            }
            case 304: {
                return PrimitiveTypeRef.VOID;
            }
        }
        ErrorManager.getDefault().log(65536, "Unknown type " + aSTree.getType());
        return null;
    }

    JavaClass getSuperClass(ClassDefinition classDefinition) {
        SuperInfo superInfo = (SuperInfo)superInfoMap.get(classDefinition.getName());
        if (superInfo != null) {
            return superInfo.superClass;
        }
        if (this.getResource().equals(classDefinition.getResource())) {
            JMManager.getLog().log(1, "Unresolved superclass for " + classDefinition.getName());
            return null;
        }
        JavaClass javaClass = classDefinition.getSuperClass();
        if (javaClass instanceof ParameterizedType) {
            return ((ParameterizedType)javaClass).getDefinition();
        }
        return javaClass;
    }

    Collection getInterfaces(ClassDefinition classDefinition) {
        SuperInfo superInfo = (SuperInfo)superInfoMap.get(classDefinition.getName());
        if (superInfo != null) {
            return superInfo.interfaces;
        }
        if (this.getResource().equals(classDefinition.getResource())) {
            JMManager.getLog().log(1, "Unresolved Interface for " + classDefinition.getName());
            return Collections.EMPTY_LIST;
        }
        return classDefinition.getInterfaces();
    }

    private Type processASTBody(ASTree aSTree) {
        ClassDefinition classDefinition = null;
        if (aSTree == null) {
            return null;
        }
        ASTree[] aSTreeArray = aSTree.getSubTrees();
        int n = aSTree.getType();
        block0 : switch (n) {
            case 15: {
                this.typeScopeInfo.push(Scope.createTypeScope(this.getResource(), this.classPath));
                this.processASTBody(aSTreeArray[2]);
                this.typeScopeInfo.pop();
                break;
            }
            case 13: 
            case 37: 
            case 84: 
            case 89: {
                ClassDefinition classDefinition2 = this.currentClass;
                this.currentClass = (ClassDefinition)this.semanticInfo.get(aSTree);
                if (this.currentClass != null) {
                    Scope scope = new Scope((Scope)this.typeScopeInfo.peek());
                    Scope scope2 = new Scope((Scope)this.variableScope.peek());
                    scope.addMember(Scope.createMemberTypeScope(this.currentClass, this));
                    scope2.addMember(Scope.createFieldScope(this.currentClass));
                    this.typeScopeInfo.push(scope);
                    this.variableScope.push(scope2);
                    if (n == 84) {
                        ASTree aSTree2 = aSTreeArray[3].getSubTrees()[1];
                        if (aSTree2 != null) {
                            this.processASTBody(aSTree2);
                        }
                    } else if (n == 89) {
                        this.processASTBody(aSTreeArray[2]);
                    } else {
                        this.processASTBody(aSTreeArray[5]);
                    }
                    this.variableScope.pop();
                    this.typeScopeInfo.pop();
                } else {
                    Scope scope = (Scope)this.typeScopeInfo.peek();
                    Scope scope3 = (Scope)this.variableScope.peek();
                    JavaClassImpl javaClassImpl = this.createTransientClasses(aSTree, null);
                    scope.addMember(new LocalClassScope(javaClassImpl));
                    this.resolveSuperTypes(aSTree, "");
                    ClassInfo classInfo = (ClassInfo)this.processAST(aSTree);
                    javaClassImpl.updatePersistent(classInfo);
                    javaClassImpl.setElementInfo(classInfo);
                    Token token = this.getToken(aSTreeArray[aSTreeArray.length - 1].getFirstToken());
                    this.semanticInfo.put(token, new Scope[]{(Scope)scope.clone(), (Scope)scope3.clone()});
                }
                this.currentClass = classDefinition2;
                break;
            }
            case 28: {
                ASTree aSTree3 = aSTreeArray[2];
                if (aSTree3.getType() == 70) {
                    this.processASTBody(aSTree3.getSubTrees()[2]);
                    break;
                }
                ASTree[] aSTreeArray2 = aSTree3.getSubTrees();
                for (int i = 0; i < aSTreeArray2.length; ++i) {
                    ASTree aSTree4 = aSTreeArray2[i];
                    this.processASTBody(aSTree4.getSubTrees()[2]);
                }
                break;
            }
            case 82: {
                ASTree aSTree5 = aSTreeArray[0];
                ASTree aSTree6 = aSTreeArray[1];
                ASTree aSTree7 = aSTreeArray[2];
                List list = this.getArgumetsTypes(aSTree6);
                this.usesMethod(null, this.currentClass, list, aSTree5, false);
                if (aSTree7 == null) break;
                this.createAnonClass(aSTree7, (JavaClass)this.currentClass);
                break;
            }
            case 18: 
            case 41: {
                Parameter parameter;
                CallableFeature callableFeature = (CallableFeature)this.semanticInfo.get(aSTree);
                Scope scope = new Scope((Scope)this.variableScope.peek());
                Scope scope4 = new Scope((Scope)this.typeScopeInfo.peek());
                Iterator iterator = callableFeature.getParameters().iterator();
                Iterator iterator2 = callableFeature.getTypeParameters().iterator();
                while (iterator.hasNext()) {
                    parameter = (Parameter)iterator.next();
                    scope.addMember(new LocalVarScope((Variable)parameter));
                }
                while (iterator2.hasNext()) {
                    parameter = (TypeParameter)iterator2.next();
                    scope4.addMember(new TypeParamScope((TypeParameter)parameter));
                }
                this.variableScope.push(scope);
                this.typeScopeInfo.push(scope4);
                this.processASTBody(aSTreeArray[5]);
                this.typeScopeInfo.pop();
                this.variableScope.pop();
                break;
            }
            case 36: 
            case 56: {
                this.variableScope.push(new Scope((Scope)this.variableScope.peek()));
                this.typeScopeInfo.push(new Scope((Scope)this.typeScopeInfo.peek()));
                this.processASTBody(aSTreeArray[1]);
                this.typeScopeInfo.pop();
                this.variableScope.pop();
                break;
            }
            case 30: {
                ParameterInfo parameterInfo = (ParameterInfo)this.processAST(aSTree);
                Scope scope = (Scope)this.variableScope.peek();
                Type type = ((SemiPersistentElement)this.currentFeature).resolveType(parameterInfo.type);
                LocalVarRefInfo localVarRefInfo = new LocalVarRefInfo(aSTree, type);
                scope.addMember(new LocalVarScope(parameterInfo.name, localVarRefInfo));
                this.storeSemanticInfo(aSTree, parameterInfo);
                break;
            }
            case 7: 
            case 10: 
            case 58: {
                boolean bl;
                if (aSTreeArray == null || aSTreeArray.length <= 0) break;
                boolean bl2 = bl = n != 7 || this.getToken(aSTree.getFirstToken()).getType() == 309;
                if (bl) {
                    this.variableScope.push(((Scope)this.variableScope.peek()).clone());
                }
                for (int i = 0; i < aSTreeArray.length; ++i) {
                    this.processASTBody(aSTreeArray[i]);
                }
                if (!bl) break;
                this.variableScope.pop();
                break;
            }
            case 40: {
                ASTree[] aSTreeArray3;
                Type type;
                Object[] objectArray;
                Scope scope = (Scope)this.variableScope.peek();
                ASTree aSTree8 = aSTreeArray[0];
                ModifiersInfo modifiersInfo = this.getModifiers(aSTree8);
                Type type2 = this.resolveClassName(aSTreeArray[1]);
                ASTree aSTree9 = aSTreeArray[2];
                Object[] objectArray2 = MDRParser.getArray(this.processAST(aSTree9));
                if (aSTree8 != null) {
                    objectArray = Boolean.valueOf(Modifier.isFinal(modifiersInfo.modifiers));
                    type = modifiersInfo.annotations;
                    this.semanticInfo.put(aSTree8, new Object[]{objectArray, type});
                }
                this.usesType(type2, aSTree);
                if (aSTree9.getType() == 70) {
                    aSTreeArray3 = new ASTree[]{aSTree9};
                    objectArray2 = new Object[]{objectArray2};
                } else {
                    aSTreeArray3 = aSTree9.getSubTrees();
                }
                for (int i = 0; i < objectArray2.length; ++i) {
                    objectArray = (Object[])objectArray2[i];
                    type = this.fullType(type2, objectArray[1]);
                    String string = (String)objectArray[0];
                    ASTree aSTree10 = aSTreeArray3[i];
                    if (objectArray2.length > 1) {
                        this.usesType(type, aSTree10);
                    }
                    scope.addMember(new LocalVarScope(string, new LocalVarRefInfo(aSTree10, type)));
                    this.processASTBody(aSTree10.getSubTrees()[2]);
                }
                break;
            }
            case 32: {
                ASTree aSTree11 = aSTreeArray[0];
                Scope scope = null;
                if (aSTree11 != null && aSTree11.getType() == 40) {
                    scope = new Scope((Scope)this.variableScope.peek());
                    this.variableScope.push(scope);
                }
                for (int i = 0; i < aSTreeArray.length; ++i) {
                    this.processASTBody(aSTreeArray[i]);
                }
                if (scope == null) break;
                this.variableScope.pop();
                break;
            }
            case 29: {
                this.variableScope.push(((Scope)this.variableScope.peek()).clone());
                for (int i = 0; i < aSTreeArray.length; ++i) {
                    this.processASTBody(aSTreeArray[i]);
                }
                this.variableScope.pop();
                break;
            }
            case 63: {
                Type type = TypeClassImpl.getRawType(this.processASTBody(aSTreeArray[0]));
                boolean bl = type instanceof JavaEnum;
                Scope scope = this.enumSwitchScope;
                this.enumSwitchScope = bl ? Scope.createFieldScope((ClassDefinition)((JavaEnum)type)) : null;
                this.processASTBody(aSTreeArray[1]);
                this.enumSwitchScope = scope;
                break;
            }
            case 61: {
                if (this.enumSwitchScope != null) {
                    this.variableScope.push(this.enumSwitchScope);
                }
                this.processASTBody(aSTreeArray[0]);
                if (this.enumSwitchScope == null) break;
                this.variableScope.pop();
                break;
            }
            case 49: {
                Type type = this.resolveClassName(aSTreeArray[0]);
                if (type != null) {
                    this.usesType(type, aSTree);
                }
                return this.jclsClass.resolveClass("java.lang.Class", false);
            }
            case 50: {
                if (aSTreeArray != null) {
                    classDefinition = this.resolveClassName(aSTreeArray[0]);
                    break;
                }
                classDefinition = this.currentClass;
                break;
            }
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: {
                String string;
                Object object = ((Token)aSTree).getValue();
                switch (n) {
                    case 356: {
                        if (object instanceof Long) {
                            string = "long";
                            break;
                        }
                        string = "int";
                        break;
                    }
                    case 357: {
                        if (object instanceof Double) {
                            string = "double";
                            break;
                        }
                        string = "float";
                        break;
                    }
                    case 355: {
                        string = "boolean";
                        break;
                    }
                    case 358: {
                        string = "char";
                        break;
                    }
                    case 359: {
                        return this.resolveClass("java.lang.String");
                    }
                    case 360: {
                        return this.resolveClass("java.lang.Object");
                    }
                    default: {
                        ErrorManager.getDefault().log(65536, "Unknown Literal: " + n);
                        return null;
                    }
                }
                return this.typeClass.resolve(string);
            }
            case 14: {
                ASTree aSTree12 = aSTreeArray[0];
                ASTree aSTree13 = aSTreeArray[2];
                ASTree aSTree14 = aSTreeArray[4];
                if (aSTree12 == null) {
                    classDefinition = this.resolveClassName(aSTree13);
                } else {
                    Object object;
                    JavaClass javaClass = (JavaClass)this.resolvePrimaryWithSuper(aSTree12, false, n);
                    if (javaClass != null && (object = this.getMemberOf(javaClass, (Token)aSTree13)) instanceof JavaClass) {
                        classDefinition = (JavaClass)object;
                        this.usesType((Type)classDefinition, aSTree13);
                    }
                }
                List list = this.getArgumetsTypes(aSTreeArray[3]);
                if (classDefinition == null) break;
                this.usesMethod(null, (ClassDefinition)((JavaClass)classDefinition), list, aSTree, false);
                if (aSTree14 == null) break;
                this.createAnonClass(aSTree14, (JavaClass)classDefinition);
                break;
            }
            case 3: {
                int n2;
                ASTree aSTree15 = aSTreeArray[0];
                Type type = this.resolveClassName(aSTree15);
                if (type != null) {
                    ASTree aSTree16 = aSTreeArray[1];
                    ASTree aSTree17 = aSTreeArray[2];
                    int n3 = this.getDimExprsDimenstion(aSTree16);
                    Integer n4 = (Integer)this.processAST(aSTree17);
                    if (n4 != null) {
                        n3 += n4.intValue();
                    }
                    if (n3 > 0) {
                        ArrayClass arrayClass = ((JavaModelPackage)type.refImmediatePackage()).getArray();
                        for (n2 = 0; n2 < n3; ++n2) {
                            type = arrayClass.resolveArray(type);
                        }
                    }
                    this.usesType(type, aSTree);
                }
                for (n2 = 1; n2 < aSTreeArray.length; ++n2) {
                    this.processASTBody(aSTreeArray[n2]);
                }
                classDefinition = type;
                break;
            }
            case 27: {
                Token token = (Token)aSTreeArray[2];
                String string = (String)token.getValue();
                boolean bl = aSTreeArray[1] != null;
                ClassDefinition classDefinition3 = this.resolvePrimaryWithSuper(aSTreeArray[0], bl, n);
                if (classDefinition3 == null || classDefinition3 instanceof UnresolvedClass) {
                    return null;
                }
                Field field = (Field)Scope.createFieldScope(classDefinition3).lookup(string);
                if (field == null) break;
                classDefinition = field.getType();
                this.usesField((Variable)field, token);
                this.storeSemanticInfo(aSTree, field);
                if (!(classDefinition instanceof JavaClass) || !(classDefinition instanceof PrimitiveType)) break;
                break;
            }
            case 43: {
                ASTree aSTree18 = aSTreeArray[0];
                Token token = (Token)aSTreeArray[3];
                String string = (String)token.getValue();
                boolean bl = aSTreeArray[1] != null;
                ClassDefinition classDefinition4 = this.resolvePrimaryWithSuper(aSTree18, bl, n);
                if (classDefinition4 != null) {
                    // empty if block
                }
                List list = this.getArgumetsTypes(aSTreeArray[4]);
                if (classDefinition4 == null) break;
                boolean bl3 = aSTree18 == null && !bl;
                classDefinition = this.usesMethod(string, classDefinition4, list, aSTree, bl3);
                break;
            }
            case 25: {
                ASTree aSTree19 = aSTreeArray[0];
                boolean bl = aSTreeArray[2].getType() == 296;
                ClassDefinition classDefinition5 = this.resolvePrimaryWithSuper(aSTree19, bl, n);
                if (classDefinition5 != null) {
                    // empty if block
                }
                List list = this.getArgumetsTypes(aSTreeArray[3]);
                if (classDefinition5 == null) break;
                classDefinition = this.usesMethod(null, classDefinition5, list, aSTree, false);
                break;
            }
            case 2: {
                ASTree aSTree20 = aSTreeArray[0];
                classDefinition = this.processASTBody(aSTree20);
                this.processASTBody(aSTreeArray[1]);
                if (classDefinition == null) break;
                if (classDefinition instanceof UnresolvedClass) {
                    classDefinition = null;
                    break;
                }
                if (!(classDefinition instanceof Array)) break;
                classDefinition = ((Array)classDefinition).getType();
                break;
            }
            case 47: {
                ASTree aSTree21 = aSTreeArray[0];
                classDefinition = this.processASTBody(aSTree21);
                for (int i = 1; i < aSTreeArray.length; ++i) {
                    this.processASTBody(aSTreeArray[i]);
                }
                break;
            }
            case 48: {
                classDefinition = this.processASTBody(aSTreeArray[1]);
                break;
            }
            case 16: {
                classDefinition = this.processASTBody(aSTreeArray[0]);
                break;
            }
            case 9: {
                ASTree aSTree22 = aSTreeArray[0];
                int n5 = aSTree22.getType();
                if (n5 == 47) {
                    aSTree22 = aSTree22.getSubTrees()[0];
                    n5 = aSTree22.getType();
                }
                if (n5 != 51 && n5 != 45 && n5 != 361 && n5 != 52) {
                    return null;
                }
                classDefinition = this.resolveClassName(aSTree22);
                this.processASTBody(aSTreeArray[1]);
                break;
            }
            case 35: {
                int n6 = aSTreeArray[1].getType();
                Type type = this.processASTBody(aSTreeArray[0]);
                Type type3 = n6 == 282 ? this.resolveClassName(aSTreeArray[2]) : this.processASTBody(aSTreeArray[2]);
                switch (n6) {
                    case 282: 
                    case 319: 
                    case 320: 
                    case 325: 
                    case 326: 
                    case 327: 
                    case 328: 
                    case 329: 
                    case 330: {
                        classDefinition = this.typeClass.resolve("boolean");
                        break block0;
                    }
                    case 333: {
                        if (type instanceof ClassDefinition || type3 instanceof ClassDefinition) {
                            classDefinition = this.resolveClass("java.lang.String");
                            break block0;
                        }
                    }
                    case 334: 
                    case 335: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 339: 
                    case 340: {
                        classDefinition = this.computeType(type, type3);
                        break block0;
                    }
                    case 341: 
                    case 342: 
                    case 343: {
                        if (type == null || !"long".equals(type.getName())) {
                            classDefinition = this.typeClass.resolve("int");
                            break block0;
                        }
                        classDefinition = this.typeClass.resolve("long");
                        break block0;
                    }
                }
                ErrorManager.getDefault().log(16, "Unknown operator " + n6 + " in " + this.getText(aSTree));
                break;
            }
            case 17: {
                this.processASTBody(aSTreeArray[0]);
                classDefinition = this.processASTBody(aSTreeArray[1]);
                this.processASTBody(aSTreeArray[2]);
                break;
            }
            case 6: {
                ASTree aSTree23 = aSTreeArray[0];
                classDefinition = this.processASTBody(aSTree23);
                this.processASTBody(aSTreeArray[2]);
                break;
            }
            case 52: {
                ASTree aSTree24 = aSTreeArray[1];
                classDefinition = this.processASTBody(aSTreeArray[0]);
                if (aSTree24 == null) break;
                classDefinition = this.fullType((Type)classDefinition, this.processAST(aSTree24));
                break;
            }
            case 51: {
                classDefinition = ((SemiPersistentElement)this.getResource()).resolveType(this.getPrimitiveType(aSTreeArray[0]));
                break;
            }
            case 45: 
            case 361: {
                Object object = this.processMultiPartId(aSTree, aSTreeArray);
                if (object instanceof Type) {
                    classDefinition = (Type)object;
                    break;
                }
                return null;
            }
            default: {
                if (aSTreeArray == null) break;
                for (int i = 0; i < aSTreeArray.length; ++i) {
                    this.processASTBody(aSTreeArray[i]);
                }
            }
        }
        this.usesType((Type)classDefinition, aSTree);
        return classDefinition;
    }

    private JavaClassImpl createTransientClasses(ASTree aSTree, JavaClass javaClass) {
        if (aSTree == null) {
            return null;
        }
        ASTree[] aSTreeArray = aSTree.getSubTrees();
        int n = aSTree.getType();
        switch (n) {
            case 13: 
            case 37: 
            case 84: 
            case 89: {
                JavaClassImpl javaClassImpl;
                ASTree aSTree2;
                String string;
                String string2 = (String)this.processAST(aSTreeArray[1]);
                String string3 = string = javaClass == null ? string2 : javaClass.getName().concat(".").concat(string2);
                if (n == 84) {
                    aSTree2 = aSTreeArray[3];
                    javaClassImpl = this.enumClass.create(string, 16384, true);
                } else if (n == 89) {
                    aSTree2 = aSTreeArray[2];
                    javaClassImpl = this.annotClass.create(string, 8192, true);
                } else {
                    int n2 = 0;
                    if (n == 37) {
                        n2 = 512;
                    }
                    aSTree2 = aSTreeArray[5];
                    javaClassImpl = this.jclsClass.create(string, n2, null, null, true);
                }
                if (javaClass != null) {
                    ((JavaClassImpl)javaClassImpl).setParentClass((JavaClassImpl)javaClass);
                }
                this.semanticInfo.put(aSTree, javaClassImpl);
                this.createTransientClasses(aSTree2, javaClassImpl);
                return javaClassImpl;
            }
            case 12: 
            case 38: 
            case 81: 
            case 88: {
                for (int i = 0; i < aSTreeArray.length; ++i) {
                    this.createTransientClasses(aSTreeArray[i], javaClass);
                }
                break;
            }
        }
        return null;
    }

    private void createAnonClass(ASTree aSTree, JavaClass javaClass) {
        Scope scope = new Scope((Scope)this.typeScopeInfo.peek());
        NameRef[] nameRefArray = null;
        NameRef nameRef = (NameRef)SemiPersistentElement.typeToTypeRef((Type)javaClass);
        Token token = this.getToken(aSTree.getFirstToken());
        scope.addMember(Scope.createMemberTypeScope((ClassDefinition)javaClass, this));
        this.typeScopeInfo.push(scope);
        FeatureInfo[] featureInfoArray = (FeatureInfo[])this.processAST(aSTree, "");
        if (javaClass.isInterface()) {
            nameRefArray = new NameRef[]{nameRef};
            nameRef = NameRef.java_lang_Object;
        }
        ClassInfo classInfo = new ClassInfo(aSTree, aSTree.getType(), null, 0, featureInfoArray, nameRef, nameRefArray, null, ElementInfo.EMPTY_ANNOTATIONS);
        this.semanticInfo.put(token, new Scope[]{scope, (Scope)this.variableScope.peek()});
        this.typeScopeInfo.pop();
        this.semanticInfo.put(aSTree, classInfo);
    }

    private Object processIdentifier(Token token) {
        Object object = this.resolveName(token);
        Variable variable = null;
        if (object == null) {
            return null;
        }
        if (object instanceof Variable) {
            variable = (Variable)object;
            object = variable.getType();
            this.usesField(variable, token);
        } else {
            this.storeSemanticInfo(token, object);
            if (object instanceof LocalVarRefInfo) {
                object = ((LocalVarRefInfo)object).type;
            }
        }
        return object;
    }

    private Object processMultiPartId(ASTree aSTree, ASTree[] aSTreeArray) {
        Object object;
        if (aSTree.getType() == 361) {
            return this.processIdentifier((Token)aSTree);
        }
        ASTree aSTree2 = aSTreeArray[0];
        Token token = (Token)aSTreeArray[1];
        Field field = null;
        object = aSTree2 != null ? (!((object = this.processMultiPartId(aSTree2, aSTree2.getSubTrees())) instanceof PrimitiveType) ? this.getMemberOf(object, token) : null) : this.processIdentifier(token);
        if (object != null) {
            if (object instanceof Field) {
                field = (Field)object;
                object = field.getType();
                this.usesField((Variable)field, token);
            } else {
                this.storeSemanticInfo(token, object);
                if (object instanceof LocalVarRefInfo) {
                    object = ((LocalVarRefInfo)object).type;
                }
            }
            if (field != null) {
                this.usesField((Variable)field, aSTree);
            } else {
                this.storeSemanticInfo(aSTree, object);
            }
        }
        this.processASTBody(aSTreeArray[2]);
        return object;
    }

    private Object getMemberOf(Object object, Token token) {
        String string = (String)token.getValue();
        if (object instanceof ClassDefinition) {
            ClassDefinition classDefinition = (ClassDefinition)object;
            Object object2 = null;
            if (!this.resolveClassName) {
                object2 = Scope.createFieldScope(classDefinition).lookup(string);
            }
            if (object2 == null) {
                object2 = Scope.createMemberTypeScope(classDefinition, this).lookup(string);
                if (classDefinition != null && object2 instanceof String) {
                    object2 = this.resolveClass((String)object2);
                }
            }
            if (object2 == null && this.resolveClassName) {
                object2 = this.jclsClass.resolve(classDefinition.getName() + "." + string);
            }
            return object2;
        }
        if (object instanceof JavaPackage) {
            String string2 = ((JavaPackage)object).getName().concat(".").concat(string);
            JavaClass javaClass = this.resolveClass(string2);
            if (javaClass != null) {
                return javaClass;
            }
            return this.getPackage(string2);
        }
        if (object instanceof Array) {
            if (string.equals("length")) {
                return this.typeClass.resolve("int");
            }
            return null;
        }
        return null;
    }

    private Object resolveName(Token token) {
        Scope scope;
        Object object;
        String string = (String)token.getValue();
        if (!this.resolveClassName && (object = (scope = (Scope)this.variableScope.peek()).lookup(string)) != null) {
            return object;
        }
        object = this.staticImpScope.lookup(string);
        if (object != null) {
            return object;
        }
        Scope scope2 = (Scope)this.typeScopeInfo.peek();
        object = scope2.lookup(string);
        if (object != null && object instanceof String) {
            object = this.resolveClass((String)object);
        }
        if (object == null) {
            object = this.resolveClass(string);
        }
        if (object != null) {
            return object;
        }
        object = this.getPackage(string);
        if (object != null) {
            return object;
        }
        return this.typeClass.resolve(string);
    }

    private ClassDefinition resolvePrimaryWithSuper(ASTree aSTree, boolean bl, int n) {
        Type type;
        Object object = aSTree != null ? ((type = !bl || n == 25 ? this.processASTBody(aSTree) : this.resolveClassName(aSTree)) instanceof ClassDefinition ? (ClassDefinition)type : this.jclsClass.resolveClass("java.lang.Object", false)) : this.currentClass;
        if (bl && object != null) {
            object = object.getSuperClass();
        }
        return object;
    }

    private List getArgumetsTypes(ASTree aSTree) {
        ArrayList arrayList = new ArrayList();
        if (aSTree != null) {
            if (aSTree.getType() == 1) {
                ASTree[] aSTreeArray = aSTree.getSubTrees();
                for (int i = 0; i < aSTreeArray.length; ++i) {
                    this.addArgumentToList(arrayList, aSTreeArray[i]);
                }
            } else {
                this.addArgumentToList(arrayList, aSTree);
            }
        }
        return arrayList;
    }

    private Type resolveClassName(ASTree aSTree) {
        this.resolveClassName = true;
        Type type = this.processASTBody(aSTree);
        this.resolveClassName = false;
        return type;
    }

    private void addArgumentToList(List list, ASTree aSTree) {
        Type type = this.processASTBody(aSTree);
        if (type == null) {
            type = this.typeClass.resolve("void");
        }
        list.add(type);
    }

    private int getDimExprsDimenstion(ASTree aSTree) {
        if (aSTree == null) {
            return 0;
        }
        if (aSTree.getType() == 21) {
            return aSTree.getSubTrees().length;
        }
        return 1;
    }

    private Type computeType(Type type, Type type2) {
        if (type == null) {
            return type2;
        }
        if (type2 == null) {
            return type;
        }
        if (type instanceof PrimitiveType && type2 instanceof PrimitiveType) {
            PrimitiveTypeKind primitiveTypeKind = ((PrimitiveType)type).getKind();
            PrimitiveTypeKind primitiveTypeKind2 = ((PrimitiveType)type2).getKind();
            if (primitiveTypeKind.equals(PrimitiveTypeKindEnum.DOUBLE)) {
                return type;
            }
            if (primitiveTypeKind2.equals(PrimitiveTypeKindEnum.DOUBLE)) {
                return type2;
            }
            if (primitiveTypeKind.equals(PrimitiveTypeKindEnum.FLOAT)) {
                return type;
            }
            if (primitiveTypeKind2.equals(PrimitiveTypeKindEnum.FLOAT)) {
                return type2;
            }
            if (primitiveTypeKind.equals(PrimitiveTypeKindEnum.LONG)) {
                return type;
            }
            if (primitiveTypeKind2.equals(PrimitiveTypeKindEnum.LONG)) {
                return type2;
            }
            return this.typeClass.resolve("int");
        }
        ErrorManager.getDefault().log(16, "Invalid types " + type.getName() + " " + type2.getName());
        return null;
    }

    private void usesField(Variable variable, ASTree aSTree) {
        this.storeSemanticInfo(aSTree, variable);
    }

    private void usesType(Type type, ASTree aSTree) {
        this.storeSemanticInfo(aSTree, type);
    }

    private CallableFeature findMethod(ClassDefinition classDefinition, String string, List list) {
        if (classDefinition != null && !(classDefinition instanceof UnresolvedClass)) {
            Type[] typeArray;
            CallableFeature[] callableFeatureArray;
            Object object;
            Object[] objectArray = null;
            if (string == null) {
                object = classDefinition.getContents().toArray();
                callableFeatureArray = new ArrayList();
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    typeArray = object[i];
                    if (!(typeArray instanceof Constructor)) continue;
                    callableFeatureArray.add(typeArray);
                    objectArray = typeArray;
                }
                if (callableFeatureArray.size() > 1) {
                    objectArray = callableFeatureArray;
                }
            } else {
                object = Scope.createMethodScope(classDefinition);
                objectArray = ((MethodScope)object).lookup(string);
            }
            if (objectArray instanceof List) {
                object = (List)objectArray;
                callableFeatureArray = object.toArray(new CallableFeature[object.size()]);
                CallableFeature callableFeature = callableFeatureArray[0];
                typeArray = list.toArray(new Type[list.size()]);
                int n = this.computeParDiff(callableFeature, typeArray.length);
                int n2 = -1;
                boolean bl = false;
                if (n == 0) {
                    bl = this.isAccessible(callableFeature);
                }
                for (int i = 1; i < callableFeatureArray.length; ++i) {
                    int n3;
                    CallableFeature callableFeature2 = callableFeatureArray[i];
                    int n4 = this.computeParDiff(callableFeature2, typeArray.length);
                    if (n4 > 0) {
                        if (n4 >= n) continue;
                        n = n4;
                        callableFeature = callableFeature2;
                        continue;
                    }
                    if (n > 0) {
                        n = 0;
                        callableFeature = callableFeature2;
                        bl = this.isAccessible(callableFeature2);
                        continue;
                    }
                    if (!this.isAccessible(callableFeature2)) continue;
                    if (!bl) {
                        callableFeature = callableFeature2;
                        bl = true;
                        continue;
                    }
                    if (n2 == -1 && (n2 = this.isApplicable(callableFeature, typeArray)) == 0) {
                        return callableFeature;
                    }
                    int n5 = this.isApplicable(callableFeature2, typeArray);
                    if (n5 == 0) {
                        return callableFeature2;
                    }
                    if (n5 == Integer.MAX_VALUE) continue;
                    if (n5 < n2) {
                        n2 = n5;
                        callableFeature = callableFeature2;
                        continue;
                    }
                    if (n5 != n2 || (n3 = this.isApplicable(callableFeature, callableFeature2)) == Integer.MAX_VALUE) continue;
                    if (n3 > 0) {
                        callableFeature = callableFeature2;
                        continue;
                    }
                    if (Modifier.isAbstract(callableFeature2.getModifiers()) || !Modifier.isAbstract(callableFeature.getModifiers())) continue;
                    callableFeature = callableFeature2;
                }
                return callableFeature;
            }
            return (CallableFeature)objectArray;
        }
        return null;
    }

    private int isApplicable(CallableFeature callableFeature, CallableFeature callableFeature2) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Object[] objectArray = callableFeature2.getParameters().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Parameter parameter = (Parameter)objectArray[i];
            arrayList.add(parameter.getType());
        }
        return this.isApplicable(callableFeature, arrayList.toArray(new Type[arrayList.size()]));
    }

    private int isApplicable(CallableFeature callableFeature, Type[] typeArray) {
        Object[] objectArray = callableFeature.getParameters().toArray();
        int n = 0;
        boolean bl = false;
        Type type = null;
        for (int i = 0; i < typeArray.length; ++i) {
            int n2;
            if (i < objectArray.length) {
                Parameter parameter = (Parameter)objectArray[i];
                type = parameter.getType();
            }
            if ((n2 = this.subType(typeArray[i], type)) == Integer.MAX_VALUE) {
                return n2;
            }
            n += n2;
        }
        return n;
    }

    private int subType(Type type, Type type2) {
        if (type == type2) {
            return 0;
        }
        if (type2.getName().equals(type.getName())) {
            return 0;
        }
        if (type instanceof ClassDefinition && type2 instanceof ClassDefinition) {
            return ((ClassDefinition)type).isSubTypeOf((ClassDefinition)type2) ? 1 : Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private int computeParDiff(CallableFeature callableFeature, int n) {
        Object[] objectArray = callableFeature.getParameters().toArray();
        int n2 = objectArray.length;
        boolean bl = false;
        if (n2 > 0) {
            Parameter parameter = (Parameter)objectArray[n2 - 1];
            bl = parameter.isVarArg();
        }
        if (bl && (n2 < n || n2 == n + 1)) {
            return 0;
        }
        return Math.abs(n - n2);
    }

    private boolean isAccessible(CallableFeature callableFeature) {
        int n = callableFeature.getModifiers();
        if (Modifier.isPublic(n)) {
            return true;
        }
        if (Modifier.isPrivate(n)) {
            return callableFeature.getResource().equals(this.getResource());
        }
        boolean bl = callableFeature.getResource().getPackageName().equals(this.getResource().getPackageName());
        if (!Modifier.isProtected(n)) {
            return bl;
        }
        if (bl) {
            return true;
        }
        return this.currentClass.isSubTypeOf(callableFeature.getDeclaringClass());
    }

    private Type usesMethod(String string, ClassDefinition classDefinition, List list, ASTree aSTree, boolean bl) {
        CallableFeature callableFeature = this.findMethod(classDefinition, string, list);
        Type type = null;
        if (callableFeature == null && bl && classDefinition != null) {
            JavaClass javaClass;
            Object object;
            if (classDefinition instanceof JavaClass) {
                type = this.usesMethod(string, ((JavaClass)classDefinition).getDeclaringClass(), list, aSTree, true);
            } else {
                object = classDefinition;
                while ((object = (Element)object.refImmediateComposite()) != null && !(object instanceof ClassDefinition)) {
                }
                type = this.usesMethod(string, (ClassDefinition)object, list, aSTree, true);
            }
            if (type == null && string != null && (object = (String)this.staticImpScope.lookup(string.concat("("))) != null && (javaClass = this.resolveClass((String)object)) != null) {
                return this.usesMethod(string, (ClassDefinition)javaClass, list, aSTree, false);
            }
            return type;
        }
        if (callableFeature != null) {
            this.storeSemanticInfo(aSTree, callableFeature);
            type = callableFeature.getType();
        }
        return type;
    }

    private void storeSemanticInfo(ASTree aSTree, Object object) {
        if (aSTree == null || object == null || this.semanticInfo.get(aSTree) != null) {
            return;
        }
        Object object2 = object instanceof Element ? this.getElementId((Element)object) : object;
        this.semanticInfo.put(aSTree, object2);
    }

    private Object getElementId(Element element) {
        String string = null;
        if (element instanceof ParameterizedType) {
            return this.getElementId((Element)((ParameterizedType)element).getDefinition());
        }
        if (element instanceof ParameterizedTypeImpl.Wrapper) {
            ParameterizedTypeImpl.Wrapper wrapper = (ParameterizedTypeImpl.Wrapper)element;
            return this.getElementId((Element)wrapper.getWrappedObject());
        }
        if (element instanceof UnresolvedClass || element instanceof TypeParameter || element instanceof Type && (!(element instanceof ClassDefinition) || !(element instanceof MetadataElement) || !((MetadataElement)element).isTransient())) {
            SemiPersistentElement semiPersistentElement = (SemiPersistentElement)this.currentClass;
            if (semiPersistentElement == null) {
                semiPersistentElement = (SemiPersistentElement)this.getResource();
            }
            return SemiPersistentElement.typeToTypeRef((Type)element);
        }
        if (element instanceof Parameter || element instanceof MetadataElement && ((MetadataElement)element).isTransient()) {
            return "^".concat(element.refMofId());
        }
        if (element instanceof NamedElement) {
            string = ((NamedElement)element).getName();
        }
        if (element instanceof JavaPackage) {
            return "*".concat(string);
        }
        if (element instanceof Field) {
            Field field = (Field)element;
            return new FieldRefInfo((TypeRef)this.getElementId((Element)field.getDeclaringClass()), string, field.refMofId());
        }
        if (element instanceof CallableFeature) {
            CallableFeature callableFeature = (CallableFeature)element;
            Object[] objectArray = callableFeature.getParameters().toArray();
            TypeRef[] typeRefArray = new TypeRef[objectArray.length];
            for (int i = 0; i < typeRefArray.length; ++i) {
                Parameter parameter = (Parameter)objectArray[i];
                typeRefArray[i] = (TypeRef)this.getElementId((Element)parameter.getType());
            }
            return new CallableRefInfo((TypeRef)this.getElementId((Element)callableFeature.getDeclaringClass()), string, typeRefArray, callableFeature.refMofId());
        }
        JMManager.getLog().log("Invalid type " + element);
        if (element instanceof NamedElement) {
            JMManager.getLog().log("Name " + string);
        }
        return null;
    }

    private static class ModifiersInfo {
        private int modifiers;
        private AnnotationInfo[] annotations;

        ModifiersInfo(int n, AnnotationInfo[] annotationInfoArray) {
            this.modifiers = n;
            this.annotations = annotationInfoArray;
        }
    }

    private static class SuperInfo {
        private JavaClass superClass;
        private List interfaces;

        SuperInfo(JavaClass javaClass, List list) {
            this.superClass = javaClass;
            this.interfaces = list;
        }
    }

    private static class LocalVarRefInfo {
        private Type type;
        private ASTree varDeclAST;
        private Variable var;

        LocalVarRefInfo(ASTree aSTree, Type type) {
            this.varDeclAST = aSTree;
            this.type = type;
        }
    }

    private static class CallableRefInfo
    extends FieldRefInfo {
        private TypeRef[] parTypes;

        CallableRefInfo(TypeRef typeRef, String string, TypeRef[] typeRefArray, String string2) {
            super(typeRef, string, string2);
            this.parTypes = typeRefArray;
        }
    }

    private static class FieldRefInfo {
        private TypeRef declClass;
        private String name;
        private String mofid;

        FieldRefInfo(TypeRef typeRef, String string, String string2) {
            this.declClass = typeRef;
            this.name = string;
            this.mofid = string2;
        }
    }
}

