/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.modules.javacore.ExclusiveMutex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.MDRParser;
import org.netbeans.modules.javacore.parser.MemberClassScope;
import org.netbeans.modules.javacore.parser.MemberFieldScope;
import org.netbeans.modules.javacore.parser.MethodScope;
import org.netbeans.modules.javacore.parser.MethodScopeMember;
import org.netbeans.modules.javacore.parser.PackageImpScope;
import org.netbeans.modules.javacore.parser.ScopeMember;
import org.netbeans.modules.javacore.parser.SingleImpScope;
import org.netbeans.modules.javacore.parser.StaticImportScope;
import org.netbeans.modules.javacore.parser.TypeParamScope;

public class Scope
implements ScopeMember {
    private Scope parentScope;
    private Map positiveCache;
    private Set negativeCache;
    private ArrayList members;
    static final /* synthetic */ boolean $assertionsDisabled;

    Scope(Scope scope) {
        this.parentScope = scope;
        this.positiveCache = new HashMap();
        this.negativeCache = new HashSet();
        this.members = new ArrayList();
    }

    public Object lookup(Object object) {
        Object object2 = this.positiveCache.get(object);
        if (object2 != null) {
            return object2;
        }
        if (!this.negativeCache.contains(object)) {
            object2 = this.lookupMembers(object);
        }
        if (object2 == null && this.parentScope != null) {
            object2 = this.parentScope.lookup(object);
        }
        return object2;
    }

    void addMember(ScopeMember scopeMember) {
        this.positiveCache.clear();
        this.negativeCache.clear();
        this.members.add(scopeMember);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Scope) {
            Scope scope = (Scope)object;
            if (!this.members.equals(scope.members)) {
                return false;
            }
            if (this.parentScope == null) {
                return this.parentScope == scope.parentScope;
            }
            return this.parentScope.equals(scope.parentScope);
        }
        return false;
    }

    protected Object clone() {
        Scope scope = new Scope(this.parentScope);
        scope.members = (ArrayList)this.members.clone();
        return scope;
    }

    private Object lookupMembers(Object object) {
        Iterator iterator = this.members.iterator();
        Object object2 = null;
        while (iterator.hasNext()) {
            ScopeMember scopeMember = (ScopeMember)iterator.next();
            Object object3 = scopeMember.lookup(object);
            if (object3 == null) continue;
            if (object2 == null) {
                object2 = object3;
                continue;
            }
            if (object2.equals(object3)) continue;
            JMManager.getLog().log("Ambiguos reference " + object + ":" + object2 + ":" + object3);
        }
        if (object2 != null) {
            this.positiveCache.put(object, object2);
        } else {
            this.negativeCache.add(object);
        }
        return object2;
    }

    static Scope createMemberTypeScope(ClassDefinition classDefinition, MDRParser mDRParser) {
        if (classDefinition instanceof ParameterizedType) {
            classDefinition = ((ParameterizedType)classDefinition).getDefinition();
        }
        if (classDefinition instanceof UnresolvedClass) {
            return new Scope(null);
        }
        MOFID mOFID = ((BaseObjectHandler)classDefinition)._getMofId();
        Map map = Scope.getCacheFor(Scope.class.getName() + "createMemberTypeScope");
        Scope scope = (Scope)map.get(mOFID);
        if (scope == null) {
            map.put(mOFID, new Scope(null));
            scope = Scope.constructMemberTypeScope(classDefinition, mDRParser);
            map.put(mOFID, scope);
        }
        return scope;
    }

    static Scope constructMemberTypeScope(ClassDefinition classDefinition, MDRParser mDRParser) {
        Object object;
        ArrayList<Scope> arrayList = new ArrayList<Scope>(2);
        Scope scope = null;
        JavaClass javaClass = Scope.getSuperClass(classDefinition, mDRParser);
        Collection collection = Scope.getInterfaces(classDefinition, mDRParser);
        Iterator iterator = collection.iterator();
        if (javaClass != null && !(javaClass instanceof UnresolvedClass)) {
            arrayList.add(Scope.createMemberTypeScope((ClassDefinition)javaClass, mDRParser));
        }
        while (iterator.hasNext()) {
            object = (JavaClass)iterator.next();
            if (object == null || object instanceof UnresolvedClass) continue;
            arrayList.add(Scope.createMemberTypeScope((ClassDefinition)object, mDRParser));
        }
        if (!arrayList.isEmpty()) {
            object = arrayList.iterator();
            scope = new Scope(null);
            while (object.hasNext()) {
                scope.addMember((ScopeMember)object.next());
            }
        }
        Scope scope2 = new Scope(scope);
        if (classDefinition instanceof JavaClass) {
            scope2.addMember(new MemberClassScope((JavaClass)classDefinition));
        }
        return scope2;
    }

    static Scope createTypeScope(String string, ClassPath classPath, ElementInfo[] elementInfoArray) {
        Scope scope = new Scope(null);
        Scope scope2 = new Scope(scope);
        Scope scope3 = new Scope(scope2);
        Scope scope4 = new Scope(scope3);
        scope.addMember(new PackageImpScope("java.lang", classPath));
        scope2.addMember(new PackageImpScope(string, classPath));
        if (elementInfoArray != null) {
            for (int i = 0; i < elementInfoArray.length; ++i) {
                ElementInfo elementInfo = elementInfoArray[i];
                String string2 = elementInfo.name;
                if (elementInfo.infoType == 68) {
                    scope.addMember(new PackageImpScope(string2, classPath));
                    continue;
                }
                scope3.addMember(new SingleImpScope(string2));
            }
        }
        return scope3;
    }

    static Scope createStaticImpScope(Resource resource) {
        Scope scope = new Scope(null);
        Scope scope2 = new Scope(scope);
        Scope scope3 = new Scope(scope2);
        Object[] objectArray = resource.getImports().toArray();
        JavaClassClassImpl javaClassClassImpl = (JavaClassClassImpl)((JavaModelPackage)resource.refImmediatePackage()).getJavaClass();
        for (int i = 0; i < objectArray.length; ++i) {
            String string;
            JavaClass javaClass;
            Import import_ = (Import)objectArray[i];
            if (!import_.isStatic()) continue;
            String string2 = import_.getName();
            if (import_.isOnDemand()) {
                JavaClass javaClass2 = javaClassClassImpl.resolveClass(string2, true);
                if (javaClass2 == null) continue;
                scope.addMember(Scope.createStaticImportScope(javaClass2, null));
                continue;
            }
            int n = string2.lastIndexOf(46);
            if (n == -1 || (javaClass = javaClassClassImpl.resolveClass(string = string2.substring(0, n), true)) == null) continue;
            scope2.addMember(Scope.createStaticImportScope(javaClass, string2.substring(n + 1)));
        }
        return scope2;
    }

    static MethodScope createMethodScope(ClassDefinition classDefinition) {
        if (classDefinition instanceof UnresolvedClass) {
            return new MethodScope(null);
        }
        MOFID mOFID = ((BaseObjectHandler)classDefinition)._getMofId();
        Map map = Scope.getCacheFor(Scope.class.getName() + "createMethodScope");
        MethodScope methodScope = (MethodScope)map.get(mOFID);
        if (methodScope == null) {
            methodScope = Scope.createMethodScopeImpl(classDefinition);
            map.put(mOFID, methodScope);
        }
        return methodScope;
    }

    private static MethodScope createMethodScopeImpl(ClassDefinition classDefinition) {
        JavaClass javaClass = classDefinition.getSuperClass();
        Iterator iterator = classDefinition.getInterfaces().iterator();
        ArrayList<MethodScope> arrayList = new ArrayList<MethodScope>(2);
        if (javaClass != null) {
            arrayList.add(Scope.createMethodScope((ClassDefinition)javaClass));
        }
        while (iterator.hasNext()) {
            JavaClass javaClass2 = (JavaClass)iterator.next();
            if (javaClass2 == null) continue;
            arrayList.add(Scope.createMethodScope((ClassDefinition)javaClass2));
        }
        MethodScope methodScope = new MethodScope(null);
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            methodScope.addMember((ScopeMember)iterator2.next());
        }
        MethodScope methodScope2 = new MethodScope(methodScope);
        methodScope2.addMember(new MethodScopeMember(classDefinition));
        return methodScope2;
    }

    static Scope createStaticImportScope(JavaClass javaClass, String string) {
        if (javaClass instanceof UnresolvedClass) {
            return new Scope(null);
        }
        return Scope.createStaticImportScopeImpl(javaClass, string);
    }

    private static Scope createStaticImportScopeImpl(JavaClass javaClass, String string) {
        JavaClass javaClass2 = javaClass.getSuperClass();
        Iterator iterator = javaClass.getInterfaces().iterator();
        ArrayList<Scope> arrayList = new ArrayList<Scope>(2);
        if (javaClass2 != null) {
            arrayList.add(Scope.createStaticImportScope(javaClass2, string));
        }
        while (iterator.hasNext()) {
            JavaClass javaClass3 = (JavaClass)iterator.next();
            if (javaClass3 == null) continue;
            arrayList.add(Scope.createStaticImportScope(javaClass3, string));
        }
        Scope scope = new Scope(null);
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            scope.addMember((ScopeMember)iterator2.next());
        }
        Scope scope2 = new Scope(scope);
        scope2.addMember(new StaticImportScope(javaClass, string));
        return scope2;
    }

    static Scope createFieldScope(ClassDefinition classDefinition) {
        if (classDefinition instanceof UnresolvedClass) {
            return new Scope(null);
        }
        MOFID mOFID = ((BaseObjectHandler)classDefinition)._getMofId();
        Map map = Scope.getCacheFor(Scope.class.getName() + "createFieldScope");
        Scope scope = (Scope)map.get(mOFID);
        if (scope == null) {
            scope = Scope.createFieldScopeImpl(classDefinition);
            map.put(mOFID, scope);
        }
        return scope;
    }

    private static Scope createFieldScopeImpl(ClassDefinition classDefinition) {
        JavaClass javaClass = classDefinition.getSuperClass();
        Iterator iterator = classDefinition.getInterfaces().iterator();
        ArrayList<Scope> arrayList = new ArrayList<Scope>(2);
        if (javaClass != null) {
            arrayList.add(Scope.createFieldScope((ClassDefinition)javaClass));
        }
        while (iterator.hasNext()) {
            JavaClass javaClass2 = (JavaClass)iterator.next();
            if (javaClass2 == null) continue;
            arrayList.add(Scope.createFieldScope((ClassDefinition)javaClass2));
        }
        Scope scope = new Scope(null);
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            scope.addMember((ScopeMember)iterator2.next());
        }
        Scope scope2 = new Scope(scope);
        scope2.addMember(new MemberFieldScope(classDefinition));
        return scope2;
    }

    private static Map getCacheFor(String string) {
        HashMap hashMap;
        ExclusiveMutex exclusiveMutex = JMManager.getTransactionMutex();
        Map map = exclusiveMutex.getParserCache();
        SoftReference softReference = (SoftReference)map.get(string);
        HashMap hashMap2 = hashMap = softReference == null ? null : (HashMap)softReference.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(string, new SoftReference(hashMap));
        }
        return hashMap;
    }

    private static JavaClass getSuperClass(ClassDefinition classDefinition, MDRParser mDRParser) {
        if (mDRParser != null) {
            return mDRParser.getSuperClass(classDefinition);
        }
        return classDefinition.getSuperClass();
    }

    private static Collection getInterfaces(ClassDefinition classDefinition, MDRParser mDRParser) {
        if (mDRParser != null) {
            return mDRParser.getInterfaces(classDefinition);
        }
        return classDefinition.getInterfaces();
    }

    public static Scope createTypeScope(Resource resource, ClassPath classPath) {
        String string = resource.getPackageName();
        List list = resource.getImports();
        Iterator iterator = list.iterator();
        ArrayList<ElementInfo> arrayList = new ArrayList<ElementInfo>();
        while (iterator.hasNext()) {
            Import import_ = (Import)iterator.next();
            if (import_.isStatic()) continue;
            int n = import_.isOnDemand() ? 68 : 54;
            arrayList.add(new ElementInfo(null, n, import_.getName()));
        }
        return Scope.createTypeScope(string, classPath, arrayList.toArray(new ElementInfo[arrayList.size()]));
    }

    public static Scope computeTypeScope(Element element) {
        Scope scope;
        if (element instanceof JavaClass) {
            ClassPath classPath;
            Scope scope2;
            JavaClass javaClass = (JavaClass)element;
            ClassDefinition classDefinition = javaClass.getDeclaringClass();
            if (element instanceof JavaClassImpl && ((JavaClassImpl)element).isTransient() && classDefinition == null) {
                scope2 = Scope.computeTypeScope((Element)JavaModelUtil.getDeclaringFeature((Element)element.refImmediateComposite()));
            } else if (classDefinition == null) {
                classPath = JavaMetamodel.getManager().getClassPath();
                scope2 = Scope.createTypeScope(element.getResource(), classPath);
            } else {
                scope2 = Scope.computeTypeScope((Element)classDefinition);
            }
            scope = new Scope(scope2);
            scope.addMember(Scope.createMemberTypeScope((ClassDefinition)javaClass, null));
            Iterator iterator = javaClass.getTypeParameters().iterator();
            while (iterator.hasNext()) {
                classPath = (TypeParameter)iterator.next();
                scope.addMember(new TypeParamScope((TypeParameter)classPath));
            }
        } else if (element instanceof ClassMember) {
            ClassMember classMember = (ClassMember)element;
            scope = Scope.computeTypeScope((Element)classMember.getDeclaringClass());
            if (classMember instanceof CallableFeature) {
                CallableFeature callableFeature = (CallableFeature)classMember;
                scope = new Scope(scope);
                Iterator iterator = callableFeature.getTypeParameters().iterator();
                while (iterator.hasNext()) {
                    TypeParameter typeParameter = (TypeParameter)iterator.next();
                    scope.addMember(new TypeParamScope(typeParameter));
                }
            }
        } else if (element instanceof ClassDefinition) {
            Scope scope3 = Scope.computeTypeScope((Element)JavaModelUtil.getDeclaringFeature(element));
            scope = new Scope(scope3);
            scope.addMember(Scope.createMemberTypeScope((ClassDefinition)element, null));
        } else {
            Feature feature = JavaModelUtil.getDeclaringFeature(element);
            if (!$assertionsDisabled && feature == null) {
                throw new AssertionError((Object)("Invalid element " + element));
            }
            scope = Scope.computeTypeScope((Element)feature);
        }
        return scope;
    }

    static {
        $assertionsDisabled = !Scope.class.desiredAssertionStatus();
    }
}

