/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.io.IOException;
import java.io.Reader;
import org.netbeans.modules.javacore.JMManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;

public class Util {
    static final String ATTR_FILE_ENCODING = "Content-Encoding";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String getFileEncoding(FileObject fileObject) {
        String string = (String)fileObject.getAttribute(ATTR_FILE_ENCODING);
        if (string == null) {
            string = JMManager.getDefaultEncoding();
        }
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    public static String readContents(Reader reader, long l) throws IOException {
        long l2;
        if (!$assertionsDisabled && l >= Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        char[] cArray = new char[(int)l];
        int n = 0;
        while (n < cArray.length && (l2 = (long)reader.read(cArray, n, cArray.length - n)) != -1L) {
            n = (int)((long)n + l2);
        }
        return new String(cArray, 0, n);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(CloneableEditorSupport.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    public static boolean isModified(FileObject fileObject) {
        return Util.getModifiedDataObject(fileObject) != null;
    }

    public static DataObject getModifiedDataObject(FileObject fileObject) {
        DataObject[] dataObjectArray = DataObject.getRegistry().getModified();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            FileObject fileObject2 = dataObjectArray[i].getPrimaryFile();
            if (fileObject2 == null || !fileObject2.isValid() || !fileObject2.equals(fileObject)) continue;
            return dataObjectArray[i];
        }
        JMManager.ModifiedDOProvider modifiedDOProvider = JMManager.ModifiedDOProvider.getModifiedDOProvider();
        if (modifiedDOProvider != null) {
            return modifiedDOProvider.getModifiedDataObject(fileObject);
        }
        return null;
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
    }
}

