/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.scanning;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.AnnotationTypeClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaEnumClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.scanning.FObjectInfo;
import org.netbeans.modules.javacore.scanning.FileInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class ClassUpdater {
    private Map fileObjectToClassFile;
    private Map nameToResource;
    private Map resourceToSuperCodes;
    private Map unmodifiedResources;
    private Map resourceToClasses;
    private ResourceClassImpl resProxy;
    private JavaClassClassImpl clsProxy;
    private JavaEnumClassImpl enumProxy;
    private AnnotationTypeClassImpl annoProxy;
    private ClassIndex classIndex;
    private ResourceImpl updatedResource;
    private long indexTimestamp;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassUpdater(JavaModelPackage javaModelPackage) {
        this.clsProxy = (JavaClassClassImpl)javaModelPackage.getJavaClass();
        this.enumProxy = (JavaEnumClassImpl)javaModelPackage.getJavaEnum();
        this.resProxy = (ResourceClassImpl)javaModelPackage.getResource();
        this.annoProxy = (AnnotationTypeClassImpl)javaModelPackage.getAnnotationType();
        this.classIndex = ClassIndex.getIndex(javaModelPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateIndex(ResourceImpl resourceImpl, FileObject fileObject) {
        JavaMetamodel.getDefaultRepository().beginTrans(false);
        try {
            JavaModelPackage javaModelPackage = (JavaModelPackage)resourceImpl.refOutermostPackage();
            HashMap<String, FObjectInfo> hashMap = new HashMap<String, FObjectInfo>();
            String string = fileObject.getNameExt();
            String string2 = fileObject.getName().concat("$");
            String string3 = fileObject.getExt();
            FileObject[] fileObjectArray = fileObject.getChildren();
            hashMap.put(string, new FObjectInfo(fileObject));
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject2 = fileObjectArray[i];
                if (!string3.equals(fileObject2.getExt()) || !fileObject2.getName().startsWith(string2)) continue;
                hashMap.put(fileObject2.getNameExt(), new FObjectInfo(fileObject2));
            }
            ClassUpdater classUpdater = new ClassUpdater(javaModelPackage);
            classUpdater.updatedResource = resourceImpl;
            classUpdater.updateResources(Collections.EMPTY_MAP, hashMap);
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans();
        }
    }

    public Collection updateResources(Map map, Map map2) {
        Object object;
        Object object2;
        Object object3;
        this.indexTimestamp = this.classIndex.getTimestamp();
        this.unmodifiedResources = new HashMap();
        this.fileObjectToClassFile = new HashMap();
        this.nameToResource = new HashMap();
        this.resourceToClasses = new HashMap();
        this.resourceToSuperCodes = new HashMap();
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Set set;
            ClassFile classFile;
            Map.Entry entry = iterator.next();
            object3 = (String)entry.getKey();
            int n = ((String)object3).indexOf(36);
            Object object4 = n > -1 ? ((String)object3).substring(0, n) + ".class" : object3;
            object2 = ((String)object4).substring(0, ((String)object4).length() - ".class".length()) + ".java";
            if (map.containsKey(object2) || (classFile = this.getClassFile((FileInfo)(object = (FileInfo)entry.getValue()))) == null || this.isAnonymous(classFile) || (set = this.getSuperCodes((String)object4, map2)) == null) continue;
            this.addFileToMap((String)object4, classFile);
            this.addSuperCodes(set, classFile);
        }
        iterator = this.resourceToSuperCodes.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object3 = iterator.next();
            Set set = (Set)object3.getValue();
            int n2 = set.size();
            object2 = new int[n2];
            Iterator iterator2 = set.iterator();
            for (int i = 0; i < n2; ++i) {
                object2[i] = (Integer)iterator2.next();
            }
            object = (ResourceImpl)((Object)object3.getKey());
            this.classIndex.setIdentifiers((Resource)object, (int[])object2);
            ++n;
        }
        iterator = this.nameToResource.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            object3 = (String)entry.getKey();
            ResourceImpl resourceImpl = (ResourceImpl)((Object)entry.getValue());
            this.updateClasses((String)object3, resourceImpl);
        }
        ArrayList arrayList = new ArrayList(this.resourceToSuperCodes.keySet());
        arrayList.addAll(this.unmodifiedResources.values());
        return arrayList;
    }

    public void addSuperCodes(Set set, ClassFile classFile) {
        ClassName className = classFile.getSuperClass();
        if (className != null) {
            set.add(this.nameToHashCode(className));
        }
        Iterator iterator = classFile.getInterfaces().iterator();
        while (iterator.hasNext()) {
            set.add(this.nameToHashCode((ClassName)iterator.next()));
        }
    }

    private Set getSuperCodes(String string, Map map) {
        if (this.unmodifiedResources.containsKey(string)) {
            return null;
        }
        Resource resource = (Resource)this.nameToResource.get(string);
        if (resource == null) {
            FileInfo fileInfo = (FileInfo)map.get(string);
            if (fileInfo == null) {
                this.unmodifiedResources.put(string, null);
                JMManager.getLog().log("ClassUpdater, cannot find file object: " + string);
                return null;
            }
            if (this.updatedResource != null) {
                if (!$assertionsDisabled && !this.updatedResource.getName().endsWith(string)) {
                    throw new AssertionError((Object)(this.updatedResource.getName() + " " + string));
                }
                resource = this.updatedResource;
            } else {
                resource = this.resProxy.resolveResource(fileInfo.getPath(), true, false);
            }
            long l = fileInfo.lastModified();
            if (resource.getTimestamp() != l || this.indexTimestamp < l) {
                resource.setTimestamp(l);
                this.nameToResource.put(string, resource);
                HashSet hashSet = new HashSet();
                this.resourceToSuperCodes.put(resource, hashSet);
                return hashSet;
            }
            this.unmodifiedResources.put(string, resource);
            return null;
        }
        return (Set)this.resourceToSuperCodes.get(resource);
    }

    public String getSimpleName(ClassName className) {
        String string = className.getSimpleName();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public Integer nameToHashCode(ClassName className) {
        return new Integer(this.getSimpleName(className).hashCode());
    }

    public boolean isAnonymous(ClassFile classFile) {
        String string = classFile.getName().getSimpleName();
        int n = string.lastIndexOf(46) + 1;
        if (string.length() == n) {
            JMManager.getLog().log("ClassUpdater, class name ends with a dot: " + string);
        }
        return n > 0 && string.length() > n && Character.isDigit(string.charAt(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFile getClassFile(FileInfo fileInfo) {
        ClassFile classFile = (ClassFile)this.fileObjectToClassFile.get(fileInfo);
        if (classFile == null) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInfo.getInputStream());
                try {
                    classFile = new ClassFile((InputStream)bufferedInputStream, false);
                    this.fileObjectToClassFile.put(fileInfo, classFile);
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            catch (InvalidClassFormatException invalidClassFormatException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.log(1, "invalid class file format: " + fileInfo.getPath());
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)iOException, 4096, fileInfo.getName(), null, null, null);
                errorManager.notify(1, (Throwable)iOException);
            }
        }
        return classFile;
    }

    public void addFileToMap(String string, ClassFile classFile) {
        HashMap<String, ClassFile> hashMap = (HashMap<String, ClassFile>)this.resourceToClasses.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, ClassFile>();
            this.resourceToClasses.put(string, hashMap);
        }
        hashMap.put(classFile.getName().getSimpleName(), classFile);
    }

    public void updateClasses(String string, ResourceImpl resourceImpl) {
        Object object;
        List list = resourceImpl.getNakedClassifiers();
        Map map = (Map)this.resourceToClasses.get(string);
        HashMap hashMap = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (RefObject)iterator.next();
            iterator.remove();
            object.refDelete();
        }
        while (map.size() > 0) {
            object = map.entrySet().iterator().next();
            ClassFile classFile = (ClassFile)object.getValue();
            this.createJavaClass(resourceImpl, list, classFile, map, hashMap);
        }
    }

    private JavaClassImpl createJavaClass(ResourceImpl resourceImpl, Collection collection, ClassFile classFile, Map map, Map map2) {
        String string;
        ClassName className = classFile.getName();
        String string2 = className.getExternalName();
        String string3 = className.getSimpleName();
        int n = string3.lastIndexOf(46);
        JavaClassImpl javaClassImpl = null;
        if (n > -1 && (javaClassImpl = (JavaClassImpl)((Object)map2.get(string = string3.substring(0, n)))) == null) {
            ClassFile classFile2 = (ClassFile)map.get(string);
            if (classFile2 == null) {
                map.remove(string3);
                return null;
            }
            javaClassImpl = this.createJavaClass(resourceImpl, collection, classFile2, map, map2);
        }
        string = className.getPackage();
        resourceImpl._setPackageName(string);
        int n2 = classFile.getAccess() & 0xFFFFFFDF | (classFile.isDeprecated() ? Integer.MIN_VALUE : 0);
        JavaClassImpl javaClassImpl2 = classFile.isAnnotation() ? this.annoProxy.create(string2, n2, false) : (classFile.isEnum() ? this.enumProxy.create(string2, n2, false) : this.clsProxy.create(string2, n2, null, null, false));
        if (javaClassImpl != null) {
            javaClassImpl2.setParentClass(javaClassImpl);
        } else {
            collection.add(javaClassImpl2);
        }
        map2.put(string3, javaClassImpl2);
        map.remove(string3);
        return javaClassImpl2;
    }

    static {
        $assertionsDisabled = !ClassUpdater.class.desiredAssertionStatus();
    }
}

