/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.scanning;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.javacore.scanning.FileInfo;
import org.openide.ErrorManager;

class FileEntry
implements FileInfo {
    private File file;
    private String path;

    public FileEntry(File file, String string) {
        this.file = file;
        this.path = string;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public FileInfo[] listFiles() {
        File[] fileArray;
        if (this.isDirectory() && (fileArray = this.file.listFiles()) != null) {
            FileInfo[] fileInfoArray = new FileInfo[fileArray.length];
            String string = this.path;
            if (this.path.length() > 0) {
                string = this.path.concat("/");
            }
            for (int i = 0; i < fileInfoArray.length; ++i) {
                File file = fileArray[i];
                fileInfoArray[i] = new FileEntry(file, string.concat(file.getName()));
            }
            return fileInfoArray;
        }
        return EMPTY_ARR;
    }

    public String getPath() {
        return this.path;
    }

    public String getCanonicalName() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return this.getName();
        }
    }
}

