/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.scanning;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.jmi.javamodel.Codebase;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.ExclusiveMutex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.ProgressDisplayer;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.scanning.ClassUpdater;
import org.netbeans.modules.javacore.scanning.FileEntry;
import org.netbeans.modules.javacore.scanning.FileInfo;
import org.netbeans.modules.javacore.scanning.JavaUpdater;
import org.netbeans.modules.javacore.scanning.ZipArchiveInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class FileScanner {
    private ClassUpdater classUpdater;
    private JavaUpdater javaUpdater;
    private File root;
    private String offset;
    private Codebase codebase;
    private JavaModelPackage mofPackage;
    private Collection resources;
    private Collection resourcesToScan;
    private boolean zipFile;
    private final ExclusiveMutex mutex;
    private static HashSet ignoredDirectories;
    private static HashSet ignoredPackages;
    private static HashSet eagerlyParse;
    private final boolean isRescan;
    private static final boolean DEBUG = false;
    private static ProgressDisplayer progress;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileScanner(URL uRL, String string, Codebase codebase) throws IllegalArgumentException {
        this(uRL, string, codebase, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileScanner(URL uRL, String string, Codebase codebase, boolean bl) throws IllegalArgumentException {
        Object object = FileScanner.class;
        synchronized (object) {
            if (ignoredPackages == null) {
                ignoredPackages = FileScanner.parseSet("org.netbeans.javacore.ignorePackages", "sun sunw");
                ignoredDirectories = FileScanner.parseSet("org.netbeans.javacore.ignoreDirectories", "SCCS CVS");
                eagerlyParse = FileScanner.parseSet("org.netbeans.javacore.eagerlyParse", "javax/swing/JFrame.java");
            }
        }
        this.isRescan = bl;
        if ("jar".equals(uRL.getProtocol())) {
            object = uRL.toExternalForm();
            int n = ((String)object).lastIndexOf("!/") + 2;
            if (!($assertionsDisabled || n > 0 && n <= ((String)object).length())) {
                throw new AssertionError((Object)"Invalid jar protocol URL");
            }
            this.offset = n == ((String)object).length() ? null : ((String)object).substring(n);
            uRL = FileUtil.getArchiveFile((URL)uRL);
            this.zipFile = true;
        }
        if (!"file".equals(uRL.getProtocol())) {
            throw new IllegalArgumentException("The URL: " + uRL.toExternalForm() + " has no file protocol.");
        }
        object = URI.create(uRL.toExternalForm());
        this.root = new File((URI)object);
        this.codebase = codebase;
        this.mofPackage = (JavaModelPackage)this.codebase.refImmediatePackage();
        this.mutex = JMManager.getTransactionMutex();
        if (!bl) {
            this.javaUpdater = new JavaUpdater(this.mofPackage, string, this);
        }
        this.classUpdater = new ClassUpdater(this.mofPackage);
    }

    private static HashSet parseSet(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty(string, string2), " \t\n\r\f,-:+!");
        HashSet<String> hashSet = new HashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    void checkParseEagerly(Resource resource) {
        if (eagerlyParse.contains(resource.getName())) {
            if (this.resourcesToScan == null) {
                this.resourcesToScan = new ArrayList(eagerlyParse.size());
            }
            this.resourcesToScan.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    public Resource[] scan() {
        Resource[] resourceArray;
        long l;
        NBMDRepositoryImpl nBMDRepositoryImpl = (NBMDRepositoryImpl)JavaMetamodel.getDefaultRepository();
        if (!this.isRescan) {
            nBMDRepositoryImpl.disableEvents();
        }
        this.resourcesToScan = null;
        ZipArchiveInfo zipArchiveInfo = null;
        ClassIndex classIndex = null;
        if (!this.zipFile) break block19;
        long l2 = this.codebase.getTimestamp();
        classIndex = ClassIndex.getIndex(this.mofPackage);
        if (l2 == 0L || l2 != (l = this.root.lastModified()) || classIndex.getTimestamp() < l) break block20;
        Resource[] resourceArray2 = new Resource[]{};
        Object var11_9 = null;
        try {
            if (zipArchiveInfo != null) {
                zipArchiveInfo.close();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        {
            void var2_19;
            block19: {
                block20: {
                    return resourceArray2;
                }
                try {
                    zipArchiveInfo = new ZipArchiveInfo(this.root, this.offset);
                    FileInfo fileInfo = zipArchiveInfo.getRootFileInfo();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    Resource[] resourceArray3 = null;
                    Object var11_10 = null;
                    try {
                        if (zipArchiveInfo != null) {
                            zipArchiveInfo.close();
                        }
                    }
                    catch (IOException iOException2) {
                        ErrorManager.getDefault().notify((Throwable)iOException2);
                    }
                    return resourceArray3;
                }
            }
            FileEntry fileEntry = new FileEntry(this.root, "");
            this.resources = new HashSet(this.mofPackage.getResource().refAllOfClass());
            this.scanPackage((FileInfo)var2_19, "", new HashSet());
            if (this.zipFile) {
                if (classIndex != null) {
                    classIndex.setTimestamp();
                }
                this.codebase.setTimestamp(this.root.lastModified());
                this.codebase.setLibrary(true);
            }
            this.removeFromRepository();
            resourceArray = this.resourcesToScan == null ? new Resource[]{} : this.resourcesToScan.toArray(new Resource[this.resourcesToScan.size()]);
        }
        Object var11_11 = null;
        try {
            if (zipArchiveInfo != null) {
                zipArchiveInfo.close();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return resourceArray;
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                if (zipArchiveInfo != null) {
                    zipArchiveInfo.close();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            throw throwable;
        }
    }

    private void removeFromRepository() {
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            ((Resource)iterator.next()).refDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanPackage(FileInfo fileInfo, String string, Set set) {
        Object object;
        if (ignoredPackages.contains(string)) {
            return;
        }
        String string2 = fileInfo.getCanonicalName();
        if (string2 != null && !set.add(string2)) {
            return;
        }
        FileInfo[] fileInfoArray = fileInfo.listFiles();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (int i = 0; i < fileInfoArray.length; ++i) {
            object = fileInfoArray[i];
            String string3 = object.getName();
            if (object.isDirectory()) {
                String string4;
                block24: {
                    if (ignoredDirectories.contains(string3) || !Utilities.isJavaIdentifier((String)string3)) continue;
                    if (this.mutex.isSwingWaiting()) {
                        Object var14_15;
                        string4 = (NBMDRepositoryImpl)JMManager.getDefaultRepository();
                        try {
                            try {
                                string4.endTrans();
                                while (this.mutex.isSwingWaiting()) {
                                    Thread.sleep(100L);
                                }
                                var14_15 = null;
                            }
                            catch (InterruptedException interruptedException) {
                                var14_15 = null;
                                string4.beginTrans(true);
                                if (!this.isRescan) {
                                    string4.disableEvents();
                                }
                                break block24;
                            }
                        }
                        catch (Throwable throwable) {
                            var14_15 = null;
                            string4.beginTrans(true);
                            if (!this.isRescan) {
                                string4.disableEvents();
                            }
                            throw throwable;
                        }
                        string4.beginTrans(true);
                        if (!this.isRescan) {
                            string4.disableEvents();
                        }
                    }
                }
                string4 = string;
                if (string.length() != 0) {
                    string4 = string.concat(".");
                }
                string4 = string4.concat(string3);
                this.scanPackage((FileInfo)object, string4, set);
                continue;
            }
            if (string3 == null) continue;
            if (string3.endsWith(".java")) {
                hashMap.put(string3, object);
                continue;
            }
            if (!string3.endsWith(".class")) continue;
            hashMap2.put(string3, object);
        }
        if (!hashMap.isEmpty() || !hashMap2.isEmpty()) {
            if (this.isRescan) {
                Iterator iterator = hashMap.values().iterator();
                object = new ArrayList();
                while (iterator.hasNext()) {
                    FileInfo fileInfo2 = (FileInfo)iterator.next();
                    try {
                        String string5 = fileInfo2.getPath();
                        long l = fileInfo2.lastModified();
                        ResourceImpl resourceImpl = (ResourceImpl)((ResourceClassImpl)this.mofPackage.getResource()).resolveResource(string5, true, false);
                        if (resourceImpl.getTimestamp() != l) {
                            FileObject fileObject = JavaMetamodel.getManager().getFileObject(resourceImpl);
                            if (fileObject == null || !fileObject.isValid()) continue;
                            this.resources.remove((Object)resourceImpl);
                            resourceImpl.updateFromFileObject(fileObject, true);
                            continue;
                        }
                        this.resources.remove((Object)resourceImpl);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                }
            } else {
                progress = ProgressDisplayer.getVisibleProgressDisplayer();
                if (progress != null) {
                    progress.updatePackage(string);
                }
                this.resources.removeAll(this.javaUpdater.updateResources(hashMap));
            }
            this.resources.removeAll(this.classUpdater.updateResources(hashMap, hashMap2));
        }
    }

    static {
        $assertionsDisabled = !FileScanner.class.desiredAssertionStatus();
    }
}

