/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.scanning;

import org.netbeans.modules.javacore.JMManager;

final class IntSet {
    private Entry[] table;
    private int size;
    private static final int LOAD_FACTOR = 2;
    private static final int GROWTH_FACTOR = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IntSet() {
        this(2048);
    }

    public IntSet(int n) {
        this.table = new Entry[n];
    }

    public boolean add(int n) {
        Entry entry;
        if (this.contains(n)) {
            return false;
        }
        if (this.size > this.table.length / 2) {
            this.resize();
        }
        int n2 = IntSet.hash(n);
        int n3 = IntSet.indexFor(n2, this.table.length);
        this.table[n3] = entry = new Entry(n, n2, this.table[n3]);
        ++this.size;
        return true;
    }

    public boolean contains(int n) {
        int n2 = IntSet.hash(n);
        Entry entry = this.table[IntSet.indexFor(n2, this.table.length)];
        while (entry != null) {
            if (entry.value == n) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        int n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                nArray[n++] = entry.value;
                entry = entry.next;
            }
        }
        if (!$assertionsDisabled && n != this.size) {
            throw new AssertionError();
        }
        return nArray;
    }

    private void resize() {
        Entry[] entryArray = new Entry[this.table.length * 2];
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                int n = IntSet.indexFor(entry.hash, entryArray.length);
                Entry entry2 = entry.next;
                entry.next = entryArray[n];
                entryArray[n] = entry;
                entry = entry2;
            }
        }
        this.table = entryArray;
        JMManager.getLog().log("IntSet: table doubled to " + this.table.length);
    }

    private static int hash(int n) {
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    private static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    static {
        $assertionsDisabled = !IntSet.class.desiredAssertionStatus();
    }

    static class Entry {
        int value;
        int hash;
        Entry next;

        Entry(int n, int n2, Entry entry) {
            this.value = n;
            this.hash = n2;
            this.next = entry;
        }
    }
}

