/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.scanning;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.AnnotationTypeClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaEnumClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.parser.TokenIterator;
import org.netbeans.modules.javacore.scanning.FileInfo;
import org.netbeans.modules.javacore.scanning.FileScanner;
import org.netbeans.modules.javacore.scanning.IntSet;
import org.openide.ErrorManager;

public class JavaUpdater {
    private final JavaClassClassImpl jclsClass;
    private final JavaEnumClassImpl enumClass;
    private final AnnotationTypeClassImpl annTypeClass;
    private final ResourceClassImpl resourceClass;
    private final ClassIndex classIndex;
    private final String sourceLevel;
    private final FileScanner fileScanner;
    private static final int[] NULL_INTS = new int[0];

    public JavaUpdater(JavaModelPackage javaModelPackage, String string, FileScanner fileScanner) {
        this.jclsClass = (JavaClassClassImpl)javaModelPackage.getJavaClass();
        this.enumClass = (JavaEnumClassImpl)javaModelPackage.getJavaEnum();
        this.resourceClass = (ResourceClassImpl)javaModelPackage.getResource();
        this.annTypeClass = (AnnotationTypeClassImpl)javaModelPackage.getAnnotationType();
        this.sourceLevel = string;
        this.classIndex = ClassIndex.getIndex(javaModelPackage);
        this.fileScanner = fileScanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] computeIndex(ResourceImpl resourceImpl, TokenIterator tokenIterator) {
        JavaMetamodel.getDefaultRepository().beginTrans(false);
        try {
            int[] nArray = this.makeIndex(resourceImpl, tokenIterator, false);
            return nArray;
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans();
        }
    }

    private int[] makeIndex(ResourceImpl resourceImpl, TokenIterator tokenIterator, boolean bl) {
        int[] nArray = NULL_INTS;
        boolean bl2 = resourceImpl.isInitialized();
        HashSet<JavaClassImpl> hashSet = new HashSet<JavaClassImpl>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        List list = resourceImpl.getPersistentClassifiers();
        Set set = this.getAllClassesFromResource(resourceImpl, list);
        if (!bl2) {
            list.clear();
        }
        try {
            boolean bl3;
            boolean bl4;
            Object object;
            JavaClassImpl javaClassImpl;
            Object object2;
            int n;
            IntSet intSet = new IntSet();
            boolean bl5 = false;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Object object3 = "";
            Stack<Object> stack = new Stack<Object>();
            int n5 = 0;
            boolean bl6 = false;
            while ((n = tokenIterator.getNextTokenType()) != 0) {
                String string;
                object2 = null;
                if (n == 361) {
                    int n6 = tokenIterator.getIdentifierHash();
                    intSet.add(n6);
                }
                if (tokenIterator.isDeprecated()) {
                    n4 |= Integer.MIN_VALUE;
                }
                switch (n) {
                    case 291: {
                        n4 |= 1;
                        break;
                    }
                    case 290: {
                        n4 |= 4;
                        break;
                    }
                    case 289: {
                        n4 |= 2;
                        break;
                    }
                    case 257: {
                        n4 |= 0x400;
                        break;
                    }
                    case 294: {
                        n4 |= 8;
                        break;
                    }
                    case 274: {
                        n4 |= 0x10;
                        break;
                    }
                    case 298: {
                        n4 |= 0x20;
                        break;
                    }
                    case 286: {
                        n4 |= 0x100;
                        break;
                    }
                    case 295: {
                        n4 |= 0x800;
                        break;
                    }
                    case 302: {
                        n4 |= 0x80;
                        break;
                    }
                    case 305: {
                        n4 |= 0x40;
                        break;
                    }
                    case 313: {
                        n4 = tokenIterator.isDeprecated() ? Integer.MIN_VALUE : 0;
                        break;
                    }
                    case 309: {
                        ++n5;
                        n4 = tokenIterator.isDeprecated() ? Integer.MIN_VALUE : 0;
                        break;
                    }
                    case 310: {
                        if (n5 == stack.size() && !stack.isEmpty()) {
                            stack.pop();
                        }
                        --n5;
                    }
                }
                if (n2 == 316 && n == 361 && ((string = tokenIterator.getIdentifierText()).equals("Deprecated") || string.equals("java.lang.Deprecated"))) {
                    n4 |= Integer.MIN_VALUE;
                }
                switch (n3) {
                    case 0: {
                        if (n == 288) {
                            n3 = 1;
                            break;
                        }
                        if (n != 265 && n != 284 && n != 272 || n2 == 315) break;
                        if (!bl6) {
                            if (JMManager.INCONSISTENCY_DEBUG) {
                                System.err.println("JavaUpdater: Setting package name of resource " + resourceImpl.getName() + " to " + (String)object3);
                            }
                            resourceImpl._setPackageName((String)object3);
                            bl6 = true;
                        }
                        if (n2 == 316 && n == 284) {
                            n4 |= 0x2000;
                            intSet.add("Annotation".hashCode());
                        }
                        n3 = 2;
                        break;
                    }
                    case 1: {
                        if (n == 361) {
                            object2 = tokenIterator.getIdentifierText();
                        }
                        if (object2 != null) {
                            object3 = ((String)object3).length() == 0 ? object2 : (String)object3 + '.' + (String)object2;
                        }
                        if (n != 313) break;
                        n3 = 0;
                        break;
                    }
                    case 2: {
                        if (n == 361) {
                            object2 = tokenIterator.getIdentifierText();
                        }
                        if (n5 == stack.size() && object2 != null) {
                            javaClassImpl = null;
                            if (!stack.empty()) {
                                javaClassImpl = (JavaClassImpl)((Object)stack.peek());
                            }
                            String string2 = this.constructFqn((String)object3, stack, (String)object2);
                            if (n2 == 284) {
                                n4 |= 0x200;
                            } else if (n2 == 272) {
                                n4 |= 0x4000;
                                intSet.add("Enum".hashCode());
                            }
                            object = this.createJavaClass(string2, n4, bl, (String)object2, set, hashSet2, javaClassImpl);
                            hashSet2.add(object);
                            stack.push(object);
                            set.remove(object);
                            if (object.refImmediateComposite() == null) {
                                if (javaClassImpl != null) {
                                    bl4 = javaClassImpl.contentsInited();
                                    bl3 = javaClassImpl.isPersisted();
                                    if (bl3) {
                                        javaClassImpl.getPersistentContents().add(object);
                                        if (bl4) {
                                            hashSet.add(javaClassImpl);
                                        }
                                    } else {
                                        ((JavaClassImpl)((Object)object)).setParentClass(javaClassImpl);
                                    }
                                } else {
                                    list.add(object);
                                }
                            }
                        }
                        n3 = 0;
                    }
                }
                n2 = n;
            }
            if (!bl6) {
                if (JMManager.INCONSISTENCY_DEBUG) {
                    System.err.println("JavaUpdater: Setting package name of resource " + resourceImpl.getName() + " to " + (String)object3);
                }
                resourceImpl._setPackageName((String)object3);
            }
            nArray = intSet.toArray();
            object2 = set.iterator();
            while (object2.hasNext()) {
                JavaClassImpl javaClassImpl2 = (JavaClassImpl)((Object)object2.next());
                if (!javaClassImpl2.isValid()) continue;
                object = javaClassImpl2.refImmediateComposite();
                if (object == resourceImpl) {
                    list.remove((Object)javaClassImpl2);
                } else if (object instanceof JavaClassImpl) {
                    javaClassImpl = (JavaClassImpl)((Object)object);
                    bl4 = javaClassImpl.contentsInited();
                    bl3 = javaClassImpl.isPersisted();
                    if (bl3) {
                        javaClassImpl.getPersistentContents().remove((Object)javaClassImpl2);
                        if (bl4) {
                            hashSet.add(javaClassImpl);
                        }
                    } else {
                        javaClassImpl2.setParentClass(null);
                    }
                }
                javaClassImpl2.refDelete();
            }
            if (resourceImpl.classifiersInited()) {
                resourceImpl.reinitClassifiers();
            }
            object2 = hashSet.iterator();
            while (object2.hasNext()) {
                JavaClassImpl javaClassImpl3 = (JavaClassImpl)((Object)object2.next());
                if (!javaClassImpl3.isValid()) continue;
                javaClassImpl3.reinitContents();
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaClassImpl createJavaClass(String string, int n, boolean bl, String string2, Set set, Set set2, JavaClass javaClass) {
        int n2;
        Object object;
        Set set3 = this.classIndex.getClassesByFqn(string);
        Object object2 = null;
        if (JMManager.INCONSISTENCY_DEBUG) {
            System.err.println("JavaUpdater: Looking for class: " + string);
        }
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            object = (JavaClass)iterator.next();
            if ((bl || javaClass == null || !javaClass.equals(object.refImmediateComposite()) || set2.contains(object)) && !set.contains(object)) continue;
            if (JMManager.INCONSISTENCY_DEBUG) {
                System.err.println("JavaUpdater: Existing class found in index.");
            }
            int n3 = object instanceof JavaEnum ? 1 : (n2 = object instanceof AnnotationType ? 2 : 0);
            if (n2 == 1 && !JavaUpdater.isEnum(n) || n2 != 1 && JavaUpdater.isEnum(n) || n2 == 2 && !JavaUpdater.isAnnotation(n) || n2 != 2 && JavaUpdater.isAnnotation(n)) {
                if (JMManager.INCONSISTENCY_DEBUG) {
                    System.err.println("JavaUpdater: The found class is of wrong type: " + object.getClass().getName() + " -> deleting...");
                }
                set.add(object);
                break;
            }
            object2 = object;
            break;
        }
        if (object2 == null) {
            if (JMManager.INCONSISTENCY_DEBUG) {
                System.err.println("JavaUpdater: No suitable class found -> creating...");
            }
            object2 = JavaUpdater.isEnum(n) ? this.enumClass.create(string, n, false) : (JavaUpdater.isAnnotation(n) ? this.annTypeClass.create(string, n, false) : this.jclsClass.create(string, n, null, null, false));
        } else if (bl) {
            boolean bl2 = ((JavaClassImpl)((Object)object2)).disableChanges;
            ((JavaClassImpl)((Object)object2)).disableChanges = true;
            try {
                object = ((JavaClassImpl)((Object)object2)).getPersistentContents();
                n2 = object.size();
                ClassMember[] classMemberArray = object.toArray(new ClassMember[n2]);
                for (int i = 0; i < n2; ++i) {
                    ClassMember classMember = classMemberArray[i];
                    object.remove(classMember);
                    if (classMember instanceof JavaClass) continue;
                    classMember.refDelete();
                }
                if (JavaUpdater.isEnum(n)) {
                    List list = object2.getPersistentConstants();
                    int n4 = list.size();
                    EnumConstant[] enumConstantArray = list.toArray(new EnumConstant[n4]);
                    for (int i = 0; i < n4; ++i) {
                        EnumConstant enumConstant = enumConstantArray[i];
                        list.remove(enumConstant);
                        enumConstant.refDelete();
                    }
                }
                ((JavaClassImpl)((Object)object2)).setPersisted(false);
            }
            finally {
                ((JavaClassImpl)((Object)object2)).disableChanges = bl2;
            }
        }
        return object2;
    }

    private Set getAllClassesFromResource(Resource resource, Collection collection) {
        Iterator iterator = collection.iterator();
        HashSet<JavaClass> hashSet = new HashSet<JavaClass>();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            Iterator iterator2 = this.classIndex.getClassesByFQNPrefix(javaClass.getName().concat(".")).iterator();
            hashSet.add(javaClass);
            while (iterator2.hasNext()) {
                JavaClass javaClass2 = (JavaClass)iterator2.next();
                if (!resource.equals(javaClass2.getResource())) continue;
                hashSet.add(javaClass2);
            }
        }
        return hashSet;
    }

    private static boolean isEnum(int n) {
        return (n & 0x4000) != 0;
    }

    private static boolean isAnnotation(int n) {
        return (n & 0x2000) != 0;
    }

    private String constructFqn(String string, Stack stack, String string2) {
        String string3 = stack.isEmpty() ? (string.length() > 0 ? string + '.' : "") : ((JavaClass)stack.peek()).getName() + '.';
        return string3.concat(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection updateResources(Map map) {
        JavaMetamodel.getDefaultRepository().beginTrans(false);
        try {
            Object object;
            Iterator iterator = map.values().iterator();
            ArrayList<ResourceImpl> arrayList = new ArrayList<ResourceImpl>();
            long l = this.classIndex.getTimestamp();
            while (iterator.hasNext()) {
                object = (FileInfo)iterator.next();
                try {
                    String string = object.getPath();
                    long l2 = object.lastModified();
                    ResourceImpl resourceImpl = (ResourceImpl)this.resourceClass.resolveResource(string, true, false);
                    arrayList.add(resourceImpl);
                    if (resourceImpl.getTimestamp() == l2 && !resourceImpl.isFromMemory() && l >= l2) continue;
                    resourceImpl.setTimestamp(l2, false);
                    if (this.fileScanner != null) {
                        this.fileScanner.checkParseEagerly(resourceImpl);
                    }
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(object.getInputStream());
                    try {
                        int[] nArray = this.makeIndex(resourceImpl, new TokenIterator(bufferedInputStream, this.sourceLevel, true), !resourceImpl.isInitialized());
                        this.classIndex.setIdentifiers(resourceImpl, nArray);
                    }
                    finally {
                        ((InputStream)bufferedInputStream).close();
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
            object = arrayList;
            return object;
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans();
        }
    }
}

