/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Utilities;

public abstract class WeakListener
implements EventListener {
    private Reference ref;
    Class listenerClass;
    private Reference source;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$java$beans$VetoableChangeListener;
    static /* synthetic */ Class class$org$openide$filesystems$FileChangeListener;
    static /* synthetic */ Class class$org$openide$filesystems$FileStatusListener;
    static /* synthetic */ Class class$org$openide$filesystems$RepositoryListener;
    static /* synthetic */ Class class$javax$swing$event$DocumentListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$org$openide$nodes$NodeListener;
    static /* synthetic */ Class class$java$awt$event$FocusListener;

    protected WeakListener(Class clazz, EventListener eventListener) {
        this.listenerClass = clazz;
        this.ref = new ListenerReference(eventListener, this);
        if (!clazz.isAssignableFrom(eventListener.getClass())) {
            throw new IllegalArgumentException(this.getClass().getName() + " constructor is calling WeakListner.<init> with illegal arguments");
        }
    }

    protected final void setSource(Object object) {
        this.source = object == null ? null : new WeakReference<Object>(object);
    }

    protected abstract String removeMethodName();

    protected final EventListener get(EventObject eventObject) {
        Object t = this.ref.get();
        if (t == null) {
            this.removeListener(eventObject == null ? null : eventObject.getSource());
        }
        return (EventListener)t;
    }

    private void removeListener(Object object) {
        Object[] objectArray = new Object[]{this.getImplementator()};
        Object object2 = this.source == null ? null : (Object)this.source.get();
        try {
            Method method = null;
            if (object2 != null && (method = WeakListener.getRemoveMethod(object2.getClass(), this.removeMethodName(), this.listenerClass)) != null) {
                method.invoke(object2, objectArray);
            }
            if (object != object2 && object != null && (method = WeakListener.getRemoveMethod(object.getClass(), this.removeMethodName(), this.listenerClass)) != null) {
                method.invoke(object, objectArray);
            }
            if (method == null && this.source == null) {
                ErrorManager.getDefault().log(16, "Can't remove " + this.listenerClass.getName() + " using method " + this.removeMethodName() + " source=" + this.source + ", src=" + object2 + ", eventSource=" + object);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(4096, (Throwable)exception);
        }
    }

    private static final Method getRemoveMethod(Class clazz, String string, Class clazz2) {
        Class[] classArray = new Class[]{clazz2};
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            do {
                try {
                    method = clazz.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
                clazz = clazz.getSuperclass();
            } while (method == null && clazz != (class$java$lang$Object == null ? WeakListener.class$("java.lang.Object") : class$java$lang$Object));
        }
        if (!(method == null || Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()))) {
            method.setAccessible(true);
        }
        return method;
    }

    Object getImplementator() {
        return this;
    }

    public String toString() {
        Object t = this.ref.get();
        return this.getClass().getName() + "[" + (t == null ? "null" : t.getClass().getName() + "]");
    }

    public static NodeListener node(NodeListener nodeListener, Object object) {
        Node node = new Node(nodeListener);
        node.setSource(object);
        return node;
    }

    public static PropertyChangeListener propertyChange(PropertyChangeListener propertyChangeListener, Object object) {
        PropertyChange propertyChange = new PropertyChange(propertyChangeListener);
        propertyChange.setSource(object);
        return propertyChange;
    }

    public static VetoableChangeListener vetoableChange(VetoableChangeListener vetoableChangeListener, Object object) {
        VetoableChange vetoableChange = new VetoableChange(vetoableChangeListener);
        vetoableChange.setSource(object);
        return vetoableChange;
    }

    public static FileChangeListener fileChange(FileChangeListener fileChangeListener, Object object) {
        FileChange fileChange = new FileChange(fileChangeListener);
        fileChange.setSource(object);
        return fileChange;
    }

    public static FileStatusListener fileStatus(FileStatusListener fileStatusListener, Object object) {
        FileStatus fileStatus = new FileStatus(fileStatusListener);
        fileStatus.setSource(object);
        return fileStatus;
    }

    public static RepositoryListener repository(RepositoryListener repositoryListener, Object object) {
        Repository repository = new Repository(repositoryListener);
        repository.setSource(object);
        return repository;
    }

    public static DocumentListener document(DocumentListener documentListener, Object object) {
        Document document = new Document(documentListener);
        document.setSource(object);
        return document;
    }

    public static ChangeListener change(ChangeListener changeListener, Object object) {
        Change change = new Change(changeListener);
        change.setSource(object);
        return change;
    }

    public static FocusListener focus(FocusListener focusListener, Object object) {
        Focus focus = new Focus(focusListener);
        focus.setSource(object);
        return focus;
    }

    public static EventListener create(Class clazz, EventListener eventListener, Object object) {
        ProxyListener proxyListener = new ProxyListener(clazz, eventListener);
        proxyListener.setSource(object);
        return (EventListener)proxyListener.proxy;
    }

    private static final class ListenerReference
    extends WeakReference
    implements Runnable {
        private static Class lastClass;
        private static String lastMethodName;
        private static Method lastRemove;
        private static Object LOCK;
        final WeakListener weakListener;

        public ListenerReference(Object object, WeakListener weakListener) {
            super(object, Utilities.activeReferenceQueue());
            this.weakListener = weakListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WeakListener weakListener;
            Method method;
            Object object;
            Class[] classArray;
            Object[] objectArray;
            block15: {
                block14: {
                    ListenerReference listenerReference = this;
                    objectArray = new Object[1];
                    classArray = new Class[1];
                    object = null;
                    method = null;
                    weakListener = listenerReference.weakListener;
                    if (weakListener.source == null) break block14;
                    Object t = weakListener.source.get();
                    object = t;
                    if (t != null) break block15;
                }
                return;
            }
            Class<?> clazz = object.getClass();
            String string = weakListener.removeMethodName();
            Object object2 = LOCK;
            synchronized (object2) {
                if (lastClass == clazz && lastMethodName == string && lastRemove != null) {
                    method = lastRemove;
                }
            }
            if (method == null) {
                classArray[0] = weakListener.listenerClass;
                method = WeakListener.getRemoveMethod(clazz, string, classArray[0]);
                if (method == null) {
                    ErrorManager.getDefault().log(16, "Can't remove " + weakListener.listenerClass.getName() + " using method " + string + " from " + object);
                    return;
                }
                object2 = LOCK;
                synchronized (object2) {
                    lastClass = clazz;
                    lastMethodName = string;
                    lastRemove = method;
                }
            }
            objectArray[0] = weakListener.getImplementator();
            try {
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().annotate((Throwable)exception, "Problem encountered while calling " + clazz + "." + string + "(...) on " + object);
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }

        static {
            LOCK = new Object();
        }
    }

    private static class ProxyListener
    extends WeakListener
    implements InvocationHandler {
        private static Method equalsMth;
        public final Object proxy;

        public ProxyListener(Class clazz, EventListener eventListener) {
            super(clazz, eventListener);
            this.proxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
        }

        private static Method getEquals() {
            if (equalsMth == null) {
                try {
                    equalsMth = (class$java$lang$Object == null ? (class$java$lang$Object = WeakListener.class$("java.lang.Object")) : class$java$lang$Object).getMethod("equals", class$java$lang$Object == null ? (class$java$lang$Object = WeakListener.class$("java.lang.Object")) : class$java$lang$Object);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
            }
            return equalsMth;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = WeakListener.class$("java.lang.Object")) : class$java$lang$Object)) {
                if (method == ProxyListener.getEquals()) {
                    boolean bl = this.equals(objectArray[0]);
                    return bl ? Boolean.TRUE : Boolean.FALSE;
                }
                return method.invoke((Object)this, objectArray);
            }
            EventObject eventObject = objectArray[0] instanceof EventObject ? (EventObject)objectArray[0] : null;
            EventListener eventListener = super.get(eventObject);
            if (eventListener != null) {
                return method.invoke((Object)eventListener, objectArray);
            }
            return null;
        }

        protected String removeMethodName() {
            String string = this.listenerClass.getName();
            int n = string.lastIndexOf(46);
            int n2 = (string = string.substring(n + 1)).lastIndexOf(36);
            if (n2 >= 0) {
                string = string.substring(n2 + 1);
            }
            return "remove".concat(string);
        }

        public String toString() {
            return super.toString() + "[" + this.listenerClass + "]";
        }

        public boolean equals(Object object) {
            return this.proxy == object || this == object;
        }

        Object getImplementator() {
            return this.proxy;
        }
    }

    public static final class Focus
    extends WeakListener
    implements FocusListener {
        public Focus(FocusListener focusListener) {
            super(class$java$awt$event$FocusListener == null ? (class$java$awt$event$FocusListener = WeakListener.class$("java.awt.event.FocusListener")) : class$java$awt$event$FocusListener, focusListener);
        }

        public void focusGained(FocusEvent focusEvent) {
            FocusListener focusListener = (FocusListener)super.get(focusEvent);
            if (focusListener != null) {
                focusListener.focusGained(focusEvent);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            FocusListener focusListener = (FocusListener)super.get(focusEvent);
            if (focusListener != null) {
                focusListener.focusLost(focusEvent);
            }
        }

        protected String removeMethodName() {
            return "removeFocusListener";
        }
    }

    public static final class Node
    extends PropertyChange
    implements NodeListener {
        public Node(NodeListener nodeListener) {
            super(class$org$openide$nodes$NodeListener == null ? (class$org$openide$nodes$NodeListener = WeakListener.class$("org.openide.nodes.NodeListener")) : class$org$openide$nodes$NodeListener, (PropertyChangeListener)nodeListener);
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            NodeListener nodeListener = (NodeListener)super.get((EventObject)nodeMemberEvent);
            if (nodeListener != null) {
                nodeListener.childrenAdded(nodeMemberEvent);
            }
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            NodeListener nodeListener = (NodeListener)super.get((EventObject)nodeMemberEvent);
            if (nodeListener != null) {
                nodeListener.childrenRemoved(nodeMemberEvent);
            }
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
            NodeListener nodeListener = (NodeListener)super.get((EventObject)nodeReorderEvent);
            if (nodeListener != null) {
                nodeListener.childrenReordered(nodeReorderEvent);
            }
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            NodeListener nodeListener = (NodeListener)super.get((EventObject)nodeEvent);
            if (nodeListener != null) {
                nodeListener.nodeDestroyed(nodeEvent);
            }
        }

        protected String removeMethodName() {
            return "removeNodeListener";
        }
    }

    public static final class Change
    extends WeakListener
    implements ChangeListener {
        public Change(ChangeListener changeListener) {
            super(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = WeakListener.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ChangeListener changeListener = (ChangeListener)super.get(changeEvent);
            if (changeListener != null) {
                changeListener.stateChanged(changeEvent);
            }
        }

        protected String removeMethodName() {
            return "removeChangeListener";
        }
    }

    public static final class Document
    extends WeakListener
    implements DocumentListener {
        public Document(DocumentListener documentListener) {
            super(class$javax$swing$event$DocumentListener == null ? (class$javax$swing$event$DocumentListener = WeakListener.class$("javax.swing.event.DocumentListener")) : class$javax$swing$event$DocumentListener, documentListener);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.changedUpdate(documentEvent);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.insertUpdate(documentEvent);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.removeUpdate(documentEvent);
            }
        }

        protected String removeMethodName() {
            return "removeDocumentListener";
        }

        private DocumentListener docGet(DocumentEvent documentEvent) {
            DocumentListener documentListener = (DocumentListener)((WeakListener)this).ref.get();
            if (documentListener == null) {
                ((WeakListener)this).removeListener(documentEvent.getDocument());
            }
            return documentListener;
        }
    }

    public static class Repository
    extends WeakListener
    implements RepositoryListener {
        public Repository(RepositoryListener repositoryListener) {
            super(class$org$openide$filesystems$RepositoryListener == null ? (class$org$openide$filesystems$RepositoryListener = WeakListener.class$("org.openide.filesystems.RepositoryListener")) : class$org$openide$filesystems$RepositoryListener, (EventListener)repositoryListener);
        }

        public void fileSystemAdded(RepositoryEvent repositoryEvent) {
            RepositoryListener repositoryListener = (RepositoryListener)super.get((EventObject)repositoryEvent);
            if (repositoryListener != null) {
                repositoryListener.fileSystemAdded(repositoryEvent);
            }
        }

        public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
            RepositoryListener repositoryListener = (RepositoryListener)super.get((EventObject)repositoryEvent);
            if (repositoryListener != null) {
                repositoryListener.fileSystemRemoved(repositoryEvent);
            }
        }

        public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
            RepositoryListener repositoryListener = (RepositoryListener)super.get((EventObject)repositoryReorderedEvent);
            if (repositoryListener != null) {
                repositoryListener.fileSystemPoolReordered(repositoryReorderedEvent);
            }
        }

        protected String removeMethodName() {
            return "removeRepositoryListener";
        }
    }

    public static class FileStatus
    extends WeakListener
    implements FileStatusListener {
        public FileStatus(FileStatusListener fileStatusListener) {
            super(class$org$openide$filesystems$FileStatusListener == null ? (class$org$openide$filesystems$FileStatusListener = WeakListener.class$("org.openide.filesystems.FileStatusListener")) : class$org$openide$filesystems$FileStatusListener, (EventListener)fileStatusListener);
        }

        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            FileStatusListener fileStatusListener = (FileStatusListener)super.get((EventObject)fileStatusEvent);
            if (fileStatusListener != null) {
                fileStatusListener.annotationChanged(fileStatusEvent);
            }
        }

        protected String removeMethodName() {
            return "removeFileStatusListener";
        }
    }

    public static class FileChange
    extends WeakListener
    implements FileChangeListener {
        public FileChange(FileChangeListener fileChangeListener) {
            super(class$org$openide$filesystems$FileChangeListener == null ? (class$org$openide$filesystems$FileChangeListener = WeakListener.class$("org.openide.filesystems.FileChangeListener")) : class$org$openide$filesystems$FileChangeListener, (EventListener)fileChangeListener);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            FileChangeListener fileChangeListener = (FileChangeListener)super.get((EventObject)fileEvent);
            if (fileChangeListener != null) {
                fileChangeListener.fileFolderCreated(fileEvent);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileChangeListener fileChangeListener = (FileChangeListener)super.get((EventObject)fileEvent);
            if (fileChangeListener != null) {
                fileChangeListener.fileDataCreated(fileEvent);
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            FileChangeListener fileChangeListener = (FileChangeListener)super.get((EventObject)fileEvent);
            if (fileChangeListener != null) {
                fileChangeListener.fileChanged(fileEvent);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileChangeListener fileChangeListener = (FileChangeListener)super.get((EventObject)fileEvent);
            if (fileChangeListener != null) {
                fileChangeListener.fileDeleted(fileEvent);
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileChangeListener fileChangeListener = (FileChangeListener)super.get((EventObject)fileRenameEvent);
            if (fileChangeListener != null) {
                fileChangeListener.fileRenamed(fileRenameEvent);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            FileChangeListener fileChangeListener = (FileChangeListener)super.get((EventObject)fileAttributeEvent);
            if (fileChangeListener != null) {
                fileChangeListener.fileAttributeChanged(fileAttributeEvent);
            }
        }

        protected String removeMethodName() {
            return "removeFileChangeListener";
        }
    }

    public static class VetoableChange
    extends WeakListener
    implements VetoableChangeListener {
        public VetoableChange(VetoableChangeListener vetoableChangeListener) {
            super(class$java$beans$VetoableChangeListener == null ? (class$java$beans$VetoableChangeListener = WeakListener.class$("java.beans.VetoableChangeListener")) : class$java$beans$VetoableChangeListener, vetoableChangeListener);
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            VetoableChangeListener vetoableChangeListener = (VetoableChangeListener)super.get(propertyChangeEvent);
            if (vetoableChangeListener != null) {
                vetoableChangeListener.vetoableChange(propertyChangeEvent);
            }
        }

        protected String removeMethodName() {
            return "removeVetoableChangeListener";
        }
    }

    public static class PropertyChange
    extends WeakListener
    implements PropertyChangeListener {
        public PropertyChange(PropertyChangeListener propertyChangeListener) {
            super(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = WeakListener.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
        }

        PropertyChange(Class clazz, PropertyChangeListener propertyChangeListener) {
            super(clazz, propertyChangeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)super.get(propertyChangeEvent);
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }

        protected String removeMethodName() {
            return "removePropertyChangeListener";
        }
    }
}

