/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.IOException;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringElement;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class NbRenameRefactoringPlugin
extends AbstractRefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private RenameRefactoring rename;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin;

    public NbRenameRefactoringPlugin(AbstractRefactoring abstractRefactoring) {
        super(abstractRefactoring);
    }

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (semafor.get() != null) {
            return null;
        }
        semafor.set(new Object());
        try {
            JavaClass javaClass;
            Resource resource;
            FileObject fileObject;
            Project project;
            this.rename = (RenameRefactoring)this.refactoring;
            Problem problem = null;
            RefObject refObject = (RefObject)this.rename.getRefactoredObject();
            if (refObject instanceof JavaClass && (project = FileOwnerQuery.getOwner((FileObject)(fileObject = JavaModel.getFileObject((Resource)(resource = (javaClass = (JavaClass)refObject).getResource()))))) != null && project instanceof NbModuleProject) {
                this.checkMetaInfServices(project, javaClass, refactoringElementsBag);
                this.checkManifest((NbModuleProject)project, javaClass, refactoringElementsBag);
                this.checkLayer((NbModuleProject)project, javaClass, refactoringElementsBag);
            }
            if (refObject instanceof JavaPackage && (fileObject = JavaModel.getFileObject((Resource)(resource = (javaClass = (JavaPackage)refObject).getResource()))) != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && project instanceof NbModuleProject) {
                this.checkMetaInfServices(project, (JavaPackage)javaClass, refactoringElementsBag);
            }
            if (refObject instanceof Method) {
                javaClass = (Method)refObject;
                problem = this.checkLayer((Method)javaClass, refactoringElementsBag);
            }
            err.log("Gonna return problem: " + problem);
            javaClass = problem;
            return javaClass;
        }
        finally {
            semafor.set(null);
        }
    }

    protected RefactoringElementImplementation createManifestRefactoring(JavaClass javaClass, FileObject fileObject, String string, String string2, String string3) {
        return new ManifestRenameRefactoringElement(javaClass, fileObject, string2, string, string3);
    }

    protected RefactoringElementImplementation createMetaInfServicesRefactoring(JavaClass javaClass, FileObject fileObject, int n) {
        return new ServicesRenameRefactoringElement(javaClass, fileObject);
    }

    protected final void checkMetaInfServices(Project project, JavaPackage javaPackage, RefactoringElementsBag refactoringElementsBag) {
        FileObject fileObject = Utility.findMetaInfServices(project);
        if (fileObject == null) {
            return;
        }
        String string = javaPackage.getName();
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            ServicesPackageRenameRefactoringElement servicesPackageRenameRefactoringElement;
            int n = this.checkContentOfFile(fileObjectArray[i], string);
            if (n == -1 || (servicesPackageRenameRefactoringElement = new ServicesPackageRenameRefactoringElement(javaPackage, fileObjectArray[i])) == null) continue;
            refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)servicesPackageRenameRefactoringElement);
        }
    }

    protected RefactoringElementImplementation createLayerRefactoring(Constructor constructor, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string) {
        return null;
    }

    protected RefactoringElementImplementation createLayerRefactoring(JavaClass javaClass, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string) {
        return new LayerClassRefactoringElement(javaClass, layerHandle, fileObject, string);
    }

    protected RefactoringElementImplementation createLayerRefactoring(Method method, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string) {
        return new LayerMethodRefactoringElement(method, layerHandle, fileObject, string);
    }

    public final class ServicesPackageRenameRefactoringElement
    extends AbstractRefactoringElement {
        private JavaPackage pack;
        private String oldName;

        public ServicesPackageRenameRefactoringElement(JavaPackage javaPackage, FileObject fileObject) {
            this.name = javaPackage.getName();
            this.parentFile = fileObject;
            this.pack = javaPackage;
            this.oldName = javaPackage.getName();
        }

        public String getDisplayText() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin = NbRenameRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbRenameRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin), (String)"TXT_ServicesPackageRename", (Object)this.name);
        }

        public void performChange() {
            String string = Utility.readFileIntoString(this.parentFile);
            if (string != null) {
                String string2 = this.oldName;
                String string3 = this.pack.getName();
                string2 = string2.replaceAll("[.]", "\\.");
                string = string.replaceAll("^" + string2, string3);
                Utility.writeFileFromString(this.parentFile, string);
            }
        }
    }

    public final class ServicesRenameRefactoringElement
    extends AbstractRefactoringElement
    implements ExternalChange {
        private JavaClass clazz;
        private String oldName;
        private String oldContent;
        private String newName;

        public ServicesRenameRefactoringElement(JavaClass javaClass, FileObject fileObject) {
            this.name = javaClass.getSimpleName();
            this.parentFile = fileObject;
            this.clazz = javaClass;
            this.oldName = javaClass.getName();
        }

        public String getDisplayText() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin = NbRenameRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbRenameRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin), (String)"TXT_ServicesRename", (Object)this.name);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            String string;
            this.oldContent = string = Utility.readFileIntoString(this.parentFile);
            if (string != null) {
                String string2 = this.oldName;
                if (this.newName == null) {
                    this.newName = this.clazz.getName();
                    this.clazz = null;
                }
                string2 = string2.replaceAll("[.]", "\\.");
                string = string.replaceAll("^" + string2 + "[ \\\n]?", this.newName + "\n");
                Utility.writeFileFromString(this.parentFile, string);
            }
        }

        public void undoExternalChange() {
            if (this.oldContent != null) {
                Utility.writeFileFromString(this.parentFile, this.oldContent);
            }
        }
    }

    public final class ManifestRenameRefactoringElement
    extends AbstractRefactoringElement
    implements ExternalChange {
        private JavaClass clazz;
        private String attrName;
        private String sectionName = null;
        private String oldName;
        private String oldContent;
        private String newName;

        public ManifestRenameRefactoringElement(JavaClass javaClass, FileObject fileObject, String string, String string2) {
            this.name = string;
            this.clazz = javaClass;
            this.parentFile = fileObject;
            this.attrName = string2;
            this.oldName = javaClass.getName();
        }

        public ManifestRenameRefactoringElement(JavaClass javaClass, FileObject fileObject, String string, String string2, String string3) {
            this(javaClass, fileObject, string, string2);
            this.sectionName = string3;
        }

        public String getDisplayText() {
            if (this.sectionName != null) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin = NbRenameRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbRenameRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin), (String)"TXT_ManifestSectionRename", (Object)this.name, (Object)this.sectionName);
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin = NbRenameRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbRenameRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin), (String)"TXT_ManifestRename", (Object)this.name, (Object)this.attrName);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            String string;
            this.oldContent = string = Utility.readFileIntoString(this.parentFile);
            if (string != null) {
                String string2 = this.oldName;
                if (this.newName == null) {
                    this.newName = this.clazz.getName();
                    this.newName = this.newName.replace('.', '/') + ".class";
                    this.clazz = null;
                }
                string2 = string2.replace('.', '/') + ".class";
                string = string.replaceAll(string2, this.newName);
                Utility.writeFileFromString(this.parentFile, string);
            }
        }

        public void undoExternalChange() {
            if (this.oldContent != null) {
                Utility.writeFileFromString(this.parentFile, this.oldContent);
            }
        }
    }

    public final class LayerClassRefactoringElement
    extends LayerAbstractRefactoringElement {
        private JavaClass clazz;
        private String newAttrName;
        private String newAttrValue;
        private String newFileName;

        public LayerClassRefactoringElement(JavaClass javaClass, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string) {
            super(layerHandle, fileObject, string);
            this.clazz = javaClass;
            if (this.oldAttrName == null) {
                this.newFileName = this.oldFileName.replaceAll("\\-" + this.clazz.getSimpleName() + "$", "-" + NbRenameRefactoringPlugin.this.rename.getNewName());
            } else if (this.oldAttrName.indexOf(this.clazz.getName().replace('.', '-') + ".instance") > 0) {
                this.newAttrName = this.oldAttrName.replaceAll("-" + this.clazz.getSimpleName() + "\\.", "-" + NbRenameRefactoringPlugin.this.rename.getNewName() + ".");
            } else if (this.oldAttrValue != null) {
                String string2 = this.clazz.getSimpleName();
                this.newAttrValue = this.oldAttrValue.replaceAll(string2, NbRenameRefactoringPlugin.this.rename.getNewName());
            }
        }

        public String getDisplayText() {
            if (this.newFileName != null) {
                return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_LayerFileRename", (Object)this.oldFileName, (Object)NbRenameRefactoringPlugin.this.rename.getNewName());
            }
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_LayerMethodRename", (Object)this.oldAttrValue, (Object)NbRenameRefactoringPlugin.this.rename.getNewName());
        }

        public void performExternalChange() {
            if (this.newAttrValue != null) {
                this.doAttributeValueChange(this.newAttrValue, this.valueType);
            }
            if (this.newAttrName != null) {
                this.doAttributeMove(this.oldAttrName, this.newAttrName);
            }
            if (this.newFileName != null) {
                this.doFileMove(this.newFileName);
            }
        }

        public void undoExternalChange() {
            if (this.newAttrValue != null) {
                this.doAttributeValueChange(this.oldAttrValue, this.valueType);
            }
            if (this.newAttrName != null) {
                this.doAttributeMove(this.newAttrName, this.oldAttrName);
            }
            if (this.newFileName != null) {
                this.doFileMove(this.oldFileName);
            }
        }
    }

    public final class LayerMethodRefactoringElement
    extends LayerAbstractRefactoringElement {
        private Method method;
        private String newAttrValue;

        public LayerMethodRefactoringElement(Method method, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string) {
            super(layerHandle, fileObject, string);
            this.method = method;
            this.newAttrValue = this.oldAttrValue.replaceAll("\\." + method.getName() + "$", "." + NbRenameRefactoringPlugin.this.rename.getNewName());
        }

        public String getDisplayText() {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_LayerMethodRename", (Object)this.oldAttrValue, (Object)NbRenameRefactoringPlugin.this.rename.getNewName());
        }

        public void performExternalChange() {
            this.doAttributeValueChange(this.newAttrValue, this.valueType);
        }

        public void undoExternalChange() {
            this.doAttributeValueChange(this.oldAttrValue, this.valueType);
        }
    }

    public abstract class LayerAbstractRefactoringElement
    extends AbstractRefactoringElement
    implements ExternalChange {
        protected FileObject layerFile;
        protected LayerUtils.LayerHandle handle;
        protected String oldFileName;
        protected String oldAttrName;
        protected String oldAttrValue;
        protected String valueType;

        public LayerAbstractRefactoringElement(LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string) {
            this.layerFile = fileObject;
            this.parentFile = layerHandle.getLayerFile();
            this.handle = layerHandle;
            this.oldFileName = fileObject.getName();
            this.oldAttrName = string;
            if (string != null) {
                Object object = fileObject.getAttribute("literal:" + string);
                if (object == null) {
                    throw new IllegalStateException();
                }
                if (object instanceof String) {
                    this.oldAttrValue = (String)object;
                    if (this.oldAttrValue.startsWith("new:")) {
                        this.oldAttrValue = ((String)object).substring("new:".length());
                        this.valueType = "newvalue:";
                    } else if (this.oldAttrValue.startsWith("method:")) {
                        this.oldAttrValue = ((String)object).substring("method:".length());
                        this.valueType = "methodvalue:";
                    }
                }
            }
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        protected void doAttributeValueChange(String string, String string2) {
            boolean bl = this.handle.isAutosave();
            if (!bl) {
                this.handle.setAutosave(true);
            }
            try {
                this.layerFile.setAttribute(this.oldAttrName, (Object)((string2 != null ? string2 : "") + string));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            if (!bl) {
                this.handle.setAutosave(false);
            }
        }

        protected void doAttributeMove(String string, String string2) {
            boolean bl = this.handle.isAutosave();
            if (!bl) {
                this.handle.setAutosave(true);
            }
            try {
                Object object = this.layerFile.getAttribute(string);
                this.layerFile.setAttribute(string, null);
                this.layerFile.setAttribute(string2, object);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            if (!bl) {
                this.handle.setAutosave(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doFileMove(String string) {
            boolean bl = this.handle.isAutosave();
            if (!bl) {
                this.handle.setAutosave(true);
            }
            FileLock fileLock = null;
            try {
                fileLock = this.layerFile.lock();
                this.layerFile.rename(fileLock, string, this.layerFile.getExt());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
            if (!bl) {
                this.handle.setAutosave(false);
            }
        }
    }
}

