/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.comparators;

import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import org.netbeans.api.java.comparators.ArrayComparator;
import org.netbeans.api.java.comparators.ClassComparator;
import org.netbeans.api.java.comparators.ConstructorComparator;
import org.netbeans.api.java.comparators.FieldComparator;
import org.netbeans.api.java.comparators.IdentifierComparator;
import org.netbeans.api.java.comparators.MParameterComparator;
import org.netbeans.api.java.comparators.MethodComparator;
import org.netbeans.api.java.comparators.TypeComparator;
import org.openide.ErrorManager;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

public abstract class JavaElementComparator
implements Comparator {
    protected int type;
    private static HashMap element2comparator;
    public static final int SOURCE = 1;
    public static final int RETURN_TYPE = 2;
    public static final int NAME = 4;
    public static final int PARAMETERS = 8;
    public static final int EXCEPTIONS = 16;
    public static final int TYPE = 32;
    public static final int MODIFIERS = 64;
    public static final int ISCLASS = 128;
    public static final int PARAM_NAME = 256;
    public static final int PARAM_MODIFIERS = 512;
    public static final int PARAM_TYPE = 1024;

    protected JavaElementComparator(int n) {
        this.type = n;
    }

    protected int getType() {
        return this.type;
    }

    public abstract int compare(Object var1, Object var2);

    public boolean equals(Object object) {
        return this.getClass().isInstance(object) && this.type == ((JavaElementComparator)object).getType();
    }

    public static Comparator createIdentifierComparator(boolean bl) {
        return IdentifierComparator.createComparator(bl ? 1 : 0);
    }

    public static Comparator createTypeComparator(boolean bl) {
        return TypeComparator.createComparator(bl ? 1 : 0);
    }

    public static Comparator createClassComparator(boolean bl, int[] nArray) {
        return JavaElementComparator.createComparator(ClassElement.class, bl, nArray);
    }

    public static Comparator createConstructorComparator(boolean bl, int[] nArray) {
        return JavaElementComparator.createComparator(ConstructorElement.class, bl, nArray);
    }

    public static Comparator createFiledComparator(boolean bl, int[] nArray) {
        return JavaElementComparator.createComparator(FieldElement.class, bl, nArray);
    }

    public static Comparator createMParameterComparator(boolean bl, int[] nArray) {
        return JavaElementComparator.createComparator(MethodParameter.class, bl, nArray);
    }

    public static Comparator createMethodComparator(boolean bl, int[] nArray) {
        return JavaElementComparator.createComparator(MethodElement.class, bl, nArray);
    }

    public static Comparator createComparator(Object object, boolean bl, int[] nArray) {
        return JavaElementComparator.createComparator(object.getClass(), bl, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Comparator createComparator(Class clazz, boolean bl, int[] nArray) {
        Method method;
        Constable constable;
        int n = bl ? 1 : 0;
        Comparator[] comparatorArray = new Comparator[nArray.length];
        if (element2comparator == null) {
            constable = JavaElementComparator.class;
            synchronized (constable) {
                if (element2comparator == null) {
                    JavaElementComparator.createElementMap();
                }
            }
        }
        if ((method = (Method)element2comparator.get(clazz)) == null) {
            return null;
        }
        if (nArray == null || nArray.length == 0) {
            try {
                constable = new Integer(n);
                return (Comparator)method.invoke(null, constable);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
                return null;
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            try {
                constable = new Integer(nArray[i] | n);
                comparatorArray[i] = (Comparator)method.invoke(null, constable);
                continue;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
                return null;
            }
        }
        return new ArrayComparator(comparatorArray);
    }

    private static void createElementMap() {
        Class[] classArray = new Class[]{Integer.TYPE};
        element2comparator = new HashMap();
        try {
            element2comparator.put(ClassElement.class, ClassComparator.class.getDeclaredMethod("createComparator", classArray));
            element2comparator.put(ConstructorElement.class, ConstructorComparator.class.getDeclaredMethod("createComparator", classArray));
            element2comparator.put(FieldElement.class, FieldComparator.class.getDeclaredMethod("createComparator", classArray));
            element2comparator.put(Identifier.class, IdentifierComparator.class.getDeclaredMethod("createComparator", classArray));
            element2comparator.put(MethodParameter.class, MParameterComparator.class.getDeclaredMethod("createComparator", classArray));
            element2comparator.put(MethodElement.class, MethodComparator.class.getDeclaredMethod("createComparator", classArray));
            element2comparator.put(Type.class, TypeComparator.class.getDeclaredMethod("createComparator", classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify(16, (Throwable)noSuchMethodException);
        }
    }
}

