/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.comparators;

import java.util.Comparator;
import org.netbeans.api.java.comparators.IdentifierComparator;
import org.netbeans.api.java.comparators.JavaElementComparator;
import org.openide.src.Type;

class TypeComparator
extends JavaElementComparator {
    private Comparator idComparator;
    private static final int T_BOOLEAN = 1;
    private static final int T_INT = 2;
    private static final int T_CHAR = 3;
    private static final int T_BYTE = 4;
    private static final int T_SHORT = 5;
    private static final int T_LONG = 6;
    private static final int T_FLOAT = 7;
    private static final int T_DOUBLE = 8;
    private static final int T_VOID = 9;
    private static final int T_CLASS = 16;
    private static final int T_ARRAY = 32;

    protected TypeComparator(int n) {
        super(n);
    }

    private int getKind(Type type) {
        if (type.isArray()) {
            return 32;
        }
        if (type.isClass()) {
            return 16;
        }
        if (type == Type.BOOLEAN) {
            return 1;
        }
        if (type == Type.BYTE) {
            return 4;
        }
        if (type == Type.CHAR) {
            return 3;
        }
        if (type == Type.DOUBLE) {
            return 8;
        }
        if (type == Type.FLOAT) {
            return 7;
        }
        if (type == Type.INT) {
            return 2;
        }
        if (type == Type.LONG) {
            return 6;
        }
        if (type == Type.SHORT) {
            return 5;
        }
        if (type == Type.VOID) {
            return 9;
        }
        return 0;
    }

    public int compare(Object object, Object object2) {
        int n;
        Type type = (Type)object;
        Type type2 = (Type)object2;
        int n2 = this.getKind(type);
        if (n2 != (n = this.getKind(type2))) {
            if (n2 > n) {
                return 1;
            }
            return -1;
        }
        if (type.isArray()) {
            return this.compare(type.getElementType(), type2.getElementType());
        }
        if (type.isClass()) {
            if (this.idComparator == null) {
                this.idComparator = IdentifierComparator.createComparator(this.type);
            }
            return this.idComparator.compare(type.getClassName(), type2.getClassName());
        }
        return 0;
    }

    static Comparator createComparator(int n) {
        return new TypeComparator(n);
    }
}

