/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.ModifierPanel;
import org.openide.util.NbBundle;

public class ModifierEditor
extends JPanel
implements ExPropertyEditor {
    private ModifierPanel panel;
    static final long serialVersionUID = 6324048239020120791L;
    private int mask;
    private int modifier = 0;
    private PropertyEnv env;

    public ModifierEditor() {
        this(1535);
    }

    public ModifierEditor(int n) {
        this.setMask(n & 0x5FF);
        this.getAccessibleContext().setAccessibleDescription(ModifierEditor.getString("ACSD_ModifierPanel"));
    }

    public void addNotify() {
        this.setLayout(new BorderLayout());
        this.panel = new ModifierPanel(this);
        this.panel.setMnemonics(this.env);
        this.add((Component)this.panel, "Center");
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.panel != null) {
            this.remove(this.panel);
            this.panel = null;
        }
    }

    int getMask() {
        return this.mask;
    }

    public void setMask(int n) {
        if (this.mask != n) {
            int n2 = this.mask;
            this.mask = n & 0x5FF;
            this.firePropertyChange("mask", new Integer(n2), new Integer(n));
            this.setModifier(this.modifier & n);
        }
    }

    int getModifier() {
        return this.modifier;
    }

    void setModifier(int n) {
        if (this.modifier != n) {
            int n2 = this.modifier;
            this.modifier = n;
            this.firePropertyChange("modifier", new Integer(n2), new Integer(n));
            this.firePropertyChange("modifiers", new Integer(n2), new Integer(n));
        }
    }

    public void setValue(Object object) throws IllegalArgumentException {
        if (object == null) {
            this.setModifier(0);
            return;
        }
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        this.setModifier((Integer)object);
    }

    public String getJavaInitializationString() {
        return new Integer(this.getModifier()).toString();
    }

    public Object getValue() {
        return new Integer(this.getModifier());
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getAsText() {
        return Modifier.toString(this.getModifier());
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int n = 0;
        int n2 = this.modifier;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
        while (stringTokenizer.hasMoreTokens()) {
            int n3;
            String string2 = stringTokenizer.nextToken();
            boolean bl = false;
            for (n3 = 0; n3 < ModifierPanel.MODIFIER_COUNT; ++n3) {
                if ((ModifierPanel.MODIFIER_VALUES[n3] & this.mask) == 0 || !string2.equals(ModifierPanel.MODIFIER_NAMES[n3])) continue;
                if (ModifierPanel.MODIFIER_VALUES[n3] == 16 && (n & 0x400) != 0 || ModifierPanel.MODIFIER_VALUES[n3] == 1024 && (n & 0x10) != 0) break;
                n |= ModifierPanel.MODIFIER_VALUES[n3];
                bl = true;
                break;
            }
            if ((n & 7) == 0) {
                for (n3 = 1; n3 <= 3; ++n3) {
                    if ((ModifierPanel.ACCESS_VALUES[n3] & this.mask) == 0 || !string2.equals(ModifierPanel.ACCESS_NAMES[n3])) continue;
                    n |= ModifierPanel.ACCESS_VALUES[n3];
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid modifier: " + string2);
            String string3 = MessageFormat.format(ModifierEditor.getString("MSG_IllegalModifierString"), string2);
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, string3, null, null);
            throw illegalArgumentException;
        }
        if (n2 != n) {
            this.modifier = n;
            this.firePropertyChange("modifier", new Integer(n2), new Integer(this.modifier));
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getValue();
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
    }

    private static String getString(String string) {
        return NbBundle.getBundle((String)"org.openide.explorer.propertysheet.editors.Bundle2", (Locale)Locale.getDefault(), (ClassLoader)ModifierEditor.class.getClassLoader()).getString(string);
    }
}

