/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.FeatureDescriptor;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.MouseUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

abstract class ObjectArrayPanel2
extends JPanel {
    static final String PROP_MNEMONIC_ADD = "mnemonic_Add";
    static final String PROP_MNEMONIC_REMOVE = "mnemonic_Remove";
    static final String PROP_MNEMONIC_UP = "mnemonic_Up";
    static final String PROP_MNEMONIC_DOWN = "mnemonic_Down";
    static final String PROP_MNEMONIC_EDIT = "mnemonic_Edit";
    static final String PROP_MNEMONIC_LIST = "mnemonic_List";
    static final String PROP_LABEL_LIST = "label_List";
    static final ResourceBundle bundle = NbBundle.getBundle((String)"org.openide.explorer.propertysheet.editors.Bundle2", (Locale)Locale.getDefault(), (ClassLoader)ObjectArrayPanel2.class.getClassLoader());
    protected DefaultListModel model;
    private JButton addButton;
    private JButton downButton;
    private JList list;
    private JScrollPane jScrollPane1;
    private JLabel jLabel1;
    private JButton changeButton;
    private JButton upButton;
    private JButton removeButton;

    public ObjectArrayPanel2() {
        this.initComponents();
        this.model = new DefaultListModel();
        this.list.setModel(this.model);
        this.updateButtons();
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ObjectArrayPanel"));
        this.list.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ObjectArrayPanel_List"));
        this.list.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ObjectArrayPanel_List"));
        this.upButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_MoveUp"));
        this.downButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_MoveDown"));
        this.addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Add"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Remove"));
        this.changeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Change"));
    }

    void setMnemonics(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        Object object = featureDescriptor.getValue(PROP_MNEMONIC_ADD);
        if (object instanceof String) {
            this.addButton.setMnemonic(((String)object).charAt(0));
        } else {
            this.addButton.setMnemonic(bundle.getString("CTL_Add_Mnemonic").charAt(0));
        }
        object = featureDescriptor.getValue(PROP_MNEMONIC_REMOVE);
        if (object instanceof String) {
            this.removeButton.setMnemonic(((String)object).charAt(0));
        } else {
            this.removeButton.setMnemonic(bundle.getString("CTL_Remove_Mnemonic").charAt(0));
        }
        object = featureDescriptor.getValue(PROP_MNEMONIC_EDIT);
        if (object instanceof String) {
            this.changeButton.setMnemonic(((String)object).charAt(0));
        } else {
            this.changeButton.setMnemonic(bundle.getString("CTL_Change_Mnemonic").charAt(0));
        }
        object = featureDescriptor.getValue(PROP_MNEMONIC_UP);
        if (object instanceof String) {
            this.upButton.setMnemonic(((String)object).charAt(0));
        } else {
            this.upButton.setMnemonic(bundle.getString("CTL_MoveUp_Mnemonic").charAt(0));
        }
        object = featureDescriptor.getValue(PROP_MNEMONIC_DOWN);
        if (object instanceof String) {
            this.downButton.setMnemonic(((String)object).charAt(0));
        } else {
            this.downButton.setMnemonic(bundle.getString("CTL_MoveDown_Mnemonic").charAt(0));
        }
        object = featureDescriptor.getValue(PROP_LABEL_LIST);
        if (object instanceof String) {
            this.jLabel1.setText((String)object);
            object = featureDescriptor.getValue(PROP_MNEMONIC_LIST);
            if (object instanceof String) {
                this.jLabel1.setDisplayedMnemonic(((String)object).charAt(0));
            }
        } else {
            this.jLabel1.setText(bundle.getString("LAB_ObjectList"));
            this.jLabel1.setDisplayedMnemonic(bundle.getString("MNEMO_ObjectList").charAt(0));
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.changeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.list);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 5, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 3));
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(3);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ObjectArrayPanel2.this.listValueChanged(listSelectionEvent);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ObjectArrayPanel2.this.listMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.upButton.setText(bundle.getString("CTL_MoveUp"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectArrayPanel2.this.upButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setText(bundle.getString("CTL_MoveDown"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectArrayPanel2.this.downButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.add((Component)this.downButton, gridBagConstraints);
        this.addButton.setText(bundle.getString("CTL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectArrayPanel2.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 5, 11);
        this.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText(bundle.getString("CTL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectArrayPanel2.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.changeButton.setText(bundle.getString("CTL_Change"));
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectArrayPanel2.this.changeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.add((Component)this.changeButton, gridBagConstraints);
    }

    private void listMouseClicked(MouseEvent mouseEvent) {
        Object object;
        int n;
        if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent) && (n = this.list.getSelectedIndex()) != -1 && (object = this.editValue(this.model.getElementAt(n))) != null) {
            this.model.setElementAt(object, n);
            this.modelChanged();
            this.updateButtons();
        }
    }

    private void listValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.list.getSelectedIndex();
        this.model.set(n + 1, this.model.set(n, this.model.getElementAt(n + 1)));
        this.list.setSelectedIndex(n + 1);
        this.modelChanged();
        this.updateButtons();
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.list.getSelectedIndex();
        this.model.set(n - 1, this.model.set(n, this.model.getElementAt(n - 1)));
        this.list.setSelectedIndex(n - 1);
        this.modelChanged();
        this.updateButtons();
    }

    private void changeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.list.getSelectedIndex();
        Object object = this.editValue(this.model.getElementAt(n));
        if (object != null) {
            this.model.setElementAt(object, n);
            this.modelChanged();
            this.updateButtons();
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.list.getSelectedIndex();
        this.model.remove(n);
        int n2 = this.model.size();
        if (n2 > 0) {
            n = Math.min(n2 - 1, n);
            this.list.setSelectedIndex(n);
        }
        this.modelChanged();
        this.updateButtons();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        Object object = this.insertNewValue();
        if (object != null) {
            this.model.addElement(object);
            this.list.setSelectedIndex(this.model.size() - 1);
            this.modelChanged();
            this.updateButtons();
        }
    }

    protected JList getListComponent() {
        return this.list;
    }

    private void updateButtons() {
        int n = this.list.getSelectedIndex();
        boolean bl = n != -1;
        this.removeButton.setEnabled(bl);
        this.changeButton.setEnabled(bl);
        this.upButton.setEnabled(bl && n > 0);
        this.downButton.setEnabled(bl && n < this.model.size() - 1);
    }

    protected abstract Object insertNewValue();

    protected abstract Object editValue(Object var1);

    protected void modelChanged() {
    }
}

