/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JEditorPane;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.src.DefaultElementPrinter;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.ElementProperties;
import org.openide.src.JavaDoc;
import org.openide.src.SourceException;
import org.openide.text.FilterDocument;
import org.openide.text.IndentEngine;

public abstract class Element
implements Serializable,
ElementProperties,
Node.Cookie {
    protected Impl impl;
    protected Impl2 impl2;
    static final long serialVersionUID = 967040188302141522L;

    protected Element(Impl impl) {
        this.impl = impl;
        if (impl instanceof Impl2) {
            this.impl2 = (Impl2)impl;
        }
        impl.attachedToElement(this);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.impl.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.impl.removePropertyChangeListener(propertyChangeListener);
    }

    public final void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.impl2 != null) {
            this.impl2.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public final void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.impl2 != null) {
            this.impl2.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void markCurrent(boolean bl) {
        this.impl.markCurrent(bl);
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = this.impl.getCookie(clazz);
        if (cookie == null && clazz.isAssignableFrom(this.getClass())) {
            cookie = this;
        }
        return cookie;
    }

    protected Object writeReplace() {
        return this.impl;
    }

    public abstract void print(ElementPrinter var1) throws ElementPrinterInterruptException;

    static boolean print(Element[] elementArray, ElementPrinter elementPrinter) throws ElementPrinterInterruptException {
        for (int i = 0; i < elementArray.length; ++i) {
            if (i > 0) {
                elementPrinter.println("");
                elementPrinter.println("");
            }
            elementArray[i].print(elementPrinter);
        }
        return elementArray.length > 0;
    }

    static void printJavaDoc(JavaDoc javaDoc, ElementPrinter elementPrinter) throws ElementPrinterInterruptException {
        if (javaDoc.isEmpty()) {
            return;
        }
        String string = javaDoc.getRawText();
        String[] stringArray = string.split("\\n");
        elementPrinter.print("/**\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            elementPrinter.print("*");
            if (string2.length() > 0 && string2.charAt(0) != ' ') {
                elementPrinter.print(" ");
            }
            elementPrinter.println(string2);
        }
        elementPrinter.print(" */");
    }

    StyledDocument createDocument() {
        Document document;
        EditorKit editorKit = JEditorPane.createEditorKitForContentType("text/x-java");
        if (editorKit == null) {
            editorKit = new DefaultEditorKit();
        }
        if ((document = editorKit.createDefaultDocument()) instanceof StyledDocument) {
            return (StyledDocument)document;
        }
        return new FilterDocument(document);
    }

    void throwSourceException(String string) throws SourceException {
        SourceException sourceException = new SourceException(string);
        ErrorManager.getDefault().annotate((Throwable)sourceException, 256, null, string, null, null);
        throw sourceException;
    }

    void throwSourceException(Throwable throwable) throws SourceException {
        SourceException sourceException = new SourceException(throwable.getMessage());
        ErrorManager.getDefault().annotate((Throwable)sourceException, throwable);
        throw sourceException;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        StyledDocument styledDocument = this.createDocument();
        IndentEngine indentEngine = IndentEngine.find((Document)styledDocument);
        PrintWriter printWriter = new PrintWriter(indentEngine.createWriter((Document)styledDocument, 0, (Writer)stringWriter));
        try {
            this.print(new DefaultElementPrinter(printWriter));
        }
        catch (ElementPrinterInterruptException elementPrinterInterruptException) {
            // empty catch block
        }
        printWriter.close();
        return stringWriter.toString();
    }

    static abstract class Memory
    implements Impl2,
    Node.Cookie {
        protected Element element;
        private PropertyChangeSupport support;
        private VetoableChangeSupport vetoSupport;
        static final long serialVersionUID = 7734412320645883859L;

        Memory() {
        }

        public void attachedToElement(Element element) {
            this.element = element;
        }

        protected final void firePropertyChange(String string, Object object, Object object2) {
            if (this.support != null) {
                this.support.firePropertyChange(string, object, object2);
            }
        }

        protected final void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.support != null) {
                this.support.firePropertyChange(propertyChangeEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.support == null) {
                Memory memory = this;
                synchronized (memory) {
                    if (this.support == null) {
                        this.support = new PropertyChangeSupport(this.element);
                    }
                }
            }
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.support != null) {
                this.support.removePropertyChangeListener(propertyChangeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            if (this.vetoSupport == null) {
                Memory memory = this;
                synchronized (memory) {
                    if (this.vetoSupport == null) {
                        this.vetoSupport = new VetoableChangeSupport(this);
                    }
                }
            }
            this.vetoSupport.addVetoableChangeListener(vetoableChangeListener);
        }

        public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            if (this.vetoSupport != null) {
                this.vetoSupport.removeVetoableChangeListener(vetoableChangeListener);
            }
        }

        protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
            if (this.vetoSupport != null) {
                this.vetoSupport.fireVetoableChange(string, object, object2);
            }
        }

        protected void fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (this.vetoSupport != null) {
                this.vetoSupport.fireVetoableChange(propertyChangeEvent);
            }
        }

        public Node.Cookie getCookie(Class clazz) {
            if (clazz.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }

        public void markCurrent(boolean bl) {
        }

        public boolean isValid() {
            return true;
        }
    }

    public static interface Impl2
    extends Impl {
        public void addVetoableChangeListener(VetoableChangeListener var1);

        public void removeVetoableChangeListener(VetoableChangeListener var1);

        public boolean isValid();
    }

    public static interface Impl
    extends Serializable {
        public static final long serialVersionUID = -3246061193296761293L;

        public void attachedToElement(Element var1);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);

        public Object readResolve();

        public Node.Cookie getCookie(Class var1);

        public void markCurrent(boolean var1);
    }
}

