/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocTag;
import org.openide.src.JavaDocTagMemoryImpl;
import org.openide.src.SourceException;

class JavaDocMemoryImpl
implements JavaDoc,
Serializable {
    protected String rawText;
    private transient String text;
    private static final JavaDocTagMemoryImpl[] EMPTY_ARRAY = new JavaDocTagMemoryImpl[0];
    private static final String lineSeparator;
    private static final int lineSeparatorLength;
    private static final char LINEFEED = '\n';

    public JavaDocMemoryImpl(String string) {
        this.rawText = string;
    }

    public String getRawText() {
        return this.rawText;
    }

    public void setRawText(String string) throws SourceException {
        this.rawText = string;
    }

    public String getText() {
        if (this.rawText == null) {
            return "";
        }
        ArrayList arrayList = new ArrayList();
        this.parseComment(arrayList);
        return this.text;
    }

    public void setText(String string) throws SourceException {
        this.regenerateRawText(JavaDocMemoryImpl.convertNewLines(string), this.getTags(), this.getSeeTags());
    }

    public void clearJavaDoc() throws SourceException {
        this.rawText = null;
    }

    public boolean isEmpty() {
        return this.rawText == null;
    }

    public JavaDocTag[] getTags() {
        if (this.rawText == null) {
            return EMPTY_ARRAY;
        }
        ArrayList arrayList = new ArrayList();
        this.parseComment(arrayList);
        JavaDocTag[] javaDocTagArray = new JavaDocTag[arrayList.size()];
        arrayList.toArray(javaDocTagArray);
        return javaDocTagArray;
    }

    public JavaDocTag[] getTags(String string) {
        JavaDocTag[] javaDocTagArray = this.getTags();
        ArrayList<JavaDocTag> arrayList = new ArrayList<JavaDocTag>(javaDocTagArray.length);
        for (int i = 0; i < javaDocTagArray.length; ++i) {
            if (!javaDocTagArray[i].name().equals(string)) continue;
            arrayList.add(javaDocTagArray[i]);
        }
        JavaDocTag[] javaDocTagArray2 = new JavaDocTag[arrayList.size()];
        arrayList.toArray(javaDocTagArray2);
        return javaDocTagArray2;
    }

    public synchronized void changeTags(JavaDocTag[] javaDocTagArray, int n) throws SourceException {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 1: 
            case 3: {
                stringBuffer.append(n == 1 ? this.getRawText() : this.getText());
                for (int i = 0; i < javaDocTagArray.length; ++i) {
                    stringBuffer.append("\n").append(javaDocTagArray[i].toString());
                }
                this.setRawText(stringBuffer.toString());
                break;
            }
            case 2: {
                JavaDocTag[] javaDocTagArray2 = this.getTags();
                stringBuffer.append(this.getText());
                for (int i = 0; i < javaDocTagArray2.length; ++i) {
                    boolean bl = false;
                    String string = javaDocTagArray2[i].toString();
                    for (int j = 0; j < javaDocTagArray.length; ++j) {
                        if (!string.equals(javaDocTagArray[j].toString())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    stringBuffer.append("\n").append(string);
                }
                this.setRawText(stringBuffer.toString());
            }
        }
    }

    public JavaDocTag.See[] getSeeTags() {
        JavaDocTag[] javaDocTagArray = this.getTags();
        ArrayList<JavaDocTag> arrayList = new ArrayList<JavaDocTag>(javaDocTagArray.length);
        for (int i = 0; i < javaDocTagArray.length; ++i) {
            if (!(javaDocTagArray[i] instanceof JavaDocTag.See)) continue;
            arrayList.add(javaDocTagArray[i]);
        }
        JavaDocTag.See[] seeArray = new JavaDocTag.See[arrayList.size()];
        arrayList.toArray(seeArray);
        return seeArray;
    }

    protected void regenerateRawText(String string, JavaDocTag[] javaDocTagArray, JavaDocTag.See[] seeArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string.length() + javaDocTagArray.length * 80 + seeArray.length * 80);
        stringBuffer.append(string);
        for (n = 0; n < javaDocTagArray.length; ++n) {
            stringBuffer.append(javaDocTagArray[n].toString());
        }
        for (n = 0; n < seeArray.length; ++n) {
            stringBuffer.append(seeArray[n].toString());
        }
        this.rawText = stringBuffer.toString();
    }

    private void parseComment(List list) {
        int n = 1;
        boolean bl = true;
        String string = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = this.rawText.length();
        for (int i = 0; i < n6; ++i) {
            char c = this.rawText.charAt(i);
            boolean bl2 = Character.isWhitespace(c);
            switch (n) {
                case 1: {
                    if (!bl || c != '@') break;
                    this.parseCommentComponent(list, null, 0, n4);
                    n2 = i;
                    n = 3;
                    break;
                }
                case 3: {
                    if (!bl2) break;
                    string = this.rawText.substring(n2, i);
                    n = 2;
                    break;
                }
                case 2: {
                    if (bl2) break;
                    n3 = i;
                    n = 4;
                }
                case 4: {
                    if (!bl || c != '@') break;
                    this.parseCommentComponent(list, string, n3, n5 + 1);
                    n2 = i;
                    n = 3;
                }
            }
            if (lineSeparator != null && i + lineSeparatorLength <= n6 && this.rawText.regionMatches(i, lineSeparator, 0, lineSeparatorLength)) {
                bl = true;
                if (n == 1) {
                    n4 = i;
                }
                i += lineSeparatorLength - 1;
                continue;
            }
            if (c == '\n') {
                bl = true;
                if (n != 1) continue;
                n4 = i;
                continue;
            }
            if (bl2) continue;
            n5 = i;
            bl = false;
        }
        switch (n) {
            case 3: {
                string = this.rawText.substring(n2, n6);
            }
            case 2: {
                n3 = n6;
            }
            case 1: 
            case 4: {
                this.parseCommentComponent(list, string, n3, n5 + 1);
            }
        }
    }

    private void parseCommentComponent(List list, String string, int n, int n2) {
        String string2;
        String string3 = string2 = n2 <= n ? "" : this.rawText.substring(n, n2);
        if (string == null) {
            this.text = string2;
        } else {
            JavaDocTagMemoryImpl javaDocTagMemoryImpl;
            if (string.equals("@exception") || string.equals("@throws")) {
                this.warnIfEmpty(string, string2);
                javaDocTagMemoryImpl = new JavaDocTagMemoryImpl.Throws(string, string2);
            } else if (string.equals("@param")) {
                this.warnIfEmpty(string, string2);
                javaDocTagMemoryImpl = new JavaDocTagMemoryImpl.Param(string, string2);
            } else if (string.equals("@see")) {
                this.warnIfEmpty(string, string2);
                javaDocTagMemoryImpl = new JavaDocTagMemoryImpl.See(string, string2);
            } else if (string.equals("@serialField")) {
                this.warnIfEmpty(string, string2);
                javaDocTagMemoryImpl = new JavaDocTagMemoryImpl.SerialField(string, string2);
            } else if (string.equals("@return")) {
                this.warnIfEmpty(string, string2);
                javaDocTagMemoryImpl = new JavaDocTagMemoryImpl(string, string2);
            } else if (string.equals("@author")) {
                this.warnIfEmpty(string, string2);
                javaDocTagMemoryImpl = new JavaDocTagMemoryImpl(string, string2);
            } else if (string.equals("@version")) {
                this.warnIfEmpty(string, string2);
                javaDocTagMemoryImpl = new JavaDocTagMemoryImpl(string, string2);
            } else {
                javaDocTagMemoryImpl = new JavaDocTagMemoryImpl(string, string2);
            }
            list.add(javaDocTagMemoryImpl);
        }
    }

    private void warnIfEmpty(String string, String string2) {
    }

    static String convertNewLines(String string) {
        if (lineSeparator == null) {
            return string;
        }
        int n = string.indexOf(lineSeparator);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        if (n > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        stringBuffer.append('\n');
        int n2 = n += lineSeparatorLength;
        while (n < cArray.length) {
            if ((n = string.indexOf(lineSeparator, n)) == -1) {
                stringBuffer.append(cArray, n2, cArray.length - n2);
                return stringBuffer.toString();
            }
            stringBuffer.append(cArray, n2, n - n2);
            stringBuffer.append('\n');
            n2 = n += lineSeparatorLength;
        }
        stringBuffer.append(cArray, n2, n - n2);
        return stringBuffer.toString();
    }

    static {
        String string = System.getProperty("line.separator");
        if (string == null || string.equals("\n")) {
            lineSeparator = null;
            lineSeparatorLength = 0;
        } else {
            lineSeparator = string;
            lineSeparatorLength = string.length();
        }
    }

    static class Method
    extends JavaDocMemoryImpl
    implements JavaDoc.Method {
        Method(String string) {
            super(string);
        }

        public JavaDocTag.Param[] getParamTags() {
            JavaDocTag[] javaDocTagArray = this.getTags();
            ArrayList<JavaDocTag> arrayList = new ArrayList<JavaDocTag>(javaDocTagArray.length);
            for (int i = 0; i < javaDocTagArray.length; ++i) {
                if (!(javaDocTagArray[i] instanceof JavaDocTag.Param)) continue;
                arrayList.add(javaDocTagArray[i]);
            }
            JavaDocTag.Param[] paramArray = new JavaDocTag.Param[arrayList.size()];
            arrayList.toArray(paramArray);
            return paramArray;
        }

        public JavaDocTag.Throws[] getThrowsTags() {
            JavaDocTag[] javaDocTagArray = this.getTags();
            ArrayList<JavaDocTag> arrayList = new ArrayList<JavaDocTag>(javaDocTagArray.length);
            for (int i = 0; i < javaDocTagArray.length; ++i) {
                if (!(javaDocTagArray[i] instanceof JavaDocTag.Throws)) continue;
                arrayList.add(javaDocTagArray[i]);
            }
            JavaDocTag.Throws[] throwsArray = new JavaDocTag.Throws[arrayList.size()];
            arrayList.toArray(throwsArray);
            return throwsArray;
        }
    }

    static class Field
    extends JavaDocMemoryImpl
    implements JavaDoc.Field {
        Field(String string) {
            super(string);
        }

        public JavaDocTag.SerialField[] getSerialFieldTags() {
            JavaDocTag[] javaDocTagArray = this.getTags();
            ArrayList<JavaDocTag> arrayList = new ArrayList<JavaDocTag>(javaDocTagArray.length);
            for (int i = 0; i < javaDocTagArray.length; ++i) {
                if (!(javaDocTagArray[i] instanceof JavaDocTag.SerialField)) continue;
                arrayList.add(javaDocTagArray[i]);
            }
            JavaDocTag.SerialField[] serialFieldArray = new JavaDocTag.SerialField[arrayList.size()];
            arrayList.toArray(serialFieldArray);
            return serialFieldArray;
        }
    }

    static class Class
    extends JavaDocMemoryImpl
    implements JavaDoc.Class {
        static final long serialVersionUID = 3206093459760846163L;

        Class(String string) {
            super(string);
        }
    }
}

